/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.policies;

import com.ibm.im.ims.workbench.editors.model.ConnectionGEFModel;
import com.ibm.im.ims.workbench.editors.preferences.GetNodePreferences;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.SegmentModel;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.swt.graphics.Color;

public class NodeConnectionEndpointEditPolicy
extends ConnectionEndpointEditPolicy {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected void addSelectionHandles() {
        super.addSelectionHandles();
        PolylineConnection figure = this.getConnectionFigure();
        if (figure.getConnectionRouter() instanceof BendpointConnectionRouter) {
            Color color = GetNodePreferences.fetchPreferenceColor("explorer_selected_connection_logical_color");
            figure.setForegroundColor(color);
            figure.setLineWidth(4);
            figure.setLineStyle(4);
            PolygonDecoration targetDecoration = new PolygonDecoration();
            targetDecoration.setForegroundColor(color);
            figure.setTargetDecoration((RotatableDecoration)targetDecoration);
            PolygonDecoration sourceDecoration = new PolygonDecoration();
            sourceDecoration.setForegroundColor(color);
            SegmentModel segmentModel = this.getConnectionModel().getChild().getSegmentModel();
            if (segmentModel.getPaired() == DBDConstants.Y) {
                figure.setSourceDecoration((RotatableDecoration)sourceDecoration);
            } else {
                if (segmentModel.getPaired() == DBDConstants.N && segmentModel.getLogicalPointer() == null) {
                    return;
                }
                if (segmentModel.getLogicalPointer() == DBDConstants.LTWIN || segmentModel.getLogicalPointer() == DBDConstants.LTWINBWD) {
                    figure.setSourceDecoration((RotatableDecoration)sourceDecoration);
                    figure.setLineStyle(3);
                }
            }
        }
    }

    protected void removeSelectionHandles() {
        super.removeSelectionHandles();
        PolylineConnection figure = this.getConnectionFigure();
        if (figure.getConnectionRouter() instanceof BendpointConnectionRouter) {
            Color color = GetNodePreferences.fetchPreferenceColor("explorer_connection_logical_color");
            figure.setForegroundColor(color);
            figure.setLineWidth(3);
            figure.setLineStyle(4);
            PolygonDecoration targetDecoration = new PolygonDecoration();
            targetDecoration.setForegroundColor(color);
            figure.setTargetDecoration((RotatableDecoration)targetDecoration);
            PolygonDecoration sourceDecoration = new PolygonDecoration();
            sourceDecoration.setForegroundColor(color);
            SegmentModel segmentModel = this.getConnectionModel().getChild().getSegmentModel();
            if (segmentModel.getPaired() == DBDConstants.Y) {
                figure.setSourceDecoration((RotatableDecoration)sourceDecoration);
            } else {
                if (segmentModel.getPaired() == DBDConstants.N && segmentModel.getLogicalPointer() == null) {
                    return;
                }
                if (segmentModel.getLogicalPointer() == DBDConstants.LTWIN || segmentModel.getLogicalPointer() == DBDConstants.LTWINBWD) {
                    figure.setSourceDecoration((RotatableDecoration)sourceDecoration);
                    figure.setLineStyle(3);
                }
            }
        }
    }

    private PolylineConnection getConnectionFigure() {
        return (PolylineConnection)this.getHost().getFigure();
    }

    private ConnectionGEFModel getConnectionModel() {
        return (ConnectionGEFModel)this.getHost().getModel();
    }
}

