/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.policies;

import com.ibm.im.ims.workbench.editors.commands.AddSegmentCommand;
import com.ibm.im.ims.workbench.editors.commands.DeleteFieldCommand;
import com.ibm.im.ims.workbench.editors.commands.DeleteSegmentCommand;
import com.ibm.im.ims.workbench.editors.commands.EditFieldCommand;
import com.ibm.im.ims.workbench.editors.model.FieldGEFModel;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;

public class ModelComponentEditPolicy
extends ComponentEditPolicy {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public static final String DELETE_SEGMENT_REQUEST = "DELETE_SEGMENT_REQUEST";
    public static final String EDIT_REQUEST = "EDIT_REQUEST";
    public static final String ADD_REQUEST = "ADD_REQUEST";
    public static final String ADD_SEGMENT_REQUEST = "ADD_SEGMENT_REQUEST";
    public static final String DELETE_REQUEST = "DELETE_REQUEST";
    public static final String IMPORT_REQUEST = "IMPORT_REQUEST";
    public static final String EXPORT_REQUEST = "EXPORT_REQUEST";
    public static final String RENAME_REQUEST = "RENAME_REQUEST";

    public Command getCommand(Request request) {
        logger.finer("request: " + String.valueOf(request.getType()));
        if (EDIT_REQUEST.equals(request.getType())) {
            EditFieldCommand editCommand = null;
            if (this.getHost().getModel() instanceof FieldGEFModel) {
                editCommand = new EditFieldCommand(this.getHost(), "Edit Field");
                editCommand.setFieldModel((FieldGEFModel)this.getHost().getModel());
            }
            return editCommand;
        }
        if (!ADD_REQUEST.equals(request.getType())) {
            if (DELETE_REQUEST.equals(request.getType())) {
                DeleteFieldCommand deleteCommand = new DeleteFieldCommand(this.getHost(), "Delete Field");
                if (this.getHost().getModel() instanceof FieldGEFModel) {
                    deleteCommand.setFieldGEFModel((FieldGEFModel)this.getHost().getModel());
                }
                return deleteCommand;
            }
            if (ADD_SEGMENT_REQUEST.equals(request.getType())) {
                Object model = this.getHost().getModel();
                if (model instanceof SegmentGEFModel) {
                    AddSegmentCommand addSegCommand = new AddSegmentCommand((SegmentGEFModel)model, "Add New Segment");
                    return addSegCommand;
                }
                if (model instanceof FieldGEFModel) {
                    AddSegmentCommand addSegCommand = new AddSegmentCommand(((FieldGEFModel)model).getSegmentGEFModel(), "Add New Segment");
                    return addSegCommand;
                }
            } else if (DELETE_SEGMENT_REQUEST.equals(request.getType())) {
                Object model = this.getHost().getModel();
                if (model instanceof SegmentGEFModel) {
                    DeleteSegmentCommand deleteSegCommand = new DeleteSegmentCommand((SegmentGEFModel)model, "Delete Segment");
                    return deleteSegCommand;
                }
                if (model instanceof FieldGEFModel) {
                    DeleteSegmentCommand deleteSegCommand = new DeleteSegmentCommand(((FieldGEFModel)model).getSegmentGEFModel(), "Delete Segment");
                    return deleteSegCommand;
                }
            }
        }
        return null;
    }
}

