/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.parts;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.figures.SegmentControlFigure;
import com.ibm.im.ims.workbench.editors.figures.SegmentFigure;
import com.ibm.im.ims.workbench.editors.model.ConnectionGEFModel;
import com.ibm.im.ims.workbench.editors.model.DbGEFModel;
import com.ibm.im.ims.workbench.editors.model.FieldGEFModel;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.editors.parts.IMSResourceEditorPart;
import com.ibm.im.ims.workbench.editors.parts.NodeConnectionEditPart;
import com.ibm.im.ims.workbench.editors.policies.NodeAnchorConnection;
import com.ibm.im.ims.workbench.editors.policies.SegmentModelEditPolicy;
import com.ibm.im.ims.workbench.editors.preferences.GetNodePreferences;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.SenfieldModel;
import com.ibm.im.ims.workbench.model.SensegModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;

public class SegmentEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
NodeEditPart,
MouseListener,
IPropertyChangeListener,
IMSResourceEditorPart {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private NodeAnchorConnection m_anchorTop;
    private NodeAnchorConnection m_anchorBtn;
    private Figure m_nodeFigure;
    public static final String ANCHOR_TOP = "Anchor_top";
    public static final String ANCHOR_BOTTOM = "Anchor_bottom";
    private AccessibleEditPart accessibleEditPart;

    public SegmentEditPart() {
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.entering(this.getClass().getName(), "SegmentEditPart()", new Object[]{this.getModel()});
            }
            this.accessibleEditPart = new MyAccessibleGraphicalEditPart();
            if (logger.isLoggable(Level.FINEST)) {
                logger.exiting(this.getClass().getName(), "SegmentEditPart()", new Object[0]);
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "SegmentEditPart()", e);
            logger.error(e);
        }
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        return this.accessibleEditPart;
    }

    protected IFigure createFigure() {
        SegmentGEFModel gefSegment = (SegmentGEFModel)this.getModel();
        Point location = gefSegment.getNodeLocation();
        this.m_nodeFigure = new SegmentFigure(gefSegment);
        this.m_nodeFigure.setLocation(location);
        this.m_anchorTop = new NodeAnchorConnection((IFigure)this.m_nodeFigure);
        this.m_anchorBtn = new NodeAnchorConnection((IFigure)this.m_nodeFigure);
        return this.m_nodeFigure;
    }

    public boolean canBeLogicalRoot() {
        return ((SegmentGEFModel)this.getModel()).getSegmentModel().canBeLogicalRoot();
    }

    public boolean canToggleConcatenate() {
        SegmentGEFModel gefSegment = (SegmentGEFModel)this.getModel();
        return !gefSegment.isLogicalSourceSegment() && gefSegment.getSegmentModel().hasLogicalParent();
    }

    public boolean canToggleNonConcatenate() {
        SegmentGEFModel gefSegment = (SegmentGEFModel)this.getModel();
        return !gefSegment.isLogicalSourceSegment() && gefSegment.getSegmentType() == 2;
    }

    public boolean canBeEdited() {
        SegmentControlFigure ctrlFigure;
        boolean retVal = true;
        IFigure figure = this.getFigure();
        if (figure instanceof SegmentFigure && (ctrlFigure = ((SegmentFigure)figure).getNodeControlFigure()) == null) {
            retVal = false;
        }
        return retVal;
    }

    protected void refreshVisuals() {
        SegmentGEFModel theModel = (SegmentGEFModel)this.getModel();
        Point loc = theModel.getNodeLocation();
        Dimension d = theModel.getPreferredSize();
        Rectangle r = new Rectangle(loc, d);
        this.updateAnchorsLocations();
        GraphicalEditPart gep = (GraphicalEditPart)this.getParent();
        IFigure fig = this.getFigure();
        gep.setLayoutConstraint((EditPart)this, fig, (Object)r);
    }

    public void activate() {
        try {
            if (logger.isLoggable(Level.FINEST)) {
                Object[] parms = new Object[]{((SegmentGEFModel)this.getModel()).getSegmentName(), "Hash code: " + Integer.toHexString(this.hashCode()), "Thread ID: " + Thread.currentThread().getId()};
                logger.entering(this.getClass().getName(), "activate()", parms);
            }
            if (!this.isActive()) {
                super.activate();
                SegmentGEFModel model = (SegmentGEFModel)this.getModel();
                model.addPropertyChangeListener(this);
                this.getFigure().addMouseListener((MouseListener)this);
                IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
                store.addPropertyChangeListener((IPropertyChangeListener)this);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.exiting(this.getClass().getName(), "activate()", new Object[0]);
                }
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "activate()", e);
            logger.error(e);
        }
    }

    public void deactivate() {
        try {
            if (logger.isLoggable(Level.FINEST)) {
                Object[] parms = new Object[]{"Hash code: " + Integer.toHexString(this.hashCode()), "Thread ID: " + Thread.currentThread().getId()};
                logger.entering(this.getClass().getName(), "deactivate()", parms);
            }
            if (this.isActive()) {
                super.deactivate();
                ((SegmentGEFModel)this.getModel()).removePropertyChangeListener(this);
                this.getFigure().removeMouseListener((MouseListener)this);
                IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
                store.removePropertyChangeListener((IPropertyChangeListener)this);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.exiting(this.getClass().getName(), "deactivate()", new Object[0]);
                }
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "deactivate()", e);
            logger.error(e);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new SegmentModelEditPolicy());
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        try {
            String prop = evt.getPropertyName();
            SegmentGEFModel model = (SegmentGEFModel)this.getModel();
            if (prop.equals("label")) {
                ((SegmentFigure)this.getFigure()).getLabelFigure().setLabelName(model.getSegmentAlias());
                this.refreshVisuals();
            } else if (prop.equals("size")) {
                this.refreshVisuals();
            } else if (prop.equals("location")) {
                this.refreshVisuals();
            } else if (prop.equals("inputs")) {
                this.refreshSourceConnections();
            } else if (prop.equals("outputs")) {
                this.refreshTargetConnections();
            } else if (prop.equals("expansion")) {
                SegmentControlFigure ctrlFigure;
                this.refreshChildren();
                IFigure figure = this.getFigure();
                if (figure instanceof SegmentFigure && (ctrlFigure = ((SegmentFigure)figure).getNodeControlFigure()) != null) {
                    ctrlFigure.setIcon(model.isExpand());
                }
            } else if (prop.equals("refresh")) {
                this.refreshChildren();
            } else if (prop.equals("Senseg")) {
                ((SegmentFigure)this.getFigure()).getLabelFigure().getCheckbox().setSelected(model.isSenseg());
                ((SegmentFigure)this.getFigure()).getLabelFigure().repaint();
                ((SegmentFigure)this.getFigure()).getNodeControlFigure().repaint();
                this.refreshChildren();
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "propertyChange(PropertyChangeEvent evt)", e);
            logger.error(e);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String prefKey = event.getProperty();
        if (prefKey.equals("explorer_field_selected_color")) {
            ((SegmentFigure)this.getFigure()).setFieldSelectionColor(GetNodePreferences.fetchPreferenceColor(prefKey));
        } else if (prefKey.equals("explorer_field_color")) {
            ((SegmentFigure)this.getFigure()).setBackgroundColor(GetNodePreferences.fetchPreferenceColor(prefKey));
        } else if (prefKey.equals("explorer_segment_color")) {
            ((SegmentFigure)this.getFigure()).getLabelFigure().setBackgroundColor(GetNodePreferences.fetchPreferenceColor(prefKey));
            ((SegmentFigure)this.getFigure()).getNodeControlFigure().setBackgroundColor(GetNodePreferences.fetchPreferenceColor(prefKey));
        } else if (prefKey.equals("explorer_segment_font")) {
            ((SegmentFigure)this.getFigure()).getLabelFigure().setFont(GetNodePreferences.fetchPreferenceFont(prefKey));
            ((SegmentGEFModel)this.getModel()).setSize(-1, -1);
        } else if (prefKey.equals("explorer_segment_expand_all_flag")) {
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            boolean expandAll = store.getBoolean(prefKey);
            ((SegmentGEFModel)this.getModel()).getDbGEFModel().propAllNodesExpandChange(expandAll);
        }
    }

    protected List<ConnectionGEFModel> getModelSourceConnections() {
        Vector<ConnectionGEFModel> sourceConnections = ((SegmentGEFModel)this.getModel()).getParentConnections();
        return sourceConnections;
    }

    protected List<ConnectionGEFModel> getModelTargetConnections() {
        Vector<ConnectionGEFModel> targetConnection = ((SegmentGEFModel)this.getModel()).getChildConnections();
        return targetConnection;
    }

    protected ConnectionEditPart createConnection(Object iModel) {
        NodeConnectionEditPart connectPart = (NodeConnectionEditPart)this.getRoot().getViewer().getEditPartRegistry().get(iModel);
        if (connectPart == null) {
            connectPart = new NodeConnectionEditPart();
            connectPart.setModel(iModel);
        }
        return connectPart;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart iConnection) {
        NodeAnchorConnection anchor = null;
        try {
            ConnectionGEFModel connection = (ConnectionGEFModel)iConnection.getModel();
            if (connection.getChildTerminal().equals(ANCHOR_TOP)) {
                anchor = this.m_anchorTop;
            } else if (connection.getChildTerminal().equals(ANCHOR_BOTTOM)) {
                anchor = this.m_anchorBtn;
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "getSourceConnectionAnchor(ConnectionEditPart iConnection)", e);
            logger.error(e);
        }
        return anchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart iConnection) {
        NodeAnchorConnection anchor = null;
        try {
            ConnectionGEFModel connection = (ConnectionGEFModel)iConnection.getModel();
            if (connection.getParentTerminal().equals(ANCHOR_TOP)) {
                anchor = this.m_anchorTop;
            } else if (connection.getParentTerminal().equals(ANCHOR_BOTTOM)) {
                anchor = this.m_anchorBtn;
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "getTargetConnectionAnchor(ConnectionEditPart iConnection)", e);
            logger.error(e);
        }
        return anchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request iRequest) {
        return this.getClosestAnchor(iRequest);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request iRequest) {
        return this.getClosestAnchor(iRequest);
    }

    private void updateAnchorsLocations() {
        Dimension size = this.m_nodeFigure.getPreferredSize();
        this.m_anchorTop.setOffsetH((size.width - 6) / 2);
        this.m_anchorBtn.setOffsetH((size.width - 6) / 2);
        this.m_anchorBtn.setOffsetV(size.height - 6);
    }

    private ConnectionAnchor getClosestAnchor(Request iRequest) {
        Point anchor2Location;
        long distance2;
        Point anchor1Location;
        NodeAnchorConnection closest = null;
        Point pt = new Point(((DropRequest)iRequest).getLocation());
        long distance1 = pt.getDistance2(anchor1Location = this.m_anchorTop.getLocation(null));
        closest = distance1 < (distance2 = (long)pt.getDistance2(anchor2Location = this.m_anchorBtn.getLocation(null))) ? this.m_anchorTop : this.m_anchorBtn;
        return closest;
    }

    public IFigure getContentPane() {
        return ((SegmentFigure)this.getFigure()).getFieldListFigure();
    }

    protected List getModelChildren() {
        List<Object> retVal = null;
        try {
            SegmentGEFModel gefSegment = (SegmentGEFModel)this.getModel();
            int segType = gefSegment.getSegmentType();
            if (segType == 2) {
                Vector<FieldGEFModel> keyFields;
                retVal = new ArrayList<SegmentGEFModel>(2);
                SegmentGEFModel logicalSourceGEFSeg1 = gefSegment.getLogicalChildSourceGEFSegment();
                SegmentGEFModel logicalSourceGEFSeg2 = gefSegment.getTargetParentSourceGEFSegment();
                if (gefSegment.getSegmentModel().getLogicalChildSourceData() == DBDConstants.N) {
                    keyFields = this.getKeyFields(logicalSourceGEFSeg1);
                    logicalSourceGEFSeg1.setFieldsList(keyFields);
                }
                if (gefSegment.getSegmentModel().getTargetParentSourceData() == DBDConstants.N) {
                    keyFields = this.getKeyFields(logicalSourceGEFSeg2);
                    logicalSourceGEFSeg2.setFieldsList(keyFields);
                }
                retVal.add(logicalSourceGEFSeg1);
                retVal.add(logicalSourceGEFSeg2);
            } else if (segType == 1) {
                retVal = new ArrayList(1);
                retVal.add(gefSegment.getLogicalChildSourceGEFSegment());
            } else {
                retVal = gefSegment.getDbGEFModel().isPsb() ? this.getSenfldList(gefSegment) : gefSegment.getFilteredFieldsList();
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "", e);
            logger.error(e);
        }
        return retVal;
    }

    private List getSenfldList(SegmentGEFModel gefSegment) throws ModelException, CoreException {
        List retVal = null;
        if (gefSegment.getDbGEFModel().editorPage.inApplicationView) {
            retVal = this.getVFKFields(gefSegment);
            retVal.addAll(this.getSenflds(gefSegment));
        } else {
            retVal = this.getSenflds(gefSegment);
        }
        return retVal;
    }

    private List getSenflds(SegmentGEFModel gefSegment) throws ModelException, CoreException {
        ArrayList<FieldGEFModel> retVal = null;
        SensegModel senseg = gefSegment.getSenSeg();
        if (senseg == null || senseg.getSenfields().isEmpty()) {
            SegmentModel lchildSrcSeg = gefSegment.getLogicalChildSourceSegment();
            SegmentModel targetParentSrcSeg = gefSegment.getTargetParentSourceSegment();
            if (lchildSrcSeg != null && targetParentSrcSeg != null) {
                segModel = gefSegment.getSegmentModel();
                String pcbName = gefSegment.getDbGEFModel().getPcbModel().getPcbNameOrLabel();
                Vector fields = segModel.getConcatenatedFieldList(lchildSrcSeg, targetParentSrcSeg, pcbName, false);
                retVal = new ArrayList(fields.size());
                int i = 0;
                while (i < fields.size()) {
                    FieldModel currField = (FieldModel)fields.get(i);
                    retVal.add(new FieldGEFModel(gefSegment, currField, null));
                    ++i;
                }
            } else {
                segModel = null;
                segModel = lchildSrcSeg != null ? gefSegment.getLogicalChildSourceSegment() : gefSegment.getSegmentModel();
                Vector fields = segModel.getFieldList(true, false);
                retVal = new ArrayList(fields.size());
                int i = 0;
                while (i < fields.size()) {
                    FieldModel currField = (FieldModel)fields.get(i);
                    retVal.add(new FieldGEFModel(gefSegment, currField, null));
                    ++i;
                }
            }
        } else {
            ArrayList senflds = senseg.getSenfields();
            retVal = new ArrayList<FieldGEFModel>(senflds.size());
            int i = 0;
            while (i < senflds.size()) {
                SenfieldModel currSenfld = (SenfieldModel)senflds.get(i);
                SegmentModel segmentModel = currSenfld.getSegmentModel();
                FieldModel fieldModel = null;
                if (segmentModel.getDBDAccessType() == DBDConstants.LOGICAL) {
                    segmentModel.setProjectName(gefSegment.getDbGEFModel().getProjectName());
                    if (segmentModel.hasSegmentSource()) {
                        fieldModel = segmentModel.getLogicalSourceSegment().getFieldWithImsNameOrAlias(currSenfld.getName());
                    } else if (segmentModel.hasConcatenatedSegmentSource() && (fieldModel = segmentModel.getLChildSourceSegment().getFieldWithImsNameOrAlias(currSenfld.getName())) == null) {
                        fieldModel = segmentModel.getTargetParentSourceSegment().getFieldWithImsNameOrAlias(currSenfld.getName());
                    }
                } else {
                    fieldModel = segmentModel.getFieldWithImsNameOrAlias(currSenfld.getName());
                }
                currSenfld.setFieldModel(fieldModel);
                retVal.add(new FieldGEFModel(gefSegment, currSenfld.getFieldModel(), currSenfld));
                ++i;
            }
        }
        if (!gefSegment.isExpand()) {
            ArrayList<FieldGEFModel> retVal1 = new ArrayList<FieldGEFModel>();
            for (FieldGEFModel currentField : retVal) {
                if (!currentField.isSeq()) continue;
                retVal1.add(currentField);
            }
            return retVal1;
        }
        return retVal;
    }

    private List<FieldGEFModel> getVFKFields(SegmentGEFModel gefSeg) throws ModelException {
        ArrayList<FieldGEFModel> retVal = new ArrayList<FieldGEFModel>();
        boolean seqFieldFound = false;
        SegmentGEFModel parentSegment = gefSeg.getParent();
        while (parentSegment != null) {
            Vector fields = parentSegment.getSegmentModel().getFieldList(false, true);
            int i = 0;
            while (fields != null && !seqFieldFound && i < fields.size()) {
                FieldModel fieldModel = (FieldModel)fields.get(i);
                DBDConstants seqType = fieldModel.getSeqType();
                if (seqType != null && seqType == DBDConstants.U) {
                    SenfieldModel senfieldModel = new SenfieldModel(fieldModel.getImsName());
                    FieldGEFModel fieldGEFModel = new FieldGEFModel(gefSeg, fieldModel, senfieldModel);
                    String prefix = parentSegment.getSegmentName() + "_";
                    if (!fieldGEFModel.getAlias().startsWith(prefix)) {
                        String newValue = prefix + fieldModel.getName();
                        fieldGEFModel.setAlias(newValue, false);
                    }
                    fieldGEFModel.setVirtualKey(true);
                    retVal.add(0, fieldGEFModel);
                    seqFieldFound = true;
                }
                ++i;
            }
            seqFieldFound = false;
            parentSegment = parentSegment.getParent();
        }
        return retVal;
    }

    private Vector<FieldGEFModel> getKeyFields(SegmentGEFModel logicalSourceGEFSeg) {
        Vector<FieldGEFModel> fields = logicalSourceGEFSeg.getFieldsList();
        int size = fields.size();
        Vector<FieldGEFModel> addedVector = new Vector<FieldGEFModel>(size);
        if (fields != null) {
            Iterator iter = fields.iterator();
            while (iter != null && iter.hasNext()) {
                FieldGEFModel aField = (FieldGEFModel)iter.next();
                if (!aField.isSeq()) continue;
                addedVector.add(aField);
            }
        }
        return addedVector;
    }

    public void mousePressed(MouseEvent me) {
        try {
            SegmentControlFigure ctrlFigure = ((SegmentFigure)this.getFigure()).getNodeControlFigure();
            if (ctrlFigure != null && ctrlFigure.pointOnIcon(me.getLocation())) {
                SegmentGEFModel gefSegment = (SegmentGEFModel)this.getModel();
                gefSegment.toggleExpand();
                gefSegment.getDbGEFModel().getOpenedDbGEFModel().recalculateLayout();
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "mousePressed(MouseEvent me)", e);
            logger.error(e);
        }
    }

    public void mouseDoubleClicked(MouseEvent me) {
    }

    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public DbGEFModel getDbGefModel() {
        return ((SegmentGEFModel)this.getModel()).getDbGEFModel();
    }

    class MyAccessibleGraphicalEditPart
    extends AbstractGraphicalEditPart.AccessibleGraphicalEditPart {
        MyAccessibleGraphicalEditPart() {
            super((AbstractGraphicalEditPart)SegmentEditPart.this);
        }

        public void getName(AccessibleEvent e) {
            e.result = ((SegmentGEFModel)SegmentEditPart.this.getModel()).getSegmentName();
        }
    }
}

