/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.parts;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.model.ConnectionGEFModel;
import com.ibm.im.ims.workbench.editors.model.DbGEFModel;
import com.ibm.im.ims.workbench.editors.parts.IMSResourceEditorPart;
import com.ibm.im.ims.workbench.editors.policies.NodeConnectionEndpointEditPolicy;
import com.ibm.im.ims.workbench.editors.preferences.GetNodePreferences;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.logging.Level;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;

public class NodeConnectionEditPart
extends AbstractConnectionEditPart
implements IPropertyChangeListener,
IMSResourceEditorPart {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new NodeConnectionEndpointEditPolicy());
    }

    protected IFigure createFigure() {
        PolylineConnection connectionFigure = (PolylineConnection)super.createFigure();
        ConnectionGEFModel connectionModel = (ConnectionGEFModel)this.getModel();
        if (connectionModel.isPhysicalConnection()) {
            ManhattanConnectionRouter manRouter = new ManhattanConnectionRouter();
            connectionFigure.setConnectionRouter((ConnectionRouter)manRouter);
        } else {
            BendpointConnectionRouter router = new BendpointConnectionRouter();
            connectionFigure.setConnectionRouter((ConnectionRouter)router);
        }
        return connectionFigure;
    }

    protected void refreshVisuals() {
        PolylineConnection figure = (PolylineConnection)this.getFigure();
        ConnectionGEFModel model = (ConnectionGEFModel)this.getModel();
        if (model.isPhysicalConnection()) {
            figure.setForegroundColor(GetNodePreferences.fetchPreferenceColor("explorer_connection_physical_color"));
        } else if (figure.getLineWidth() == 4) {
            this.setColor(figure, model, GetNodePreferences.fetchPreferenceColor("explorer_selected_connection_logical_color"));
        } else {
            this.setColor(figure, model, GetNodePreferences.fetchPreferenceColor("explorer_connection_logical_color"));
        }
    }

    private void setColor(PolylineConnection figure, ConnectionGEFModel model, Color color) {
        figure.setForegroundColor(color);
        PolygonDecoration targetDecoration = new PolygonDecoration();
        targetDecoration.setForegroundColor(color);
        figure.setTargetDecoration((RotatableDecoration)targetDecoration);
        PolygonDecoration sourceDecoration = new PolygonDecoration();
        sourceDecoration.setForegroundColor(color);
        SegmentModel segmentModel = model.getChild().getSegmentModel();
        if (segmentModel.getPaired() == DBDConstants.Y) {
            figure.setSourceDecoration((RotatableDecoration)sourceDecoration);
        } else {
            if (segmentModel.getPaired() == DBDConstants.N && segmentModel.getLogicalPointer() == null) {
                return;
            }
            if (segmentModel.getLogicalPointer() == DBDConstants.LTWIN || segmentModel.getLogicalPointer() == DBDConstants.LTWINBWD) {
                figure.setSourceDecoration((RotatableDecoration)sourceDecoration);
            }
        }
    }

    public void activate() {
        try {
            if (logger.isLoggable(Level.FINEST)) {
                Object[] parms = new Object[]{"Hash code: " + Integer.toHexString(this.hashCode()), "Thread ID: " + Thread.currentThread().getId()};
                logger.entering(this.getClass().getName(), "activate()", parms);
            }
            super.activate();
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            store.addPropertyChangeListener((IPropertyChangeListener)this);
            if (logger.isLoggable(Level.FINEST)) {
                logger.exiting(this.getClass().getName(), "activate()", new Object[0]);
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "activate()", e);
            logger.error(e);
        }
    }

    public void deactivate() {
        try {
            if (logger.isLoggable(Level.FINEST)) {
                Object[] parms = new Object[]{"Hash code: " + Integer.toHexString(this.hashCode()), "Thread ID: " + Thread.currentThread().getId()};
                logger.entering(this.getClass().getName(), "deactivate()", parms);
            }
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            store.removePropertyChangeListener((IPropertyChangeListener)this);
            super.deactivate();
            if (logger.isLoggable(Level.FINEST)) {
                logger.exiting(this.getClass().getName(), "deactivate()", new Object[0]);
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "deactivate()", e);
            logger.error(e);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String prefKey = event.getProperty();
        if (prefKey.equals("explorer_connection_physical_color") || prefKey.equals("explorer_connection_logical_color") || prefKey.equals("explorer_selected_connection_logical_color")) {
            this.refreshVisuals();
            this.refresh();
        }
    }

    @Override
    public DbGEFModel getDbGefModel() {
        ConnectionGEFModel connGefModel = (ConnectionGEFModel)this.getModel();
        return connGefModel.getParent().getDbGEFModel();
    }
}

