/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.parts;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.form.PsbSummaryPage;
import com.ibm.im.ims.workbench.editors.model.DbGEFModel;
import com.ibm.im.ims.workbench.editors.model.DbdBorderModel;
import com.ibm.im.ims.workbench.editors.parts.IMSResourceEditorPart;
import com.ibm.im.ims.workbench.editors.preferences.GetNodePreferences;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.utilities.DBDSourceGenerator;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.logging.Level;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.TitleBarBorder;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class DbdBorderEditPart
extends AbstractGraphicalEditPart
implements IPropertyChangeListener,
IMSResourceEditorPart {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private RectangleFigure dbdBorderFigure;
    private TitleBarBorder titleBarBorder;

    protected IFigure createFigure() {
        this.dbdBorderFigure = new RectangleFigure();
        DbdBorderModel dbdBorderModel = (DbdBorderModel)this.getModel();
        dbdBorderModel.setFigure(this.dbdBorderFigure);
        String title = "|   " + WorkbenchPlugin.labels.getString("WB114") + " " + dbdBorderModel.getDbGefModel().getDbdName() + "   |   ";
        if (dbdBorderModel.getDbGefModel().getDbdModel() != null) {
            title = title + WorkbenchPlugin.labels.getString("WB023") + WorkbenchPlugin.colon.getString("COLON") + DBDSourceGenerator.getACCESSString((DbdModel)dbdBorderModel.getDbGefModel().getDbdModel()) + "   |   ";
        }
        if (dbdBorderModel.getDbGefModel().getPcbModel() != null) {
            DbGEFModel dbGEFModel = dbdBorderModel.getDbGefModel();
            PcbDBModel pcbModel = dbGEFModel.getPcbModel();
            String pcbName = pcbModel.getPcbNameOrLabel();
            String pageName = PsbSummaryPage.createPageName(pcbName, pcbModel.getPcbNum());
            title = "|    " + WorkbenchPlugin.labels.getString("WB430") + WorkbenchPlugin.colon.getString("COLON") + pageName + "   |   ";
            String procopt = pcbModel.getProcopt();
            if (procopt == null || procopt.isEmpty()) {
                procopt = "A";
            }
            title = title + WorkbenchPlugin.labels.getString("WB022") + WorkbenchPlugin.colon.getString("COLON") + pcbModel.getDbdName() + "   |   ";
            title = title + WorkbenchPlugin.labels.getString("WB423") + WorkbenchPlugin.colon.getString("COLON") + procopt + "   |   ";
            title = dbdBorderModel.getDbGefModel().isApplicationView() ? title + WorkbenchPlugin.labels.getString("WB446") + "   |   " : title + WorkbenchPlugin.labels.getString("WB447") + "   |   ";
        }
        this.titleBarBorder = new TitleBarBorder(title);
        this.titleBarBorder.setFont(GetNodePreferences.fetchPreferenceFont("explorer_dbd_font"));
        this.titleBarBorder.setBackgroundColor(GetNodePreferences.fetchPreferenceColor("explorer_dbd_label_color"));
        this.dbdBorderFigure.setBorder((Border)this.titleBarBorder);
        this.dbdBorderFigure.setBackgroundColor(GetNodePreferences.fetchPreferenceColor("explorer_dbd_background_color"));
        this.dbdBorderFigure.setOpaque(true);
        return this.dbdBorderFigure;
    }

    @Override
    public DbGEFModel getDbGefModel() {
        return ((DbdBorderModel)this.getModel()).getDbGefModel();
    }

    public void activate() {
        try {
            if (logger.isLoggable(Level.FINEST)) {
                Object[] parms = new Object[]{"Hash code: " + Integer.toHexString(this.hashCode()), "Thread ID: " + Thread.currentThread().getId()};
                logger.entering(this.getClass().getName(), "activate()", parms);
            }
            super.activate();
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            store.addPropertyChangeListener((IPropertyChangeListener)this);
            if (logger.isLoggable(Level.FINEST)) {
                logger.exiting(this.getClass().getName(), "activate()", new Object[0]);
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "activate()", e);
            logger.error(e);
        }
    }

    public void deactivate() {
        try {
            if (logger.isLoggable(Level.FINEST)) {
                Object[] parms = new Object[]{"Hash code: " + Integer.toHexString(this.hashCode()), "Thread ID: " + Thread.currentThread().getId()};
                logger.entering(this.getClass().getName(), "deactivate()", parms);
            }
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            store.removePropertyChangeListener((IPropertyChangeListener)this);
            super.deactivate();
            if (logger.isLoggable(Level.FINEST)) {
                logger.exiting(this.getClass().getName(), "deactivate()", new Object[0]);
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "deactivate()", e);
            logger.error(e);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String prefKey = event.getProperty();
        if (prefKey.equals("explorer_dbd_background_color")) {
            this.dbdBorderFigure.setBackgroundColor(GetNodePreferences.fetchPreferenceColor(prefKey));
        } else if (prefKey.equals("explorer_dbd_label_color")) {
            this.titleBarBorder.setBackgroundColor(GetNodePreferences.fetchPreferenceColor(prefKey));
            this.dbdBorderFigure.repaint();
        } else if (prefKey.equals("explorer_dbd_font")) {
            this.titleBarBorder.setFont(GetNodePreferences.fetchPreferenceFont(prefKey));
            this.dbdBorderFigure.setSize(-1, -1);
        }
    }

    protected void createEditPolicies() {
    }
}

