/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.model;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.InvalidDBDSourceException;
import com.ibm.im.ims.workbench.editors.model.ConnectionGEFModel;
import com.ibm.im.ims.workbench.editors.model.DbGEFModel;
import com.ibm.im.ims.workbench.editors.model.FieldGEFModel;
import com.ibm.im.ims.workbench.editors.model.NodeEvents;
import com.ibm.im.ims.workbench.editors.properties.FieldProperties;
import com.ibm.im.ims.workbench.editors.properties.SegmentProperties;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.SenfieldModel;
import com.ibm.im.ims.workbench.model.SensegModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.im.ims.workbench.utilities.InfoDialog;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.ToggleModel;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySource;

public class SegmentGEFModel
implements IAdaptable,
ChangeListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private SegmentGEFModel parentSegmentGEFModel;
    private ArrayList<SegmentGEFModel> childGEFSegments = new ArrayList();
    private ArrayList<SegmentGEFModel> childGEFSegmentsFromRLC;
    private ArrayList<SegmentGEFModel> childGEFSegmentsFromTargetParent;
    private int treeWidth;
    private int nodeLevel;
    private Figure figure;
    private DbGEFModel dbGEFModel;
    private Vector<FieldGEFModel> fieldList = null;
    private SegmentModel segmentModel;
    private boolean logicalSourceSegment = false;
    private SegmentGEFModel lchildGEFSegment;
    private SegmentGEFModel targetParentGEFSegment;
    private SegmentModel lchildSegment;
    private SegmentModel targetParentSegment;
    private SensegModel sensegModel = null;
    private Point nodeLocation;
    private Vector<ConnectionGEFModel> topAnchorPoint = new Vector(2);
    private Vector<ConnectionGEFModel> bottomAnchorPoint = new Vector(2);
    private SegmentProperties segmentProperty = null;
    private boolean isNodeExpand;
    public static final int PHYSICAL = 0;
    public static final int LOGICAL = 1;
    public static final int CONCATENATED = 2;
    public static final int LOGICAL_SOURCE = 3;
    private boolean openConfirmDialog = true;
    private boolean firstConfirmation = true;
    private boolean checkboxConfirmed = false;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();

    public SegmentGEFModel(DbGEFModel dbGEFModel, SegmentModel segmentModel, SegmentGEFModel logicalChildSourceGefSegment, SegmentGEFModel targetParentSourceGefSegment, boolean isLogicalSourceSegment) throws InvalidDBDSourceException, ModelException {
        this.dbGEFModel = dbGEFModel;
        this.segmentModel = segmentModel;
        this.lchildGEFSegment = logicalChildSourceGefSegment;
        this.targetParentGEFSegment = targetParentSourceGefSegment;
        if (logicalChildSourceGefSegment != null) {
            this.lchildSegment = logicalChildSourceGefSegment.getSegmentModel();
        }
        if (this.targetParentGEFSegment != null) {
            this.targetParentSegment = this.targetParentGEFSegment.getSegmentModel();
        }
        this.logicalSourceSegment = isLogicalSourceSegment;
        this.addFieldGEFModels();
        this.isNodeExpand = WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("explorer_segment_expand_all_flag");
        this.nodeLevel = 0;
        this.parentSegmentGEFModel = null;
    }

    public SegmentGEFModel(DbGEFModel dbGEFModel, SegmentModel segmentModel, SegmentModel logicalChildSourceSegment, SegmentModel targetParentSourceSegment) throws InvalidDBDSourceException, ModelException {
        this.dbGEFModel = dbGEFModel;
        this.segmentModel = segmentModel;
        this.lchildSegment = logicalChildSourceSegment;
        this.targetParentSegment = targetParentSourceSegment;
        this.addFieldGEFModels();
        this.isNodeExpand = WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("explorer_segment_expand_all_flag");
        this.nodeLevel = 0;
        this.parentSegmentGEFModel = null;
    }

    public SegmentGEFModel(SegmentGEFModel another) throws InvalidDBDSourceException, ModelException {
        SegmentModel origTargetParentSegment;
        this.segmentModel = new SegmentModel(another.getSegmentModel());
        SegmentModel origLchildSegment = another.getLogicalChildSourceSegment();
        if (origLchildSegment != null) {
            this.lchildSegment = new SegmentModel(origLchildSegment);
        }
        if ((origTargetParentSegment = another.getTargetParentSourceSegment()) != null) {
            this.targetParentSegment = new SegmentModel(origTargetParentSegment);
        }
        this.dbGEFModel = another.getDbGEFModel();
        this.sensegModel = another.getSenSeg();
        this.addFieldGEFModels();
        this.isNodeExpand = WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("explorer_segment_expand_all_flag");
        if (another.getLchildGEFSegment() != null) {
            this.lchildGEFSegment = new SegmentGEFModel(another.getLchildGEFSegment());
        }
        if (another.getTargetParentGEFSegment() != null) {
            this.targetParentGEFSegment = new SegmentGEFModel(another.getTargetParentGEFSegment());
        }
    }

    public void removeAllFields() throws ModelException {
        this.fieldList.removeAllElements();
        this.segmentModel.removeAllFields();
    }

    public SegmentGEFModel getLogicalChildSourceGEFSegment() {
        return this.lchildGEFSegment;
    }

    public SegmentGEFModel getTargetParentSourceGEFSegment() {
        return this.targetParentGEFSegment;
    }

    public SegmentModel getLogicalChildSourceSegment() {
        return this.lchildSegment;
    }

    public SegmentModel getTargetParentSourceSegment() {
        return this.targetParentSegment;
    }

    public ArrayList<SegmentGEFModel> getChildGEFSegmentsFromRLC() {
        return this.childGEFSegmentsFromRLC;
    }

    public ArrayList<SegmentGEFModel> getChildGEFSegmentsFromTargetParent() {
        return this.childGEFSegmentsFromTargetParent;
    }

    public void setFigure(Figure figure) {
        this.figure = figure;
    }

    public SegmentGEFModel getLchildGEFSegment() {
        return this.lchildGEFSegment;
    }

    public SegmentGEFModel getTargetParentGEFSegment() {
        return this.targetParentGEFSegment;
    }

    public Figure getFigure() {
        return this.figure;
    }

    public boolean hasChildren() {
        return this.getChildGEFSegments() != null;
    }

    public SegmentGEFModel getSegment(String segmentName) {
        SegmentGEFModel retVal = null;
        DBDConstants dbdAccessType = this.segmentModel.getDbdModel().getAccessType();
        if (dbdAccessType != DBDConstants.GSAM && this.segmentModel.getImsName().equalsIgnoreCase(segmentName) || this.segmentModel.getName().equalsIgnoreCase(segmentName)) {
            retVal = this;
        } else {
            ArrayList<SegmentGEFModel> array = this.getChildGEFSegments();
            int i = 0;
            while (i < array.size()) {
                SegmentGEFModel segment = array.get(i);
                retVal = segment.getSegment(segmentName);
                if (retVal != null) break;
                ++i;
            }
        }
        return retVal;
    }

    public boolean isSenseg() {
        return this.sensegModel != null;
    }

    public ArrayList<SegmentGEFModel> getChildGEFSegments() {
        return this.childGEFSegments;
    }

    public SegmentModel getSegmentModel() {
        return this.segmentModel;
    }

    public boolean isLogicalSourceSegment() {
        return this.logicalSourceSegment;
    }

    public void setLogicalSourceSegment(boolean logicalSourceSegment) {
        this.logicalSourceSegment = logicalSourceSegment;
    }

    public void addFieldGEFModels() throws InvalidDBDSourceException, ModelException {
        if (!this.dbGEFModel.isPsb() && this.segmentModel != null) {
            Vector sysRelFields;
            Vector fieldModelList = this.segmentModel.getFieldList(true, false);
            if (fieldModelList.size() == 0) {
                this.getFields();
                if (this.lchildSegment != null) {
                    for (FieldModel currentField : this.lchildSegment.getFieldList(true, false)) {
                        if (currentField.getName().indexOf("/") != -1) continue;
                        fieldModelList.add(currentField);
                    }
                }
                if (this.targetParentSegment != null) {
                    for (FieldModel currentField : this.targetParentSegment.getFieldList(true, false)) {
                        if (this.segmentModel.getTargetParentSourceData().equals((Object)DBDConstants.N) && currentField.getSeqType() != null && currentField.getSeqType().equals((Object)DBDConstants.U)) {
                            fieldModelList.add(currentField);
                            break;
                        }
                        if (currentField.getName().indexOf("/") != -1) continue;
                        fieldModelList.add(currentField);
                    }
                }
            }
            if ((sysRelFields = this.segmentModel.getSysRelFieldList()) != null) {
                fieldModelList.addAll(sysRelFields);
            }
            this.fieldList = new Vector();
            for (FieldModel fieldModel : fieldModelList) {
                if ((this.dbGEFModel == null || this.dbGEFModel.isPsb()) && fieldModel.getName().indexOf("/") != -1) continue;
                this.fieldList.add(new FieldGEFModel(this, fieldModel, this.sensegModel != null ? new SenfieldModel(fieldModel, this.segmentModel) : null));
            }
        }
    }

    private void getFields() throws InvalidDBDSourceException {
        if (this.dbGEFModel != null && this.dbGEFModel.getDbdModel() != null && this.dbGEFModel.getDbdModel().getAccessType() == DBDConstants.LOGICAL && this.dbGEFModel.isPsb()) {
            SegmentModel segment = this.getSegmentModel();
            if (segment.hasSegmentSource()) {
                String dbName = segment.getSegmentSourceDBName();
                String segName = segment.getSegmentSourceSegName();
                if (dbName != null && segName != null && dbName.length() > 0 && segName.length() > 0) {
                    this.lchildSegment = this.getDbGEFModel().getLogicalSourceSegment(dbName, segName);
                }
            } else if (segment.hasConcatenatedSegmentSource()) {
                String lchildDbName = segment.getLogicalChildSourceDBName();
                String lchildSegName = segment.getLogicalChildSourceSegName();
                if (lchildDbName != null && lchildSegName != null && lchildDbName.length() > 0 && lchildSegName.length() > 0) {
                    this.lchildSegment = this.getDbGEFModel().getLogicalSourceSegment(lchildDbName, lchildSegName);
                }
                String targetParentDbName = segment.getTargetParentSourceDBName();
                String targetParentSegName = segment.getTargetParentSourceSegName();
                if (targetParentDbName != null && targetParentSegName != null && targetParentDbName.length() > 0 && targetParentSegName.length() > 0) {
                    this.targetParentSegment = this.getDbGEFModel().getLogicalSourceSegment(targetParentDbName, targetParentSegName);
                }
            }
        }
    }

    private HashMap<String, SenfieldModel> buildSenfldMap(Iterator<SenfieldModel> senfldIter) {
        HashMap<Object, SenfieldModel> retVal = null;
        if (senfldIter != null && senfldIter.hasNext()) {
            retVal = new HashMap<Object, SenfieldModel>();
            while (senfldIter.hasNext()) {
                SenfieldModel senfldType = senfldIter.next();
                if (retVal.get(senfldType.getName()) == null) {
                    retVal.put(senfldType.getName(), senfldType);
                    continue;
                }
                retVal.put(senfldType.getName() + "_LP", senfldType);
            }
        }
        return retVal;
    }

    public String getSegmentName() {
        String retVal = this.segmentModel.getImsName();
        if (retVal == null || retVal.equals("")) {
            retVal = this.segmentModel.getName();
        }
        return retVal;
    }

    public int getSegmentType() {
        int retVal = this.logicalSourceSegment ? 3 : (this.lchildGEFSegment != null ? (this.targetParentGEFSegment != null ? 2 : 1) : 0);
        return retVal;
    }

    public String getSegmentAlias() {
        String retVal = this.segmentModel.getName();
        if (retVal == null || retVal.equals("")) {
            retVal = this.segmentModel.getImsName();
        }
        return retVal;
    }

    public void setSegmentAlias(String newValue) {
        if (!newValue.equals(this.segmentModel.getName())) {
            String oldValue = this.segmentModel.getName();
            this.segmentModel.setName(newValue);
            this.dbGEFModel.fireEvent(new NodeEvents(4, this));
            this.firePropertyChange("label", oldValue, this.segmentModel.getName());
            this.dbGEFModel.recalculateLayout();
            this.setRelatedNodeAttribute();
        }
    }

    public void setSegAlias(String newValue) {
        this.segmentModel.setName(newValue);
        this.firePropertyChange("label", "", this.segmentModel.getName());
        this.dbGEFModel.recalculateLayout();
    }

    private void setRelatedNodeAttribute() {
        Vector<DbGEFModel> pcbList = this.dbGEFModel.getPsbModel().getList();
        int i = 0;
        while (i < pcbList.size()) {
            DbGEFModel dliPcbModel = pcbList.get(i);
            if (!dliPcbModel.getPcbName().equals(this.dbGEFModel.getPcbName()) && dliPcbModel.getDbdName().equals(this.dbGEFModel.getDbdName())) {
                Vector<SegmentGEFModel> segList = dliPcbModel.getSegmentGEFModels();
                int j = 0;
                while (j < segList.size()) {
                    SegmentGEFModel dliSegModel = segList.get(j);
                    if (dliSegModel.getSegmentName().equals(this.segmentModel.getImsName())) {
                        dliSegModel.setSegAlias(this.getSegmentAlias());
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public int getSegLen() {
        return this.segmentModel.getMaxBytes();
    }

    public Point getNodeLocation() {
        if (this.nodeLocation == null) {
            this.nodeLocation = new Point();
        }
        return this.nodeLocation;
    }

    public void setNodeLocation(Point iLocation) {
        this.nodeLocation = iLocation;
        this.firePropertyChange("location", null, iLocation);
    }

    public void updateSegmentLabelVisuals() {
        this.firePropertyChange("updateSegmentLabelVisuals", null, null);
        this.dbGEFModel.recalculateLayout();
    }

    public DbGEFModel getDbGEFModel() {
        return this.dbGEFModel;
    }

    public Dimension getPreferredSize() {
        if (this.figure != null) {
            return this.figure.getPreferredSize();
        }
        return new Dimension(-1, -1);
    }

    public Vector<FieldGEFModel> getFieldsList() {
        Vector<FieldGEFModel> retVal = new Vector<FieldGEFModel>();
        if (this.fieldList != null) {
            int i = 0;
            while (i < this.fieldList.size()) {
                FieldGEFModel currField = this.fieldList.get(i);
                retVal.add(currField);
                this.recursiveAddFields(retVal, currField);
                ++i;
            }
        }
        return retVal;
    }

    private void recursiveAddFields(Vector<FieldGEFModel> list, FieldGEFModel parentField) {
        Vector<FieldGEFModel> childFields = parentField.getChildFields();
        if (childFields != null && childFields.size() > 0) {
            int i = 0;
            while (i < childFields.size()) {
                FieldGEFModel currField = childFields.get(i);
                list.add(currField);
                this.recursiveAddFields(list, currField);
                ++i;
            }
        }
    }

    public void setFieldsList(Vector<FieldGEFModel> newFields) {
        this.fieldList = newFields;
    }

    public List<FieldGEFModel> getFilteredFieldsList() {
        if (this.isNodeExpand) {
            return this.getFieldsList();
        }
        ArrayList<FieldGEFModel> list = new ArrayList<FieldGEFModel>();
        if (this.fieldList != null) {
            int i = 0;
            while (i < this.fieldList.size()) {
                FieldGEFModel dliFieldGEFModel = this.fieldList.get(i);
                if (dliFieldGEFModel.isSeq()) {
                    list.add(dliFieldGEFModel);
                }
                ++i;
            }
        }
        return list;
    }

    public void deleteFieldfromList(FieldGEFModel dliFieldGEFModel) {
        this.dbGEFModel.fireEvent(new NodeEvents(3, dliFieldGEFModel));
        this.segmentModel.removeField(dliFieldGEFModel.getField());
        this.fieldList.remove(dliFieldGEFModel);
        this.firePropertyChange("refresh", null, dliFieldGEFModel.getAlias());
        this.getDbGEFModel().recalculateLayout();
    }

    public Vector<FieldGEFModel> getNonSelectedFields(String fieldName) {
        Vector<FieldGEFModel> newFields = new Vector<FieldGEFModel>();
        int i = 0;
        while (i < this.fieldList.size()) {
            FieldGEFModel dliFieldGEFModel = this.fieldList.get(i);
            if (!dliFieldGEFModel.getAlias().equals(fieldName)) {
                newFields.add(dliFieldGEFModel);
            }
            ++i;
        }
        return newFields;
    }

    public String toString() {
        return this.segmentModel.getImsName();
    }

    public Vector<ConnectionGEFModel> getParentConnections() {
        return this.topAnchorPoint;
    }

    public Vector<ConnectionGEFModel> getChildConnections() {
        return this.bottomAnchorPoint;
    }

    public void connectInput(ConnectionGEFModel iConnectionModel) {
        this.topAnchorPoint.addElement(iConnectionModel);
        this.fireStructureChange("inputs", iConnectionModel);
    }

    public void connectOutput(ConnectionGEFModel iConnectionModel) {
        this.bottomAnchorPoint.addElement(iConnectionModel);
        this.fireStructureChange("outputs", iConnectionModel);
    }

    public void disconnectInput(ConnectionGEFModel iConnectionModel) {
        this.topAnchorPoint.remove(iConnectionModel);
        this.fireStructureChange("inputs", iConnectionModel);
    }

    public void disconnectOutput(ConnectionGEFModel iConnectionModel) {
        this.bottomAnchorPoint.removeElement(iConnectionModel);
        this.fireStructureChange("outputs", iConnectionModel);
    }

    public void setParent(SegmentGEFModel parent) {
        this.parentSegmentGEFModel = parent;
    }

    public SegmentGEFModel getParent() {
        return this.parentSegmentGEFModel;
    }

    public void removeChildGefSegment(SegmentGEFModel childGefSegment) {
        this.childGEFSegments.remove(childGefSegment);
        childGefSegment.setParent(null);
        if (this.childGEFSegmentsFromRLC != null && this.childGEFSegmentsFromRLC.contains(childGefSegment)) {
            this.childGEFSegmentsFromRLC.remove(childGefSegment);
        }
        if (this.childGEFSegmentsFromTargetParent != null && this.childGEFSegmentsFromTargetParent.contains(childGefSegment)) {
            this.childGEFSegmentsFromTargetParent.remove(childGefSegment);
        }
        if (this.segmentModel.getChildSegments().contains(childGefSegment.getSegmentModel())) {
            this.segmentModel.removeSegment(childGefSegment.getSegmentModel());
        }
    }

    public void addChild(SegmentGEFModel childGEFSegment) {
        this.childGEFSegments.add(childGEFSegment);
        childGEFSegment.setParent(this);
        if (!this.segmentModel.getChildSegments().contains(childGEFSegment.getSegmentModel())) {
            this.segmentModel.getChildSegments().add(childGEFSegment.getSegmentModel());
            childGEFSegment.getSegmentModel().setParent(this.segmentModel);
        }
    }

    public void moveRLCChildrenToOtherSegment(SegmentGEFModel otherGefSegment) {
        ArrayList rlcChildren = null;
        ArrayList<SegmentGEFModel> temp = this.getChildGEFSegmentsFromRLC();
        if (temp != null) {
            rlcChildren = (ArrayList)temp.clone();
            int i = 0;
            while (i < rlcChildren.size()) {
                SegmentGEFModel childGefSegment = (SegmentGEFModel)rlcChildren.get(i);
                this.childGEFSegmentsFromRLC.remove(childGefSegment);
                this.childGEFSegments.remove(childGefSegment);
                otherGefSegment.addChild(childGefSegment);
                childGefSegment.setParent(otherGefSegment);
                Vector<ConnectionGEFModel> connections = childGefSegment.getParentConnections();
                int j = 0;
                while (j < connections.size()) {
                    ConnectionGEFModel conn = connections.elementAt(j);
                    conn.setParent(otherGefSegment);
                    otherGefSegment.connectOutput(conn);
                    ++j;
                }
                ++i;
            }
        }
    }

    public void addChildFromTargetParent(SegmentGEFModel childGEFSegment) {
        this.addChild(childGEFSegment);
        if (this.childGEFSegmentsFromTargetParent == null) {
            this.childGEFSegmentsFromTargetParent = new ArrayList();
        }
        this.childGEFSegmentsFromTargetParent.add(childGEFSegment);
    }

    public void addChildFromRLC(SegmentGEFModel childGEFSegment) {
        this.addChild(childGEFSegment);
        if (this.childGEFSegmentsFromRLC == null) {
            this.childGEFSegmentsFromRLC = new ArrayList();
        }
        this.childGEFSegmentsFromRLC.add(childGEFSegment);
    }

    protected int getLevel() {
        return this.nodeLevel;
    }

    protected void setLevel(int m_level) {
        this.nodeLevel = m_level;
    }

    public int getTreeWidth() {
        return this.treeWidth;
    }

    public void setTreeWidth(int treeWidth) {
        this.treeWidth = treeWidth;
    }

    public boolean isExpand() {
        return this.isNodeExpand;
    }

    public void setExpand(boolean expand) {
        if (this.isNodeExpand != expand) {
            this.toggleExpand();
        }
    }

    public void toggleExpand() {
        this.isNodeExpand = !this.isNodeExpand;
        int segType = this.getSegmentType();
        if (segType == 1) {
            SegmentGEFModel sourceGefSeg = this.getLogicalChildSourceGEFSegment();
            sourceGefSeg.toggleExpand();
            this.firePropertyChange("expansion", !this.isNodeExpand, this.isNodeExpand);
        } else if (segType == 2) {
            SegmentGEFModel sourceGefSeg = this.getLogicalChildSourceGEFSegment();
            sourceGefSeg.toggleExpand();
            SegmentGEFModel sourceGefSeg2 = this.getTargetParentSourceGEFSegment();
            sourceGefSeg2.toggleExpand();
            this.firePropertyChange("expansion", !this.isNodeExpand, this.isNodeExpand);
        } else {
            this.firePropertyChange("expansion", !this.isNodeExpand, this.isNodeExpand);
        }
    }

    public void setSize(Dimension iSize) {
        this.firePropertyChange("size", null, iSize);
    }

    public void setSize(int x, int y) {
        this.setSize(new Dimension(x, y));
    }

    public FieldProperties getFieldProperty(FieldGEFModel fieldGEFModel, String category) {
        HashMap<FieldGEFModel, FieldProperties> fieldMap = new HashMap<FieldGEFModel, FieldProperties>();
        FieldProperties prop = (FieldProperties)fieldMap.get(fieldGEFModel);
        if (prop == null) {
            prop = category != null ? new FieldProperties(fieldGEFModel, category) : new FieldProperties(fieldGEFModel);
            fieldMap.put(fieldGEFModel, prop);
        }
        return prop;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            if (this.segmentProperty == null) {
                this.segmentProperty = new SegmentProperties(this);
            }
            return this.segmentProperty;
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String prop, Object old, Object newValue) {
        this.listeners.firePropertyChange(prop, old, newValue);
    }

    protected void fireStructureChange(String prop, Object child) {
        this.listeners.firePropertyChange(prop, null, child);
    }

    public void handleStateChanged(ChangeEvent event) {
        try {
            if (event.getPropertyName().equalsIgnoreCase("selected") && this.openConfirmDialog) {
                logger.finer("Segment " + this.segmentModel.getImsName() + " was selected");
                boolean isSelected = ((ToggleModel)event.getSource()).isSelected();
                if (this.firstConfirmation) {
                    if (!this.store.getBoolean("EDITORS_SENSEG_WARNING")) {
                        if (isSelected) {
                            this.openInformationDialog(WorkbenchPlugin.descriptions.getString("WB121"));
                        } else {
                            this.openInformationDialog(WorkbenchPlugin.descriptions.getString("WB122"));
                        }
                    } else {
                        this.checkboxConfirmed = true;
                    }
                }
                if (this.checkboxConfirmed) {
                    Figure figure = this.getFigure();
                    figure.setFocusTraversable(false);
                    figure.setRequestFocusEnabled(true);
                    figure.requestFocus();
                    this.toggleSensitiveSegment(isSelected);
                    this.getDbGEFModel().fireEvent(new NodeEvents(13, this));
                } else {
                    this.openConfirmDialog = false;
                    ((ToggleModel)event.getSource()).setSelected(!isSelected);
                }
            } else {
                this.openConfirmDialog = true;
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "handleStateChanged(ChangeEvent event)", e);
            logger.error(e);
        }
    }

    public void toggleSensitiveSegment(boolean isSelected) throws ModelException {
        if (isSelected) {
            this.createSenseg(false, this.checkboxConfirmed);
        } else {
            this.deleteSenseg(false, this.checkboxConfirmed);
        }
        this.firstConfirmation = true;
    }

    private void setGEFSenseg(SensegModel sensegModel) throws ModelException {
        this.sensegModel = sensegModel;
        ArrayList senfieldModels = sensegModel.getSenfields();
        if (!this.dbGEFModel.getDbdModel().getAccessType().equals((Object)DBDConstants.DEDB) && this.dbGEFModel.getDbdModel().getAccessType().equals((Object)DBDConstants.MSDB)) {
            int i = 0;
            while (i < senfieldModels.size()) {
                SenfieldModel senfieldModel = (SenfieldModel)senfieldModels.get(i);
                int j = 0;
                while (j < this.getFieldsList().size()) {
                    FieldGEFModel fieldGEFModel = this.getFieldsList().get(j);
                    if (fieldGEFModel.getField().getImsName().equals(senfieldModel.getName())) {
                        fieldGEFModel.setSenfld(senfieldModel);
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int j = 0;
            while (j < this.getFieldsList().size()) {
                FieldGEFModel fieldGEFModel = this.getFieldsList().get(j);
                if (fieldGEFModel.getField().getName().indexOf(47) == -1) {
                    SenfieldModel senfieldModel = new SenfieldModel(fieldGEFModel.getField(), this.getSegmentModel());
                    fieldGEFModel.setSenfld(senfieldModel);
                }
                ++j;
            }
        }
    }

    private void resetGEFSenseg() {
        this.sensegModel = null;
        Iterator<FieldGEFModel> iter = this.getFieldsList().iterator();
        while (iter.hasNext()) {
            iter.next().setSenfld(null);
        }
    }

    private void createSenseg(boolean firstConfirmation, boolean checkboxConfirmed) throws ModelException {
        if (!this.isSenseg()) {
            logger.finest("Segment " + this.getSegmentName() + " is marked as sensitive.");
            this.firstConfirmation = firstConfirmation;
            this.checkboxConfirmed = checkboxConfirmed;
            SensegModel sensegModel = new SensegModel(this.getSegmentModel());
            this.setGEFSenseg(sensegModel);
            this.firePropertyChange("Senseg", null, null);
            this.setParent(this.getParent());
            if (this.parentSegmentGEFModel != null) {
                if (!this.parentSegmentGEFModel.isSenseg()) {
                    this.parentSegmentGEFModel.createSenseg(false, this.checkboxConfirmed);
                }
                this.parentSegmentGEFModel.getSenSeg().addChild(sensegModel);
                sensegModel.setParent(this.parentSegmentGEFModel.getSenSeg());
            }
            this.checkboxConfirmed = false;
        }
    }

    protected void deleteSenseg(boolean firstConfirmation, boolean checkboxConfirmed) {
        if (this.isSenseg() && this.getFieldsList() != null) {
            logger.finest("Segment " + this.getSegmentName() + " is marked as NOT sensitive.");
            this.firstConfirmation = firstConfirmation;
            this.checkboxConfirmed = checkboxConfirmed;
            if (this.sensegModel.getParent() != null) {
                this.sensegModel.getParent().removeChild(this.sensegModel);
            }
            this.resetGEFSenseg();
            this.firePropertyChange("Senseg", null, null);
            Iterator<SegmentGEFModel> iter1 = this.getChildGEFSegments().iterator();
            while (iter1.hasNext()) {
                iter1.next().deleteSenseg(false, this.checkboxConfirmed);
            }
            this.checkboxConfirmed = false;
        }
    }

    public void setSenSeg(SensegModel sensegModel) {
        this.sensegModel = sensegModel;
    }

    public void setSegmentModel(SegmentModel segModel) {
        this.segmentModel = segModel;
    }

    public SensegModel getSenSeg() {
        return this.sensegModel;
    }

    public void refreshFieldList() throws InvalidDBDSourceException, ModelException {
        this.fieldList = new Vector();
        this.addFieldGEFModels();
    }

    private void openInformationDialog(String msg) {
        InfoDialog dialog = new InfoDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), WorkbenchPlugin.descriptions.getString("WB120"), null, WorkbenchModelBundle.getNoXlatLabel().getString("EAWC_EDITORS_SENSEG_WARNING") + " - " + msg, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.setWarningType("EDITORS_SENSEG_WARNING");
        this.checkboxConfirmed = dialog.open() == 0;
    }
}

