/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.model;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.model.NodeEvents;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.SenfieldModel;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.views.properties.IPropertySource;

public class FieldGEFModel
implements IAdaptable {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public static final int FIELD_NO_KEY = 2200;
    public static final int FIELD_UNIQUE_KEY = 2201;
    public static final int FIELD_NON_UNIQUE_KEY = 2202;
    public static final int FIELD_TYPE_USER = 2203;
    private SegmentGEFModel segmentGEFModel;
    private SenfieldModel senfldModel;
    private FieldModel fieldModel;
    private Vector<FieldGEFModel> childFields;
    private boolean isVirtualKey;
    private String fieldXMLType;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    public FieldGEFModel(SegmentGEFModel segmentGEFModel, FieldModel fieldModel, SenfieldModel senfldModel) {
        this.segmentGEFModel = segmentGEFModel;
        this.fieldModel = fieldModel;
        this.senfldModel = senfldModel;
    }

    public FieldModel getField() {
        return this.fieldModel;
    }

    public String getIMSName() {
        return this.fieldModel.getImsName();
    }

    public void setIMSName(String newValue) {
        this.fieldModel.setImsName(newValue);
    }

    public String getAlias() {
        String retVal = this.fieldModel.getName();
        if (retVal == null || retVal.equals("")) {
            retVal = this.fieldModel.getImsName();
        }
        return retVal;
    }

    public void setAlias(String newValue, boolean NotVirtualKeyFld) {
        if (this.fieldModel.getName() == null) {
            this.fieldModel.setName(newValue);
        } else if (!newValue.equals(this.fieldModel.getName())) {
            String oldValue = this.fieldModel.getName();
            this.fieldModel.setName(newValue);
            if (NotVirtualKeyFld) {
                this.setNodeAttribute("alias", newValue);
                this.firePropertyChange("Alias", oldValue, newValue);
                this.segmentGEFModel.getDbGEFModel().recalculateLayout();
            }
        }
    }

    private void setNodeAttribute(String name, String value) {
        this.segmentGEFModel.getDbGEFModel().fireEvent(new NodeEvents(2, this));
    }

    public int getStartPos() {
        return this.fieldModel.getStartPos();
    }

    public void setStartPos(int newValue) {
        this.fieldModel.setStartPos(newValue);
    }

    public int getBytes() {
        return this.fieldModel.getBytes() > 0 ? this.fieldModel.getBytes() : this.fieldModel.getMaxBytes();
    }

    public void setBytes(int newValue) {
        this.fieldModel.setBytes(newValue);
    }

    public String getPhysicalDataType() {
        String dataType = null;
        if (this.fieldModel.getPhysicalDataType() != null) {
            dataType = this.fieldModel.getPhysicalDataType().toString();
        }
        return dataType;
    }

    public void setDataType(String newValue) {
        this.fieldModel.setPhysicalDataType(DBDConstants.valueOf((String)newValue));
    }

    public void setAppDatatype(String value) {
        this.fieldModel.setAppDatatype(DBDConstants.valueOf((String)value));
    }

    public String getAppDatatype() {
        String appDatatype = null;
        DBDConstants adt = this.fieldModel.getAppDatatype();
        if (adt != null) {
            appDatatype = adt.toString();
        }
        return appDatatype;
    }

    public String getImsDatatype() {
        if (this.fieldModel.getImsDatatype() == null) {
            return null;
        }
        return this.fieldModel.getImsDatatype().toString();
    }

    public void setImsDatatype(String value) {
        this.fieldModel.setImsDatatype(DBDConstants.valueOf((String)value.toString()));
    }

    public void setTypeQualifider(String newValue) {
        this.fieldModel.setPattern(newValue);
    }

    public String getTypeQualifier() {
        return this.fieldModel.getPattern();
    }

    public String getSeqType() {
        if (this.fieldModel.getSeqType() == null) {
            return null;
        }
        return this.fieldModel.getSeqType().toString();
    }

    public void setSeqType(String value) {
        this.fieldModel.setSeqType(DBDConstants.valueOf((String)value.toString()));
    }

    public String getOverflow() {
        return this.fieldModel.getOverflow();
    }

    public String getPattern() {
        return this.fieldModel.getPattern();
    }

    public String getEncoding() {
        return this.fieldModel.getEncoding();
    }

    public String getUrl() {
        return this.fieldModel.getUrl();
    }

    public String getXMLType() {
        return this.fieldXMLType;
    }

    public Integer getPrecision() {
        return this.fieldModel.getPrecision();
    }

    public void setPrecision(String value) {
        this.fieldModel.setPrecision(value);
    }

    public void setScale(String value) {
        this.fieldModel.setScale(value);
    }

    public Integer getScale() {
        return this.fieldModel.getScale();
    }

    public String getIsSigned() {
        if (this.fieldModel.getIsSigned() == null) {
            return null;
        }
        return this.fieldModel.getIsSigned().toString();
    }

    public void setIsSigned(String value) {
        this.fieldModel.setIsSigned(value);
    }

    public void setUserTypeConverer(String value) {
        this.fieldModel.setUserTypeConverer(value);
    }

    public String getUserTypeConverter() {
        return this.fieldModel.getUserTypeConverter();
    }

    public void setXMLType(String newValue) {
        if (!newValue.equalsIgnoreCase(this.fieldXMLType)) {
            String oldValue = this.fieldXMLType;
            this.fieldXMLType = newValue;
            this.firePropertyChange("XMLType", oldValue, newValue);
            this.segmentGEFModel.getDbGEFModel().recalculateLayout();
        }
    }

    public int getFieldType() {
        return 0;
    }

    public void setRemarks(String remarks) {
        this.fieldModel.setRemarks(remarks);
    }

    public String getRemarks() {
        return this.fieldModel.getRemarks();
    }

    public int getPropertyListSize() {
        return this.fieldModel.getPropertyListSize();
    }

    public String getPropertyName(int pos) {
        return this.fieldModel.getPropertyName(pos);
    }

    public String getPropertyValue(int pos) {
        return this.fieldModel.getPropertyValue(pos);
    }

    public void addNewProperty(String name, String value) {
        this.fieldModel.addNewProperty(name, value);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            if (this.isSenfld()) {
                return this.segmentGEFModel.getFieldProperty(this, WorkbenchPlugin.labels.getString("WB457") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB473") + ")");
            }
            return this.segmentGEFModel.getFieldProperty(this, WorkbenchPlugin.labels.getString("WB458") + " " + WorkbenchPlugin.noxlatlabels.getString("WB051"));
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String prop, Object old, Object newValue) {
        this.listeners.firePropertyChange(prop, old, newValue);
    }

    public String toString() {
        return this.fieldModel.getName();
    }

    public SegmentGEFModel getSegmentGEFModel() {
        return this.segmentGEFModel;
    }

    public void setSegmentGEFModel(SegmentGEFModel segmentGEFModel) {
        this.segmentGEFModel = segmentGEFModel;
    }

    public boolean isSeq() {
        return this.fieldModel.getSeqType() != null;
    }

    public boolean isSenfld() {
        return this.senfldModel != null;
    }

    public SenfieldModel getSenfld() {
        return this.senfldModel;
    }

    public void setSenfld(SenfieldModel senfldModel) {
        try {
            this.senfldModel = senfldModel;
            this.firePropertyChange("Senfld", null, null);
            this.segmentGEFModel.getDbGEFModel().fireEvent(new NodeEvents(14, this));
        }
        catch (Exception e) {
            logger.throwing(this.getClass().getName(), "setSenfld(SenfieldModel senfldType)", (Throwable)e);
            logger.error((Throwable)e);
        }
    }

    public void setVirtualKey(boolean isVirtualKey) {
        this.isVirtualKey = isVirtualKey;
    }

    public boolean isVirtualKey() {
        return this.isVirtualKey;
    }

    public void addChildField(FieldGEFModel childField) {
        if (this.childFields == null) {
            this.childFields = new Vector();
        }
        this.childFields.add(childField);
    }

    public Vector<FieldGEFModel> getChildFields() {
        return this.childFields;
    }
}

