/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.model;

import com.ibm.im.ims.metadata.dbd.ObjectFactory;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.importer.datastructure.ImportDsToDbdController;
import com.ibm.im.ims.workbench.editors.InvalidDBDSourceException;
import com.ibm.im.ims.workbench.editors.MissingDBDException;
import com.ibm.im.ims.workbench.editors.ResourceEditorPage;
import com.ibm.im.ims.workbench.editors.layout.DbdLayoutManager;
import com.ibm.im.ims.workbench.editors.model.ConnectionGEFModel;
import com.ibm.im.ims.workbench.editors.model.DbdBorderModel;
import com.ibm.im.ims.workbench.editors.model.DbdOrPcbList;
import com.ibm.im.ims.workbench.editors.model.DbdsGEFModel;
import com.ibm.im.ims.workbench.editors.model.FieldGEFModel;
import com.ibm.im.ims.workbench.editors.model.LogicalRelationshipGEFModel;
import com.ibm.im.ims.workbench.editors.model.NodeEventListener;
import com.ibm.im.ims.workbench.editors.model.NodeEvents;
import com.ibm.im.ims.workbench.editors.model.PsbGEFModel;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.editors.wizards.ManageLogicalRelWizard;
import com.ibm.im.ims.workbench.editors.wizards.ManageSecondaryIxWizard;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.LogicalChildModel;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.SensegModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.utilities.EditDatasetInfoDialog;
import com.ibm.im.ims.workbench.utilities.EditDbdInfoDialog;
import com.ibm.im.ims.workbench.utilities.EditSegmInfoDialog;
import com.ibm.im.ims.workbench.utilities.SearchDialog;
import com.ibm.im.ims.workbench.wizard.editsenseg.EditSenSegWizard;
import com.ibm.im.ims.workbench.wizard.importds.ImportDataStructureWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.draw2d.TitleBarBorder;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DbGEFModel
implements IAdaptable {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private final Vector<SegmentGEFModel> physicalDBDViewNodes = new Vector();
    private SegmentGEFModel physicalRootGEFSegment = null;
    private final Vector<SegmentGEFModel> logicalDBDViewNodes = new Vector();
    private SegmentGEFModel logicalRootGEFSegment = null;
    private Vector<DbGEFModel> logicallyRelatedDBDs = null;
    private Vector<LogicalRelationshipGEFModel> logicalRels = null;
    private DbGEFModel openedDbGEFModel = null;
    private DbdBorderModel dbdBorderModel;
    private DbdOrPcbList psbGEFModel;
    private DbdModel dbdModel = null;
    private PcbDBModel pcb = null;
    private boolean logicallyRelatedDBD = false;
    private ObjectFactory dbdObjFactory = null;
    private String projectName;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private ListenerList listenerList = new ListenerList(1);
    public ResourceEditorPage editorPage;
    private StringBuffer missingPhysicalDBDs = new StringBuffer();
    private boolean allNodesExpanded = false;

    public DbGEFModel(DbdOrPcbList psbGEFModel, PcbDBModel pcb, DbdModel dbdModel, String projectName) throws InvalidDBDSourceException, MissingDBDException, ModelException {
        this.openedDbGEFModel = this;
        this.psbGEFModel = psbGEFModel;
        this.dbdModel = dbdModel;
        this.pcb = pcb;
        this.projectName = projectName;
        this.dbdObjFactory = new ObjectFactory();
        this.dbdBorderModel = new DbdBorderModel(this);
        this.allNodesExpanded = WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("explorer_segment_expand_all_flag");
        SegmentModel rootSegmentModel = dbdModel.getRootSegment();
        DBDConstants dbAccessType = dbdModel.getAccessType();
        if (rootSegmentModel != null) {
            if (dbAccessType != DBDConstants.LOGICAL) {
                this.logicallyRelatedDBD = this.determineIfLogicallyRelatedDBD(rootSegmentModel, dbdModel);
                logger.finest("DBD " + dbdModel.getDbd().getDbdName() + " has logical relationship(s): " + this.logicallyRelatedDBD);
            }
            if (dbAccessType == DBDConstants.LOGICAL) {
                this.logicallyRelatedDBDs = new Vector(2);
                this.populateLogicalSourceDBDs(rootSegmentModel, dbdModel);
            }
            this.physicalRootGEFSegment = this.createSegmentGEFModel(rootSegmentModel);
            logger.finest("After opening dbd: " + dbdModel.getDbd().getDbdName() + " physicalDBDViewNodes.size(): " + this.physicalDBDViewNodes.size());
        }
    }

    public void assignSensegs(String pcbName) throws ModelException {
        SensegModel rootSenseg = this.pcb.getRootSenseg();
        String rootSensegName = rootSenseg.getName();
        String rootSegName = this.physicalRootGEFSegment.getSegmentName();
        String rootSegAlias = this.physicalRootGEFSegment.getSegmentAlias();
        if (!rootSensegName.equals(rootSegName) && !rootSensegName.equals(rootSegAlias)) {
            Object[] inserts = new Object[]{rootSensegName, pcbName, rootSegName, this.dbdModel.getDBDName()};
            ModelException me = new ModelException(WorkbenchPlugin.errors.getString("PSB_EDITOR_001", inserts));
            logger.throwing(this.getClass().getName(), "", (Throwable)me);
            throw me;
        }
        this.physicalRootGEFSegment.setSenSeg(rootSenseg);
        this.assignSensegsRecursively(this.physicalRootGEFSegment.getChildGEFSegments(), rootSenseg.getChildren());
    }

    public void assignSenfields() throws InvalidDBDSourceException, ModelException {
        this.assignSenfieldsRecursively(this.physicalRootGEFSegment);
    }

    private void assignSenfieldsRecursively(SegmentGEFModel gefSeg) throws InvalidDBDSourceException, ModelException {
        gefSeg.addFieldGEFModels();
        ArrayList<SegmentGEFModel> childGefSegs = gefSeg.getChildGEFSegments();
        int i = 0;
        while (i < childGefSegs.size()) {
            SegmentGEFModel currChildGefSeg = childGefSegs.get(i);
            this.assignSenfieldsRecursively(currChildGefSeg);
            ++i;
        }
    }

    private void assignSensegsRecursively(ArrayList<SegmentGEFModel> gefSegs, ArrayList<SensegModel> sensegs) {
        int i = 0;
        while (i < gefSegs.size()) {
            ArrayList childSensegs;
            SegmentGEFModel currSeg = gefSegs.get(i);
            SensegModel currSenseg = this.getSensegModel(sensegs, currSeg.getSegmentName());
            currSeg.setSenSeg(currSenseg);
            if (currSenseg != null && (childSensegs = currSenseg.getChildren()) != null && childSensegs.size() > 0) {
                this.assignSensegsRecursively(currSeg.getChildGEFSegments(), childSensegs);
            }
            ++i;
        }
    }

    private SensegModel getSensegModel(ArrayList<SensegModel> sensegs, String segName) {
        SensegModel retVal = null;
        int i = 0;
        while (i < sensegs.size()) {
            SensegModel currSenseg = sensegs.get(i);
            if (currSenseg.getName().equals(segName)) {
                retVal = currSenseg;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public void replacePhysicalNodesWithSecondaryDataStructure() throws InvalidDBDSourceException, ModelException {
        String procseq = this.pcb.getProcSequence();
        if (procseq == null || procseq.isEmpty()) {
            return;
        }
        SegmentModel indexTargetSeg = this.dbdModel.getTargetSegmentForProcseq(procseq);
        if (indexTargetSeg != null && !indexTargetSeg.isRoot()) {
            if (!this.editorPage.inApplicationView && this.logicalRootGEFSegment != null) {
                return;
            }
            this.createPotentialLogicalDBDNodes(this.getGEFSegment(this.getDbdName(), indexTargetSeg.getImsName()));
            this.physicalRootGEFSegment = this.logicalRootGEFSegment;
            this.physicalDBDViewNodes.removeAllElements();
            this.physicalDBDViewNodes.addAll(this.logicalDBDViewNodes);
        }
    }

    public String getProjectName() {
        return this.projectName;
    }

    public DbGEFModel(DbGEFModel openedDbGEFModel, DbdModel dbdModel) throws InvalidDBDSourceException, ModelException {
        this.openedDbGEFModel = openedDbGEFModel;
        this.dbdModel = dbdModel;
        this.physicalRootGEFSegment = this.createSegmentGEFModel(dbdModel.getRootSegment());
        this.dbdBorderModel = new DbdBorderModel(this);
        this.editorPage = openedDbGEFModel.editorPage;
        this.allNodesExpanded = WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("explorer_segment_expand_all_flag");
        if (this.editorPage != null && this.editorPage.getPsbMultiPageEditor() != null) {
            this.projectName = this.editorPage.getPsbMultiPageEditor().getProjectName();
        }
    }

    private void populateLogicalSourceDBDs(SegmentModel segment, DbdModel dbd) throws MissingDBDException, ModelException, InvalidDBDSourceException {
        this.populateLogicalSourceDBDsForSegment(segment, dbd);
        for (SegmentModel childSeg : segment.getChildSegments()) {
            this.populateLogicalSourceDBDs(childSeg, dbd);
        }
    }

    private void populateLogicalSourceDBDsForSegment(SegmentModel segment, DbdModel dbd) throws MissingDBDException, ModelException, InvalidDBDSourceException {
        if (logger.isLoggable(Level.FINER)) {
            String parm = dbd.getDbd().getDbdName() + "." + segment.getImsName();
            logger.entering(this.getClass().getName(), "populateLogicalSourceDBDsForSegment(SegmentGEFModel gefSegment, DbGEFModel gefDbd)", new Object[]{parm});
        }
        if (segment.hasSegmentSource()) {
            this.addLogicalSourceDBD(segment.getSegmentSourceDBName());
        } else if (segment.hasConcatenatedSegmentSource()) {
            this.addLogicalSourceDBD(segment.getLogicalChildSourceDBName());
            this.addLogicalSourceDBD(segment.getTargetParentSourceDBName());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "populateLogicalSourceDBDsForSegment(SegmentGEFModel gefSegment, DbGEFModel gefDbd)", new Object[0]);
        }
    }

    public DbGEFModel getOpenedDbGEFModel() {
        return this.openedDbGEFModel;
    }

    private void addLogicalSourceDBD(String dbdName) throws MissingDBDException, ModelException, InvalidDBDSourceException {
        logger.entering(this.getClass().getName(), "addLogicalSourceDBD(String dbdName)", new Object[]{dbdName});
        if (!this.isDbdInList(dbdName)) {
            try {
                logger.finer("New logical source DBD " + dbdName + " is not in the list. Reading it in now...");
                DbdModel newDb = ProjectTreeFileHelper.unmarshalDbd((String)dbdName, (String)this.projectName);
                if (newDb == null) {
                    Object[] inserts = new Object[]{dbdName};
                    throw new MissingDBDException(WorkbenchPlugin.errors.getString("DHB1701", inserts));
                }
                DbGEFModel newGefDb = new DbGEFModel(this, newDb);
                this.logicallyRelatedDBDs.addElement(newGefDb);
            }
            catch (CoreException e) {
                logger.throwing(this.getClass().getName(), "populateLogicalParentRels(SegmentModel segmentModel, DbdModel dbdModel)", (Throwable)e);
                logger.error((Throwable)e);
            }
        } else {
            logger.finer("New logical source DBD " + dbdName + " is already in the list.");
        }
        logger.exiting(this.getClass().getName(), "addLogicalSourceDBD(String dbdName)", new Object[0]);
    }

    public StringBuffer getMissingPhysicalDBDs() {
        return this.missingPhysicalDBDs;
    }

    public DbdBorderModel getDbdBorderModel() {
        return this.dbdBorderModel;
    }

    public boolean isLogicallyRelatedDBD() {
        return this.logicallyRelatedDBD;
    }

    public void toggleRelDBDs() throws MissingDBDException, ModelException, InvalidDBDSourceException {
        logger.entering(this.getClass().getName(), "toggleRelDBDs()", new Object[0]);
        if (this.editorPage.inDisplayRelatedDBDsMode) {
            this.editorPage.inDisplayRelatedDBDsMode = false;
            this.goToPhysicalOnlyMode();
            this.fireEvent(new NodeEvents(9, this));
        } else {
            this.editorPage.inDisplayRelatedDBDsMode = true;
            try {
                this.goToRelatedDBDMode();
            }
            catch (MissingDBDException e) {
                this.editorPage.inDisplayRelatedDBDsMode = false;
                throw e;
            }
            catch (ModelException e) {
                this.editorPage.inDisplayRelatedDBDsMode = false;
                throw e;
            }
            catch (InvalidDBDSourceException e) {
                this.editorPage.inDisplayRelatedDBDsMode = false;
                throw e;
            }
            this.createLogicalConnections();
            this.fireEvent(new NodeEvents(9, this));
            this.recalculateLayout();
        }
        logger.exiting(this.getClass().getName(), "toggleRelDBDs()", new Object[0]);
    }

    private void goToPhysicalOnlyMode() {
        int i = 0;
        while (i < this.logicallyRelatedDBDs.size()) {
            this.removeRelDBDSegmentsFromView(this.logicallyRelatedDBDs.elementAt(i).getPhysicalRootGEFSegment());
            ++i;
        }
        this.removeLogicalConnections();
    }

    private void goToRelatedDBDMode() throws MissingDBDException, ModelException, InvalidDBDSourceException {
        if (this.logicallyRelatedDBDs == null) {
            this.logicallyRelatedDBDs = new Vector();
        }
        this.populateLogicalRelsForDbd(this.physicalRootGEFSegment, this);
        if (!this.editorPage.inLogicalViewMode) {
            int i = 0;
            while (i < this.logicallyRelatedDBDs.size()) {
                this.addRelDBDSegmentsToView(this.logicallyRelatedDBDs.elementAt(i).getPhysicalRootGEFSegment());
                ++i;
            }
        }
    }

    public void toggleLogicalView(SegmentGEFModel seg) throws ModelException, MissingDBDException, InvalidDBDSourceException {
        logger.entering(this.getClass().getName(), "inLogicalViewMode(SegmentGEFModel seg)", new Object[]{seg});
        if (this.editorPage.inLogicalViewMode) {
            logger.finer(" toggleLocalview is true");
            this.editorPage.inLogicalViewMode = false;
            this.fireEvent(new NodeEvents(10, this));
            this.recalculateLayout();
        } else {
            logger.finer(" toggleLocalview is false");
            this.editorPage.inLogicalViewMode = true;
            try {
                this.goToRelatedDBDMode();
            }
            catch (MissingDBDException e) {
                this.editorPage.inLogicalViewMode = false;
                throw e;
            }
            catch (ModelException e) {
                this.editorPage.inLogicalViewMode = false;
                throw e;
            }
            catch (InvalidDBDSourceException e) {
                this.editorPage.inLogicalViewMode = false;
                throw e;
            }
            try {
                this.goToLogicalViewMode(seg);
            }
            catch (InvalidDBDSourceException e) {
                this.editorPage.inLogicalViewMode = false;
                throw e;
            }
            this.fireEvent(new NodeEvents(10, this));
            this.recalculateLayout();
        }
        logger.exiting(this.getClass().getName(), "inLogicalViewMode(SegmentGEFModel seg)", new Object[0]);
    }

    public void launchManageSecondaryIx(SegmentGEFModel seg, IWorkbenchWindow window) {
        logger.entering(this.getClass().getName(), "launchManageSecondaryIx(SegmentGEFModel seg)", new Object[]{seg.getSegmentName()});
        ManageSecondaryIxWizard wizard = new ManageSecondaryIxWizard();
        wizard.setGefSegment(seg);
        WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            seg.updateSegmentLabelVisuals();
        }
        logger.exiting(this.getClass().getName(), "launchManageSecondaryIx(SegmentGEFModel seg)", new Object[0]);
    }

    public void launchManageLogicalRel(SegmentGEFModel seg, IWorkbenchWindow window) {
        logger.entering(this.getClass().getName(), "launchManageSecondaryIx(SegmentGEFModel seg)", new Object[]{seg.getSegmentName()});
        ManageLogicalRelWizard wizard = new ManageLogicalRelWizard();
        wizard.setGefSegment(seg);
        WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            seg.updateSegmentLabelVisuals();
            this.logicallyRelatedDBD = this.determineIfLogicallyRelatedDBD(this.dbdModel.getRootSegment(), this.dbdModel);
        }
        logger.exiting(this.getClass().getName(), "launchManageSecondaryIx(SegmentGEFModel seg)", new Object[0]);
    }

    public void launchEditSenSegSenField(SegmentGEFModel seg, IWorkbenchWindow window, ResourceEditorPage page, boolean isReadOnly) {
        logger.entering(this.getClass().getName(), "launchEditSenSegSenField(SegmentGEFModel seg)", new Object[]{seg.getSegmentName()});
        EditSenSegWizard wizard = new EditSenSegWizard(seg, this, page, this.pcb, isReadOnly);
        wizard.setGefSegment(seg);
        WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            seg.setExpand(true);
            this.editorPage.getPsbMultiPageEditor().setDirty(true);
            this.fireEvent(new NodeEvents(4, this));
            this.recalculateLayout();
        }
        logger.exiting(this.getClass().getName(), "launchEditSenSegSenField(SegmentGEFModel seg)", new Object[0]);
    }

    public void launchImportDataStructure(SegmentGEFModel seg, IWorkbenchWindow window) throws InvalidDBDSourceException, ModelException {
        if (seg.getSegmentModel() != null) {
            logger.entering(this.getClass().getName(), "launchImportDataStructure(SegmentGEFModel seg,IWorkbenchWindow window)", new Object[]{seg.getSegmentName()});
        } else {
            logger.entering(this.getClass().getName(), "launchImportDataStructure(SegmentGEFModel seg,IWorkbenchWindow window)", new Object[0]);
        }
        ImportDsToDbdController controller = new ImportDsToDbdController(seg.getSegmentModel(), seg.getDbGEFModel().getDbdModel(), this.projectName);
        DbGEFModel dbGefModel = seg.getDbGEFModel();
        ResourceEditorPage editor = dbGefModel.getEditorPage();
        ImportDataStructureWizard wizard = new ImportDataStructureWizard(controller, editor);
        WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(wizard.getShell().getMinimumSize());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            seg.toggleExpand();
            seg.setExpand(true);
            Vector affectedSegmentNames = controller.getAffectedSegmentNames();
            for (String segName : affectedSegmentNames) {
                if (dbGefModel.getDbdModel().getRootSegment() == null) {
                    dbGefModel.setPhysicalRootGEFSegment(controller.getExistingSegmentModel(segName));
                }
                SegmentGEFModel currAffectedSeg = dbGefModel.getSegmentGEFModel(segName);
                currAffectedSeg.setExpand(false);
                currAffectedSeg.refreshFieldList();
                currAffectedSeg.setExpand(true);
            }
            try {
                this.fireEvent(new NodeEvents(2, this));
            }
            catch (Throwable e) {
                logger.throwing(this.getClass().getName(), "launchImportDataStructure(SegmentGEFModel seg,IWorkbenchWindow window)", e);
                logger.error(e);
            }
            this.recalculateLayout();
        }
        logger.exiting(this.getClass().getName(), "launchImportDataStructure(SegmentGEFModel seg,IWorkbenchWindow window)", new Object[0]);
    }

    public void launchEditEncoding(SegmentGEFModel seg, IWorkbenchWindow window, boolean isReadOnly) throws Exception {
        logger.entering(this.getClass().getName(), "launchEditEncoding(SegmentGEFModel seg,IWorkbenchWindow window)", new Object[]{seg != null ? seg.getSegmentName() : this.getDbdName()});
        SegmentModel segment = seg.getSegmentModel();
        EditSegmInfoDialog dialog = new EditSegmInfoDialog(this.projectName, window.getShell(), segment, isReadOnly);
        if (dialog.open() == 0) {
            seg.setSegAlias(seg.getSegmentAlias());
            if (segment.hasConcatenatedSegmentSource() || segment.hasSegmentSource()) {
                SegmentGEFModel lseg2;
                SegmentGEFModel lseg1 = seg.getLogicalChildSourceGEFSegment();
                if (lseg1 != null) {
                    lseg1.refreshFieldList();
                }
                if ((lseg2 = seg.getTargetParentSourceGEFSegment()) != null) {
                    lseg2.refreshFieldList();
                }
                seg.toggleExpand();
                seg.getDbGEFModel().getOpenedDbGEFModel().recalculateLayout();
                seg.toggleExpand();
                seg.getDbGEFModel().getOpenedDbGEFModel().recalculateLayout();
            }
            this.editorPage.getPsbMultiPageEditor().setDirty(true);
        }
        logger.exiting(this.getClass().getName(), "launchEditEncoding(SegmentGEFModel seg,IWorkbenchWindow window)", new Object[]{seg != null ? seg.getSegmentName() : this.getDbdName()});
    }

    public void launchEditVersionDbver(IWorkbenchWindow window, boolean isReadOnly) throws ModelException {
        logger.entering(this.getClass().getName(), "launchEditVersionDbver(IWorkbenchWindow window, boolean isReadOnly)", new Object[]{this.getDbdName()});
        EditDbdInfoDialog dialog = new EditDbdInfoDialog(window.getShell(), this.dbdModel, isReadOnly);
        if (dialog.open() == 0) {
            this.editorPage.getPsbMultiPageEditor().setDirty(true);
        }
        logger.exiting(this.getClass().getName(), "launchEditVersionDbver(IWorkbenchWindow window, boolean isReadOnly)", new Object[]{this.getDbdName()});
    }

    public void launchEditDataset(IWorkbenchWindow window, boolean isReadOnly) throws ModelException {
        logger.entering(this.getClass().getName(), "launchEditDataset(IWorkbenchWindow window, boolean isReadOnly)", new Object[]{this.getDbdName()});
        EditDatasetInfoDialog dialog = new EditDatasetInfoDialog(window.getShell(), this.dbdModel, isReadOnly);
        if (dialog.open() == 0) {
            this.editorPage.getPsbMultiPageEditor().setDirty(true);
        }
        logger.exiting(this.getClass().getName(), "launchEditDataset(IWorkbenchWindow window, boolean isReadOnly)", new Object[]{this.getDbdName()});
    }

    public void launchSearch() {
        logger.entering(this.getClass().getName(), "launchSearch()", new Object[]{this.getDbdName()});
        SearchDialog dialog = new SearchDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.editorPage);
        dialog.open();
        logger.exiting(this.getClass().getName(), "launchSearch()", new Object[]{this.getDbdName()});
    }

    public void toggleConcatenate(SegmentGEFModel seg) throws Exception {
        logger.entering(this.getClass().getName(), "toggleConcatenate(SegmentGEFModel seg)", new Object[]{seg.getSegmentName()});
        if (seg.getSegmentType() == 2) {
            logger.finer(seg.getSegmentName() + " is a concatenated segment");
            this.undoConcatenation(seg);
            this.fireEvent(new NodeEvents(11, this));
            this.recalculateLayout();
        } else {
            logger.finer(seg.getSegmentName() + " is NOT a concatenated segment");
            if (this.logicallyRelatedDBDs == null || this.logicallyRelatedDBDs.size() == 0) {
                this.goToRelatedDBDMode();
            }
            this.doConcatenation(seg);
            this.fireEvent(new NodeEvents(11, this));
            this.recalculateLayout();
        }
        logger.exiting(this.getClass().getName(), "toggleConcatenate(SegmentGEFModel seg)", new Object[0]);
    }

    private void goToLogicalViewMode(SegmentGEFModel seg) throws InvalidDBDSourceException, ModelException {
        if (this.logicalDBDViewNodes.size() == 0) {
            this.createPotentialLogicalDBDNodes(seg);
        } else {
            String currentLogicalRootSegName;
            String newLogicalRootSegName = seg.getSegmentName();
            if (!newLogicalRootSegName.equalsIgnoreCase(currentLogicalRootSegName = this.logicalRootGEFSegment.getSegmentName()) || this.isPsb() && this.editorPage.inApplicationView) {
                this.logicalDBDViewNodes.clear();
                this.createPotentialLogicalDBDNodes(seg);
            }
        }
    }

    private void createPotentialLogicalDBDNodes(SegmentGEFModel rootSegment) throws InvalidDBDSourceException, ModelException {
        logger.entering(this.getClass().getName(), "createPotentialLogicalDBDNodes(SegmentGEFModel rootSegment)", new Object[]{rootSegment.getSegmentName()});
        DBDConstants accessType = rootSegment.getDbGEFModel().getDbdModel().getAccessType();
        this.logicalRootGEFSegment = this.buildSubtreeClone(rootSegment, true);
        if (this.isPsb() && this.editorPage.inApplicationView) {
            this.logicalRootGEFSegment.setSenSeg(rootSegment.getSenSeg());
        }
        SegmentGEFModel newViewCurrGefSegment = this.logicalRootGEFSegment;
        SegmentGEFModel oldViewCurrGefSegment = rootSegment.getParent();
        while (oldViewCurrGefSegment != null) {
            logger.finer("current old segment: " + oldViewCurrGefSegment.getSegmentName());
            SegmentGEFModel parentOfCurrSeg = oldViewCurrGefSegment.getParent();
            boolean includeChildSegments = true;
            if (accessType == DBDConstants.DEDB && parentOfCurrSeg == null) {
                includeChildSegments = false;
            }
            SegmentGEFModel temp = this.buildSubtreeClone(oldViewCurrGefSegment, includeChildSegments);
            newViewCurrGefSegment.addChild(temp);
            ConnectionGEFModel connection = new ConnectionGEFModel(true);
            connection.setName("Connection from " + temp.getSegmentAlias() + " to " + newViewCurrGefSegment.getSegmentAlias());
            connection.setChild(temp);
            connection.setChildTerminal("Anchor_top");
            temp.connectInput(connection);
            connection.setParent(newViewCurrGefSegment);
            connection.setParentTerminal("Anchor_bottom");
            newViewCurrGefSegment.connectOutput(connection);
            newViewCurrGefSegment = temp;
            oldViewCurrGefSegment = oldViewCurrGefSegment.getParent();
        }
        logger.exiting(this.getClass().getName(), "createPotentialLogicalDBDNodes(SegmentGEFModel rootSegment)", new Object[0]);
    }

    private void undoConcatenation(SegmentGEFModel gefSegment) {
        SegmentGEFModel gefParent = gefSegment.getParent();
        if (gefParent == null) {
            return;
        }
        gefParent.removeChildGefSegment(gefSegment);
        this.removeGefConnections(gefSegment, true, false);
        SegmentGEFModel lchildGefSegment = gefSegment.getLogicalChildSourceGEFSegment();
        lchildGefSegment.setLogicalSourceSegment(false);
        gefParent.addChild(lchildGefSegment);
        this.createNewGefConnection(lchildGefSegment, gefParent);
        this.logicalDBDViewNodes.add(lchildGefSegment);
        gefSegment.moveRLCChildrenToOtherSegment(lchildGefSegment);
        this.freeSubtree(gefSegment);
    }

    private void freeSubtree(SegmentGEFModel gefSegment) {
        ArrayList children = (ArrayList)gefSegment.getChildGEFSegments().clone();
        int i = 0;
        while (i < children.size()) {
            SegmentGEFModel childGefSegment = (SegmentGEFModel)children.get(i);
            this.freeSubtree(childGefSegment);
            ++i;
        }
        this.logicalDBDViewNodes.remove(gefSegment);
        SegmentGEFModel parentGefSegment = gefSegment.getParent();
        if (parentGefSegment != null) {
            parentGefSegment.removeChildGefSegment(gefSegment);
            this.removeGefConnections(gefSegment, true, false);
        }
    }

    private void doConcatenation(SegmentGEFModel gefSegment) throws InvalidDBDSourceException, ModelException {
        logger.entering(this.getClass().getName(), "doConcatenation(SegmentGEFModel gefSegment)", new Object[]{gefSegment.getSegmentName()});
        SegmentGEFModel targetParentGefSegment = null;
        if (gefSegment.getSegmentModel().isVirtualLogicalChild()) {
            logger.finer(gefSegment.getSegmentName() + " is a virtual logical child segment");
            SegmentGEFModel logSourceGefSegment = this.getGEFSegment(gefSegment.getSegmentModel().getSegmentSourceDBName(), gefSegment.getSegmentModel().getSegmentSourceSegName());
            targetParentGefSegment = logSourceGefSegment.getParent();
        } else {
            logger.finer(gefSegment.getSegmentName() + " is a real logical child segment");
            targetParentGefSegment = this.getGEFSegment(gefSegment.getSegmentModel().getLogicalParentDbdName(), gefSegment.getSegmentModel().getLogicalParentName());
        }
        DbdModel newDbdModel = new DbdModel("dummy");
        newDbdModel.setAccessType(DBDConstants.LOGICAL.toString());
        SegmentModel newConcatenatedSegmentModel = new SegmentModel(newDbdModel);
        newConcatenatedSegmentModel.setSegmentType(DBDConstants.LOGICAL);
        newConcatenatedSegmentModel.setImsName(gefSegment.getSegmentName());
        newConcatenatedSegmentModel.setName(gefSegment.getSegmentName() + "_concatenated");
        newConcatenatedSegmentModel.createConcatenatedSegmentSource();
        newConcatenatedSegmentModel.setLogicalChildSourceData(DBDConstants.N);
        newConcatenatedSegmentModel.setLogicalChildSourceDBName(gefSegment.getSegmentModel().getDbdName());
        newConcatenatedSegmentModel.setLogicalChildSourceSegName(gefSegment.getSegmentName());
        newConcatenatedSegmentModel.setTargetParentSourceDBName(targetParentGefSegment.getSegmentModel().getDbdName());
        newConcatenatedSegmentModel.setTargetParentSourceSegName(targetParentGefSegment.getSegmentName());
        newConcatenatedSegmentModel.setTargetParentSourceData(DBDConstants.N);
        SegmentGEFModel clonedTargetParentSegment = new SegmentGEFModel(targetParentGefSegment);
        gefSegment.setLogicalSourceSegment(true);
        clonedTargetParentSegment.setLogicalSourceSegment(true);
        SegmentGEFModel newConcatenatedGefSegment = new SegmentGEFModel(this, newConcatenatedSegmentModel, gefSegment, clonedTargetParentSegment, false);
        this.buildSubtreeCloneForNewConcatenatedSegment(newConcatenatedGefSegment, targetParentGefSegment);
        if (gefSegment.getSegmentModel().isRealLogicalChild()) {
            this.placeChildrenUnderNewParent(gefSegment, newConcatenatedGefSegment);
        }
        this.logicalDBDViewNodes.add(newConcatenatedGefSegment);
        this.logicalDBDViewNodes.remove(gefSegment);
        SegmentGEFModel parentGefSegment = gefSegment.getParent();
        parentGefSegment.getChildGEFSegments().remove(gefSegment);
        parentGefSegment.getChildGEFSegments().add(newConcatenatedGefSegment);
        newConcatenatedGefSegment.setParent(parentGefSegment);
        Vector<ConnectionGEFModel> conns = gefSegment.getParentConnections();
        int i = 0;
        while (i < conns.size()) {
            ConnectionGEFModel connection = conns.elementAt(i);
            gefSegment.disconnectInput(connection);
            SegmentGEFModel logicalOrPhysParent = connection.getParent();
            logicalOrPhysParent.disconnectOutput(connection);
            ++i;
        }
        this.createNewGefConnection(newConcatenatedGefSegment, parentGefSegment);
        logger.exiting(this.getClass().getName(), "doConcatenation(SegmentGEFModel gefSegment)", new Object[0]);
    }

    private void createNewGefConnection(SegmentGEFModel childGefSegment, SegmentGEFModel parentGefSegment) {
        ConnectionGEFModel connection = new ConnectionGEFModel(true);
        connection.setName("Connection from " + childGefSegment.getSegmentAlias() + " to " + parentGefSegment.getSegmentAlias());
        connection.setChild(childGefSegment);
        connection.setChildTerminal("Anchor_top");
        childGefSegment.connectInput(connection);
        connection.setParent(parentGefSegment);
        connection.setParentTerminal("Anchor_bottom");
        parentGefSegment.connectOutput(connection);
    }

    private void placeChildrenUnderNewParent(SegmentGEFModel oldParent, SegmentGEFModel newParent) {
        ArrayList children = (ArrayList)oldParent.getChildGEFSegments().clone();
        int i = 0;
        while (i < children.size()) {
            SegmentGEFModel childGefSegment = (SegmentGEFModel)children.get(i);
            Vector<ConnectionGEFModel> parentConnections = childGefSegment.getParentConnections();
            int j = 0;
            while (j < parentConnections.size()) {
                ConnectionGEFModel connection = parentConnections.elementAt(j);
                SegmentGEFModel gefParent = connection.getParent();
                gefParent.disconnectOutput(connection);
                connection.setParent(newParent);
                newParent.connectOutput(connection);
                oldParent.removeChildGefSegment(childGefSegment);
                childGefSegment.setParent(newParent);
                newParent.addChildFromRLC(childGefSegment);
                ++j;
            }
            ++i;
        }
    }

    private SegmentGEFModel getGEFSegment(String dbdName, String segName) {
        SegmentGEFModel retVal = null;
        if (this.getDbdName().equalsIgnoreCase(dbdName)) {
            retVal = this.getSegmentGEFModel(segName);
        } else {
            DbGEFModel gefDbd = this.getLogicalDbGEFModel(dbdName);
            retVal = gefDbd.getSegmentGEFModel(segName);
        }
        return retVal;
    }

    private DbGEFModel getLogicalDbGEFModel(String dbdName) {
        DbGEFModel retVal = null;
        int i = 0;
        while (i < this.logicallyRelatedDBDs.size()) {
            if (this.logicallyRelatedDBDs.elementAt(i).getDbdName().equals(dbdName)) {
                retVal = this.logicallyRelatedDBDs.elementAt(i);
                break;
            }
            ++i;
        }
        return retVal;
    }

    private LogicalRelationshipGEFModel getLogicalRel(String logicalParentSegment, String logicalParentDbd, String realLogicalChildSegment, String realLogicalChildDbd) {
        LogicalRelationshipGEFModel retVal = null;
        if (this.logicalRels != null) {
            int i = 0;
            while (i < this.logicalRels.size()) {
                LogicalRelationshipGEFModel temp = this.logicalRels.elementAt(i);
                if (temp.getLogicalParentDbd() != null && temp.getLogicalParentDbd().equalsIgnoreCase(logicalParentDbd) && temp.getLogicalParentSegment() != null && temp.getLogicalParentSegment().equalsIgnoreCase(logicalParentSegment) && temp.getRealLogicalChildDbd() != null && temp.getRealLogicalChildDbd().equalsIgnoreCase(realLogicalChildDbd) && temp.getRealLogicalChildSegment() != null && temp.getRealLogicalChildSegment().equalsIgnoreCase(realLogicalChildSegment)) {
                    retVal = temp;
                    break;
                }
                ++i;
            }
        }
        return retVal;
    }

    public void addLogicalRel(LogicalRelationshipGEFModel logicalRel) {
        if (this.logicalRels == null) {
            this.logicalRels = new Vector();
        }
        this.logicalRels.addElement(logicalRel);
    }

    public Vector<LogicalRelationshipGEFModel> getLogicalRelationships() {
        return this.logicalRels;
    }

    public SegmentGEFModel getPhysicalRootGEFSegment() {
        return this.physicalRootGEFSegment;
    }

    public SegmentGEFModel getLogicalRootGEFSegment() {
        return this.logicalRootGEFSegment;
    }

    private void addRelDBDSegmentsToView(SegmentGEFModel gefSegment) {
        this.physicalDBDViewNodes.add(gefSegment);
        ArrayList<SegmentGEFModel> children = gefSegment.getChildGEFSegments();
        int i = 0;
        while (i < children.size()) {
            SegmentGEFModel childGefSegment = children.get(i);
            this.addRelDBDSegmentsToView(childGefSegment);
            ++i;
        }
    }

    private void removeRelDBDSegmentsFromView(SegmentGEFModel gefSegment) {
        this.physicalDBDViewNodes.remove(gefSegment);
        ArrayList<SegmentGEFModel> array = gefSegment.getChildGEFSegments();
        int i = 0;
        while (i < array.size()) {
            SegmentGEFModel childSegment = array.get(i);
            this.removeRelDBDSegmentsFromView(childSegment);
            ++i;
        }
    }

    public ObjectFactory getDbdObjFactory() {
        return this.dbdObjFactory;
    }

    public DbdModel getDbdModel() {
        return this.dbdModel;
    }

    private void createLogicalConnections() {
        logger.finest("Num logically related DBDs: " + this.logicallyRelatedDBDs.size());
        int i = 0;
        while (i < this.logicalRels.size()) {
            SegmentGEFModel parentGEFSegment = this.logicalRels.elementAt(i).getGefLogicalParent();
            SegmentGEFModel childGEFSegment = this.logicalRels.elementAt(i).getGefRealLogicalChild();
            if (parentGEFSegment != null && childGEFSegment != null) {
                ConnectionGEFModel connection = new ConnectionGEFModel(childGEFSegment, parentGEFSegment);
                childGEFSegment.connectInput(connection);
                parentGEFSegment.connectOutput(connection);
            }
            ++i;
        }
    }

    private void removeLogicalConnections() {
        int i = 0;
        while (i < this.logicalRels.size()) {
            SegmentGEFModel childGefSegment = this.logicalRels.elementAt(i).getGefRealLogicalChild();
            if (childGefSegment != null) {
                this.removeGefConnections(childGefSegment, false, true);
            }
            ++i;
        }
    }

    private void removeGefConnections(SegmentGEFModel childGefSegment, boolean removePhysicalConnections, boolean removeLogicalConnections) {
        Vector<ConnectionGEFModel> parentConnections = childGefSegment.getParentConnections();
        int j = 0;
        while (j < parentConnections.size()) {
            ConnectionGEFModel parentConnection = parentConnections.elementAt(j);
            if (parentConnection.isPhysicalConnection() && removePhysicalConnections || !parentConnection.isPhysicalConnection() && removeLogicalConnections) {
                SegmentGEFModel parentGefSegment = parentConnection.getParent();
                logger.finer("Removing connection from " + childGefSegment.getSegmentAlias() + " to " + parentGefSegment.getSegmentAlias());
                parentGefSegment.disconnectOutput(parentConnection);
                childGefSegment.disconnectInput(parentConnection);
            }
            ++j;
        }
    }

    private boolean determineIfLogicallyRelatedDBD(SegmentModel segmentModel, DbdModel dbdModel) {
        boolean retVal = false;
        DBDConstants accessType = dbdModel.getAccessType();
        if (accessType == DBDConstants.LOGICAL || accessType == DBDConstants.INDEX) {
            return false;
        }
        retVal = this.determineLogicalRelsForSegment(segmentModel, dbdModel);
        if (!retVal) {
            for (SegmentModel childSeg : segmentModel.getChildSegments()) {
                retVal = this.determineIfLogicallyRelatedDBD(childSeg, dbdModel);
                if (retVal) break;
            }
        }
        return retVal;
    }

    private boolean determineLogicalRelsForSegment(SegmentModel segmentModel, DbdModel dbdModel) {
        if (logger.isLoggable(Level.FINER)) {
            String parm = dbdModel.getDbd().getDbdName() + "." + segmentModel.getImsName();
            logger.entering(this.getClass().getName(), "determineLogicalRelsForSegment(SegmentModel segmentModel, DbdModel dbdModel)", new Object[]{parm});
        }
        boolean retVal = false;
        retVal = this.determineLogicalParentRels(segmentModel, dbdModel);
        if (!retVal) {
            retVal = this.determineVirtualLogicalChildRels(segmentModel, dbdModel);
        }
        if (!retVal) {
            retVal = this.determineRealLogicalChildRels(segmentModel, dbdModel);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "determineLogicalRelsForSegment(SegmentModel segmentModel, DbdModel dbdModel)", new Object[]{retVal});
        }
        return retVal;
    }

    private void populateLogicalRelsForDbd(SegmentGEFModel gefSegment, DbGEFModel gefDbd) throws MissingDBDException, ModelException, InvalidDBDSourceException {
        this.populateLogicalRelsForSegment(gefSegment, gefDbd);
        for (SegmentGEFModel childSeg : gefSegment.getChildGEFSegments()) {
            this.populateLogicalRelsForDbd(childSeg, gefDbd);
        }
    }

    private void populateLogicalRelsForSegment(SegmentGEFModel gefSegment, DbGEFModel gefDbd) throws MissingDBDException, ModelException, InvalidDBDSourceException {
        if (logger.isLoggable(Level.FINER)) {
            String parm = gefDbd.getDbdModel().getDbd().getDbdName() + "." + gefSegment.getSegmentModel().getImsName();
            logger.entering(this.getClass().getName(), "populateLogicalRelsForSegment(SegmentModel segmentModel, DbdModel dbdList)", new Object[]{parm});
        }
        this.populateLogicalParentRels(gefSegment, gefDbd);
        this.populateVirtualLogicalChildRels(gefSegment, gefDbd);
        this.populateRealLogicalChildRels(gefSegment, gefDbd);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "populateLogicalRelsForSegment(SegmentModel segmentModel, DbdModel dbdList)", new Object[0]);
        }
    }

    public String toString() {
        return this.dbdModel.getDbd().getDbdName();
    }

    private void populateVirtualLogicalChildRels(SegmentGEFModel gefSegment, DbGEFModel gefDbd) {
        SegmentModel segmentModel = gefSegment.getSegmentModel();
        if (segmentModel.isVirtualLogicalChild()) {
            boolean logicalRelAlreadyAdded;
            String parentSegStr = segmentModel.getParent().getImsName();
            LogicalRelationshipGEFModel logicalRel = this.getLogicalRel(parentSegStr, gefDbd.getDbdModel().getDbd().getDbdName(), segmentModel.getSegmentSourceSegName(), segmentModel.getSegmentSourceDBName());
            if (logicalRel == null) {
                logicalRelAlreadyAdded = false;
                logicalRel = new LogicalRelationshipGEFModel();
                logicalRel.setGefVirtualLogicalChild(gefSegment);
                this.addLogicalRel(logicalRel);
            } else {
                logicalRelAlreadyAdded = true;
                logicalRel.setGefVirtualLogicalChild(gefSegment);
            }
            if (logger.isLoggable(Level.FINER)) {
                String traceStr = "Logical relationship found. Virtual Logical Child: " + gefDbd.getDbdModel().getDbd().getDbdName() + "." + logicalRel.getVirtualLogicalChildSegment() + " Real Logical Child: " + logicalRel.getRealLogicalChildDbd() + "." + logicalRel.getRealLogicalChildSegment();
                if (logicalRelAlreadyAdded) {
                    traceStr = traceStr + " - Logical Rel had already been added.";
                }
                logger.finer(traceStr);
            }
        }
    }

    private boolean determineVirtualLogicalChildRels(SegmentModel segmentModel, DbdModel dbdModel) {
        SegmentModel parentSegModel;
        boolean retVal = false;
        if (segmentModel.hasSegmentSource() && segmentModel.getSegmentSourceDBName() != null && segmentModel.getSegmentSourceSegName() != null && (parentSegModel = segmentModel.getParent()) != null) {
            retVal = true;
        }
        return retVal;
    }

    private void populateRealLogicalChildRels(SegmentGEFModel gefSegment, DbGEFModel gefDbd) throws ModelException, MissingDBDException, InvalidDBDSourceException {
        if (gefSegment.getSegmentModel().isRealLogicalChild()) {
            String relatedDbdName;
            boolean logicalRelAlreadyAdded;
            LogicalRelationshipGEFModel logicalRel = this.getLogicalRel(gefSegment.getSegmentModel().getLogicalParentName(), gefSegment.getSegmentModel().getLogicalParentDbdName(), gefSegment.getSegmentModel().getImsName(), gefDbd.getDbdModel().getDbd().getDbdName());
            if (logicalRel == null) {
                logicalRelAlreadyAdded = false;
                logicalRel = new LogicalRelationshipGEFModel();
                logicalRel.setLogicalParentDbd(gefSegment.getSegmentModel().getLogicalParentDbdName());
                logicalRel.setLogicalParentSegment(gefSegment.getSegmentModel().getLogicalParentName());
                logicalRel.setGefRealLogicalChild(gefSegment);
                this.addLogicalRel(logicalRel);
            } else {
                logicalRelAlreadyAdded = true;
                logicalRel.setGefRealLogicalChild(gefSegment);
            }
            if (logger.isLoggable(Level.FINER)) {
                String traceStr = "Logical relationship found. Real Logical Child: " + logicalRel.getRealLogicalChildDbd() + "." + logicalRel.getRealLogicalChildSegment() + " Logical Parent: " + logicalRel.getLogicalParentDbd() + "." + logicalRel.getLogicalParentSegment();
                if (logicalRelAlreadyAdded) {
                    traceStr = traceStr + " - Logical Rel had already been added.";
                }
                logger.finer(traceStr);
            }
            if (!this.isDbdInList(relatedDbdName = logicalRel.getLogicalParentDbd())) {
                try {
                    logger.finer("New logically related DBD " + relatedDbdName + " is not in the list. Reading it in now...");
                    DbdModel newDb = ProjectTreeFileHelper.unmarshalDbd((String)relatedDbdName, (String)this.projectName);
                    if (newDb == null) {
                        Object[] inserts = new Object[]{relatedDbdName};
                        throw new MissingDBDException(WorkbenchPlugin.errors.getString("DHB1701", inserts));
                    }
                    DbGEFModel newGefDb = new DbGEFModel(this, newDb);
                    this.logicallyRelatedDBDs.addElement(newGefDb);
                    this.populateLogicalRelsForDbd(newGefDb.getPhysicalRootGEFSegment(), newGefDb);
                }
                catch (CoreException e) {
                    logger.throwing(this.getClass().getName(), "populateLogicalParentRels(SegmentModel segmentModel, DbdModel dbdModel)", (Throwable)e);
                    logger.error((Throwable)e);
                }
            } else {
                logger.finer("New logically related DBD " + relatedDbdName + " was already in the logicallyRelatedDBDs list.");
            }
        }
    }

    private boolean determineRealLogicalChildRels(SegmentModel segmentModel, DbdModel dbdModel) {
        boolean retVal = false;
        if (segmentModel.hasLogicalParent()) {
            retVal = true;
        }
        return retVal;
    }

    private void populateLogicalParentRels(SegmentGEFModel gefSegment, DbGEFModel gefDbd) throws MissingDBDException, ModelException, InvalidDBDSourceException {
        for (LogicalChildModel logicalChild : gefSegment.getSegmentModel().getLogicalChildList()) {
            String relatedDbdName;
            boolean logicalRelAlreadyAdded;
            if (logicalChild.getPointer() == DBDConstants.INDX || logicalChild.getPointer() == DBDConstants.SYMB) continue;
            LogicalRelationshipGEFModel logicalRel = this.getLogicalRel(gefSegment.getSegmentModel().getImsName(), gefDbd.getDbdModel().getDbd().getDbdName(), logicalChild.getName(), logicalChild.getDbd());
            if (logicalRel == null) {
                logicalRelAlreadyAdded = false;
                logicalRel = new LogicalRelationshipGEFModel();
                logicalRel.setGefLogicalParent(gefSegment);
                logicalRel.setRealLogicalChildDbd(logicalChild.getDbd());
                logicalRel.setRealLogicalChildSegment(logicalChild.getName());
                this.addLogicalRel(logicalRel);
            } else {
                logicalRelAlreadyAdded = true;
                logicalRel.setGefLogicalParent(gefSegment);
            }
            if (logger.isLoggable(Level.FINER)) {
                String traceStr = "Logical relationship found. Logical Parent: " + gefDbd.getDbdModel().getDbd().getDbdName() + "." + logicalRel.getLogicalParentSegment() + " Real Logical Child: " + logicalRel.getRealLogicalChildDbd() + "." + logicalRel.getRealLogicalChildSegment();
                if (logicalRelAlreadyAdded) {
                    traceStr = traceStr + " - Logical Rel had already been added.";
                }
                logger.finer(traceStr);
            }
            if (!this.isDbdInList(relatedDbdName = logicalRel.getRealLogicalChildDbd())) {
                try {
                    logger.finer("New logically related DBD " + relatedDbdName + " is not in the list. Reading it in now...");
                    DbdModel newDb = ProjectTreeFileHelper.unmarshalDbd((String)relatedDbdName, (String)this.projectName);
                    if (newDb != null) {
                        DbGEFModel newGefDb = new DbGEFModel(this, newDb);
                        this.logicallyRelatedDBDs.addElement(newGefDb);
                        this.populateLogicalRelsForDbd(newGefDb.getPhysicalRootGEFSegment(), newGefDb);
                        continue;
                    }
                    Object[] inserts = new Object[]{relatedDbdName};
                    throw new MissingDBDException(WorkbenchPlugin.errors.getString("DHB1701", inserts));
                }
                catch (CoreException e) {
                    logger.throwing(this.getClass().getName(), "populateLogicalParentRels(SegmentModel segmentModel, DbdModel dbdModel)", (Throwable)e);
                    logger.error((Throwable)e);
                }
                continue;
            }
            logger.finer("New logically related DBD " + relatedDbdName + " was already in the logicallyRelatedDBDs list.");
        }
    }

    private boolean determineLogicalParentRels(SegmentModel segmentModel, DbdModel dbdModel) {
        boolean retVal = false;
        for (LogicalChildModel logicalChild : segmentModel.getLogicalChildList()) {
            if (logicalChild.getPointer() == DBDConstants.INDX || logicalChild.getPointer() == DBDConstants.SYMB) continue;
            retVal = true;
        }
        return retVal;
    }

    private boolean isDbdInList(String dbdName) {
        boolean retVal = false;
        if (dbdName == null || dbdName.equalsIgnoreCase(this.dbdModel.getDbd().getDbdName())) {
            retVal = true;
        } else {
            logger.finest("logicallyRelatedDBDs.size(): " + this.logicallyRelatedDBDs.size());
            int i = 0;
            while (i < this.logicallyRelatedDBDs.size()) {
                DbdModel dbd = this.logicallyRelatedDBDs.elementAt(i).getDbdModel();
                if (dbd.getDbd().getDbdName().equals(dbdName)) {
                    retVal = true;
                    break;
                }
                ++i;
            }
        }
        return retVal;
    }

    public void addListener(NodeEventListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removeListener(NodeEventListener listener) {
        this.listenerList.remove((Object)listener);
    }

    public void fireEvent(NodeEvents event) {
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((NodeEventListener)listeners[i]).handleEvent(event);
            ++i;
        }
    }

    public void addNewSegment(SegmentGEFModel parentGEFSegment, SegmentGEFModel childGEFSegment) {
        parentGEFSegment.addChild(childGEFSegment);
        parentGEFSegment.getSegmentModel().addNewSegment(childGEFSegment.getSegmentModel());
        ConnectionGEFModel connection = new ConnectionGEFModel(true);
        connection.setName("Connection from " + childGEFSegment.getSegmentAlias() + " to " + parentGEFSegment.getSegmentAlias());
        connection.setChild(childGEFSegment);
        connection.setChildTerminal("Anchor_top");
        childGEFSegment.connectInput(connection);
        connection.setParent(parentGEFSegment);
        connection.setParentTerminal("Anchor_bottom");
        parentGEFSegment.connectOutput(connection);
        this.physicalDBDViewNodes.add(childGEFSegment);
        this.fireEvent(new NodeEvents(7, parentGEFSegment));
    }

    public void removeSegment(SegmentGEFModel gefSegment, boolean fireEvent) {
        Vector conns = (Vector)gefSegment.getParentConnections().clone();
        int i = 0;
        while (i < conns.size()) {
            ConnectionGEFModel connection = (ConnectionGEFModel)conns.elementAt(i);
            gefSegment.disconnectInput(connection);
            SegmentGEFModel logicalOrPhysParent = connection.getParent();
            logicalOrPhysParent.disconnectOutput(connection);
            ++i;
        }
        SegmentGEFModel parent = gefSegment.getParent();
        this.physicalDBDViewNodes.remove(gefSegment);
        parent.getChildGEFSegments().remove(gefSegment);
        parent.getSegmentModel().removeSegment(gefSegment.getSegmentModel());
        if (fireEvent) {
            this.fireEvent(new NodeEvents(8, gefSegment));
        }
    }

    public String getPcbName() {
        String retVal = null;
        if (this.pcb == null) {
            retVal = "";
        } else {
            retVal = this.pcb.getPcbName();
            if (retVal == null) {
                retVal = this.pcb.getLabel();
            }
        }
        return retVal;
    }

    public String getDbdName() {
        return this.dbdModel.getDbd().getDbdName();
    }

    public String getPcbAlias() {
        String retVal = null;
        if (this.pcb != null) {
            retVal = this.pcb.getPcbAlias();
        }
        return retVal;
    }

    public void setPcbAlias(String newValue) throws ModelException {
        if (!newValue.equals(this.pcb.getPcbAlias())) {
            this.pcb.setPcbAlias(newValue);
            this.fireEvent(new NodeEvents(5, this));
        }
    }

    public boolean isDuplicateAlias(String alias) {
        int i = 0;
        while (i < this.psbGEFModel.getList().size()) {
            DbGEFModel dliPcbModel = this.psbGEFModel.getList().get(i);
            if (dliPcbModel != this && dliPcbModel.getPcbAlias().equals(alias)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void recalculateLayout() {
        DbdLayoutManager layoutManager = new DbdLayoutManager();
        layoutManager.assignSegmentNodeLocations(this.getDbGefs());
    }

    public Vector<DbGEFModel> getDbGefs() {
        Vector<DbGEFModel> dbGefs = null;
        if (this.logicallyRelatedDBDs != null && this.editorPage.inDisplayRelatedDBDsMode && !this.editorPage.inLogicalViewMode && !this.isPsb()) {
            dbGefs = new Vector(this.logicallyRelatedDBDs.size() + 1);
            dbGefs.addElement(this);
            int i = 0;
            while (i < this.logicallyRelatedDBDs.size()) {
                dbGefs.addElement(this.logicallyRelatedDBDs.elementAt(i));
                ++i;
            }
        } else {
            dbGefs = new Vector<DbGEFModel>(1);
            dbGefs.addElement(this);
        }
        return dbGefs;
    }

    public void propAllNodesExpandChange(boolean b) {
        if (b ? this.allNodesExpanded : !this.allNodesExpanded) {
            return;
        }
        this.allNodesExpanded = b;
        this.setExpand(b);
    }

    public void setExpand(boolean b) {
        Enumeration<SegmentGEFModel> e = this.physicalDBDViewNodes.elements();
        while (e.hasMoreElements()) {
            SegmentGEFModel theNodeModel = e.nextElement();
            theNodeModel.setExpand(b);
        }
        this.openedDbGEFModel.recalculateLayout();
    }

    public Vector<SegmentGEFModel> getSegmentGEFModels() {
        if (this.editorPage.inLogicalViewMode) {
            logger.finer("logicalDBDViewNodes.size = " + this.logicalDBDViewNodes.size());
            return this.logicalDBDViewNodes;
        }
        logger.finer("physicalDBDViewNodes.size = " + this.physicalDBDViewNodes.size());
        return this.physicalDBDViewNodes;
    }

    public Vector getNonSelectedSegments(String nodeName) {
        Vector<SegmentGEFModel> newNodes = new Vector<SegmentGEFModel>();
        int i = 0;
        while (i < this.physicalDBDViewNodes.size()) {
            SegmentGEFModel dliSegmentGEFModel = this.physicalDBDViewNodes.get(i);
            if (!dliSegmentGEFModel.getSegmentAlias().equals(nodeName)) {
                newNodes.add(dliSegmentGEFModel);
            }
            ++i;
        }
        return newNodes;
    }

    protected SegmentGEFModel createSegmentGEFModel(SegmentModel segment) throws InvalidDBDSourceException, ModelException {
        SegmentModel logicalChildSourceSegmentModel = null;
        SegmentGEFModel logicalChildSourceGefSegment = null;
        SegmentModel targetParentSourceSegmentModel = null;
        SegmentGEFModel targetParentSourceGefSegment = null;
        if (this.dbdModel.getAccessType() == DBDConstants.LOGICAL) {
            if (segment.hasSegmentSource()) {
                String dbName = segment.getSegmentSourceDBName();
                String segName = segment.getSegmentSourceSegName();
                if (dbName != null && segName != null && dbName.length() > 0 && segName.length() > 0) {
                    logicalChildSourceSegmentModel = new SegmentModel(this.getLogicalSourceSegment(dbName, segName));
                }
                if (!this.isPsb() && logicalChildSourceSegmentModel != null) {
                    logicalChildSourceGefSegment = new SegmentGEFModel(this, logicalChildSourceSegmentModel, null, null, true);
                }
            } else if (segment.hasConcatenatedSegmentSource()) {
                String lchildDbName = segment.getLogicalChildSourceDBName();
                String lchildSegName = segment.getLogicalChildSourceSegName();
                if (lchildDbName != null && lchildSegName != null && lchildDbName.length() > 0 && lchildSegName.length() > 0) {
                    logicalChildSourceSegmentModel = new SegmentModel(this.getLogicalSourceSegment(lchildDbName, lchildSegName));
                }
                if (!this.isPsb() && logicalChildSourceSegmentModel != null) {
                    logicalChildSourceGefSegment = new SegmentGEFModel(this, logicalChildSourceSegmentModel, null, null, true);
                }
                String targetParentDbName = segment.getTargetParentSourceDBName();
                String targetParentSegName = segment.getTargetParentSourceSegName();
                if (targetParentDbName != null && targetParentSegName != null && targetParentDbName.length() > 0 && targetParentSegName.length() > 0) {
                    targetParentSourceSegmentModel = new SegmentModel(this.getLogicalSourceSegment(targetParentDbName, targetParentSegName));
                }
                if (!this.isPsb() && targetParentSourceSegmentModel != null) {
                    targetParentSourceGefSegment = new SegmentGEFModel(this, targetParentSourceSegmentModel, null, null, true);
                }
            }
        }
        SegmentGEFModel retNode = this.isPsb() && this.dbdModel.getAccessType() == DBDConstants.LOGICAL ? new SegmentGEFModel(this, segment, logicalChildSourceSegmentModel, targetParentSourceSegmentModel) : new SegmentGEFModel(this, segment, logicalChildSourceGefSegment, targetParentSourceGefSegment, false);
        this.physicalDBDViewNodes.add(retNode);
        for (SegmentModel childModelSegment : segment.getChildSegments()) {
            SegmentGEFModel childGEFSegment = this.createSegmentGEFModel(childModelSegment);
            retNode.addChild(childGEFSegment);
            ConnectionGEFModel connection = new ConnectionGEFModel(true);
            connection.setName("Connection from " + childGEFSegment.getSegmentAlias() + " to " + retNode.getSegmentAlias());
            connection.setChild(childGEFSegment);
            connection.setChildTerminal("Anchor_top");
            childGEFSegment.connectInput(connection);
            connection.setParent(retNode);
            connection.setParentTerminal("Anchor_bottom");
            retNode.connectOutput(connection);
        }
        return retNode;
    }

    public void setPhysicalRootGEFSegment(SegmentModel rootSegmentModel) throws InvalidDBDSourceException, ModelException {
        this.physicalRootGEFSegment = this.createSegmentGEFModel(rootSegmentModel);
    }

    protected SegmentGEFModel buildSubtreeClone(SegmentGEFModel gefSegment, boolean includeChildSegments) throws InvalidDBDSourceException, ModelException {
        Vector<FieldGEFModel> newFieldList;
        SegmentGEFModel retNode = new SegmentGEFModel(gefSegment);
        if (this.isPsb() && this.editorPage.inApplicationView && (newFieldList = this.buildFieldList(gefSegment)).size() > 0) {
            retNode.setFieldsList(newFieldList);
        }
        this.logicalDBDViewNodes.add(retNode);
        if (includeChildSegments) {
            for (SegmentGEFModel childGefSegment : gefSegment.getChildGEFSegments()) {
                if (this.isPsb() && childGefSegment.getSenSeg() == null && this.editorPage.inApplicationView) continue;
                SegmentGEFModel clonedChildGEFSegment = this.buildSubtreeClone(childGefSegment, true);
                if (this.isPsb() && this.editorPage.inApplicationView) {
                    clonedChildGEFSegment.setSenSeg(childGefSegment.getSenSeg());
                    Vector<FieldGEFModel> newFieldList2 = this.buildFieldList(childGefSegment);
                    if (newFieldList2.size() > 0) {
                        clonedChildGEFSegment.setFieldsList(newFieldList2);
                    }
                }
                retNode.addChild(clonedChildGEFSegment);
                ConnectionGEFModel connection = new ConnectionGEFModel(true);
                connection.setName("Connection from " + clonedChildGEFSegment.getSegmentAlias() + " to " + retNode.getSegmentAlias());
                connection.setChild(clonedChildGEFSegment);
                connection.setChildTerminal("Anchor_top");
                clonedChildGEFSegment.connectInput(connection);
                connection.setParent(retNode);
                connection.setParentTerminal("Anchor_bottom");
                retNode.connectOutput(connection);
            }
        }
        return retNode;
    }

    private Vector<FieldGEFModel> buildFieldList(SegmentGEFModel segmentGEFModel) {
        Vector<FieldGEFModel> fieldList = new Vector<FieldGEFModel>();
        for (FieldGEFModel currentFld : segmentGEFModel.getFieldsList()) {
            if (!currentFld.isSenfld()) continue;
            fieldList.add(currentFld);
        }
        return fieldList;
    }

    protected void buildSubtreeCloneForNewConcatenatedSegment(SegmentGEFModel concatenatedGefSegment, SegmentGEFModel gefSegment) throws InvalidDBDSourceException, ModelException {
        for (SegmentGEFModel childGefSegment : gefSegment.getChildGEFSegments()) {
            SegmentGEFModel clonedChildGEFSegment = this.buildSubtreeClone(childGefSegment, true);
            concatenatedGefSegment.addChildFromTargetParent(clonedChildGEFSegment);
            clonedChildGEFSegment.setParent(concatenatedGefSegment);
            ConnectionGEFModel connection = new ConnectionGEFModel(true);
            connection.setName("Connection from " + clonedChildGEFSegment.getSegmentAlias() + " to " + concatenatedGefSegment.getSegmentAlias());
            connection.setChild(clonedChildGEFSegment);
            connection.setChildTerminal("Anchor_top");
            clonedChildGEFSegment.connectInput(connection);
            connection.setParent(concatenatedGefSegment);
            connection.setParentTerminal("Anchor_bottom");
            concatenatedGefSegment.connectOutput(connection);
        }
    }

    protected SegmentModel getLogicalSourceSegment(String dbName, String segmentName) throws InvalidDBDSourceException {
        SegmentModel retVal = null;
        int i = 0;
        while (i < this.logicallyRelatedDBDs.size()) {
            DbGEFModel gefDbd = this.logicallyRelatedDBDs.elementAt(i);
            if (gefDbd.getDbdModel().getDbd().getDbdName().equalsIgnoreCase(dbName)) {
                SegmentGEFModel gefSegment = gefDbd.getSegmentGEFModel(segmentName);
                if (gefSegment == null) {
                    Object[] inserts = new Object[]{this.dbdModel.getDBDName(), segmentName, dbName};
                    throw new InvalidDBDSourceException(WorkbenchPlugin.errors.getString("DHB1702", inserts));
                }
                retVal = gefSegment.getSegmentModel();
            }
            ++i;
        }
        return retVal;
    }

    public SegmentGEFModel getSegmentGEFModel(String segmentName) {
        return this.physicalRootGEFSegment.getSegment(segmentName);
    }

    public SegmentGEFModel getClonedSegmentGEFModel(String segmentName) {
        return this.logicalRootGEFSegment.getSegment(segmentName);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String prop, Object old, Object newValue) {
        this.listeners.firePropertyChange(prop, old, newValue);
    }

    public DbdOrPcbList getPsbModel() {
        return this.psbGEFModel;
    }

    public void setDliPsbGEFModel(DbdsGEFModel dliPsbGEFModel) {
        this.psbGEFModel = dliPsbGEFModel;
    }

    public PcbDBModel getPcbModel() {
        return this.pcb;
    }

    public void toggleApplicationView() throws MissingDBDException, ModelException, InvalidDBDSourceException {
        String procopt;
        if (!this.isPsb()) {
            return;
        }
        this.editorPage.inApplicationView = !this.editorPage.inApplicationView;
        this.toggleLogicalView(this.getPhysicalRootGEFSegment());
        Object pcbName = this.pcb.getPcbName();
        if (!(pcbName != null && ((String)pcbName).length() != 0 || (pcbName = this.pcb.getLabel()) != null && ((String)pcbName).length() != 0)) {
            PsbModel psb = ((PsbGEFModel)this.psbGEFModel).getPsb();
            int numberOfTpPcb = psb.getTPPcbList() != null ? psb.getTPPcbList().size() : 0;
            int i = 0;
            while (i < psb.getDBPcbList().size()) {
                PcbDBModel currentPcbModel = (PcbDBModel)psb.getDBPcbList().get(i);
                if (currentPcbModel.equals(this.pcb)) {
                    pcbName = "(PCB#" + String.valueOf(i + numberOfTpPcb + 1) + ")";
                    break;
                }
                ++i;
            }
        }
        if ((procopt = this.pcb.getProcopt()) == null || procopt.isEmpty()) {
            procopt = "A";
        }
        String title = "|    " + WorkbenchPlugin.labels.getString("WB430") + WorkbenchPlugin.colon.getString("COLON") + (String)pcbName + "   |   ";
        title = title + WorkbenchPlugin.labels.getString("WB022") + WorkbenchPlugin.colon.getString("COLON") + this.pcb.getDbdName() + "   |   ";
        title = title + WorkbenchPlugin.labels.getString("WB423") + WorkbenchPlugin.colon.getString("COLON") + procopt + "   |   ";
        title = this.editorPage.inApplicationView ? title + WorkbenchPlugin.labels.getString("WB446") + "   |   " : title + WorkbenchPlugin.labels.getString("WB447") + "   |   ";
        ((TitleBarBorder)this.dbdBorderModel.getFigure().getBorder()).setLabel(title);
    }

    public boolean isApplicationView() {
        return this.editorPage.inApplicationView;
    }

    public boolean isPsb() {
        return this.getPcbModel() != null;
    }

    public boolean isInLogicalViewMode() {
        return this.editorPage.inLogicalViewMode;
    }

    public boolean isInDisplayRelatedDBDsMode() {
        return this.editorPage.inDisplayRelatedDBDsMode;
    }

    public boolean isInPCBEditMode() {
        return !this.editorPage.inApplicationView;
    }

    public boolean isPhysicalDb() {
        DBDConstants accessType = this.dbdModel.getAccessType();
        return accessType != DBDConstants.LOGICAL;
    }

    public boolean isNotMSDB() {
        DBDConstants accessType = this.dbdModel.getAccessType();
        return accessType != DBDConstants.MSDB;
    }

    public ResourceEditorPage getEditorPage() {
        return this.editorPage;
    }

    public void setEditorPage(ResourceEditorPage editorPage) {
        this.editorPage = editorPage;
    }
}

