/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.layout;

import com.ibm.im.ims.workbench.editors.model.DbGEFModel;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.TitleBarBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class DbdLayoutManager {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private int[] maxHeight = new int[15];
    private static final short MAX_DEPTH = 15;
    public static final Insets CANVAS_INSETS = new Insets(45, 5, 0, 0);
    public static final Insets DB_BORDER_INSETS = new Insets(10, 10, 20, 20);
    public static final int DB_BORDER_GAP = 10;
    public static final int SEGMENT_HORIZONTAL_GAP = 20;
    public static final int SEGMENT_VERTICAL_GAP = 25;

    public DbdLayoutManager() {
        this.initializeMaxHeight();
    }

    private void initializeMaxHeight() {
        int i = 0;
        while (i < this.maxHeight.length) {
            this.maxHeight[i] = 0;
            ++i;
        }
    }

    public void assignSegmentNodeLocations(Vector<DbGEFModel> dbGefs) {
        int leftBoundary = DbdLayoutManager.CANVAS_INSETS.left + DbdLayoutManager.DB_BORDER_INSETS.right;
        int i = 0;
        while (i < dbGefs.size()) {
            DbGEFModel dbGef = dbGefs.elementAt(i);
            SegmentGEFModel rootSegment = dbGef.editorPage.inLogicalViewMode ? dbGef.getLogicalRootGEFSegment() : dbGef.getPhysicalRootGEFSegment();
            if (rootSegment != null) {
                this.passOne(rootSegment);
                this.passTwo(rootSegment, leftBoundary);
                int width = rootSegment.getTreeWidth() + DbdLayoutManager.DB_BORDER_INSETS.right;
                RectangleFigure dbdBorderFigure = dbGef.getDbdBorderModel().getFigure();
                TitleBarBorder titleBarBorder = (TitleBarBorder)dbdBorderFigure.getBorder();
                int titleLength = titleBarBorder.getPreferredSize((IFigure)dbdBorderFigure).width;
                if (width < titleLength) {
                    width = titleLength;
                }
                dbGef.getDbdBorderModel().setConstraint(new Rectangle(leftBoundary - DbdLayoutManager.DB_BORDER_INSETS.left, DbdLayoutManager.CANVAS_INSETS.top, width, this.calcDbBorderHeight()));
                leftBoundary += width + DbdLayoutManager.DB_BORDER_INSETS.right;
                this.initializeMaxHeight();
            }
            ++i;
        }
    }

    private int calcDbBorderHeight() {
        int retVal = 0;
        int numLevels = 0;
        int i = 0;
        while (i < this.maxHeight.length) {
            ++numLevels;
            if (this.maxHeight[i] == 0) break;
            retVal += this.maxHeight[i];
            ++i;
        }
        if (numLevels > 1) {
            retVal += 25 * (numLevels - 1);
        }
        return retVal += DbdLayoutManager.DB_BORDER_INSETS.bottom;
    }

    private void passOne(SegmentGEFModel segment) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("segment name = " + segment.getSegmentName());
        }
        this.traverseDbd(segment, 0);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("tree width = " + segment.getTreeWidth());
        }
        this.traceMaxHeights();
    }

    private void passTwo(SegmentGEFModel segment, int leftBoundary) {
        this.assignYourLocation(segment, DbdLayoutManager.CANVAS_INSETS.top + DbdLayoutManager.DB_BORDER_INSETS.top, leftBoundary, 0);
    }

    private void assignYourLocation(SegmentGEFModel segment, int ceiling, int leftBoundary, int level) {
        if (logger.isLoggable(Level.FINEST)) {
            Object[] parms = new Object[]{segment.getSegmentAlias(), ceiling, leftBoundary, level};
            logger.entering(this.getClass().getName(), "assignYourLocation(SegmentGEFModel segment, int ceiling, int leftBoundary, int level)", parms);
        }
        Point location = new Point(0, 0);
        location.y = ceiling + 25;
        Iterator<SegmentGEFModel> iter = segment.getChildGEFSegments().iterator();
        location.x = iter == null || !iter.hasNext() ? leftBoundary : leftBoundary + segment.getTreeWidth() / 2 - segment.getPreferredSize().width / 2;
        segment.setNodeLocation(location);
        logger.finest("Segment: " + String.valueOf(segment) + " new node location: " + String.valueOf(location));
        int childrenCeiling = ceiling + 25 + this.maxHeight[level];
        ++level;
        int childLeftBoundary = leftBoundary;
        while (iter.hasNext()) {
            SegmentGEFModel child = iter.next();
            this.assignYourLocation(child, childrenCeiling, childLeftBoundary, level);
            childLeftBoundary += child.getTreeWidth() + 20;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.exiting(this.getClass().getName(), "assignYourLocation(SegmentGEFModel segment, int ceiling, int leftBoundary, int level)", new Object[0]);
        }
    }

    private int traverseDbd(SegmentGEFModel segment, int level) {
        if (logger.isLoggable(Level.FINEST)) {
            Object[] parms = new Object[]{segment.getSegmentAlias(), segment.getPreferredSize().width, level};
            logger.entering(this.getClass().getName(), "traverseDbd(SegmentGEFModel segment, int level)", parms);
        }
        int retVal = 0;
        Dimension preferredSize = segment.getPreferredSize();
        this.maxHeight[level] = Math.max(this.maxHeight[level], preferredSize.height);
        Iterator<SegmentGEFModel> iter = segment.getChildGEFSegments().iterator();
        if (iter == null || !iter.hasNext()) {
            retVal = preferredSize.width;
            segment.setTreeWidth(retVal);
        } else {
            ++level;
            int numChildren = 0;
            while (iter.hasNext()) {
                retVal += this.traverseDbd(iter.next(), level);
                ++numChildren;
            }
            if (numChildren > 1) {
                retVal += (numChildren - 1) * 20;
            }
            int thisSegmentWidth = preferredSize.width;
            retVal = Math.max(retVal, thisSegmentWidth);
            segment.setTreeWidth(retVal);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.exiting(this.getClass().getName(), "traverseDbd(SegmentGEFModel segment, int level)", new Object[]{segment.getSegmentAlias() + " treeWidth: " + retVal});
        }
        return retVal;
    }

    private void traceMaxHeights() {
        int i = 0;
        while (i < this.maxHeight.length) {
            if (this.maxHeight[i] == 0) break;
            logger.finest("Level " + i + " Max height: " + this.maxHeight[i]);
            ++i;
        }
    }
}

