/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.handlers;

import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.imsdb.connections.exceptions.ImsDbConnectionException;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbUtils;
import com.ibm.im.ims.workbench.imsdb.connections.utils.JDBCHelper;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.EAMessageControl;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.swt.XSwt;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class SQLToDLIHandler
implements ModifyListener,
VerifyListener,
SelectionListener,
IHandler,
DisposeListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private UIHelper uih;
    private static int margin = 5;
    private static final int adjustment = 2;
    private static final int status_label_space = 4;
    private static final int MIN_WIDTH = 550;
    private static final int MIN_HEIGHT = 400;
    private Font courierNewFont;
    private Shell shell = null;
    private Label profileLabel;
    private Label psbLabel;
    private Label sqlLabel;
    private Label dliLabel;
    private Text sqlStatements;
    private Text dliCalls;
    private Combo profileCombo;
    private Combo psbCombo;
    private Button translateButton;
    private EAMessageControl msgControl;
    private String prevProfileName = "";
    private String prevPsb = "";
    private IImsDbConnection connection;

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            Rectangle scrSize = workbench.getDisplay().getBounds();
            if (this.shell == null || this.shell.isDisposed()) {
                this.shell = new Shell(workbench.getActiveWorkbenchWindow().getShell(), 1268);
            }
            this.shell.setText(WorkbenchPlugin.labels.getString("SHOW_SQL_TO_DLI_WIZ_4"));
            this.shell.setMinimumSize(550, 400);
            this.shell.setLocation((scrSize.width - 550) / 2, (scrSize.height - 400) / 2);
            this.createTranslationPage(this.shell);
            this.shell.setDefaultButton(this.translateButton);
            this.shell.addDisposeListener((DisposeListener)this);
            this.shell.pack();
            this.shell.open();
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.throwing(this.getClass().getName(), "execute(ExecutionEvent event)", e);
            logger.error(e);
        }
        return null;
    }

    private void createTranslationPage(Shell composite) {
        logger.entering(this.getClass().getName(), "createTranslationPage(Shell composite)", new Object[0]);
        try {
            this.uih = new UIHelper();
            Display display = composite.getDisplay();
            this.uih.setDisplay(display);
            FormLayout layout = new FormLayout();
            layout.marginWidth = margin;
            layout.marginHeight = margin;
            composite.setLayout((Layout)layout);
            FormData fd = this.uih.genFormData(new FormAttachment(0, margin), null, new FormAttachment(0, margin), null);
            this.profileLabel = new Label((Composite)composite, 0);
            this.profileLabel.setText(WorkbenchPlugin.labels.getString("SHOW_SQL_TO_DLI_WIZ_7") + WorkbenchPlugin.colon.getString("COLON"));
            this.profileLabel.pack();
            this.profileLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment(0, margin - 2), null, new FormAttachment((Control)this.profileLabel, margin), new FormAttachment(100, -margin * 4));
            this.profileCombo = new Combo((Composite)composite, 8);
            this.profileCombo.setLayoutData((Object)fd);
            this.msgControl = new EAMessageControl((Composite)composite);
            this.msgControl.addControl((Control)this.profileCombo);
            fd = this.uih.genFormData(new FormAttachment((Control)this.profileCombo, margin + 2), null, new FormAttachment(0, margin), null);
            this.psbLabel = new Label((Composite)composite, 0);
            this.psbLabel.setText(WorkbenchPlugin.labels.getString("SHOW_SQL_TO_DLI_WIZ_8") + WorkbenchPlugin.colon.getString("COLON"));
            this.psbLabel.pack();
            this.psbLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)this.profileCombo, margin), null, new FormAttachment((Control)this.psbLabel, margin), new FormAttachment(100, -margin * 4));
            this.psbCombo = new Combo((Composite)composite, 0);
            this.psbCombo.setLayoutData((Object)fd);
            this.psbCombo.setEnabled(false);
            this.msgControl.addControl((Control)this.psbCombo);
            fd = this.uih.genFormData(new FormAttachment((Control)this.psbCombo, margin + 2), null, new FormAttachment(0, margin), null);
            this.sqlLabel = new Label((Composite)composite, 0);
            this.sqlLabel.setText(WorkbenchPlugin.labels.getString("SHOW_SQL_TO_DLI_WIZ_1") + WorkbenchPlugin.colon.getString("COLON"));
            this.sqlLabel.pack();
            this.sqlLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)this.psbCombo, margin), new FormAttachment(45, margin), new FormAttachment((Control)this.sqlLabel, margin), new FormAttachment(100, -margin * 4));
            this.sqlStatements = new Text((Composite)composite, 2115);
            this.sqlStatements.setLayoutData((Object)fd);
            this.sqlStatements.setEnabled(false);
            this.msgControl.addControl((Control)this.sqlStatements);
            fd = this.uih.genFormData(new FormAttachment((Control)this.sqlStatements, margin + 2), null, new FormAttachment(0, margin), null);
            this.dliLabel = new Label((Composite)composite, 0);
            this.dliLabel.setText(WorkbenchPlugin.labels.getString("SHOW_SQL_TO_DLI_WIZ_3") + WorkbenchPlugin.colon.getString("COLON"));
            this.dliLabel.pack();
            this.dliLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)this.sqlStatements, margin), new FormAttachment(100, -margin * 7), new FormAttachment((Control)this.dliLabel, margin), new FormAttachment(100, -margin * 4));
            this.dliCalls = new Text((Composite)composite, 2123);
            FontData[] fontData = composite.getFont().getFontData();
            fontData[0].setName("Courier New");
            this.courierNewFont = new Font((Device)display, fontData[0]);
            this.dliCalls.setFont(this.courierNewFont);
            this.dliCalls.setLayoutData((Object)fd);
            int buttonWidth = Utility.getTextWidth((Composite)composite, 0, WorkbenchPlugin.labels.getString("SHOW_SQL_TO_DLI_WIZ_2")) + margin;
            fd = this.uih.genFormData(new FormAttachment(100, -margin * 6), null, new FormAttachment(100, -margin * 4 - buttonWidth - margin), null);
            fd.width = buttonWidth + margin;
            this.translateButton = new Button((Composite)composite, 8);
            this.translateButton.setText(WorkbenchPlugin.labels.getString("SHOW_SQL_TO_DLI_WIZ_2"));
            this.translateButton.setLayoutData((Object)fd);
            this.translateButton.setEnabled(false);
            this.alignControls();
            this.initWidgetValues();
            this.addListeners();
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "createTranslationPage(Shell composite)", e);
            logger.error(e);
        }
        logger.exiting(this.getClass().getName(), "createTranslationPage(Shell composite)", new Object[0]);
    }

    private void alignControls() {
        int[] allLabelSize = new int[]{this.sqlLabel.getSize().x, this.dliLabel.getSize().x, this.psbLabel.getSize().x, this.profileLabel.getSize().x};
        int leftOffset = Utility.getMaxSize(allLabelSize) + margin;
        this.setFormDataLayout((Control)this.sqlStatements, leftOffset);
        this.setFormDataLayout((Control)this.dliCalls, leftOffset);
        this.setFormDataLayout((Control)this.profileCombo, leftOffset);
        this.setFormDataLayout((Control)this.psbCombo, leftOffset);
    }

    private void setFormDataLayout(Control control, int offset) {
        FormData fd = (FormData)control.getLayoutData();
        fd.left = new FormAttachment(0, offset);
        control.setLayoutData((Object)fd);
    }

    private void addListeners() {
        this.profileCombo.addModifyListener((ModifyListener)this);
        this.psbCombo.addModifyListener((ModifyListener)this);
        this.sqlStatements.addModifyListener((ModifyListener)this);
        this.psbCombo.addVerifyListener((VerifyListener)this);
        this.sqlStatements.addVerifyListener((VerifyListener)this);
        this.translateButton.addSelectionListener((SelectionListener)this);
    }

    private void initWidgetValues() {
        this.prevProfileName = "";
        this.populateProfileCombo();
    }

    private void populateProfileCombo() {
        this.profileCombo.add(WorkbenchModelBundle.getLabel().getString("SHOW_SQL_TO_DLI_WIZ_9"));
        List connProfiles = ImsDbUtils.getConnectionProfiles();
        if (connProfiles.size() >= 1) {
            Iterator iter = connProfiles.iterator();
            while (iter.hasNext()) {
                this.profileCombo.add(((ConnectionProfile)iter.next()).getName());
            }
            this.profileCombo.setText(this.profileCombo.getItem(0));
            if (this.psbCombo.getItemCount() > 0) {
                this.msgControl.clearValidationMessage((Control)this.profileCombo);
            }
        } else {
            this.msgControl.setValidationMessage((Control)this.profileCombo, WorkbenchPlugin.errors.getString("CATALOG_IMPORT_ERROR03"), 3);
        }
    }

    public void verifyText(VerifyEvent e) {
        try {
            this.msgControl.clearValidationMessage((Control)this.profileCombo);
            this.msgControl.clearValidationMessage((Control)this.psbCombo);
            this.msgControl.clearValidationMessage((Control)this.sqlStatements);
            this.dliCalls.setText("");
            if (e.character == '\r') {
                e.text = "";
                this.dliCalls.setText(this.translateSQLStatements());
            } else if (this.psbCombo.getSelectionIndex() != 0) {
                if (e.character >= 'a' && e.character <= 'z') {
                    String upperCaseChar;
                    e.text = upperCaseChar = e.text.toUpperCase();
                }
                boolean validPsb = this.psbExisted();
                this.sqlStatements.setEnabled(validPsb);
                if (!this.psbCombo.getText().trim().isEmpty() && !validPsb) {
                    Object[] inserts = new Object[]{this.psbCombo.getText().trim(), this.profileCombo.getText()};
                    this.msgControl.setValidationMessage((Control)this.psbCombo, WorkbenchPlugin.errors.getString("CATALOG_IMPORT_ERROR04", inserts), 3);
                }
            }
        }
        catch (InvalidInputException ex) {
            if (ex.getAttrNames().length > 0) {
                this.msgControl.setValidationMessage((Control)this.psbCombo, ex.getMessage(), 3);
                this.sqlStatements.setEnabled(false);
            } else {
                this.msgControl.setValidationMessage((Control)this.sqlStatements, ex.getMessage(), 3);
                this.translateButton.setEnabled(false);
            }
        }
        catch (Throwable err) {
            logger.throwing(this.getClass().getName(), "verifyText(VerifyEvent e)", err);
            logger.error(err);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        try {
            this.dliCalls.setText(this.translateSQLStatements());
            this.msgControl.clearValidationMessage((Control)this.profileCombo);
            this.msgControl.clearValidationMessage((Control)this.psbCombo);
            this.msgControl.clearValidationMessage((Control)this.sqlStatements);
        }
        catch (InvalidInputException ex) {
            this.dliCalls.setText("");
            if (ex.getAttrNames().length > 0) {
                this.msgControl.setValidationMessage((Control)this.psbCombo, ex.getMessage(), 3);
                this.sqlStatements.setEnabled(false);
            } else {
                this.msgControl.setValidationMessage((Control)this.sqlStatements, ex.getMessage(), 3);
                this.translateButton.setEnabled(false);
            }
        }
        catch (Throwable ex) {
            logger.throwing(this.getClass().getName(), "widgetSelected(SelectionEvent e)", ex);
            logger.error(ex);
        }
    }

    public void modifyText(ModifyEvent e) {
        try {
            if (e.widget == this.profileCombo) {
                if (this.profileCombo.getSelectionIndex() == 0) {
                    this.msgControl.clearValidationMessage((Control)this.profileCombo);
                    this.msgControl.clearValidationMessage((Control)this.psbCombo);
                    this.msgControl.clearValidationMessage((Control)this.sqlStatements);
                    this.psbCombo.removeAll();
                    this.psbCombo.setEnabled(false);
                } else {
                    this.psbCombo.setEnabled(!this.profileCombo.getText().isEmpty());
                    if (this.psbCombo.isEnabled()) {
                        this.populatePsbCombo();
                    }
                    if (this.psbCombo.getItemCount() == 2) {
                        this.psbCombo.setText(this.psbCombo.getItem(1));
                    }
                }
            } else if (e.widget == this.psbCombo) {
                String psbName = this.psbCombo.getText().trim();
                this.sqlStatements.setEnabled(!psbName.isEmpty() && this.psbExisted());
                if (!psbName.equals(this.prevPsb)) {
                    // empty if block
                }
                this.sqlStatements.setText("");
            } else if (e.widget == this.sqlStatements) {
                this.translateButton.setEnabled(!this.sqlStatements.getText().trim().isEmpty());
                if (!this.translateButton.isEnabled()) {
                    this.dliCalls.setText("");
                }
            }
        }
        catch (Throwable ex) {
            logger.throwing(this.getClass().getName(), "modifyText(ModifyEvent e)", ex);
            logger.error(ex);
        }
    }

    private void populatePsbCombo() throws InvocationTargetException, InterruptedException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "populatePsbCombo", new Object[0]);
        }
        String selectedProfileName = this.profileCombo.getText();
        if (this.connection == null || !this.prevProfileName.equals(selectedProfileName)) {
            this.psbCombo.removeModifyListener((ModifyListener)this);
            this.psbCombo.removeAll();
            this.psbCombo.add(WorkbenchModelBundle.getLabel().getString("SHOW_SQL_TO_DLI_WIZ_10"));
            this.prevProfileName = selectedProfileName;
            PopulatePsbCombo popOp = new PopulatePsbCombo(selectedProfileName);
            new ProgressMonitorDialog(this.shell).run(true, false, (IRunnableWithProgress)popOp);
            SQLException sqlException = popOp.getSqlException();
            if (sqlException != null) {
                this.psbCombo.removeAll();
                this.psbCombo.setEnabled(false);
                this.sqlStatements.setText("");
                this.sqlStatements.setEnabled(false);
                logger.throwing(this.getClass().getName(), "populatePsbCombo()", (Throwable)sqlException);
                this.msgControl.setValidationMessage((Control)this.profileCombo, sqlException.getMessage(), 3);
                MessageDialog.openError((Shell)this.shell, (String)"SQLException", (String)sqlException.getMessage());
            } else {
                List<String> psbNames = popOp.getPsbNames();
                int i = 0;
                while (i < psbNames.size()) {
                    String currPsbName = psbNames.get(i);
                    this.psbCombo.add(currPsbName);
                    ++i;
                }
                this.psbCombo.setText(this.psbCombo.getItem(0));
                this.psbCombo.addModifyListener((ModifyListener)this);
                this.msgControl.clearValidationMessage((Control)this.profileCombo);
                this.msgControl.clearValidationMessage((Control)this.psbCombo);
                this.msgControl.clearValidationMessage((Control)this.sqlStatements);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "populatePsbCombo", new Object[0]);
        }
    }

    private boolean psbExisted() {
        boolean retVal = false;
        int i = 1;
        while (i < this.psbCombo.getItemCount()) {
            String psbName = this.psbCombo.getItem(i);
            if (psbName.equals(this.psbCombo.getText().trim())) {
                retVal = true;
                break;
            }
            ++i;
        }
        return retVal;
    }

    private String translateSQLStatements() throws InvalidInputException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "translateSQLStatements", new Object[0]);
        }
        String retVal = "";
        String psbName = this.psbCombo.getText().trim();
        this.translateButton.setEnabled(false);
        try {
            if (this.connection == null || !psbName.equals(this.prevPsb)) {
                String connProfName = this.profileCombo.getText();
                this.connection = ImsDbUtils.getConnectionByName((String)connProfName, (boolean)true);
            }
            retVal = this.connection.nativeSQL(this.sqlStatements.getText());
        }
        catch (Throwable t) {
            if (t instanceof ImsDbConnectionException) {
                t = t.getCause();
            }
            throw new InvalidInputException(t.getMessage());
        }
        this.prevPsb = psbName;
        this.translateButton.setEnabled(true);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "translateSQLStatements", new Object[0]);
        }
        return retVal;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public void widgetDisposed(DisposeEvent arg0) {
        this.courierNewFont.dispose();
    }

    public void dispose() {
    }

    class PopulatePsbCombo
    implements IRunnableWithProgress {
        private String selectedProfile;
        private List<String> psbNames;
        private SQLException sqlException = null;

        public PopulatePsbCombo(String selectedProfile) {
            this.selectedProfile = selectedProfile;
            this.psbNames = new ArrayList<String>();
        }

        public List<String> getPsbNames() {
            return this.psbNames;
        }

        public SQLException getSqlException() {
            return this.sqlException;
        }

        public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
            try {
                monitor.beginTask(WorkbenchModelBundle.getLabel().getString("SHOW_SQL_TO_DLI_WIZ_11"), -1);
                SQLToDLIHandler.this.connection = ImsDbUtils.getConnectionByName((String)this.selectedProfile, (boolean)true);
                if (JDBCHelper.isCatalogConnection()) {
                    this.psbNames = SQLToDLIHandler.this.connection.getPsbList();
                } else {
                    String psbName = SQLToDLIHandler.this.connection.getCatalog();
                    this.psbNames.add(psbName);
                    SQLToDLIHandler.this.prevPsb = psbName;
                }
            }
            catch (Throwable t) {
                logger.error(t);
                if (t instanceof ImsDbConnectionException && t.getCause() instanceof SQLException) {
                    this.sqlException = (SQLException)t.getCause();
                }
                MessageDialog.openError((Shell)XSwt.getActiveShell(), (String)WorkbenchModelBundle.getError().getString("SQL2DLI_ERROR_TITLE"), (String)t.getMessage());
            }
        }
    }
}

