/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.handlers;

import com.ibm.im.ims.workbench.controller.compare.SubmitChangesController;
import com.ibm.im.ims.workbench.dialogs.SubmitChangesToIMSDialog;
import com.ibm.im.ims.workbench.editors.ResourceEditorPage;
import com.ibm.im.ims.workbench.editors.ResourceMultiPageEditor;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.logging.Level;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class PublishChangesToCatalog
implements IHandler {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();

    public void addHandlerListener(IHandlerListener arg0) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "execute(ExecutionEvent event)", new Object[0]);
        }
        try {
            ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
            IStructuredSelection uzSelection = (IStructuredSelection)selection;
            Object selObject = uzSelection.getFirstElement();
            SubmitChangesController controller = null;
            String dbdName = null;
            String projectName = null;
            if (selObject instanceof IResource) {
                projectName = ((IResource)selObject).getProject().getName();
                String fileName = ((IResource)selObject).getName();
                dbdName = fileName.substring(0, fileName.indexOf("."));
            } else {
                IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
                if (editor instanceof ResourceMultiPageEditor) {
                    ResourceEditorPage page = ((ResourceMultiPageEditor)editor).getCurrentPage();
                    projectName = ((ResourceMultiPageEditor)editor).getProjectName();
                    dbdName = page.getDbGEFModel().getDbdName();
                }
            }
            IFile dbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, dbdName);
            DbdModel dbd = new DbdModel(dbdFile.getContents());
            controller = new SubmitChangesController(projectName, dbd);
            SubmitChangesToIMSDialog dialog = new SubmitChangesToIMSDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), controller);
            dialog.open();
        }
        catch (Throwable e) {
            logger.error(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "execute(ExecutionEvent event)", new Object[0]);
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener arg0) {
    }
}

