/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.handlers;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowModelUtil;
import com.ibm.im.ims.workbench.editors.ResourceEditorPage;
import com.ibm.im.ims.workbench.editors.ResourceMultiPageEditor;
import com.ibm.im.ims.workbench.editors.model.DbGEFModel;
import com.ibm.im.ims.workbench.editors.model.FieldGEFModel;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.editors.parts.FieldEditPart;
import com.ibm.im.ims.workbench.editors.parts.SegmentEditPart;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerSegmentTreeObject;
import com.ibm.im.ims.workbench.ui.navigator.actions.ManageArtifactAction;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public class ManageMappingsHandler
implements IHandler {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "execute(ExecutionEvent event)", new Object[0]);
        }
        try {
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection) {
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof IMSExplorerSegmentTreeObject) {
                    SegmentGEFModel segGEFModel;
                    IMSExplorerSegmentTreeObject selectedSegment = (IMSExplorerSegmentTreeObject)obj;
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage page = window.getActivePage();
                    page.findView("com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorDbd");
                    IFile dbdFile = ManageArtifactAction.getDbdFile(selectedSegment);
                    String segmentName = selectedSegment.getName();
                    ResourceMultiPageEditor dbdEditor = (ResourceMultiPageEditor)page.openEditor((IEditorInput)new FileEditorInput(dbdFile), "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorDbd");
                    ResourceEditorPage editorPage = dbdEditor.getCurrentPage();
                    DbGEFModel dbGEFModel = editorPage.getDbGEFModel();
                    IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
                    String projectName = ((ResourceMultiPageEditor)editor).getProjectName();
                    if (dbGEFModel != null && (segGEFModel = dbGEFModel.getSegmentGEFModel(segmentName)) != null) {
                        if (!FieldImportWorkflowModelUtil.isProjectWorkflowEnabled((String)projectName)) {
                            if (segGEFModel.getSegmentModel().isVirtualLogicalChild()) {
                                MessageDialog.openError((Shell)window.getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)WorkbenchPlugin.errors.getString("NO_LAUNCH_MNG_MAPS_VLC"));
                            } else {
                                SegmentEditPart segEditPart = ManageArtifactAction.getSelectedSegment(editorPage, segmentName);
                                if (segEditPart != null) {
                                    ManageArtifactAction.revealEditPart(editorPage, (GraphicalEditPart)segEditPart);
                                    editorPage.setSelectedPart((EditPart)segEditPart);
                                }
                                ((ResourceMultiPageEditor)editor).launchManageMappings(segGEFModel, window);
                            }
                        } else {
                            String dbdName = segGEFModel.getDbGEFModel().getDbdName();
                            segmentName = segGEFModel.getSegmentModel().getImsName();
                            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
                            Utility.selectSegmentInWfmEditor(Utility.launchWfmEditor(projectName, dbdName, segmentName), dbdName, segmentName, "com.ibm.im.ims.workbench.popup.actions.ManageMappingAction");
                            if (!store.getBoolean("WFM_DS_IMPORT_WARNING")) {
                                Object[] inserts = new Object[]{WorkbenchModelBundle.getLabel().getString("WFM_ADDEDIT_MAP"), WorkbenchModelBundle.getLabel().getString("WFM_TITLE")};
                                String msg = WorkbenchModelBundle.getDescription().getString("IDSWM_ACTION_DISALLOWED_FROM_DBD_EDITOR", inserts);
                                Utility.openInformationDialog(msg, inserts);
                            }
                        }
                    }
                } else if (obj instanceof SegmentEditPart || obj instanceof FieldEditPart) {
                    IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
                    IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
                    String projectName = ((ResourceMultiPageEditor)editor).getProjectName();
                    SegmentGEFModel gefSegment = null;
                    List editParts = ((ResourceMultiPageEditor)editor).getCurrentPage().getSelectedParts();
                    if (editParts.size() == 1) {
                        EditPart editPart = (EditPart)editParts.get(0);
                        if (editPart instanceof SegmentEditPart) {
                            gefSegment = (SegmentGEFModel)((SegmentEditPart)editPart).getModel();
                        } else if (editPart instanceof FieldEditPart) {
                            gefSegment = ((FieldGEFModel)((FieldEditPart)editPart).getModel()).getSegmentGEFModel();
                        }
                        if (gefSegment != null) {
                            if (!FieldImportWorkflowModelUtil.isProjectWorkflowEnabled((String)projectName)) {
                                if (gefSegment.getSegmentModel().isVirtualLogicalChild()) {
                                    MessageDialog.openError((Shell)window.getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)WorkbenchPlugin.errors.getString("NO_LAUNCH_MNG_MAPS_VLC"));
                                } else {
                                    ((ResourceMultiPageEditor)editor).launchManageMappings(gefSegment, window);
                                }
                            } else {
                                String dbdName = gefSegment.getDbGEFModel().getDbdName();
                                String segmentName = gefSegment.getSegmentModel().getImsName();
                                IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
                                Utility.selectSegmentInWfmEditor(Utility.launchWfmEditor(projectName, dbdName, segmentName), dbdName, segmentName, "com.ibm.im.ims.workbench.popup.actions.ManageMappingAction");
                                if (!store.getBoolean("WFM_DS_IMPORT_WARNING")) {
                                    Object[] inserts = new Object[]{WorkbenchModelBundle.getLabel().getString("WFM_ADDEDIT_MAP"), WorkbenchModelBundle.getLabel().getString("WFM_TITLE")};
                                    String msg = WorkbenchModelBundle.getDescription().getString("IDSWM_ACTION_DISALLOWED_FROM_DBD_EDITOR", inserts);
                                    Utility.openInformationDialog(msg, inserts);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "execute(ExecutionEvent event)", e);
            logger.error(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "execute(ExecutionEvent event)", new Object[0]);
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

