/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.handlers;

import com.ibm.im.ims.workbench.editors.model.DbGEFModel;
import com.ibm.im.ims.workbench.editors.parts.IMSResourceEditorPart;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.ui.navigator.IMSExplorerSegmentTreeObject;
import com.ibm.im.ims.workbench.ui.navigator.actions.ManageArtifactAction;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class IMSResourceEditorPartPropertyTester
extends PropertyTester {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "test(Object receiver, String property, Object[] args, Object expectedValue)", new Object[0]);
        boolean retVal = false;
        try {
            if (receiver instanceof IMSResourceEditorPart) {
                DbGEFModel gefDb = ((IMSResourceEditorPart)receiver).getDbGefModel();
                if ("isPsbEditor".equals(property)) {
                    retVal = gefDb.isPsb();
                } else if ("isDbdEditor".equals(property)) {
                    retVal = !gefDb.isPsb();
                } else if ("isNotInLogicalViewMode".equals(property)) {
                    retVal = !gefDb.isInLogicalViewMode();
                } else if ("isNotInRelDbViewMode".equals(property)) {
                    retVal = !gefDb.isInDisplayRelatedDBDsMode();
                } else if ("isInRelDbViewMode".equals(property)) {
                    retVal = gefDb.isInDisplayRelatedDBDsMode();
                } else if ("isInLogicalViewMode".equals(property)) {
                    retVal = gefDb.isInLogicalViewMode();
                } else if ("isPhysicalDb".equals(property)) {
                    retVal = gefDb.isPhysicalDb();
                } else if ("isInApplicationMode".equals(property)) {
                    retVal = gefDb.isApplicationView();
                } else if ("isInPCBEditMode".equals(property)) {
                    retVal = gefDb.isInPCBEditMode();
                } else if ("isOnlyOnePartSelected".equals(property)) {
                    List editParts = gefDb.editorPage.getSelectedParts();
                    if (editParts.size() == 1) {
                        retVal = true;
                    }
                } else if ("isNotMSDB".equals(property)) {
                    retVal = gefDb.isNotMSDB();
                }
            } else if (receiver instanceof IMSExplorerSegmentTreeObject) {
                IMSExplorerSegmentTreeObject selectedSegment = (IMSExplorerSegmentTreeObject)receiver;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                page.findView("com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorDbd");
                IFile dbdFile = ManageArtifactAction.getDbdFile(selectedSegment);
                DbdModel dbdModel = new DbdModel(dbdFile.getContents());
                if ("isPhysicalDb".equals(property)) {
                    retVal = dbdModel.getAccessType() != DBDConstants.LOGICAL;
                }
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "test(Object receiver, String property, Object[] args, Object expectedValue)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "test(Object receiver, String property, Object[] args, Object expectedValue)", new Object[]{"For property: " + property + " returning: " + retVal});
        return retVal;
    }
}

