/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.handlers;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.builder.MessageDialogRunner;
import com.ibm.im.ims.workbench.controller.workflow.field.EnablementController;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowModelUtil;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class EnableWorkflowHandler
implements IHandler {
    private static final IExplorerLogger logger = ExplorerLogger.instance();

    public void addHandlerListener(IHandlerListener arg0) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ISchedulingRule rule = null;
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
            String projectName = this.getSelectedProjectName(selection);
            rule = ruleFactory.modifyRule((IResource)ProjectTreeFileHelper.getProject((String)projectName));
            ExecEnableWorkspaceOp workspaceOp = new ExecEnableWorkspaceOp(rule, projectName);
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell()).run(true, false, (IRunnableWithProgress)workspaceOp);
        }
        catch (Throwable e) {
            logger.error(e);
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener arg0) {
    }

    private String getSelectedProjectName(ISelection selection) {
        IStructuredSelection uzSelection;
        Object selObject;
        if (selection instanceof IStructuredSelection && (selObject = (uzSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            return ((IResource)selObject).getProject().getName();
        }
        return null;
    }

    class ExecEnableWorkspaceOp
    extends WorkspaceModifyOperation {
        private String projectName;

        public ExecEnableWorkspaceOp(ISchedulingRule modifyRule, String projectName) {
            super(modifyRule);
            this.projectName = projectName;
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            try {
                String projectUUID = ProjectTreeFileHelper.getUUIDForProject((String)this.projectName, (String)"com.ibm.im.ims.workbench");
                EnablementController enabler = new EnablementController(this.projectName, projectUUID);
                if (!enabler.isProjectWorkflowEnabled()) {
                    enabler.workflowEnableProject();
                    Vector dbdFiles = ProjectTreeFileHelper.getDbdMetadataFileList((String)this.projectName);
                    monitor.beginTask("", dbdFiles.size());
                    monitor.setTaskName(WorkbenchPlugin.labels.getString("FIM_ENABLE_WF_PROGRESS"));
                    Object[] dbdNames = new Object[dbdFiles.size()];
                    int i = 0;
                    while (i < dbdFiles.size()) {
                        IFile dbdFile = (IFile)dbdFiles.get(i);
                        String fileName = dbdFile.getName();
                        dbdNames[i] = fileName.substring(0, fileName.length() - 4);
                        ++i;
                    }
                    enabler.addImportedDBDsToWorkflow(dbdNames, monitor);
                    MessageDialogRunner mdr = new MessageDialogRunner("warning", "gsam not supported by this editor");
                    PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)mdr);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
                            IWorkbenchPage page = window.getActivePage();
                            IViewPart view = page.findView("org.eclipse.ui.navigator.ProjectExplorer");
                            IFile wfFile = FieldImportWorkflowModelUtil.getFieldImportWorkflowFile((String)ExecEnableWorkspaceOp.this.projectName);
                            try {
                                page.openEditor((IEditorInput)new FileEditorInput(wfFile), "com.ibm.im.ims.catalog.ui.workflow.WorkflowManager");
                            }
                            catch (PartInitException e) {
                                logger.error((Throwable)e);
                            }
                            ((ISetSelectionTarget)view).selectReveal((ISelection)new StructuredSelection((Object)wfFile));
                        }
                    });
                }
            }
            catch (Throwable e) {
                logger.error(e);
            }
        }
    }
}

