/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.form;

import com.ibm.im.ims.metadata.psb.DblevelType;
import com.ibm.im.ims.metadata.psb.SbType;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.InvalidDBDSourceException;
import com.ibm.im.ims.workbench.editors.MissingDBDException;
import com.ibm.im.ims.workbench.editors.ResourceEditorPage;
import com.ibm.im.ims.workbench.editors.ResourceMultiPageEditor;
import com.ibm.im.ims.workbench.editors.figures.FigureConstants;
import com.ibm.im.ims.workbench.editors.model.DbGEFModel;
import com.ibm.im.ims.workbench.editors.model.DbdOrPcbList;
import com.ibm.im.ims.workbench.editors.model.PsbGEFModel;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.PcbGsamModel;
import com.ibm.im.ims.workbench.model.PcbTPModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.MessageDialogRunner;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.wizard.editpcb.EditDbPcbWizard;
import com.ibm.im.ims.workbench.wizard.editpcb.EditGsamPcbWizard;
import com.ibm.im.ims.workbench.wizard.editpcb.EditTpPcbWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.draw2d.TitleBarBorder;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.FileEditorInput;

public class PsbSummaryPage
extends FormPage
implements Listener,
SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    ResourceMultiPageEditor rmeParent;
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Table dbPcbTable;
    private Table tpPcbTable;
    private Table gsamPcbTable;
    Link pcbLabel;
    Link pcbTPlink;
    Link pcbDBlink;
    Link PcbGSAMlink;
    Link psbDescription;
    private Combo langCombo;
    private Combo cmpatCombo;
    private Combo olicCombo;
    private Combo gsrolbokCombo;
    private Combo wtorCombo;
    private Combo dblevelCombo;
    private Label maxqStatus;
    private Label iosizeStatus;
    private Label ssasizeStatus;
    private Label ioeropnStatus;
    private Label lockmaxStatus;
    private Label langStatus;
    private Label olicStatus;
    private Label remarksStatus;
    private Label emptyLabel;
    private Text maxqField;
    private Text ioasizeField;
    private Text ssasizeField;
    private Text ioeropnField;
    private Text lockmaxField;
    private Text remarksField;
    private Button tpAddButton;
    private Button tpEditButton;
    private Button tpRemoveButton;
    private Button dbAddButton;
    private Button dbEditButton;
    private Button dbRemoveButton;
    private Button gsamAddButton;
    private Button gsamEditButton;
    private Button gsamRemoveButton;
    private Button launchEditorButton;
    private String[] fffpDbNames;
    private String[] gsamDbNames;
    private int margin = 5;
    public static int editorWidth = 920;
    public static int tableHeight = 250;
    public static int tpWizardWidth = 810;
    public static int tpWizardHeight = 430;
    public static int dbWizardWidth = 1200;
    public static int dbWizardHeight = 900;
    public static int gsamWizardWidth = 640;
    public static int gsamWizardHeight = 430;
    private int buttonWidth;
    public static Color COLOR_WHITE = new Color((Device)PlatformUI.createDisplay(), 255, 255, 255);
    public static Color COLOR_RED = new Color((Device)PlatformUI.createDisplay(), 255, 0, 0);
    private String[] dbColumnLabels = new String[]{WorkbenchPlugin.labels.getString("PSP_PCB_NUM"), WorkbenchPlugin.labels.getString("PSP_PCB_NAME"), WorkbenchPlugin.labels.getString("WB211"), "DBDNAME", "DBVER", "PROCOPT", "SB", "KEYLEN", "POS", "PROCSEQ(D)", "VIEW=MSDB", "LIST", "PSELOPT", "ACCESS"};
    private String[] dbTooltips = new String[]{WorkbenchPlugin.labels.getString("WB440"), WorkbenchPlugin.descriptions.getString("WB414"), WorkbenchPlugin.labels.getString("WB211"), WorkbenchPlugin.labels.getString("WB422"), WorkbenchPlugin.descriptions.getString("WB413A"), WorkbenchPlugin.labels.getString("WB423"), WorkbenchPlugin.labels.getString("WB424"), WorkbenchPlugin.labels.getString("WB425"), WorkbenchPlugin.labels.getString("WB427"), WorkbenchPlugin.labels.getString("WB428"), WorkbenchPlugin.labels.getString("WB429"), WorkbenchPlugin.labels.getString("WB421"), WorkbenchPlugin.labels.getString("WB437"), WorkbenchPlugin.labels.getString("WB438")};
    protected static final String[] condOrNo = new String[]{WorkbenchPlugin.labels.getString("YES_CONDITIONALLY"), WorkbenchPlugin.labels.getString("NO")};
    protected static final String[] multipleOrSingle = new String[]{WorkbenchPlugin.labels.getString("MULTIPLE"), WorkbenchPlugin.labels.getString("SINGLE")};
    protected static final String[] dbOrIndex = new String[]{"DB", "INDEX"};
    private static String[] langsShort = new String[]{"", "ASSEM", "COBOL", "JAVA", "PASCAL", "PL/I"};
    private static String[] langs = new String[]{"Application is LE-enabled", "Assembler", "Cobol", "Java", "Pascal", "PL/I"};
    private static String[] dbLevelTypes = new String[]{"", DblevelType.BASE.toString(), DblevelType.CURR.toString()};
    private static String[] yesNo = new String[]{WorkbenchPlugin.labels.getString("YES"), WorkbenchPlugin.labels.getString("NO")};
    private ScrolledForm form;
    private boolean warningIssued = false;
    private Composite compositeContainer;
    private String projectName = "";
    private boolean isReadOnly;

    public PsbSummaryPage(ResourceMultiPageEditor rmeParent, Composite compositeContainer) {
        super(null, "Dbpcb", WorkbenchPlugin.labels.getString("WB433"));
        this.rmeParent = rmeParent;
        this.compositeContainer = compositeContainer;
        this.createContent();
    }

    protected void createContent() {
        if (this.rmeParent != null) {
            FileEditorInput fileInput = (FileEditorInput)this.rmeParent.getEditorInput();
            IFile file = fileInput.getFile();
            IPath path = file.getFullPath();
            this.projectName = path.segments()[0];
        }
        if (this.projectName.equals("IMS_Explorer_Catalog_ReadOnly")) {
            this.isReadOnly = true;
        }
        FormColors formColors = new FormColors(this.compositeContainer.getDisplay());
        formColors.markShared();
        FormToolkit toolkit = new FormToolkit(formColors);
        this.form = toolkit.createScrolledForm(this.compositeContainer);
        this.form.setExpandHorizontal(true);
        this.form.setExpandVertical(true);
        this.form.setText(WorkbenchPlugin.labels.getString("WB432"));
        Composite composite = this.form.getBody();
        TableWrapLayout layout = new TableWrapLayout();
        composite.setLayout((Layout)layout);
        this.pcbLabel = new Link(composite, 64);
        this.pcbLabel.setBackground(COLOR_WHITE);
        this.pcbLabel.setText(WorkbenchPlugin.descriptions.getString("WB424") + " <a>" + WorkbenchPlugin.labels.getString("WB439") + "</a>");
        this.pcbLabel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.im.ims.workbench.ies1_wb_psbsummary3");
            }
        });
        int[] labelSizes = new int[]{Utility.getTextWidth(composite, 0, WorkbenchPlugin.labels.getString("WB008A")), Utility.getTextWidth(composite, 0, WorkbenchPlugin.labels.getString("WB042A")), Utility.getTextWidth(composite, 0, WorkbenchPlugin.labels.getString("WB443")), Utility.getTextWidth(composite, 0, WorkbenchPlugin.labels.getString("WB009A"))};
        this.buttonWidth = Utility.getMaxSize(labelSizes) + this.margin;
        this.createTablePcbTPSection(this.form, toolkit);
        this.createTablePcbDBSection(this.form, toolkit);
        this.createTablePcbGSAMSection(this.form, toolkit);
        this.createPsbSection(this.form, toolkit);
        if (this.isReadOnly) {
            this.dbAddButton.setEnabled(false);
            this.tpAddButton.setEnabled(false);
            this.gsamAddButton.setEnabled(false);
        }
        this.form.setMinSize(300, 800);
    }

    private void createTablePcbTPSection(final ScrolledForm form, FormToolkit toolkit) {
        Section section = toolkit.createSection(form.getBody(), 194);
        section.setText(WorkbenchPlugin.labels.getString("WB401") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB401") + ")");
        Object[] inserts = new Object[]{WorkbenchPlugin.colon.getString("COLON")};
        section.setDescription(WorkbenchPlugin.descriptions.getString("WB425", inserts));
        toolkit.createCompositeSeparator((Composite)section);
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        this.pcbTPlink = new Link(client, 64);
        this.pcbTPlink.setBackground(COLOR_WHITE);
        this.pcbTPlink.setText(" <a>" + WorkbenchPlugin.labels.getString("WB439") + "</a>");
        GridData gdLink = new GridData();
        gdLink.horizontalSpan = 2;
        this.pcbTPlink.setLayoutData((Object)gdLink);
        this.pcbTPlink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.im.ims.workbench.ies1_wb_psbsummary4");
            }
        });
        this.tpPcbTable = toolkit.createTable(client, 268503042);
        this.tpPcbTable.addSelectionListener((SelectionListener)this);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 100;
        gd.verticalSpan = 4;
        this.tpPcbTable.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
        String[] tpColumnLabels = new String[]{WorkbenchPlugin.labels.getString("PSP_PCB_NUM"), WorkbenchPlugin.labels.getString("PSP_PCB_NAME"), WorkbenchPlugin.labels.getString("WB211"), "LTERM/NAME", "ALTRESP", "SAMETRM", "MODIFY", "EXPRESS", "LIST"};
        String[] tpTooltips = new String[]{WorkbenchPlugin.labels.getString("WB440"), WorkbenchPlugin.descriptions.getString("WB414"), WorkbenchPlugin.labels.getString("WB211"), WorkbenchPlugin.descriptions.getString("WB415"), WorkbenchPlugin.labels.getString("WB416"), WorkbenchPlugin.labels.getString("WB417"), WorkbenchPlugin.labels.getString("WB418"), WorkbenchPlugin.labels.getString("WB419"), WorkbenchPlugin.labels.getString("WB421")};
        this.setColumns(this.tpPcbTable, tpColumnLabels, tpTooltips);
        this.addTpPcbButon(toolkit, client);
        this.editTpPcbButton(toolkit, client);
        this.removeTpPcbButton(toolkit, client);
        this.refreshTpPcbTableItems();
        section.setClient((Control)client);
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        TableWrapData td = new TableWrapData(128);
        td.colspan = 1;
        section.setLayoutData((Object)td);
    }

    public void refreshTpPcbTableItems() {
        PsbModel psb;
        if (this.tpPcbTable.getItemCount() > 0) {
            this.tpPcbTable.removeAll();
        }
        if ((psb = ((PsbGEFModel)this.rmeParent.getDbdOrPcbList()).getPsb()).getTPPcbList() != null) {
            int i = 0;
            while (i < psb.getTPPcbList().size()) {
                PcbTPModel tpPcb = (PcbTPModel)psb.getTPPcbList().get(i);
                TableItem currentTableItem = new TableItem(this.tpPcbTable, 0, i);
                currentTableItem.setText(0, String.valueOf(tpPcb.getPcbNum()));
                String pcbNameOrLabel = tpPcb.getPcbName();
                if (pcbNameOrLabel == null && (pcbNameOrLabel = tpPcb.getLabel()) == null) {
                    pcbNameOrLabel = "";
                }
                currentTableItem.setText(1, pcbNameOrLabel);
                String pcbAlias = tpPcb.getExternalName();
                if (pcbAlias == null && (pcbAlias = tpPcb.getPcbNameOrLabel()) == null) {
                    pcbAlias = "";
                }
                currentTableItem.setText(2, pcbAlias);
                String ltermOrName = tpPcb.getLtermName();
                if (ltermOrName == null && (ltermOrName = tpPcb.getTrancodeName()) == null) {
                    ltermOrName = "";
                }
                currentTableItem.setText(3, ltermOrName);
                currentTableItem.setText(4, PsbSummaryPage.getYesNoString(tpPcb.getAltresp()));
                currentTableItem.setText(5, PsbSummaryPage.getYesNoString(tpPcb.getSametrm()));
                currentTableItem.setText(6, PsbSummaryPage.getYesNoString(tpPcb.getModify()));
                currentTableItem.setText(7, PsbSummaryPage.getYesNoString(tpPcb.getExpress()));
                currentTableItem.setText(8, PsbSummaryPage.getYesNoString(tpPcb.getList()));
                if (tpPcb.getLabel() != null) {
                    currentTableItem.setData(DBDConstants.PCB_NAME_LABEL_GROUP.toString(), (Object)WorkbenchPlugin.labels.getString("LABEL"));
                } else {
                    currentTableItem.setData(DBDConstants.PCB_NAME_LABEL_GROUP.toString(), (Object)WorkbenchPlugin.noxlatlabels.getString("WB420"));
                }
                ++i;
            }
        }
        this.layoutColumns(this.tpPcbTable);
    }

    private void addTpPcbButon(FormToolkit toolkit, Composite client) {
        String aButon = WorkbenchPlugin.labels.getString("WB008A");
        this.tpAddButton = toolkit.createButton(client, aButon, 8);
        GridData gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.tpAddButton.setLayoutData((Object)gd);
        this.tpAddButton.addSelectionListener((SelectionListener)this);
        this.tpAddButton.setEnabled(true);
    }

    private void editTpPcbButton(FormToolkit toolkit, Composite client) {
        String eButton = WorkbenchPlugin.labels.getString("WB042A");
        this.tpEditButton = toolkit.createButton(client, eButton, 8);
        GridData gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.tpEditButton.setLayoutData((Object)gd);
        this.tpEditButton.addSelectionListener((SelectionListener)this);
        this.tpEditButton.setEnabled(false);
    }

    private void removeTpPcbButton(FormToolkit toolkit, Composite client) {
        String remButton = WorkbenchPlugin.labels.getString("WB009A");
        this.tpRemoveButton = toolkit.createButton(client, remButton, 8);
        GridData gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.tpRemoveButton.setLayoutData((Object)gd);
        this.tpRemoveButton.addSelectionListener((SelectionListener)this);
        this.tpRemoveButton.setEnabled(false);
    }

    private void createTablePcbDBSection(final ScrolledForm form, FormToolkit toolkit) {
        Section section = toolkit.createSection(form.getBody(), 194);
        toolkit.createCompositeSeparator((Composite)section);
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        this.pcbDBlink = new Link(client, 64);
        this.pcbDBlink.setBackground(COLOR_WHITE);
        this.pcbDBlink.setText(" <a>" + WorkbenchPlugin.labels.getString("WB439") + "</a>");
        GridData gdLink = new GridData();
        gdLink.horizontalSpan = 2;
        this.pcbDBlink.setLayoutData((Object)gdLink);
        this.pcbDBlink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.im.ims.workbench.ies1_wb_psbsummary5");
            }
        });
        this.dbPcbTable = toolkit.createTable(client, 268503042);
        this.dbPcbTable.addSelectionListener((SelectionListener)this);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 100;
        gd.verticalSpan = 4;
        this.dbPcbTable.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
        this.setColumns(this.dbPcbTable, this.dbColumnLabels, this.dbTooltips);
        this.refreshDbPcbTableItems();
        this.dbAddButton = toolkit.createButton(client, WorkbenchPlugin.labels.getString("WB008A"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.dbAddButton.setLayoutData((Object)gd);
        this.dbAddButton.addSelectionListener((SelectionListener)this);
        this.dbAddButton.setEnabled(true);
        this.dbEditButton = toolkit.createButton(client, WorkbenchPlugin.labels.getString("WB042A"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.dbEditButton.setLayoutData((Object)gd);
        this.dbEditButton.addSelectionListener((SelectionListener)this);
        this.dbEditButton.setEnabled(false);
        this.launchEditorButton = toolkit.createButton(client, WorkbenchPlugin.labels.getString("WB443"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.launchEditorButton.setLayoutData((Object)gd);
        this.launchEditorButton.addSelectionListener((SelectionListener)this);
        this.launchEditorButton.setEnabled(false);
        this.launchEditorButton.setToolTipText(WorkbenchPlugin.descriptions.getString("WB438"));
        this.dbRemoveButton = toolkit.createButton(client, WorkbenchPlugin.labels.getString("WB009A"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.dbRemoveButton.setLayoutData((Object)gd);
        this.dbRemoveButton.addSelectionListener((SelectionListener)this);
        this.dbRemoveButton.setEnabled(false);
        section.setText(WorkbenchPlugin.labels.getString("WB402") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB402") + ")");
        section.setDescription(WorkbenchPlugin.descriptions.getString("WB426"));
        section.setClient((Control)client);
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        TableWrapData td = new TableWrapData(128);
        td.colspan = 1;
        section.setLayoutData((Object)td);
    }

    public void refreshDbPcbTableItems() {
        PsbModel psb;
        if (this.dbPcbTable.getItemCount() > 0) {
            this.dbPcbTable.removeAll();
        }
        if ((psb = ((PsbGEFModel)this.rmeParent.getDbdOrPcbList()).getPsb()).getDBPcbList() != null) {
            int i = 0;
            while (i < psb.getDBPcbList().size()) {
                PcbDBModel dbPcb = (PcbDBModel)psb.getDBPcbList().get(i);
                TableItem currentTableItem = new TableItem(this.dbPcbTable, 0, i);
                currentTableItem.setText(0, String.valueOf(dbPcb.getPcbNum()));
                String pcbNameOrLabel = dbPcb.getPcbName();
                if (pcbNameOrLabel == null && (pcbNameOrLabel = dbPcb.getLabel()) == null) {
                    pcbNameOrLabel = "";
                }
                currentTableItem.setText(1, pcbNameOrLabel);
                String pcbAlias = dbPcb.getExternalName();
                if (pcbAlias == null && (pcbAlias = dbPcb.getPcbNameOrLabel()) == null) {
                    pcbAlias = "";
                }
                currentTableItem.setText(2, pcbAlias);
                String dbdName = dbPcb.getDbdName();
                if (dbdName == null) {
                    dbdName = "";
                }
                currentTableItem.setText(3, dbdName);
                currentTableItem.setText(4, dbPcb.getDbdUserVersion() != null ? dbPcb.getDbdUserVersion().toString() : "");
                currentTableItem.setText(5, dbPcb.getProcopt().toString().length() > 0 ? dbPcb.getProcopt().toString() : "A");
                currentTableItem.setText(6, dbPcb.getSb().value().equals(SbType.NO.value()) ? condOrNo[1] : condOrNo[0]);
                currentTableItem.setText(7, String.valueOf(dbPcb.getKeyLength()));
                DBDConstants posValue = dbPcb.getPos();
                String posStr = multipleOrSingle[1];
                if (posValue != null && posValue.equals((Object)DBDConstants.M)) {
                    posStr = multipleOrSingle[0];
                }
                currentTableItem.setText(8, posStr);
                String procSeqStr = dbPcb.getProcSequence();
                if (procSeqStr == null || procSeqStr.isEmpty()) {
                    procSeqStr = dbPcb.getProcSequenceD();
                }
                if (procSeqStr == null) {
                    procSeqStr = "";
                }
                currentTableItem.setText(9, procSeqStr);
                currentTableItem.setText(10, dbPcb.getView() != null ? yesNo[0] : yesNo[1]);
                currentTableItem.setText(11, PsbSummaryPage.getYesNoString(dbPcb.getList()));
                String pseloptValue = dbPcb.getPselOpt();
                String pseloptStr = pseloptValue != null ? (pseloptValue.equals("M") ? multipleOrSingle[0] : multipleOrSingle[1]) : "";
                currentTableItem.setText(12, pseloptStr);
                String accessValue = dbPcb.getAccess();
                String accessStr = dbOrIndex[0];
                if (accessValue != null && accessValue.equals("I")) {
                    accessStr = dbOrIndex[1];
                }
                currentTableItem.setText(13, accessStr);
                if (dbPcb.getLabel() != null) {
                    currentTableItem.setData(DBDConstants.PCB_NAME_LABEL_GROUP.toString(), (Object)WorkbenchPlugin.labels.getString("LABEL"));
                } else {
                    currentTableItem.setData(DBDConstants.PCB_NAME_LABEL_GROUP.toString(), (Object)WorkbenchPlugin.noxlatlabels.getString("WB420"));
                }
                ++i;
            }
        }
        this.layoutColumns(this.dbPcbTable);
    }

    private void createTablePcbGSAMSection(final ScrolledForm form, FormToolkit toolkit) {
        Section section = toolkit.createSection(form.getBody(), 194);
        toolkit.createCompositeSeparator((Composite)section);
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        this.PcbGSAMlink = new Link(client, 64);
        this.PcbGSAMlink.setBackground(COLOR_WHITE);
        this.PcbGSAMlink.setText(" <a>" + WorkbenchPlugin.labels.getString("WB439") + "</a>");
        GridData gdLink = new GridData();
        gdLink.horizontalSpan = 2;
        this.PcbGSAMlink.setLayoutData((Object)gdLink);
        this.PcbGSAMlink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.im.ims.workbench.ies1_wb_psbsummary6");
            }
        });
        this.gsamPcbTable = toolkit.createTable(client, 268503042);
        this.gsamPcbTable.addSelectionListener((SelectionListener)this);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 100;
        gd.verticalSpan = 4;
        this.gsamPcbTable.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
        String[] gsamColumnLabels = new String[]{WorkbenchPlugin.labels.getString("PSP_PCB_NUM"), WorkbenchPlugin.labels.getString("PSP_PCB_NAME"), WorkbenchPlugin.labels.getString("WB211"), "DBDNAME", "PROCOPT", "LIST"};
        String[] gsamTooltips = new String[]{WorkbenchPlugin.labels.getString("WB440"), WorkbenchPlugin.descriptions.getString("WB414"), WorkbenchPlugin.labels.getString("WB211"), WorkbenchPlugin.labels.getString("WB441"), WorkbenchPlugin.labels.getString("WB423"), WorkbenchPlugin.labels.getString("WB421")};
        this.setColumns(this.gsamPcbTable, gsamColumnLabels, gsamTooltips);
        this.gsamAddButton = toolkit.createButton(client, WorkbenchPlugin.labels.getString("WB008A"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.gsamAddButton.setLayoutData((Object)gd);
        this.gsamAddButton.addSelectionListener((SelectionListener)this);
        this.gsamAddButton.setEnabled(true);
        this.gsamEditButton = toolkit.createButton(client, WorkbenchPlugin.labels.getString("WB042A"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.gsamEditButton.setLayoutData((Object)gd);
        this.gsamEditButton.addSelectionListener((SelectionListener)this);
        this.gsamEditButton.setEnabled(false);
        this.gsamRemoveButton = toolkit.createButton(client, WorkbenchPlugin.labels.getString("WB009A"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.gsamRemoveButton.setLayoutData((Object)gd);
        this.gsamRemoveButton.addSelectionListener((SelectionListener)this);
        this.gsamRemoveButton.setEnabled(false);
        section.setText(WorkbenchPlugin.labels.getString("WB403") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB403") + ")");
        section.setDescription(WorkbenchPlugin.descriptions.getString("WB427"));
        section.setClient((Control)client);
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        this.refreshGsamPcbTableItems();
        TableWrapData td = new TableWrapData(128);
        td.colspan = 1;
        section.setLayoutData((Object)td);
    }

    public void refreshGsamPcbTableItems() {
        PsbModel psb;
        if (this.gsamPcbTable.getItemCount() > 0) {
            this.gsamPcbTable.removeAll();
        }
        if ((psb = ((PsbGEFModel)this.rmeParent.getDbdOrPcbList()).getPsb()).getGsamPcbList() != null) {
            int i = 0;
            while (i < psb.getGsamPcbList().size()) {
                PcbGsamModel gsamPcb = (PcbGsamModel)psb.getGsamPcbList().get(i);
                TableItem currentTableItem = new TableItem(this.gsamPcbTable, 0, i);
                currentTableItem.setText(0, String.valueOf(gsamPcb.getPcbNum()));
                String pcbNameOrLabel = gsamPcb.getPcbName();
                if (pcbNameOrLabel == null && (pcbNameOrLabel = gsamPcb.getLabel()) == null) {
                    pcbNameOrLabel = "";
                }
                currentTableItem.setText(1, pcbNameOrLabel);
                String pcbAlias = gsamPcb.getExternalName();
                if (pcbAlias == null && (pcbAlias = gsamPcb.getPcbNameOrLabel()) == null) {
                    pcbAlias = "";
                }
                currentTableItem.setText(2, pcbAlias);
                String dbdNameOrName = gsamPcb.getDbdName();
                if (dbdNameOrName == null) {
                    dbdNameOrName = "";
                }
                currentTableItem.setText(3, dbdNameOrName);
                DBDConstants procoptConst = gsamPcb.getProcopt();
                String procoptStr = "";
                if (procoptConst != null) {
                    procoptStr = procoptConst.toString();
                }
                currentTableItem.setText(4, procoptStr);
                currentTableItem.setText(5, PsbSummaryPage.getYesNoString(gsamPcb.getList()));
                if (gsamPcb.getLabel() != null) {
                    currentTableItem.setData(DBDConstants.PCB_NAME_LABEL_GROUP.toString(), (Object)WorkbenchPlugin.labels.getString("LABEL"));
                } else {
                    currentTableItem.setData(DBDConstants.PCB_NAME_LABEL_GROUP.toString(), (Object)WorkbenchPlugin.noxlatlabels.getString("WB420"));
                }
                ++i;
            }
        }
        this.layoutColumns(this.gsamPcbTable);
    }

    private void createPsbSection(final ScrolledForm form, FormToolkit toolkit) {
        PsbModel psb = ((PsbGEFModel)this.rmeParent.getDbdOrPcbList()).getPsb();
        UIHelper uih = new UIHelper();
        Section section = toolkit.createSection(form.getBody(), 194);
        toolkit.createCompositeSeparator((Composite)section);
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        client.setLayout((Layout)layout);
        toolkit.paintBordersFor(client);
        this.psbDescription = new Link(client, 64);
        this.psbDescription.setBackground(COLOR_WHITE);
        this.psbDescription.setText(" <a>" + WorkbenchPlugin.labels.getString("WB439") + "</a>");
        GridData gdLink = new GridData();
        gdLink.horizontalSpan = 3;
        this.psbDescription.setLayoutData((Object)gdLink);
        this.psbDescription.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.im.ims.workbench.ies1_wb_psbsummary7");
            }
        });
        GridData gdLang = new GridData(768);
        Label langLabel = toolkit.createLabel(client, WorkbenchPlugin.labels.getString("WB405") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB405") + ")" + WorkbenchPlugin.colon.getString("COLON"));
        langLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB109"));
        this.langCombo = new Combo(client, 12);
        toolkit.adapt((Composite)this.langCombo);
        toolkit.paintBordersFor(client);
        this.langCombo.setItems(langs);
        this.langCombo.setLayoutData((Object)gdLang);
        DBDConstants langType = psb.getLang();
        if (langType != null) {
            switch (langType) {
                case JAVA: {
                    this.langCombo.setText(langs[3]);
                    break;
                }
                case COBOL: {
                    this.langCombo.setText(langs[2]);
                    break;
                }
                case PL_I: {
                    this.langCombo.setText(langs[5]);
                    break;
                }
                case ASSEM: {
                    this.langCombo.setText(langs[1]);
                    break;
                }
                case PASCAL: {
                    this.langCombo.setText(langs[4]);
                    break;
                }
                default: {
                    this.langCombo.setText("");
                }
            }
        }
        this.langStatus = new Label(client, 0);
        this.langStatus.setImage(FigureConstants.ERROR);
        this.langStatus.setBackground(COLOR_WHITE);
        this.langStatus.setLayoutData((Object)new GridData(768));
        this.langStatus.setVisible(false);
        this.langCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PsbSummaryPage.this.langCombo.getText().equals(langs[langs.length - 1]) && PsbSummaryPage.this.olicCombo.getText().equals(yesNo[0])) {
                    Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB405"), langs[langs.length - 1], WorkbenchPlugin.noxlatlabels.getString("WB411"), yesNo[0]};
                    MessageFormat formatter = new MessageFormat("");
                    formatter.setLocale(Locale.getDefault());
                    formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC16"));
                    PsbSummaryPage.this.langStatus.setToolTipText(formatter.format(messageArguments));
                    PsbSummaryPage.this.langStatus.setVisible(true);
                    PsbSummaryPage.this.olicStatus.setVisible(false);
                    PsbSummaryPage.this.olicStatus.setToolTipText(null);
                } else {
                    PsbSummaryPage.this.langStatus.setVisible(false);
                    PsbSummaryPage.this.langStatus.setToolTipText(null);
                    PsbSummaryPage.this.olicStatus.setVisible(false);
                    PsbSummaryPage.this.olicStatus.setToolTipText(null);
                }
                if (!PsbSummaryPage.this.langCombo.getText().equals(langs[0])) {
                    int i = 1;
                    while (i < langs.length) {
                        if (PsbSummaryPage.this.langCombo.getText().equals(langs[i])) {
                            ((PsbGEFModel)PsbSummaryPage.this.rmeParent.getDbdOrPcbList()).getPsb().setLang(DBDConstants.valueOf((String)langsShort[i].replace('/', '_')));
                            break;
                        }
                        ++i;
                    }
                } else {
                    ((PsbGEFModel)PsbSummaryPage.this.rmeParent.getDbdOrPcbList()).getPsb().setLang(DBDConstants.BLANK);
                }
                PsbSummaryPage.this.rmeParent.setDirty(!PsbSummaryPage.this.maxqStatus.isVisible() && !PsbSummaryPage.this.iosizeStatus.isVisible() && !PsbSummaryPage.this.ssasizeStatus.isVisible() && !PsbSummaryPage.this.ioeropnStatus.isVisible() && !PsbSummaryPage.this.lockmaxStatus.isVisible() && !PsbSummaryPage.this.olicStatus.isVisible() && !PsbSummaryPage.this.remarksStatus.isVisible());
            }
        });
        GridData gdMaxq = new GridData(768);
        Label maxqLabel = toolkit.createLabel(client, WorkbenchPlugin.labels.getString("WB406") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB406") + ")" + WorkbenchPlugin.colon.getString("COLON"));
        maxqLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB110"));
        this.maxqField = toolkit.createText(client, "");
        this.maxqField.setToolTipText(WorkbenchPlugin.descriptions.getString("WB428"));
        this.maxqField.setLayoutData((Object)gdMaxq);
        this.maxqField.setText(Integer.toString(psb.getMaxq()));
        this.maxqStatus = toolkit.createLabel(client, "");
        this.maxqStatus.setImage(FigureConstants.ERROR);
        this.maxqStatus.setBackground(COLOR_WHITE);
        this.maxqStatus.setLayoutData((Object)new GridData(768));
        this.maxqStatus.setVisible(false);
        this.maxqField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String maxQ = PsbSummaryPage.this.maxqField.getText();
                if (!Utility.isStringNumeric(maxQ)) {
                    Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB406"), 0, Short.MAX_VALUE};
                    MessageFormat formatter = new MessageFormat("");
                    formatter.setLocale(Locale.getDefault());
                    formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC43"));
                    PsbSummaryPage.this.maxqStatus.setToolTipText(formatter.format(messageArguments));
                    PsbSummaryPage.this.maxqStatus.setVisible(true);
                } else if (maxQ.length() > 0 && (Integer.valueOf(maxQ) < 0 || Integer.valueOf(maxQ) > Short.MAX_VALUE)) {
                    Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB406"), 0, Short.MAX_VALUE};
                    MessageFormat formatter = new MessageFormat("");
                    formatter.setLocale(Locale.getDefault());
                    formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC17"));
                    PsbSummaryPage.this.maxqStatus.setToolTipText(formatter.format(messageArguments));
                    PsbSummaryPage.this.maxqStatus.setVisible(true);
                } else {
                    PsbSummaryPage.this.maxqStatus.setToolTipText(null);
                    PsbSummaryPage.this.maxqStatus.setVisible(false);
                    ((PsbGEFModel)PsbSummaryPage.this.rmeParent.getDbdOrPcbList()).getPsb().setMaxq(maxQ.length() == 0 ? null : Integer.valueOf(maxQ));
                    PsbSummaryPage.this.rmeParent.setDirty(!PsbSummaryPage.this.iosizeStatus.isVisible() && !PsbSummaryPage.this.ssasizeStatus.isVisible() && !PsbSummaryPage.this.ioeropnStatus.isVisible() && !PsbSummaryPage.this.lockmaxStatus.isVisible() && !PsbSummaryPage.this.langStatus.isVisible() && !PsbSummaryPage.this.olicStatus.isVisible() && !PsbSummaryPage.this.remarksStatus.isVisible());
                }
            }
        });
        GridData gdCmpat = new GridData(768);
        Label cmpatLabel = toolkit.createLabel(client, WorkbenchPlugin.labels.getString("WB407") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB407") + ")" + WorkbenchPlugin.colon.getString("COLON"));
        cmpatLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB111"));
        this.cmpatCombo = new Combo(client, 12);
        toolkit.adapt((Composite)this.cmpatCombo);
        toolkit.paintBordersFor(client);
        this.cmpatCombo.setItems(yesNo);
        this.cmpatCombo.setLayoutData((Object)gdCmpat);
        if (psb.getCompat() != null) {
            this.cmpatCombo.setText(PsbSummaryPage.getYesNoString(psb.getCompat()));
        } else {
            this.cmpatCombo.setText(yesNo[1]);
        }
        this.cmpatCombo.setLayoutData((Object)new GridData(768));
        this.cmpatCombo.addListener(24, (Listener)this);
        this.cmpatCombo.setBackground(COLOR_WHITE);
        this.createEmptyLabel(toolkit, client);
        this.cmpatCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((PsbGEFModel)PsbSummaryPage.this.rmeParent.getDbdOrPcbList()).getPsb().setCompat(PsbSummaryPage.getYesNoConstant(PsbSummaryPage.this.cmpatCombo.getText()));
                PsbSummaryPage.this.rmeParent.setDirty(!PsbSummaryPage.this.maxqStatus.isVisible() && !PsbSummaryPage.this.iosizeStatus.isVisible() && !PsbSummaryPage.this.ssasizeStatus.isVisible() && !PsbSummaryPage.this.ioeropnStatus.isVisible() && !PsbSummaryPage.this.lockmaxStatus.isVisible() && !PsbSummaryPage.this.langStatus.isVisible() && !PsbSummaryPage.this.olicStatus.isVisible() && !PsbSummaryPage.this.remarksStatus.isVisible());
            }
        });
        GridData gdIoa = new GridData(768);
        Label ioasizeLabel = toolkit.createLabel(client, WorkbenchPlugin.labels.getString("WB408") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB408") + ")" + WorkbenchPlugin.colon.getString("COLON"));
        ioasizeLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB112"));
        this.ioasizeField = psb.getIoAreaSize() != null ? uih.genTextField(client, 2048, String.valueOf(psb.getIoAreaSize()), 6, gdIoa, (Listener)this, 24) : uih.genTextField(client, 2048, "", 6, gdIoa, (Listener)this, 24);
        this.ioasizeField.setToolTipText(WorkbenchPlugin.descriptions.getString("WB429"));
        this.ioasizeField.setLayoutData((Object)gdIoa);
        this.iosizeStatus = toolkit.createLabel(client, "", 0);
        this.iosizeStatus.setImage(FigureConstants.ERROR);
        this.iosizeStatus.setBackground(COLOR_WHITE);
        this.iosizeStatus.setLayoutData((Object)new GridData(768));
        this.iosizeStatus.setVisible(false);
        this.ioasizeField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String ioSize = PsbSummaryPage.this.ioasizeField.getText();
                if (!Utility.isStringNumeric(ioSize)) {
                    Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB408"), 0, 256000};
                    MessageFormat formatter = new MessageFormat("");
                    formatter.setLocale(Locale.getDefault());
                    formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC43"));
                    PsbSummaryPage.this.iosizeStatus.setToolTipText(formatter.format(messageArguments));
                    PsbSummaryPage.this.iosizeStatus.setVisible(true);
                } else if (ioSize.length() > 0 && (Integer.valueOf(ioSize) < 0 || Integer.valueOf(ioSize) > 256000)) {
                    Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB408"), 0, 256000};
                    MessageFormat formatter = new MessageFormat("");
                    formatter.setLocale(Locale.getDefault());
                    formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC17"));
                    PsbSummaryPage.this.iosizeStatus.setToolTipText(formatter.format(messageArguments));
                    PsbSummaryPage.this.iosizeStatus.setVisible(true);
                } else {
                    PsbSummaryPage.this.iosizeStatus.setToolTipText(null);
                    PsbSummaryPage.this.iosizeStatus.setVisible(false);
                    ((PsbGEFModel)PsbSummaryPage.this.rmeParent.getDbdOrPcbList()).getPsb().setIoAreaSize(ioSize == null || ioSize.length() == 0 ? null : Integer.valueOf(ioSize));
                    PsbSummaryPage.this.rmeParent.setDirty(!PsbSummaryPage.this.maxqStatus.isVisible() && !PsbSummaryPage.this.ssasizeStatus.isVisible() && !PsbSummaryPage.this.ioeropnStatus.isVisible() && !PsbSummaryPage.this.lockmaxStatus.isVisible() && !PsbSummaryPage.this.langStatus.isVisible() && !PsbSummaryPage.this.olicStatus.isVisible() && !PsbSummaryPage.this.remarksStatus.isVisible());
                }
            }
        });
        GridData gdSa = new GridData(768);
        Label ssasizeLabel = toolkit.createLabel(client, WorkbenchPlugin.labels.getString("WB409") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB409") + ")" + WorkbenchPlugin.colon.getString("COLON"));
        ssasizeLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB116"));
        this.ssasizeField = psb.getSsaSize() != null ? this.genTextField(client, 2048, String.valueOf(psb.getSsaSize()), 6, gdSa, this, 24) : this.genTextField(client, 2048, "", 6, gdSa, this, 24);
        this.ssasizeField.setToolTipText(WorkbenchPlugin.descriptions.getString("WB429"));
        this.ssasizeStatus = toolkit.createLabel(client, "", 0);
        this.ssasizeStatus.setImage(FigureConstants.ERROR);
        this.ssasizeStatus.setLayoutData((Object)new GridData(768));
        this.ssasizeStatus.setVisible(false);
        this.ssasizeField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String ssaSize = PsbSummaryPage.this.ssasizeField.getText();
                if (!Utility.isStringNumeric(ssaSize)) {
                    Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB409"), 0, 256000};
                    MessageFormat formatter = new MessageFormat("");
                    formatter.setLocale(Locale.getDefault());
                    formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC43"));
                    PsbSummaryPage.this.ssasizeStatus.setToolTipText(formatter.format(messageArguments));
                    PsbSummaryPage.this.ssasizeStatus.setVisible(true);
                } else if (ssaSize.length() > 0 && (Integer.valueOf(ssaSize) < 0 || Integer.valueOf(ssaSize) > 256000)) {
                    Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB409"), 0, 256000};
                    MessageFormat formatter = new MessageFormat("");
                    formatter.setLocale(Locale.getDefault());
                    formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC17"));
                    PsbSummaryPage.this.ssasizeStatus.setToolTipText(formatter.format(messageArguments));
                    PsbSummaryPage.this.ssasizeStatus.setVisible(true);
                } else {
                    PsbSummaryPage.this.ssasizeStatus.setToolTipText(null);
                    PsbSummaryPage.this.ssasizeStatus.setVisible(false);
                    ((PsbGEFModel)PsbSummaryPage.this.rmeParent.getDbdOrPcbList()).getPsb().setSsaSize(ssaSize.length() == 0 ? null : Integer.valueOf(ssaSize));
                    PsbSummaryPage.this.rmeParent.setDirty(!PsbSummaryPage.this.maxqStatus.isVisible() && !PsbSummaryPage.this.iosizeStatus.isVisible() && !PsbSummaryPage.this.ioeropnStatus.isVisible() && !PsbSummaryPage.this.lockmaxStatus.isVisible() && !PsbSummaryPage.this.langStatus.isVisible() && !PsbSummaryPage.this.olicStatus.isVisible() && !PsbSummaryPage.this.remarksStatus.isVisible());
                }
            }
        });
        GridData gdIoeropn = new GridData(768);
        Label ioeropnLabel = toolkit.createLabel(client, WorkbenchPlugin.labels.getString("WB410") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB410") + ")" + WorkbenchPlugin.colon.getString("COLON"));
        ioeropnLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB117"));
        this.ioeropnField = psb.getIoeropnConditionCode() != null ? this.genTextField(client, 2048, String.valueOf(psb.getIoeropnConditionCode()), 4, gdIoeropn, this, 24) : this.genTextField(client, 2048, "", 4, gdIoeropn, this, 24);
        this.ioeropnField.setToolTipText(WorkbenchPlugin.descriptions.getString("WB430"));
        this.ioeropnStatus = toolkit.createLabel(client, "", 0);
        this.ioeropnStatus.setImage(FigureConstants.ERROR);
        this.ioeropnStatus.setBackground(COLOR_WHITE);
        this.ioeropnStatus.setLayoutData((Object)new GridData(768));
        this.ioeropnStatus.setVisible(false);
        this.ioeropnField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String ioeropn = PsbSummaryPage.this.ioeropnField.getText();
                if (!Utility.isStringNumeric(ioeropn)) {
                    Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB410"), 0, 4095};
                    MessageFormat formatter = new MessageFormat("");
                    formatter.setLocale(Locale.getDefault());
                    formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC43"));
                    PsbSummaryPage.this.ioeropnStatus.setToolTipText(formatter.format(messageArguments));
                    PsbSummaryPage.this.ioeropnStatus.setVisible(true);
                } else if (ioeropn.length() > 0 && (Integer.valueOf(ioeropn) < 0 || Integer.valueOf(ioeropn) > 4095)) {
                    Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB410"), 0, 4095};
                    MessageFormat formatter = new MessageFormat("");
                    formatter.setLocale(Locale.getDefault());
                    formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC17"));
                    PsbSummaryPage.this.ioeropnStatus.setToolTipText(formatter.format(messageArguments));
                    PsbSummaryPage.this.ioeropnStatus.setVisible(true);
                } else {
                    PsbSummaryPage.this.ioeropnStatus.setToolTipText(null);
                    PsbSummaryPage.this.ioeropnStatus.setVisible(false);
                    ((PsbGEFModel)PsbSummaryPage.this.rmeParent.getDbdOrPcbList()).getPsb().setIoeropnConditionCode(ioeropn.length() == 0 ? null : Integer.valueOf(ioeropn));
                    PsbSummaryPage.this.rmeParent.setDirty(!PsbSummaryPage.this.maxqStatus.isVisible() && !PsbSummaryPage.this.iosizeStatus.isVisible() && !PsbSummaryPage.this.ssasizeStatus.isVisible() && !PsbSummaryPage.this.lockmaxStatus.isVisible() && !PsbSummaryPage.this.langStatus.isVisible() && !PsbSummaryPage.this.olicStatus.isVisible() && !PsbSummaryPage.this.remarksStatus.isVisible());
                }
                PsbSummaryPage.this.wtorCombo.setEnabled(ioeropn.length() > 0 && !PsbSummaryPage.this.ioeropnStatus.isVisible());
            }
        });
        GridData gdWtor = new GridData(768);
        Label wtorComboLabel = toolkit.createLabel(client, WorkbenchPlugin.labels.getString("WB445") + WorkbenchPlugin.colon.getString("COLON"));
        wtorComboLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB439"));
        this.wtorCombo = new Combo(client, 12);
        toolkit.adapt((Composite)this.wtorCombo);
        toolkit.paintBordersFor(client);
        this.wtorCombo.setItems(yesNo);
        this.wtorCombo.setLayoutData((Object)gdWtor);
        if (psb.getIoeropnWTOR() != null) {
            this.wtorCombo.setText(PsbSummaryPage.getYesNoString(psb.getIoeropnWTOR()));
        }
        this.createEmptyLabel(toolkit, client);
        this.wtorCombo.addListener(24, (Listener)this);
        this.wtorCombo.setBackground(COLOR_WHITE);
        this.wtorCombo.setEnabled(this.ioeropnField.getText().length() > 0);
        this.wtorCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PsbSummaryPage.this.wtorCombo.getText().equals(yesNo[0]) && !PsbSummaryPage.this.ioeropnStatus.isVisible()) {
                    ((PsbGEFModel)PsbSummaryPage.this.rmeParent.getDbdOrPcbList()).getPsb().setIoeropnWTOR(DBDConstants.Y);
                } else {
                    ((PsbGEFModel)PsbSummaryPage.this.rmeParent.getDbdOrPcbList()).getPsb().setIoeropnWTOR(DBDConstants.N);
                }
                PsbSummaryPage.this.rmeParent.setDirty(!PsbSummaryPage.this.maxqStatus.isVisible() && !PsbSummaryPage.this.iosizeStatus.isVisible() && !PsbSummaryPage.this.ssasizeStatus.isVisible() && !PsbSummaryPage.this.ioeropnStatus.isVisible() && !PsbSummaryPage.this.lockmaxStatus.isVisible() && !PsbSummaryPage.this.langStatus.isVisible() && !PsbSummaryPage.this.olicStatus.isVisible() && !PsbSummaryPage.this.remarksStatus.isVisible());
            }
        });
        GridData gdOlic = new GridData(768);
        Label olicLabel = toolkit.createLabel(client, WorkbenchPlugin.labels.getString("WB411") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB411") + ")" + WorkbenchPlugin.colon.getString("COLON"));
        olicLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB114"));
        this.olicCombo = new Combo(client, 12);
        toolkit.adapt((Composite)this.olicCombo);
        toolkit.paintBordersFor(client);
        this.olicCombo.setItems(yesNo);
        this.olicCombo.setLayoutData((Object)gdOlic);
        this.olicCombo.addListener(24, (Listener)this);
        this.olicCombo.setBackground(COLOR_WHITE);
        if (psb.getOnlineDBImageCopy() != null) {
            this.olicCombo.setText(PsbSummaryPage.getYesNoString(psb.getOnlineDBImageCopy()));
        }
        this.olicStatus = toolkit.createLabel(client, "", 0);
        this.olicStatus.setImage(FigureConstants.ERROR);
        this.olicStatus.setBackground(COLOR_WHITE);
        this.olicStatus.setLayoutData((Object)new GridData());
        this.olicStatus.setVisible(false);
        this.olicCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PsbSummaryPage.this.langCombo.getText().equals(langs[langs.length - 1]) && PsbSummaryPage.this.olicCombo.getText().equals(yesNo[0])) {
                    Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB411"), yesNo[0], WorkbenchPlugin.noxlatlabels.getString("WB405"), langs[langs.length - 1]};
                    MessageFormat formatter = new MessageFormat("");
                    formatter.setLocale(Locale.getDefault());
                    formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC16"));
                    PsbSummaryPage.this.olicStatus.setToolTipText(formatter.format(messageArguments));
                    PsbSummaryPage.this.olicStatus.setVisible(true);
                    PsbSummaryPage.this.langStatus.setVisible(false);
                    PsbSummaryPage.this.langStatus.setToolTipText(null);
                } else {
                    PsbSummaryPage.this.langStatus.setVisible(false);
                    PsbSummaryPage.this.langStatus.setToolTipText(null);
                    PsbSummaryPage.this.olicStatus.setVisible(false);
                    PsbSummaryPage.this.olicStatus.setToolTipText(null);
                }
                ((PsbGEFModel)PsbSummaryPage.this.rmeParent.getDbdOrPcbList()).getPsb().setOnlineDBImageCopy(PsbSummaryPage.getYesNoConstant(PsbSummaryPage.this.olicCombo.getText()));
                PsbSummaryPage.this.rmeParent.setDirty(!PsbSummaryPage.this.maxqStatus.isVisible() && !PsbSummaryPage.this.iosizeStatus.isVisible() && !PsbSummaryPage.this.ssasizeStatus.isVisible() && !PsbSummaryPage.this.ioeropnStatus.isVisible() && !PsbSummaryPage.this.lockmaxStatus.isVisible() && !PsbSummaryPage.this.langStatus.isVisible() && !PsbSummaryPage.this.olicStatus.isVisible() && !PsbSummaryPage.this.remarksStatus.isVisible());
            }
        });
        Label gsrolbokLabel = toolkit.createLabel(client, WorkbenchPlugin.labels.getString("WB412") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB412") + ")" + WorkbenchPlugin.colon.getString("COLON"));
        gsrolbokLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB115"));
        this.gsrolbokCombo = new Combo(client, 12);
        toolkit.adapt((Composite)this.gsrolbokCombo);
        toolkit.paintBordersFor(client);
        this.gsrolbokCombo.setItems(yesNo);
        if (psb.getGsamRollb() != null) {
            this.gsrolbokCombo.setText(PsbSummaryPage.getYesNoString(psb.getGsamRollb()));
        } else {
            this.gsrolbokCombo.setText(yesNo[1]);
        }
        this.gsrolbokCombo.setLayoutData((Object)new GridData(768));
        this.createEmptyLabel(toolkit, client);
        this.gsrolbokCombo.addListener(24, (Listener)this);
        this.gsrolbokCombo.setBackground(COLOR_WHITE);
        this.gsrolbokCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((PsbGEFModel)PsbSummaryPage.this.rmeParent.getDbdOrPcbList()).getPsb().setGsamRollb(PsbSummaryPage.getYesNoConstant(PsbSummaryPage.this.gsrolbokCombo.getText()));
                PsbSummaryPage.this.rmeParent.setDirty(!PsbSummaryPage.this.maxqStatus.isVisible() && !PsbSummaryPage.this.iosizeStatus.isVisible() && !PsbSummaryPage.this.ssasizeStatus.isVisible() && !PsbSummaryPage.this.ioeropnStatus.isVisible() && !PsbSummaryPage.this.lockmaxStatus.isVisible() && !PsbSummaryPage.this.langStatus.isVisible() && !PsbSummaryPage.this.olicStatus.isVisible() && !PsbSummaryPage.this.remarksStatus.isVisible());
            }
        });
        GridData gdLockMax = new GridData(768);
        Label lockmaxLabel = toolkit.createLabel(client, WorkbenchPlugin.labels.getString("WB413") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB413") + ")" + WorkbenchPlugin.colon.getString("COLON"));
        lockmaxLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB116"));
        this.lockmaxField = psb.getMaximumLock() != null ? this.genTextField(client, 2048, String.valueOf(psb.getMaximumLock()), 3, gdLockMax, this, 24) : uih.genTextField(client, 2048, "0", 3, gdLockMax, (Listener)this, 24);
        this.lockmaxField.setToolTipText(WorkbenchPlugin.descriptions.getString("WB431"));
        this.lockmaxStatus = toolkit.createLabel(client, "", 0);
        this.lockmaxStatus.setImage(FigureConstants.ERROR);
        this.lockmaxStatus.setBackground(COLOR_WHITE);
        this.lockmaxStatus.setLayoutData((Object)new GridData());
        this.lockmaxStatus.setVisible(false);
        this.lockmaxField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String lockMax = PsbSummaryPage.this.lockmaxField.getText();
                if (!Utility.isStringNumeric(lockMax)) {
                    Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB413"), 0, 255};
                    MessageFormat formatter = new MessageFormat("");
                    formatter.setLocale(Locale.getDefault());
                    formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC43"));
                    PsbSummaryPage.this.lockmaxStatus.setToolTipText(formatter.format(messageArguments));
                    PsbSummaryPage.this.lockmaxStatus.setVisible(true);
                } else if (lockMax.length() > 0 && (Integer.valueOf(lockMax) < 0 || Integer.valueOf(lockMax) > 255)) {
                    Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB413"), 0, 255};
                    MessageFormat formatter = new MessageFormat("");
                    formatter.setLocale(Locale.getDefault());
                    formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC17"));
                    PsbSummaryPage.this.lockmaxStatus.setToolTipText(formatter.format(messageArguments));
                    PsbSummaryPage.this.lockmaxStatus.setVisible(true);
                } else {
                    PsbSummaryPage.this.lockmaxStatus.setToolTipText(null);
                    PsbSummaryPage.this.lockmaxStatus.setVisible(false);
                    ((PsbGEFModel)PsbSummaryPage.this.rmeParent.getDbdOrPcbList()).getPsb().setMaximumLock(lockMax.length() == 0 ? null : Integer.valueOf(lockMax));
                    PsbSummaryPage.this.rmeParent.setDirty(!PsbSummaryPage.this.maxqStatus.isVisible() && !PsbSummaryPage.this.iosizeStatus.isVisible() && !PsbSummaryPage.this.ssasizeStatus.isVisible() && !PsbSummaryPage.this.ioeropnStatus.isVisible() && !PsbSummaryPage.this.langStatus.isVisible() && !PsbSummaryPage.this.olicStatus.isVisible() && !PsbSummaryPage.this.remarksStatus.isVisible());
                }
            }
        });
        Label dblevelLabel = toolkit.createLabel(client, WorkbenchPlugin.labels.getString("DBLEVEL") + " (" + WorkbenchPlugin.noxlatlabels.getString("DBLEVEL") + ")" + WorkbenchPlugin.colon.getString("COLON"));
        dblevelLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB115"));
        this.dblevelCombo = new Combo(client, 12);
        toolkit.adapt((Composite)this.dblevelCombo);
        toolkit.paintBordersFor(client);
        this.dblevelCombo.setItems(dbLevelTypes);
        if (psb.getDblevel() != null) {
            this.dblevelCombo.setText(psb.getDblevel());
        }
        this.dblevelCombo.setLayoutData((Object)new GridData(768));
        this.createEmptyLabel(toolkit, client);
        this.dblevelCombo.addListener(24, (Listener)this);
        this.dblevelCombo.setBackground(COLOR_WHITE);
        this.dblevelCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((PsbGEFModel)PsbSummaryPage.this.rmeParent.getDbdOrPcbList()).getPsb().setDblevel(PsbSummaryPage.this.dblevelCombo.getText());
                PsbSummaryPage.this.rmeParent.setDirty(!PsbSummaryPage.this.maxqStatus.isVisible() && !PsbSummaryPage.this.iosizeStatus.isVisible() && !PsbSummaryPage.this.ssasizeStatus.isVisible() && !PsbSummaryPage.this.ioeropnStatus.isVisible() && !PsbSummaryPage.this.lockmaxStatus.isVisible() && !PsbSummaryPage.this.langStatus.isVisible() && !PsbSummaryPage.this.olicStatus.isVisible() && !PsbSummaryPage.this.remarksStatus.isVisible());
            }
        });
        Label remarksLabel = toolkit.createLabel(client, WorkbenchPlugin.labels.getString("REMARKS") + " (" + WorkbenchPlugin.noxlatlabels.getString("REMARKS") + ")" + WorkbenchPlugin.colon.getString("COLON"));
        remarksLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB099"));
        GridData gdlabel = new GridData();
        gdlabel.verticalAlignment = 1;
        remarksLabel.setLayoutData((Object)gdlabel);
        GridData gdrm = new GridData(768);
        gdrm.heightHint = 75;
        this.remarksField = new Text(client, 2114);
        this.remarksField.setToolTipText(WorkbenchPlugin.descriptions.getString("WB100"));
        this.remarksField.setLayoutData((Object)gdrm);
        if (psb.getPsbRemarks() != null) {
            this.remarksField.setText(psb.getPsbRemarks());
        }
        this.remarksField.setTextLimit(256);
        this.remarksStatus = toolkit.createLabel(client, "", 0);
        this.remarksStatus.setImage(FigureConstants.ERROR);
        this.remarksStatus.setBackground(COLOR_WHITE);
        this.remarksStatus.setLayoutData((Object)new GridData(768));
        this.remarksStatus.setVisible(false);
        this.remarksField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.widget == PsbSummaryPage.this.remarksField) {
                    if (e.character == '\t') {
                        e.text = null;
                        PsbSummaryPage.this.remarksField.traverse(16);
                    } else if (e.character == '\r') {
                        e.text = null;
                        PsbSummaryPage.this.remarksField.traverse(4, (KeyEvent)e);
                    }
                }
            }
        });
        this.remarksField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (PsbSummaryPage.this.remarksStatus != null) {
                    PsbSummaryPage.this.remarksStatus.setToolTipText(null);
                    PsbSummaryPage.this.remarksStatus.setVisible(false);
                    String invalidCharacter = Utility.getInvalidRemarksCharacter(PsbSummaryPage.this.remarksField.getText());
                    if (invalidCharacter != null) {
                        Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB019A"), invalidCharacter};
                        Object errorMessage = WorkbenchModelBundle.getError().getString("EISRC11", inserts);
                        if (invalidCharacter.equals("'")) {
                            errorMessage = (String)errorMessage + " " + WorkbenchModelBundle.getError().getString("EISRC11A");
                        }
                        PsbSummaryPage.this.remarksStatus.setVisible(true);
                        PsbSummaryPage.this.remarksStatus.setToolTipText(Utility.formatMessage((String)errorMessage));
                    }
                    ((PsbGEFModel)PsbSummaryPage.this.rmeParent.getDbdOrPcbList()).getPsb().setPsbRemarks(PsbSummaryPage.this.remarksField.getText());
                    PsbSummaryPage.this.rmeParent.setDirty(!PsbSummaryPage.this.maxqStatus.isVisible() && !PsbSummaryPage.this.iosizeStatus.isVisible() && !PsbSummaryPage.this.ssasizeStatus.isVisible() && !PsbSummaryPage.this.ioeropnStatus.isVisible() && !PsbSummaryPage.this.lockmaxStatus.isVisible() && !PsbSummaryPage.this.langStatus.isVisible() && !PsbSummaryPage.this.olicStatus.isVisible() && !PsbSummaryPage.this.remarksStatus.isVisible());
                }
            }
        });
        section.setText(WorkbenchPlugin.labels.getString("WB431"));
        section.setDescription(WorkbenchPlugin.descriptions.getString("WB423"));
        section.setClient((Control)client);
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        TableWrapData td = new TableWrapData(128);
        td.colspan = 1;
        section.setLayoutData((Object)td);
        if (this.isReadOnly) {
            this.langCombo.setEnabled(false);
            this.cmpatCombo.setEnabled(false);
            this.olicCombo.setEnabled(false);
            this.gsrolbokCombo.setEnabled(false);
            this.dblevelCombo.setEnabled(false);
            this.wtorCombo.setEnabled(false);
            this.maxqField.setEnabled(false);
            this.ioasizeField.setEnabled(false);
            this.ssasizeField.setEnabled(false);
            this.ioeropnField.setEnabled(false);
            this.lockmaxField.setEnabled(false);
            this.remarksField.setEnabled(false);
        }
    }

    private void createEmptyLabel(FormToolkit toolkit, Composite client) {
        this.emptyLabel = toolkit.createLabel(client, "");
        this.emptyLabel.setLayoutData((Object)new GridData(768));
    }

    private void setColumns(Table table, String[] columnsLabels, String[] columnsTooltips) {
        int i = 0;
        while (i < columnsLabels.length) {
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setMoveable(true);
            tableColumn.setResizable(true);
            tableColumn.setText(columnsLabels[i]);
            tableColumn.setToolTipText(columnsTooltips[i]);
            tableColumn.setWidth(70);
            ++i;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    private void layoutColumns(Table table) {
        TableColumn[] tableColumns = table.getColumns();
        if (tableColumns.length > 0) {
            int tableWidth = editorWidth - this.buttonWidth - this.margin * 3;
            int columnWidth = tableWidth / tableColumns.length - table.getBorderWidth();
            int i = 0;
            while (i < tableColumns.length) {
                tableColumns[i].setWidth(columnWidth);
                ++i;
            }
        }
    }

    public Table getTpPcbTable() {
        return this.tpPcbTable;
    }

    public Table getDbPcbTable() {
        return this.dbPcbTable;
    }

    public Table getGsamPcbTable() {
        return this.gsamPcbTable;
    }

    public static DBDConstants getYesNoConstant(String value) {
        DBDConstants retVal = DBDConstants.N;
        if (value.equals(yesNo[0])) {
            retVal = DBDConstants.Y;
        }
        return retVal;
    }

    public static String getYesNoString(DBDConstants value) {
        return value.equals((Object)DBDConstants.Y) ? yesNo[0] : yesNo[1];
    }

    public String[] getFffpDbNames() {
        return this.fffpDbNames;
    }

    public String[] getGsamDbNames() {
        return this.gsamDbNames;
    }

    private void initDbdNames() throws CoreException {
        if (this.rmeParent != null && this.fffpDbNames == null && this.gsamDbNames == null) {
            FileEditorInput fileInput = (FileEditorInput)this.rmeParent.getEditorInput();
            IFile file = fileInput.getFile();
            IPath path = file.getFullPath();
            String projectName = path.segments()[0];
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = wsRoot.getProject(projectName);
            if (project != null && project.isOpen()) {
                IFolder databaseFolder = project.getFolder("DBD");
                if (!databaseFolder.exists()) {
                    return;
                }
                ArrayList<String> fffpDbNames = new ArrayList<String>();
                ArrayList<String> gsamDbNames = new ArrayList<String>();
                Vector allDbNames = ProjectTreeFileHelper.getDbdNamesInProject((String)projectName);
                for (String dbdName : allDbNames) {
                    fffpDbNames.add(dbdName);
                    gsamDbNames.add(dbdName);
                }
                if (fffpDbNames.size() > 0) {
                    this.fffpDbNames = fffpDbNames.toArray(new String[fffpDbNames.size()]);
                }
                if (gsamDbNames.size() > 0) {
                    this.gsamDbNames = gsamDbNames.toArray(new String[gsamDbNames.size()]);
                }
            }
        }
    }

    public Composite getPage() {
        return this.form;
    }

    public void widgetSelected(SelectionEvent event) {
        try {
            if (event.widget == this.launchEditorButton) {
                this.setActivePage();
            } else if (event.widget == this.dbPcbTable) {
                this.enableDbPcbButtons();
            } else if (event.widget == this.tpPcbTable) {
                this.enableTpPcbButtons();
            } else if (event.widget == this.gsamPcbTable) {
                this.enableGsamPcbButtons();
            } else if (event.widget == this.tpRemoveButton) {
                this.handleTpRemove();
            } else if (event.widget == this.dbRemoveButton) {
                this.handleDbRemove();
            } else if (event.widget == this.gsamRemoveButton) {
                this.handleGsamRemove();
            } else if (event.widget == this.dbEditButton) {
                this.handleDbEdit();
            } else if (event.widget == this.dbAddButton) {
                this.handleDbAdd();
            } else if (event.widget == this.tpEditButton) {
                this.handleTpEdit();
            } else if (event.widget == this.tpAddButton) {
                this.handleTpAdd();
            } else if (event.widget == this.gsamEditButton) {
                this.handleGsamEdit();
            } else if (event.widget == this.gsamAddButton) {
                this.handleGsamAdd();
            }
        }
        catch (ModelException e) {
            MessageDialog.openError((Shell)this.getPage().getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected", e);
            logger.error(e);
        }
    }

    private void handleGsamAdd() throws CoreException {
        this.initDbdNames();
        EditGsamPcbWizard editGsamPcbWizard = new EditGsamPcbWizard(null, this, true, this.isReadOnly);
        WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)editGsamPcbWizard);
        dialog.create();
        dialog.getShell().setSize(editGsamPcbWizard.getShell().getMinimumSize());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.getRMEParent().setDirty(true);
            this.refreshGsamPcbTableItems();
        }
    }

    private void handleGsamEdit() {
        try {
            TableItem selectedItem = this.gsamPcbTable.getSelection()[0];
            EditGsamPcbWizard editGsamPcbWizard = new EditGsamPcbWizard(selectedItem, this, false, this.isReadOnly);
            WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)editGsamPcbWizard);
            dialog.create();
            dialog.getShell().setSize(editGsamPcbWizard.getShell().getMinimumSize());
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                this.getRMEParent().setDirty(true);
                this.refreshGsamPcbTableItems();
                this.enableGsamPcbButtons();
            }
        }
        catch (Exception e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleGsamEdit()", (Throwable)e);
            logger.error((Throwable)e);
        }
    }

    private void handleTpAdd() {
        try {
            EditTpPcbWizard editTpPcbWizard = new EditTpPcbWizard(null, this, true, this.isReadOnly);
            WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)editTpPcbWizard);
            dialog.create();
            dialog.getShell().setSize(editTpPcbWizard.getShell().getMinimumSize());
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                this.getRMEParent().setDirty(true);
                this.refreshTpPcbTableItems();
                this.refreshDbPcbTableItems();
                this.refreshGsamPcbTableItems();
                this.updatePageNames();
            }
        }
        catch (Exception e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleTpAdd()", (Throwable)e);
            logger.error((Throwable)e);
        }
    }

    private void handleDbRemove() throws CoreException {
        int[] selectedIndexes = this.dbPcbTable.getSelectionIndices();
        ResourceMultiPageEditor editor = this.getRMEParent();
        int i = 0;
        while (i < selectedIndexes.length) {
            String currPcbNumStr;
            TableItem selectedItem = this.dbPcbTable.getItem(selectedIndexes[i]);
            PsbModel psb = ((PsbGEFModel)this.getRMEParent().getDbdOrPcbList()).getPsb();
            PcbDBModel removedDbPcb = psb.getDbPcbWithNum(Integer.valueOf(currPcbNumStr = selectedItem.getText(0)).intValue());
            if (removedDbPcb == null) {
                throw new RuntimeException("IMS Explorer Error: selected pcb does not exist in the model");
            }
            int j = 1;
            while (j < editor.getPageCount()) {
                PcbDBModel currDbPcb;
                editor.setActivePage(j);
                if (editor.getCurrentPage() != null && editor.getCurrentPage().getDbPcbModel() != null && (currDbPcb = editor.getCurrentPage().getDbPcbModel()) == removedDbPcb) {
                    editor.removePage(j);
                    --j;
                }
                ++j;
            }
            editor.setActivePage(0);
            ++i;
        }
        this.removeSelectedDbPcbsFromModel(selectedIndexes);
        this.refreshDbPcbTableItems();
        this.refreshGsamPcbTableItems();
        this.enableDbPcbButtons();
        this.updatePageNames();
        this.getRMEParent().setDirty(true);
    }

    private void updatePageNames() {
        PsbModel psb = ((PsbGEFModel)this.getRMEParent().getDbdOrPcbList()).getPsb();
        List pcbs = psb.getDBPcbList();
        if (pcbs != null) {
            int i = 0;
            while (i < pcbs.size()) {
                PcbDBModel theDbPcb = (PcbDBModel)pcbs.get(i);
                this.setPageName(theDbPcb);
                ++i;
            }
        }
    }

    private void handleTpEdit() {
        try {
            TableItem selectedItem = this.tpPcbTable.getSelection()[0];
            EditTpPcbWizard editTpPcbWizard = new EditTpPcbWizard(selectedItem, this, false, this.isReadOnly);
            WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)editTpPcbWizard);
            dialog.create();
            dialog.getShell().setSize(editTpPcbWizard.getShell().getMinimumSize());
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                this.getRMEParent().setDirty(true);
                this.refreshTpPcbTableItems();
                this.enableTpPcbButtons();
            }
        }
        catch (Exception e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleTpEdit()", (Throwable)e);
            logger.error((Throwable)e);
        }
    }

    private void handleDbAdd() throws CoreException {
        this.initDbdNames();
        EditDbPcbWizard editDbPcbWizard = new EditDbPcbWizard(null, this, true, this.isReadOnly);
        WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)editDbPcbWizard);
        dialog.create();
        dialog.getShell().setSize(editDbPcbWizard.getShell().getMinimumSize());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.getRMEParent().setDirty(true);
            this.refreshDbPcbTableItems();
            this.refreshGsamPcbTableItems();
            this.dbPcbTable.setSelection(this.dbPcbTable.getItemCount() - 1);
        }
    }

    private void handleDbEdit() {
        try {
            TableItem selectedItem = this.dbPcbTable.getSelection()[0];
            PsbModel psb = ((PsbGEFModel)this.getRMEParent().getDbdOrPcbList()).getPsb();
            PcbDBModel currDbPcb = psb.getDbPcbWithNum(Integer.valueOf(selectedItem.getText(0)).intValue());
            if (currDbPcb == null) {
                throw new RuntimeException("IMS Explorer Error: selected pcb does not exist in the model");
            }
            EditDbPcbWizard editDbPcbWizard = new EditDbPcbWizard(selectedItem, this, false, this.isReadOnly);
            WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)editDbPcbWizard);
            dialog.create();
            dialog.getShell().setSize(editDbPcbWizard.getShell().getMinimumSize());
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                this.getRMEParent().setDirty(true);
                this.refreshDbPcbTableItems();
                this.enableDbPcbButtons();
                this.setPageName(currDbPcb);
            }
        }
        catch (Exception e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleDbEdit()", (Throwable)e);
            logger.error((Throwable)e);
        }
    }

    private void handleGsamRemove() {
        int[] selectedIndexes = this.gsamPcbTable.getSelectionIndices();
        this.removeSelectedGsamPcbsFromModel(selectedIndexes);
        this.refreshGsamPcbTableItems();
        this.enableGsamPcbButtons();
        this.getRMEParent().setDirty(true);
    }

    private void removeSelectedGsamPcbsFromModel(int[] selectedIndexes) {
        PsbModel psbModel = ((PsbGEFModel)this.rmeParent.getDbdOrPcbList()).getPsb();
        List<PcbGsamModel> pcbsForRemoval = this.getGsamPcbsToRemove(selectedIndexes, psbModel);
        int i = 0;
        while (i < pcbsForRemoval.size()) {
            psbModel.removeGsamPcb(pcbsForRemoval.get(i));
            ++i;
        }
    }

    private List<PcbGsamModel> getGsamPcbsToRemove(int[] selectedIndexes, PsbModel psbModel) {
        Vector<PcbGsamModel> retVal = new Vector<PcbGsamModel>();
        int i = 0;
        while (i < selectedIndexes.length) {
            int selPcbIx = selectedIndexes[i];
            String pcbNumStr = this.gsamPcbTable.getItem(selPcbIx).getText(0);
            PcbGsamModel gsamPcb = psbModel.getGsamPcbWithNum(Integer.parseInt(pcbNumStr));
            if (gsamPcb == null) {
                throw new RuntimeException("IMS Explorer Error: selected pcb does not exist in the model");
            }
            retVal.add(gsamPcb);
            ++i;
        }
        return retVal;
    }

    private void removeSelectedDbPcbsFromModel(int[] selectedIndexes) {
        PsbModel psbModel = ((PsbGEFModel)this.rmeParent.getDbdOrPcbList()).getPsb();
        List<PcbDBModel> pcbsForRemoval = this.getDbPcbsToRemove(selectedIndexes, psbModel);
        int i = 0;
        while (i < pcbsForRemoval.size()) {
            psbModel.removeDBPcb(pcbsForRemoval.get(i));
            ++i;
        }
    }

    private void handleTpRemove() {
        int[] selectedIndexes = this.tpPcbTable.getSelectionIndices();
        this.removeSelectedTpPcbsFromModel(selectedIndexes);
        this.refreshTpPcbTableItems();
        this.refreshDbPcbTableItems();
        this.refreshGsamPcbTableItems();
        this.enableTpPcbButtons();
        this.updatePageNames();
        this.getRMEParent().setDirty(true);
    }

    private void removeSelectedTpPcbsFromModel(int[] selectedIndexes) {
        PsbModel psbModel = ((PsbGEFModel)this.rmeParent.getDbdOrPcbList()).getPsb();
        List<PcbTPModel> pcbsForRemoval = this.getTpPcbsToRemove(selectedIndexes, psbModel);
        int i = 0;
        while (i < pcbsForRemoval.size()) {
            psbModel.removeTPPcb(pcbsForRemoval.get(i));
            ++i;
        }
    }

    private List<PcbTPModel> getTpPcbsToRemove(int[] selectedIndexes, PsbModel psbModel) {
        Vector<PcbTPModel> retVal = new Vector<PcbTPModel>();
        int i = 0;
        while (i < selectedIndexes.length) {
            int selPcbIx = selectedIndexes[i];
            String pcbNumStr = this.tpPcbTable.getItem(selPcbIx).getText(0);
            PcbTPModel tpPcb = psbModel.getTpPcbWithNum(Integer.parseInt(pcbNumStr));
            if (tpPcb == null) {
                throw new RuntimeException("IMS Explorer Error: selected pcb does not exist in the model");
            }
            retVal.add(tpPcb);
            ++i;
        }
        return retVal;
    }

    public void enableGsamPcbButtons() {
        int numGsamPcbSelected = this.gsamPcbTable.getSelectionCount();
        if (numGsamPcbSelected == 0) {
            this.gsamEditButton.setEnabled(false);
            this.gsamRemoveButton.setEnabled(false);
        } else if (numGsamPcbSelected == 1) {
            this.gsamEditButton.setEnabled(true);
            this.gsamRemoveButton.setEnabled(true);
        } else if (numGsamPcbSelected > 1) {
            this.gsamEditButton.setEnabled(false);
            this.gsamRemoveButton.setEnabled(true);
        }
        if (this.isReadOnly) {
            this.gsamRemoveButton.setEnabled(false);
        }
    }

    public void enableTpPcbButtons() {
        int numTpPcbSelected = this.tpPcbTable.getSelectionCount();
        if (numTpPcbSelected == 0) {
            this.tpEditButton.setEnabled(false);
            this.tpRemoveButton.setEnabled(false);
        } else if (numTpPcbSelected == 1) {
            this.tpEditButton.setEnabled(true);
            this.tpRemoveButton.setEnabled(true);
        } else if (numTpPcbSelected > 1) {
            this.tpEditButton.setEnabled(false);
            this.tpRemoveButton.setEnabled(true);
        }
        if (this.isReadOnly) {
            this.tpRemoveButton.setEnabled(false);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void enableDbPcbButtons() throws CoreException {
        numDbPcbSelected = this.dbPcbTable.getSelectionCount();
        if (numDbPcbSelected == 0) {
            this.dbEditButton.setEnabled(false);
            this.dbRemoveButton.setEnabled(false);
            this.launchEditorButton.setEnabled(false);
        } else if (numDbPcbSelected == 1) {
            this.dbEditButton.setEnabled(true);
            this.dbRemoveButton.setEnabled(true);
            currentDbdName = this.getCurrentDbPcb().getDbdName();
            fileInput = (FileEditorInput)this.getRMEParent().getEditorInput();
            file = fileInput.getFile();
            path = file.getFullPath();
            projectName = path.segments()[0];
            try {
                dbdExists = ProjectTreeFileHelper.isDbdMetadataFileExists((String)projectName, (String)currentDbdName);
                if (dbdExists) {
                    this.launchEditorButton.setEnabled(true);
                }
                this.launchEditorButton.setEnabled(false);
                if (this.warningIssued) ** GOTO lbl35
                inserts = new Object[]{currentDbdName};
                warningDialog = new MessageDialog(this.launchEditorButton.getShell(), WorkbenchPlugin.errors.getString("EISRC27"), null, WorkbenchPlugin.errors.getString("EISRC20", inserts), 4, new String[]{IDialogConstants.OK_LABEL}, 0);
                runner = new MessageDialogRunner(warningDialog);
                this.launchEditorButton.getShell().getDisplay().asyncExec((Runnable)runner);
                this.warningIssued = true;
            }
            catch (CoreException e) {
                this.launchEditorButton.setEnabled(false);
                throw e;
            }
        } else if (numDbPcbSelected > 1) {
            this.dbEditButton.setEnabled(false);
            this.dbRemoveButton.setEnabled(true);
            this.launchEditorButton.setEnabled(false);
        }
lbl35:
        // 7 sources

        if (this.isReadOnly) {
            this.dbRemoveButton.setEnabled(false);
        }
    }

    public void setActivePage() throws CoreException, ModelException, InvalidDBDSourceException {
        ResourceMultiPageEditor editor = this.getRMEParent();
        TableItem selectedItem = this.dbPcbTable.getSelection()[0];
        PsbModel psb = ((PsbGEFModel)editor.getDbdOrPcbList()).getPsb();
        PcbDBModel currDbPcb = psb.getDbPcbWithNum(Integer.valueOf(selectedItem.getText(0)).intValue());
        if (currDbPcb == null) {
            throw new RuntimeException("IMS Explorer Error: selected pcb does not exist in the model");
        }
        DbGEFModel dbGEFModel = this.getDbGEFModel(currDbPcb);
        currDbPcb.setDbdModel(dbGEFModel.getDbdModel());
        dbGEFModel.addListener(this.getRMEParent());
        String pageName = PsbSummaryPage.createPageName(currDbPcb.getPcbNameOrLabel(), currDbPcb.getPcbNum());
        int i = 2;
        while (i < editor.getPageCount()) {
            editor.setActivePage(i);
            if (editor.getCurrentPage() != null && editor.getCurrentPage().getPageName().equals(pageName)) {
                return;
            }
            ++i;
        }
        ResourceEditorPage page = new ResourceEditorPage(editor, dbGEFModel);
        dbGEFModel.replacePhysicalNodesWithSecondaryDataStructure();
        dbGEFModel.assignSensegs(pageName);
        dbGEFModel.assignSenfields();
        page.setPageName(pageName);
        editor.addPage(page, true);
    }

    public DbGEFModel getDbGEFModel(PcbDBModel pcbModel) throws CoreException, ModelException, InvalidDBDSourceException {
        DbGEFModel retVal = null;
        DbdModel tempDbdModel = null;
        String dbdName = pcbModel.getDbdName();
        Vector<DbGEFModel> gefDbs = this.getRMEParent().getDbdOrPcbList().getList();
        int i = 0;
        while (i < gefDbs.size()) {
            DbGEFModel tempGefDb = gefDbs.get(i);
            if (tempGefDb.getDbdName().equalsIgnoreCase(dbdName)) {
                if (tempGefDb.getPcbModel().getPcbNum() == pcbModel.getPcbNum()) {
                    retVal = tempGefDb;
                    break;
                }
                tempDbdModel = tempGefDb.getDbdModel();
            }
            ++i;
        }
        if (retVal == null) {
            String projectName = this.getRMEParent().getProjectName();
            try {
                if (tempDbdModel == null && (tempDbdModel = this.readInNewDbdModel(pcbModel, projectName)) == null) {
                    Object[] inserts = new Object[]{dbdName};
                    throw new MissingDBDException(WorkbenchPlugin.errors.getString("DHB1701", inserts));
                }
                DbdOrPcbList psb = this.getRMEParent().getDbdOrPcbList();
                retVal = new DbGEFModel(psb, pcbModel, tempDbdModel, projectName);
                psb.getList().add(retVal);
            }
            catch (MissingDBDException e) {
                MessageDialog.openWarning(null, (String)WorkbenchPlugin.errors.getString("EISRC41"), (String)e.getMessage());
            }
        }
        return retVal;
    }

    private DbdModel readInNewDbdModel(PcbDBModel currDbPcb, String projectName) throws CoreException, ModelException, InvalidDBDSourceException {
        String dbdName = currDbPcb.getDbdName();
        DbdModel dbdModel = null;
        IFile dbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)dbdName);
        if (dbdFile != null && dbdFile.exists()) {
            dbdModel = new DbdModel(dbdFile.getContents());
        }
        return dbdModel;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void handleEvent(Event event) {
        if (this.wtorCombo != null) {
            this.wtorCombo.setEnabled(this.ioeropnField != null && this.ioeropnField.getText().length() > 0 && this.ioeropnStatus != null && !this.ioeropnStatus.isVisible());
        }
    }

    private PcbDBModel getCurrentDbPcb() {
        PcbDBModel retVal = null;
        TableItem selectedItem = this.dbPcbTable.getSelection()[0];
        PsbModel psb = ((PsbGEFModel)this.getRMEParent().getDbdOrPcbList()).getPsb();
        retVal = psb.getDbPcbWithNum(Integer.valueOf(selectedItem.getText(0)).intValue());
        return retVal;
    }

    private List<PcbDBModel> getDbPcbsToRemove(int[] selectedIndexes, PsbModel psbModel) {
        Vector<PcbDBModel> retVal = new Vector<PcbDBModel>();
        int i = 0;
        while (i < selectedIndexes.length) {
            int selPcbIx = selectedIndexes[i];
            String pcbNumStr = this.dbPcbTable.getItem(selPcbIx).getText(0);
            PcbDBModel dbPcb = psbModel.getDbPcbWithNum(Integer.parseInt(pcbNumStr));
            if (dbPcb == null) {
                throw new RuntimeException("IMS Explorer Error: selected pcb does not exist in the model");
            }
            retVal.add(dbPcb);
            ++i;
        }
        return retVal;
    }

    public DbdModel getDbdModel(String dbdName) {
        FileEditorInput fileInput = (FileEditorInput)this.rmeParent.getEditorInput();
        IFile file = fileInput.getFile();
        IPath path = file.getFullPath();
        String projectName = path.segments()[0];
        try {
            if (ProjectTreeFileHelper.isDbdMetadataFileExists((String)projectName, (String)dbdName)) {
                IFile dbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)dbdName);
                return new DbdModel(dbdFile.getContents());
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    private void setPageName(PcbDBModel dbPcb) {
        String newName = PsbSummaryPage.createPageName(dbPcb.getPcbNameOrLabel(), dbPcb.getPcbNum());
        ResourceMultiPageEditor editor = this.getRMEParent();
        int i = 1;
        while (i < editor.getPageCount()) {
            DbGEFModel dbGEFModel;
            PcbDBModel currDbPcb;
            editor.setActivePage(i);
            ResourceEditorPage page = editor.getCurrentPage();
            if (page != null && (currDbPcb = (dbGEFModel = page.getDbGEFModel()).getPcbModel()) == dbPcb) {
                String procopt = dbPcb.getProcopt();
                if (procopt == null || procopt.isEmpty()) {
                    procopt = "A";
                }
                String title = "|    " + WorkbenchPlugin.labels.getString("WB430") + ": " + newName + "   |   ";
                title = title + WorkbenchPlugin.labels.getString("WB022") + ": " + dbPcb.getDbdName() + "   |   ";
                title = title + WorkbenchPlugin.labels.getString("WB423") + ": " + procopt + "   |   ";
                title = dbGEFModel.isApplicationView() ? title + WorkbenchPlugin.labels.getString("WB446") + "   |   " : title + WorkbenchPlugin.labels.getString("WB447") + "   |   ";
                ((TitleBarBorder)dbGEFModel.getDbdBorderModel().getFigure().getBorder()).setLabel(title);
                page.setPageName(newName);
                editor.setPageName(page, newName);
                break;
            }
            ++i;
        }
        editor.setActivePage(0);
    }

    public static String createPageName(String pcbNameOrLabel, int pcbNum) {
        Object pageName = pcbNameOrLabel;
        if (pageName == null) {
            pageName = "(PCB#" + pcbNum + ")";
        }
        return pageName;
    }

    public ResourceMultiPageEditor getRMEParent() {
        return this.rmeParent;
    }

    public Text genTextField(Composite composite, int style, String text, int limit, GridData gridData, Listener listener, int eventType) {
        FormColors formColors = new FormColors(this.compositeContainer.getDisplay());
        formColors.markShared();
        FormToolkit toolkit = new FormToolkit(formColors);
        Text txt = toolkit.createText(composite, "");
        txt.setText(text);
        txt.setTextLimit(limit);
        txt.setLayoutData((Object)gridData);
        txt.addListener(eventType, listener);
        return txt;
    }

    public void dispose() {
        super.dispose();
        COLOR_RED.dispose();
        COLOR_WHITE.dispose();
    }
}

