/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.figures;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.figures.FigureConstants;
import com.ibm.im.ims.workbench.editors.figures.TooltipFigure;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.editors.preferences.GetNodePreferences;
import com.ibm.im.ims.workbench.model.SegmentModel;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.CheckBox;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToggleModel;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class SegmentLabelFigure
extends Figure {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Label m_label = null;
    private CheckBox m_checkBox = null;
    private Label m_totalLen = null;
    private Label m_secondaryIndex = null;
    private Label m_logicalRel = null;
    private Label m_logicalParent = null;
    private int segType = 0;
    private SegmentGEFModel gefSegment;
    private boolean has2ndIndexes = false;
    private boolean hasLogRels = false;
    boolean isReadOnly;

    public SegmentLabelFigure(SegmentGEFModel gefSegment) {
        Font m_boldFont;
        this.init();
        this.isReadOnly = gefSegment.getDbGEFModel().getProjectName().equalsIgnoreCase("IMS_Explorer_Catalog_ReadOnly");
        this.gefSegment = gefSegment;
        Image nodeLabelImage = FigureConstants.SEGMENT_IMAGE;
        Image secondIndexImage = FigureConstants.SECONDARYINDEX_IMAGE;
        Image logicalParentImage = FigureConstants.LOGICALPARENT_IMAGE;
        Image logicalChildImage = FigureConstants.LOGICALCHILD_IMAGE;
        Image vlcImage = FigureConstants.VLOGICALCHILD_IMAGE;
        String name = gefSegment.getSegmentAlias();
        if (name == null || name.length() == 0) {
            name = gefSegment.getSegmentName();
        }
        this.segType = gefSegment.getSegmentType();
        if (this.segType == 3) {
            this.m_label = new Label(gefSegment.getSegmentModel().getDbdName() + "." + name, null);
        } else {
            this.m_label = new Label(name);
            if (gefSegment.getDbGEFModel() != null && gefSegment.getDbGEFModel().isPsb() && !gefSegment.getDbGEFModel().isApplicationView()) {
                this.m_checkBox = new CheckBox();
            } else {
                this.m_label.setIcon(nodeLabelImage);
            }
        }
        if (this.m_checkBox != null) {
            ToggleModel aModel = new ToggleModel();
            this.m_checkBox.setModel((ButtonModel)aModel);
            this.m_checkBox.setSelected(gefSegment.isSenseg());
            this.m_checkBox.setEnabled(gefSegment.getParent() != null);
            aModel.addChangeListener((ChangeListener)gefSegment);
        }
        if (this.m_label != null) {
            this.m_label.setLabelAlignment(2);
        }
        boolean isVLC = false;
        int len1 = -1;
        Object length = "";
        if (this.segType == 2) {
            len1 = gefSegment.getLogicalChildSourceGEFSegment().getSegLen();
            length = String.valueOf(len1 += gefSegment.getTargetParentSourceGEFSegment().getSegLen());
        } else {
            SegmentModel segmentModel = gefSegment.getSegmentModel();
            len1 = segmentModel.getMaxBytes();
            if (len1 < 0) {
                if (gefSegment.getLogicalChildSourceGEFSegment() != null) {
                    len1 = gefSegment.getLogicalChildSourceGEFSegment().getSegLen();
                }
                if (gefSegment.getTargetParentSourceGEFSegment() != null) {
                    len1 += gefSegment.getTargetParentSourceGEFSegment().getSegLen();
                }
                length = String.valueOf(len1);
                if (len1 == -1) {
                    isVLC = true;
                    int i = 0;
                    while (i < gefSegment.getFieldsList().size()) {
                        len1 += gefSegment.getFieldsList().get(i).getBytes();
                        ++i;
                    }
                    length = String.valueOf(len1 + 1);
                }
            } else {
                length = segmentModel.getMinBytes() > 0 ? "(" + String.valueOf(len1) + "," + String.valueOf(segmentModel.getMinBytes()) + ")" : String.valueOf(len1);
            }
        }
        Object[] inserts = new Object[]{length};
        this.m_totalLen = new Label("   " + WorkbenchPlugin.labels.getString("WB352", inserts) + "   ");
        this.m_secondaryIndex = new Label("   " + WorkbenchPlugin.labels.getString("WB353") + "   ", secondIndexImage);
        this.m_logicalRel = isVLC ? new Label("   " + WorkbenchPlugin.labels.getString("WB354") + "   ", vlcImage) : new Label("   " + WorkbenchPlugin.labels.getString("WB355") + "   ", logicalChildImage);
        if (gefSegment.getSegmentModel().hasLogicalChild()) {
            this.m_logicalParent = new Label("   " + WorkbenchPlugin.labels.getString("WB356") + "   ", logicalParentImage);
        }
        if ((m_boldFont = GetNodePreferences.fetchPreferenceFont("explorer_segment_font")) != null) {
            this.setLabelFont(m_boldFont);
        }
        FlowLayout firstLineLayout = new FlowLayout();
        Figure firstLineFigure = new Figure();
        firstLineFigure.setLayoutManager((LayoutManager)firstLineLayout);
        if (this.m_checkBox != null) {
            firstLineFigure.add((IFigure)this.m_checkBox);
        }
        firstLineFigure.add((IFigure)this.m_label);
        this.add((IFigure)firstLineFigure);
        if (this.segType != 3 && !gefSegment.getDbGEFModel().isPsb()) {
            this.updateLogRelsAnd2IxLabels();
        }
        if (this.segType != 3 && !isVLC) {
            this.add((IFigure)this.m_totalLen);
        }
        String line1 = (gefSegment.isSenseg() ? WorkbenchPlugin.labels.getString("WB449") : WorkbenchPlugin.labels.getString("WB450")) + WorkbenchPlugin.colon.getString("COLON") + name;
        String line2 = ", " + WorkbenchPlugin.labels.getString("WB451") + ": " + (gefSegment.getParent() != null ? gefSegment.getParent().getSegmentName() : "0");
        Object line3 = gefSegment.isSenseg() ? (gefSegment.getSenSeg().getProcopt() == null ? "" : ", " + WorkbenchPlugin.labels.getString("WB423") + WorkbenchPlugin.colon.getString("COLON") + gefSegment.getSenSeg().getProcopt()) : ", " + WorkbenchPlugin.labels.getString("WB352", inserts);
        String toolTipMessage = line1 + line2 + (String)line3;
        this.setToolTip((IFigure)new TooltipFigure(toolTipMessage, FigureConstants.SEGMENT_IMAGE));
        if (this.isReadOnly && this.m_checkBox != null) {
            this.m_checkBox.setEnabled(false);
        }
    }

    public void updateLogRelsAnd2IxLabels() {
        if (this.has2ndIndexes) {
            this.remove((IFigure)this.m_secondaryIndex);
            this.has2ndIndexes = false;
        }
        if (this.hasLogRels) {
            this.remove((IFigure)this.m_logicalRel);
            this.hasLogRels = false;
        }
        if (this.gefSegment.getSegmentModel().hasSecondaryIndexes()) {
            this.add((IFigure)this.m_secondaryIndex);
            this.has2ndIndexes = true;
        }
        if (this.gefSegment.getSegmentModel().hasLogicalParent()) {
            this.add((IFigure)this.m_logicalRel);
            this.hasLogRels = true;
        }
        if (this.gefSegment.getSegmentModel().hasLogicalChild()) {
            this.add((IFigure)this.m_logicalParent);
            this.hasLogRels = true;
        }
    }

    protected void init() {
        ToolbarLayout layout = new ToolbarLayout();
        layout.setMinorAlignment(1);
        layout.setStretchMinorAxis(false);
        layout.setSpacing(0);
        this.setLayoutManager((LayoutManager)layout);
        this.setBorder((Border)new LabelFigureBorder());
        this.setOpaque(true);
    }

    private String getSegLen() {
        Object length = "";
        SegmentModel segmentModel = this.gefSegment.getSegmentModel();
        int len1 = segmentModel.getMaxBytes();
        if (len1 < 0) {
            if (this.gefSegment.getLogicalChildSourceGEFSegment() != null) {
                len1 = this.gefSegment.getLogicalChildSourceGEFSegment().getSegLen();
            }
            if (this.gefSegment.getTargetParentSourceGEFSegment() != null) {
                len1 += this.gefSegment.getTargetParentSourceGEFSegment().getSegLen();
            }
            length = String.valueOf(len1);
            if (len1 == -1) {
                int i = 0;
                while (i < this.gefSegment.getFieldsList().size()) {
                    len1 += this.gefSegment.getFieldsList().get(i).getBytes();
                    ++i;
                }
                length = String.valueOf(len1 + 1);
            }
        } else {
            length = segmentModel.getMinBytes() > 0 ? "(" + String.valueOf(len1) + "," + String.valueOf(segmentModel.getMinBytes()) + ")" : String.valueOf(len1);
        }
        Object[] inserts = new Object[]{length};
        return "   " + WorkbenchPlugin.labels.getString("WB352", inserts) + "   ";
    }

    public String getLabelLen() {
        return this.m_totalLen.getText();
    }

    public String getLabelName() {
        return this.m_label.getText();
    }

    public void setLabelName(String label) {
        if (this.m_label != null) {
            this.m_label.setText(label);
        } else {
            this.m_checkBox = new CheckBox(label);
            if (this.isReadOnly) {
                this.m_checkBox.setEnabled(false);
            }
        }
        if (this.m_totalLen != null) {
            this.m_totalLen.setText(this.getSegLen());
        }
    }

    private void setLabelFont(Font font) {
        if (this.m_label != null) {
            this.m_label.setFont(font);
        } else if (this.m_checkBox != null) {
            this.m_checkBox.setFont(font);
        }
        FontData[] fieldFontData = font.getFontData();
        fieldFontData[0].setStyle(0);
        Font fieldFont = new Font((Device)Display.getCurrent(), fieldFontData[0]);
        this.m_secondaryIndex.setFont(fieldFont);
        this.m_totalLen.setFont(fieldFont);
    }

    protected void paintFigure(Graphics graphics) {
        Color savedBg = graphics.getBackgroundColor();
        Color savedFg = graphics.getForegroundColor();
        Color m_fgColor = GetNodePreferences.fetchPreferenceColor("explorer_segment_color");
        if (this.gefSegment.getDbGEFModel() != null && this.gefSegment.getDbGEFModel().isPsb() && !this.gefSegment.getDbGEFModel().isApplicationView() && !this.gefSegment.isSenseg()) {
            m_fgColor = GetNodePreferences.fetchPreferenceColor("explorer_field_color");
        }
        Color m_bgColor = GetNodePreferences.fetchPreferenceColor("explorer_field_color");
        graphics.setBackgroundColor(m_bgColor);
        graphics.setForegroundColor(m_fgColor);
        graphics.fillGradient(this.getBounds(), this.segType != 3);
        graphics.setBackgroundColor(savedBg);
        graphics.setForegroundColor(savedFg);
    }

    public SegmentGEFModel getSegmentGEFModel() {
        return this.gefSegment;
    }

    public CheckBox getCheckbox() {
        return this.m_checkBox;
    }

    private class LabelFigureBorder
    extends AbstractBorder {
        private LabelFigureBorder() {
        }

        public Insets getInsets(IFigure figure) {
            return new Insets(0, 3, 6, 0);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            Point p1 = LabelFigureBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getBottomLeft();
            Point p2 = tempRect.getBottomRight();
            graphics.drawLine(p1.x, p1.y - 1, p2.x, p2.y - 1);
        }
    }
}

