/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.figures;

import com.ibm.im.ims.workbench.editors.figures.FieldListFigure;
import com.ibm.im.ims.workbench.editors.figures.FigureConstants;
import com.ibm.im.ims.workbench.editors.figures.SegmentControlFigure;
import com.ibm.im.ims.workbench.editors.figures.SegmentLabelFigure;
import com.ibm.im.ims.workbench.editors.figures.SourceSegmentsFigure;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.editors.preferences.GetNodePreferences;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class SegmentFigure
extends RectangleFigure {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private SegmentGEFModel gefSegment;
    private static final int SPACING = 0;
    private SegmentControlFigure m_controlFigure;
    private Figure m_middleFigure;
    private SegmentLabelFigure m_labelFigure;

    public SegmentFigure(SegmentGEFModel theModel) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "SegmentFigure(SegmentGEFModel theModel)", new Object[]{theModel.getSegmentModel().getImsName()});
        }
        theModel.setFigure((Figure)this);
        ToolbarLayout layout = new ToolbarLayout();
        layout.setSpacing(0);
        this.setLayoutManager((LayoutManager)layout);
        this.setOpaque(true);
        this.gefSegment = theModel;
        this.setBackgroundColor(GetNodePreferences.fetchPreferenceColor("explorer_field_color"));
        this.m_labelFigure = new SegmentLabelFigure(theModel);
        int segType = this.gefSegment.getSegmentType();
        if (segType == 2 || segType == 1) {
            this.m_middleFigure = new SourceSegmentsFigure();
        } else if (segType == 0 || segType == 3) {
            this.m_middleFigure = new FieldListFigure();
        }
        this.add((IFigure)this.m_labelFigure);
        this.add((IFigure)this.m_middleFigure);
        if (segType != 3) {
            this.m_controlFigure = new SegmentControlFigure(theModel.isExpand());
            this.m_controlFigure.setBackgroundColor(GetNodePreferences.fetchPreferenceColor("explorer_segment_color"));
            this.add((IFigure)this.m_controlFigure);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "SegmentFigure(SegmentGEFModel theModel)", new Object[0]);
        }
    }

    public List getChildren() {
        List retVal = super.getChildren();
        return retVal;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension retVal = this.getLayoutManager().getPreferredSize((IFigure)this, wHint, hHint);
        return retVal;
    }

    public SegmentControlFigure getNodeControlFigure() {
        return this.m_controlFigure;
    }

    public void setFieldSelectionColor(Color color) {
        int segType = this.gefSegment.getSegmentType();
        if (segType == 2 || segType == 1) {
            ((SourceSegmentsFigure)this.m_middleFigure).setHighLightColor(color);
        } else if (segType == 0 || segType == 3) {
            ((FieldListFigure)this.m_middleFigure).setHighLightColor(color);
        }
    }

    public IFigure getFieldListFigure() {
        return this.m_middleFigure;
    }

    public SegmentLabelFigure getLabelFigure() {
        return this.m_labelFigure;
    }

    protected void fillShape(Graphics graphics) {
        Rectangle rect = Rectangle.SINGLETON.setBounds(this.getBounds());
        if (this.gefSegment.getSegmentType() != 3) {
            Insets shadowInset = new Insets(0, 0, 6, 6);
            rect.crop(shadowInset);
            this.drawShadow(rect, graphics);
        }
        graphics.fillRectangle(rect);
    }

    public Insets getInsets() {
        if (this.gefSegment.getSegmentType() != 3) {
            return new Insets(1, 1, 6, 6);
        }
        return new Insets(1, 1, 0, 0);
    }

    protected void outlineShape(Graphics graphics) {
        Rectangle rect = Rectangle.SINGLETON.setBounds(this.getBounds());
        if (this.gefSegment.getSegmentType() != 3) {
            Insets shadowInset = new Insets(this.lineWidth / 2, this.lineWidth / 2, this.lineWidth + 6 - 1, this.lineWidth + 6 - 1);
            rect.crop(shadowInset);
        }
        if (this.gefSegment.getSegLen() > 0) {
            graphics.drawRectangle(rect);
        } else {
            graphics.fillRectangle(rect);
        }
    }

    private void drawShadow(Rectangle rectangle, Graphics graphics) {
        this.drawShadowLayer(rectangle, graphics, 6, FigureConstants.BORDER_SHADOW_COLOR_6);
        this.drawShadowLayer(rectangle, graphics, 5, FigureConstants.BORDER_SHADOW_COLOR_5);
        this.drawShadowLayer(rectangle, graphics, 4, FigureConstants.BORDER_SHADOW_COLOR_4);
        this.drawShadowLayer(rectangle, graphics, 3, FigureConstants.BORDER_SHADOW_COLOR_3);
        this.drawShadowLayer(rectangle, graphics, 2, FigureConstants.BORDER_SHADOW_COLOR_2);
        this.drawShadowLayer(rectangle, graphics, 1, FigureConstants.BORDER_SHADOW_COLOR_1);
        this.drawShadowLayer(rectangle, graphics, 0, FigureConstants.BORDER_COLOR);
    }

    private void drawShadowLayer(Rectangle rectangle, Graphics graphics, int offset, Color color) {
        graphics.pushState();
        graphics.setLineWidth(0);
        graphics.setBackgroundColor(color);
        Rectangle shadowLayer = new Rectangle(rectangle);
        shadowLayer.x += offset;
        shadowLayer.y += offset;
        graphics.fillRectangle(shadowLayer);
        graphics.popState();
    }
}

