/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.figures;

import com.ibm.im.ims.workbench.editors.figures.FigureConstants;
import com.ibm.im.ims.workbench.editors.figures.SegmentFigure;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.editors.preferences.GetNodePreferences;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class SegmentControlFigure
extends Figure {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IFigure m_controlFigure = null;

    public SegmentControlFigure(boolean isExpanded) {
        this.init();
        this.m_controlFigure = new Label(FigureConstants.CONTROL_OFF_IMAGE){

            protected Dimension calculateLabelSize(Dimension txtSize) {
                return new Dimension(this.getIcon().getBounds().width, 10);
            }
        };
        this.setIcon(isExpanded);
        this.add(this.m_controlFigure);
    }

    protected void init() {
        ToolbarLayout layout = new ToolbarLayout();
        layout.setMinorAlignment(0);
        layout.setStretchMinorAxis(false);
        layout.setSpacing(0);
        this.setLayoutManager((LayoutManager)layout);
        this.setBorder((Border)new ControlFigureBorder());
        this.setOpaque(true);
    }

    public void setIcon(boolean m_bExpand) {
        if (m_bExpand) {
            ((Label)this.m_controlFigure).setIcon(FigureConstants.CONTROL_OFF_IMAGE);
        } else {
            ((Label)this.m_controlFigure).setIcon(FigureConstants.CONTROL_ON_IMAGE);
        }
    }

    public boolean pointOnIcon(Point p) {
        return this.m_controlFigure.containsPoint(p);
    }

    protected void paintFigure(Graphics graphics) {
        Color savedBg = graphics.getBackgroundColor();
        Color savedFg = graphics.getForegroundColor();
        Color m_bgColor = GetNodePreferences.fetchPreferenceColor("explorer_segment_color");
        SegmentGEFModel segmentGEFModel = ((SegmentFigure)this.getParent()).getLabelFigure().getSegmentGEFModel();
        if (!segmentGEFModel.isSenseg() && segmentGEFModel.getDbGEFModel() != null && !segmentGEFModel.getDbGEFModel().isApplicationView()) {
            m_bgColor = GetNodePreferences.fetchPreferenceColor("explorer_field_color");
        }
        int red = m_bgColor.getRed() - 100;
        int green = m_bgColor.getGreen() - 100;
        int blue = m_bgColor.getBlue() - 100;
        if (red < 0 || green < 0 || blue < 0) {
            graphics.setBackgroundColor(m_bgColor);
        } else {
            graphics.setBackgroundColor(new Color((Device)Display.getCurrent(), red, green, blue));
        }
        Color m_fgColor = GetNodePreferences.fetchPreferenceColor("explorer_field_color");
        graphics.setForegroundColor(m_fgColor);
        graphics.fillGradient(this.getBounds(), true);
        graphics.setBackgroundColor(savedBg);
        graphics.setForegroundColor(savedFg);
    }

    private class ControlFigureBorder
    extends AbstractBorder {
        private ControlFigureBorder() {
        }

        public Insets getInsets(IFigure figure) {
            return new Insets(1, 0, 0, 0);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            Point p1 = ControlFigureBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getTopLeft();
            Point p2 = tempRect.getTopRight();
            graphics.drawLine(p1.x, p1.y, p2.x, p2.y);
        }
    }
}

