/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.figures;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.figures.FigureConstants;
import com.ibm.im.ims.workbench.editors.figures.TooltipFigure;
import com.ibm.im.ims.workbench.editors.model.FieldGEFModel;
import com.ibm.im.ims.workbench.editors.preferences.GetNodePreferences;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.FieldModel;
import java.text.MessageFormat;
import java.util.Locale;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CheckBox;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.swt.graphics.Image;

public class FieldFigure
extends Figure {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Label m_label;
    private CheckBox checkbox;
    private FieldGEFModel gefField;

    public FieldFigure(FieldGEFModel gefField) {
        this.gefField = gefField;
        FieldModel fieldModel = gefField.getField();
        String fieldName = null;
        if (fieldModel == null) {
            fieldName = gefField.getSenfld().getName();
        } else {
            fieldName = fieldModel.getName();
            if (fieldName == null || fieldName.length() == 0) {
                fieldName = fieldModel.getImsName();
            }
        }
        this.m_label = new Label(fieldName, this.getFieldImage());
        this.add((IFigure)this.m_label);
        this.init();
        Object[] inserts = new Object[]{gefField.getBytes()};
        String toolTipMessage = (gefField.isSenfld() ? WorkbenchPlugin.labels.getString("WB457") : WorkbenchPlugin.labels.getString("WB010A")) + ": " + fieldName + ", " + WorkbenchPlugin.labels.getString("WB012A") + ": " + String.valueOf(gefField.getStartPos()) + ", " + (String)(gefField.isSenfld() ? WorkbenchPlugin.labels.getString("WB460") + ": " + this.getLongName(gefField.getSenfld().getReplace()) : WorkbenchPlugin.labels.getString("WB352", inserts));
        if (gefField.isVirtualKey()) {
            String vfkFieldName = gefField.getAlias();
            int index = vfkFieldName.lastIndexOf("_");
            String segmentName = vfkFieldName.substring(0, index);
            String keyFfieldName = vfkFieldName.substring(index + 1);
            Object[] messageArguments = new Object[]{vfkFieldName, keyFfieldName, segmentName};
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(Locale.getDefault());
            formatter.applyPattern(WorkbenchPlugin.descriptions.getString("WB447"));
            toolTipMessage = WorkbenchPlugin.labels.getString("WB497A") + " " + formatter.format(messageArguments);
        }
        this.setToolTip((IFigure)new TooltipFigure(toolTipMessage, this.getFieldImage()));
    }

    private void init() {
        FlowLayout layout = new FlowLayout();
        this.setLayoutManager((LayoutManager)layout);
        this.setBorder((Border)new MarginBorder(1, 0, 1, 0));
        this.setBackgroundColor(GetNodePreferences.fetchPreferenceColor("explorer_field_selected_color"));
        this.setFont(GetNodePreferences.fetchPreferenceFont("explorer_field_font"));
    }

    private Image getFieldImage() {
        if (this.gefField.isVirtualKey()) {
            return FigureConstants.FIELD_VIRTUALKEY_IMAGE;
        }
        if (this.gefField.getField().getSeqType() != null) {
            if (this.gefField.getField().getSeqType().equals((Object)DBDConstants.U)) {
                return FigureConstants.FIELD_UNIQUE_IMAGE;
            }
            return FigureConstants.FIELD_NONUNIQUE_IMAGE;
        }
        if (!this.gefField.getField().getImsName().isEmpty()) {
            return FigureConstants.FIELD_REGULAR_IMAGE;
        }
        return FigureConstants.FIELD_USERDEFINED_IMAGE;
    }

    public FieldFigure getFigure() {
        return this;
    }

    public void setText(String text) {
        this.m_label.setText(text);
    }

    public String toString() {
        return this.m_label.getText();
    }

    public void setCheckBox() {
        if (this.checkbox != null) {
            this.checkbox.setSelected(this.gefField.isSenfld());
        }
    }

    public CheckBox getCheckBox() {
        return this.checkbox;
    }

    private String getLongName(DBDConstants shortValue) {
        String retVal = "";
        if (shortValue.equals((Object)DBDConstants.Y)) {
            retVal = WorkbenchPlugin.labels.getString("YES");
        } else if (shortValue.equals((Object)DBDConstants.N) || shortValue.equals((Object)DBDConstants.NO)) {
            retVal = WorkbenchPlugin.labels.getString("NO");
        }
        return retVal;
    }
}

