/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.commands;

import com.ibm.im.ims.workbench.editors.model.ConnectionGEFModel;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.gef.commands.Command;

public class DeleteSegmentCommand
extends Command {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SegmentGEFModel gefSegment;
    private Stack<SegmentGEFModel> sChildrenSegmentsForDelete = new Stack();
    private Stack<SegmentGEFModel> sChildrenSegmentsForAdd = new Stack();

    public DeleteSegmentCommand(SegmentGEFModel segment, String taskName) {
        super(taskName);
        this.gefSegment = segment;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        this.sChildrenSegmentsForDelete.push(this.gefSegment);
        this.findChildrenSegments(this.gefSegment);
        while (!this.sChildrenSegmentsForDelete.isEmpty()) {
            SegmentGEFModel aGEFModel = this.sChildrenSegmentsForDelete.pop();
            if (!this.sChildrenSegmentsForAdd.contains(aGEFModel)) {
                this.sChildrenSegmentsForAdd.push(aGEFModel);
            }
            this.gefSegment.getDbGEFModel().removeSegment(aGEFModel, true);
        }
    }

    public void findChildrenSegments(SegmentGEFModel segment) {
        Vector<ConnectionGEFModel> tgtConnModels = segment.getChildConnections();
        int size = tgtConnModels.size();
        int i = 0;
        while (i < size) {
            ConnectionGEFModel connModel = tgtConnModels.elementAt(i);
            SegmentGEFModel childSeg = connModel.getChild();
            if (childSeg != null) {
                this.sChildrenSegmentsForDelete.push(childSeg);
                this.findChildrenSegments(childSeg);
            }
            ++i;
        }
    }

    public boolean canUndo() {
        return this.gefSegment != null;
    }

    public void undo() {
        while (!this.sChildrenSegmentsForAdd.isEmpty()) {
            SegmentGEFModel aGEFModel = this.sChildrenSegmentsForAdd.pop();
            this.gefSegment.getDbGEFModel().addNewSegment(aGEFModel.getParent(), aGEFModel);
        }
    }
}

