/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.commands;

import com.ibm.im.ims.workbench.editors.InvalidDBDSourceException;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AddSegmentCommand
extends Command {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private final SegmentGEFModel parentGEFSegment;
    private SegmentGEFModel newChildGEFSegment = null;

    public AddSegmentCommand(SegmentGEFModel model, String taskName) {
        super(taskName);
        this.parentGEFSegment = model;
    }

    public void execute() {
        Shell shell = Display.getCurrent().getActiveShell();
        InputDialog inputDialog = new InputDialog(shell, "Create New Segment", "Segment name", null, null);
        if (inputDialog.open() == 1) {
            return;
        }
        try {
            SegmentModel newModelSegment = new SegmentModel(this.parentGEFSegment.getSegmentModel(), this.parentGEFSegment.getDbGEFModel().getDbdModel());
            newModelSegment.setImsName(inputDialog.getValue());
            newModelSegment.setName(inputDialog.getValue());
            this.newChildGEFSegment = new SegmentGEFModel(this.parentGEFSegment.getDbGEFModel(), newModelSegment, null, null, false);
        }
        catch (ModelException e) {
            logger.error((Throwable)e);
        }
        catch (InvalidDBDSourceException e) {
            logger.error((Throwable)e);
        }
        this.redo();
    }

    public void redo() {
        this.parentGEFSegment.getDbGEFModel().addNewSegment(this.parentGEFSegment, this.newChildGEFSegment);
        this.parentGEFSegment.getDbGEFModel().recalculateLayout();
    }

    public boolean canUndo() {
        return this.newChildGEFSegment != null;
    }

    public void undo() {
        this.parentGEFSegment.getDbGEFModel().removeSegment(this.newChildGEFSegment, true);
        this.parentGEFSegment.getDbGEFModel().recalculateLayout();
    }
}

