/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.commands;

import com.ibm.im.ims.workbench.editors.model.FieldGEFModel;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.Vector;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;

public class AddFieldCommand
extends Command {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private EditPart part = null;
    private SegmentGEFModel dliSegmentModel;
    private Vector newFieldInfo;
    private FieldGEFModel newFieldGEFModel;
    private static final IExplorerLogger logger = ExplorerLogger.instance();

    public AddFieldCommand(EditPart part, String taskName) {
        super(taskName);
        this.part = part;
    }

    public void setSegmentGEFModel(SegmentGEFModel dliSegmentModel) {
        this.dliSegmentModel = dliSegmentModel;
    }

    public void setNewFieldInfo(Vector newFieldInfo) {
        this.newFieldInfo = newFieldInfo;
    }

    public void redo() {
        try {
            if (this.dliSegmentModel != null && this.newFieldGEFModel != null) {
                this.dliSegmentModel.getSegmentModel().addField(this.newFieldGEFModel.getField());
                this.dliSegmentModel.refreshFieldList();
                this.dliSegmentModel.setExpand(true);
                this.dliSegmentModel.getDbGEFModel().recalculateLayout();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "redo()", e);
            logger.error(e);
        }
    }

    public void undo() {
        try {
            if (this.dliSegmentModel != null && this.newFieldGEFModel != null) {
                this.dliSegmentModel.deleteFieldfromList(this.newFieldGEFModel);
                this.dliSegmentModel.setExpand(true);
                this.dliSegmentModel.getDbGEFModel().recalculateLayout();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", e);
            logger.error(e);
        }
    }

    public void execute() {
    }

    public void dispose() {
        this.dliSegmentModel = null;
        this.newFieldInfo = null;
        this.part = null;
        this.newFieldGEFModel = null;
    }
}

