/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.actions;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.ResourceEditorPage;
import com.ibm.im.ims.workbench.editors.ResourceMultiPageEditor;
import com.ibm.im.ims.workbench.editors.commands.DeleteSegmentCommand;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.editors.parts.SegmentEditPart;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class DeleteSegmentAction
extends SelectionAction {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String DELETE_SEGMENT = "com.ibm.im.ims.workbench.ui.gef.actions.deletesegment";
    private IWorkbenchPart part = null;
    private Request request;

    public DeleteSegmentAction(IWorkbenchPart part) {
        super(part);
        this.part = part;
        this.setId(DELETE_SEGMENT);
        this.request = new Request((Object)"DELETE_SEGMENT_REQUEST");
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void run() {
        if (this.part instanceof ResourceMultiPageEditor) {
            DeleteSegmentCommand deleteCommand = (DeleteSegmentCommand)this.getCommand();
            EditPart editPart = this.getEditPart();
            if (editPart != null && editPart instanceof SegmentEditPart) {
                SegmentGEFModel segModel = (SegmentGEFModel)editPart.getModel();
                String selSeg = segModel.getSegmentAlias();
                String parent = segModel.getDbGEFModel().getDbdName();
                Object[] messageArguments = new Object[]{selSeg, parent};
                MessageFormat formatter = new MessageFormat("");
                formatter.setLocale(Locale.getDefault());
                formatter.applyPattern(WorkbenchPlugin.errors.getString("IOGWB0070"));
                if (MessageDialog.openConfirm((Shell)this.part.getSite().getShell(), (String)WorkbenchPlugin.errors.getString("IOGWB0069"), (String)formatter.format(messageArguments)) && deleteCommand != null) {
                    this.execute(deleteCommand);
                }
            }
        }
    }

    private Command getCommand() {
        Command command = null;
        EditPart editPart = this.getEditPart();
        command = editPart.getCommand(this.request);
        return command;
    }

    private EditPart getEditPart() {
        ResourceEditorPage pcbPage;
        List editParts;
        ResourceMultiPageEditor editor;
        ResourceEditorPage page;
        if (this.part instanceof ResourceMultiPageEditor && (page = (editor = (ResourceMultiPageEditor)this.part).getCurrentPage()) != null && page instanceof ResourceEditorPage && (editParts = (pcbPage = page).getSelectedParts()).size() == 1) {
            EditPart editPart = (EditPart)editParts.get(0);
            return editPart;
        }
        return null;
    }
}

