/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors.actions;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.ResourceEditorPage;
import com.ibm.im.ims.workbench.editors.ResourceMultiPageEditor;
import com.ibm.im.ims.workbench.editors.commands.DeleteFieldCommand;
import com.ibm.im.ims.workbench.editors.model.FieldGEFModel;
import com.ibm.im.ims.workbench.editors.parts.FieldEditPart;
import com.ibm.im.ims.workbench.ui.core.Utility;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class DeleteFieldAction
extends SelectionAction {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String DELETE_FIELD = "com.ibm.ims.dlimodel.ui.gef.actions.deletefield";
    private IWorkbenchPart part = null;
    private Request request;

    public DeleteFieldAction(IWorkbenchPart part) {
        super(part);
        this.setId(DELETE_FIELD);
        this.part = part;
    }

    protected boolean calculateEnabled() {
        return true;
    }

    protected void init() {
        super.init();
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("deleteFldEn")));
        this.setText(WorkbenchPlugin.labels.getString("WB260"));
        this.setToolTipText(WorkbenchPlugin.descriptions.getString("WB201"));
        this.setEnabled(false);
        this.request = new Request((Object)"DELETE_REQUEST");
    }

    private Command getCommand() {
        ResourceEditorPage pcbPage;
        List editParts;
        ResourceMultiPageEditor editor;
        ResourceEditorPage page;
        Command command = null;
        if (this.part instanceof ResourceMultiPageEditor && (page = (editor = (ResourceMultiPageEditor)this.part).getCurrentPage()) != null && page instanceof ResourceEditorPage && (editParts = (pcbPage = page).getSelectedParts()).size() == 1) {
            EditPart editPart = (EditPart)editParts.get(0);
            command = editPart.getCommand(this.request);
        }
        return command;
    }

    public void run() {
        if (this.part instanceof ResourceMultiPageEditor) {
            ResourceEditorPage pcbPage;
            List selParts;
            DeleteFieldCommand deleteCommand = (DeleteFieldCommand)this.getCommand();
            ResourceMultiPageEditor editor = (ResourceMultiPageEditor)this.part;
            ResourceEditorPage page = editor.getCurrentPage();
            if (page != null && page instanceof ResourceEditorPage && (selParts = (pcbPage = page).getSelectedParts()).size() == 1 && selParts.get(0) instanceof FieldEditPart) {
                FieldEditPart fieldEditPart = (FieldEditPart)selParts.get(0);
                FieldGEFModel dliFieldModel = (FieldGEFModel)fieldEditPart.getModel();
                String delField = dliFieldModel.getAlias();
                String parent = dliFieldModel.getSegmentGEFModel().getSegmentAlias();
                Object[] messageArguments = new Object[]{delField, parent};
                MessageFormat formatter = new MessageFormat("");
                formatter.setLocale(Locale.getDefault());
                formatter.applyPattern(WorkbenchPlugin.errors.getString("IOGWB0068"));
                if (MessageDialog.openConfirm((Shell)this.part.getSite().getWorkbenchWindow().getShell(), (String)WorkbenchPlugin.errors.getString("IOGWB0067"), (String)formatter.format(messageArguments)) && deleteCommand != null) {
                    deleteCommand.setFieldGEFModel(dliFieldModel);
                    this.execute(deleteCommand);
                }
            }
        }
    }
}

