/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.editor.ResourceEditorController;
import com.ibm.im.ims.workbench.controller.mapping.ManageMappingController;
import com.ibm.im.ims.workbench.editors.DelegatingCommandStack;
import com.ibm.im.ims.workbench.editors.DelegatingZoomManager;
import com.ibm.im.ims.workbench.editors.InvalidDBDSourceException;
import com.ibm.im.ims.workbench.editors.MissingDBDException;
import com.ibm.im.ims.workbench.editors.ResourceEditorOutlinePage;
import com.ibm.im.ims.workbench.editors.ResourceEditorPage;
import com.ibm.im.ims.workbench.editors.actions.AddSegmentAction;
import com.ibm.im.ims.workbench.editors.actions.DeleteFieldAction;
import com.ibm.im.ims.workbench.editors.actions.DeleteSegmentAction;
import com.ibm.im.ims.workbench.editors.figures.FigureConstants;
import com.ibm.im.ims.workbench.editors.form.PsbSummaryPage;
import com.ibm.im.ims.workbench.editors.model.DbGEFModel;
import com.ibm.im.ims.workbench.editors.model.DbdOrPcbList;
import com.ibm.im.ims.workbench.editors.model.DbdsGEFModel;
import com.ibm.im.ims.workbench.editors.model.NodeEventListener;
import com.ibm.im.ims.workbench.editors.model.NodeEvents;
import com.ibm.im.ims.workbench.editors.model.PsbGEFModel;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.utilities.InvalidNameException;
import com.ibm.im.ims.workbench.model.utilities.InvalidRefException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.ui.core.Utility;
import com.ibm.im.ims.workbench.utilities.InfoDialogRunner;
import com.ibm.im.ims.workbench.utilities.MigrateHelper;
import com.ibm.im.ims.workbench.utilities.SearchDialog;
import com.ibm.im.ims.workbench.wizard.managemapping.ManageMappingWizard;
import com.ibm.ims.explorer.common.ExplorerCommonPlugin;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.SaveAction;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.StackAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.gef.ui.properties.UndoablePropertySheetEntry;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class ResourceMultiPageEditor
extends MultiPageEditorPart
implements IAdaptable,
NodeEventListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private String projectName = "";
    private boolean isUpdated = false;
    private ResourceEditorController reController;
    private DbdOrPcbList dbdOrPcbList;
    private ActionRegistry actionRegistry;
    private DelegatingCommandStack delegatingCommandStack;
    private DelegatingZoomManager delegatingZoomManager;
    private List editorActionIDs = new ArrayList();
    private List editPartActionIDs = new ArrayList();
    private boolean isDirty = false;
    private boolean isReadOnly = false;
    private MultiPageCommandStackListener multiPageCommandStackListener;
    private ResourceEditorOutlinePage outlinePage;
    private ResourceTracker resourceTracker;
    private KeyHandler sharedKeyHandler;
    private List stackActionIDs = new ArrayList();
    private SelectionSynchronizer synchronizer;
    private PropertySheetPage undoablePropertySheetPage;
    private PsbSummaryPage summaryPage = null;
    private static double[] ZOOM_LEVELS = new double[]{0.5, 0.75, 1.0, 1.25, 1.5, 1.75, 2.0, 2.25, 2.5, 2.75, 3.0, 3.25, 3.5, 3.75, 4.0};
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            ResourceMultiPageEditor.this.updateActions(ResourceMultiPageEditor.this.editPartActionIDs);
        }
    };
    private CommandStackListener delegatingCommandStackListener = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            ResourceMultiPageEditor.this.updateActions(ResourceMultiPageEditor.this.stackActionIDs);
        }
    };

    public ResourceMultiPageEditor() {
        this.createActions();
    }

    public void addChildSegment() {
        this.getActionRegistry().getAction((Object)"com.ibm.im.ims.workbench.ui.gef.actions.addsegment").run();
    }

    public void deleteSegment() {
        this.getActionRegistry().getAction((Object)"com.ibm.im.ims.workbench.ui.gef.actions.deletesegment").run();
    }

    public void deleteField() {
        this.getActionRegistry().getAction((Object)"com.ibm.ims.dlimodel.ui.gef.actions.deletefield").run();
    }

    protected void addAction(IAction action) {
        this.getActionRegistry().registerAction(action);
    }

    protected void addEditorAction(WorkbenchPartAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.editorActionIDs.add(action.getId());
    }

    protected void addEditPartAction(SelectionAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.editPartActionIDs.add(action.getId());
    }

    protected void addStackAction(StackAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.stackActionIDs.add(action.getId());
    }

    private void closeEditor(final boolean save) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ResourceMultiPageEditor.this.getSite().getPage().closeEditor((IEditorPart)ResourceMultiPageEditor.this, save);
            }
        });
    }

    protected void createActions() {
        this.addStackAction((StackAction)new UndoAction((IEditorPart)this));
        this.addStackAction((StackAction)new RedoAction((IEditorPart)this));
        this.addEditorAction((WorkbenchPartAction)new SaveAction((IEditorPart)this));
        this.addEditorAction((WorkbenchPartAction)new PrintAction((IWorkbenchPart)this));
        DeleteFieldAction deleteField = new DeleteFieldAction((IWorkbenchPart)this);
        AddSegmentAction addChildSegment = new AddSegmentAction((IWorkbenchPart)this);
        DeleteSegmentAction deleteSegment = new DeleteSegmentAction((IWorkbenchPart)this);
        this.addAction((IAction)deleteField);
        this.addAction((IAction)addChildSegment);
        this.addAction((IAction)deleteSegment);
    }

    protected void createPages() {
        try {
            if (this.dbdOrPcbList != null) {
                if (this.dbdOrPcbList instanceof PsbGEFModel) {
                    IFile ddlContentFile;
                    this.summaryPage = new PsbSummaryPage(this, this.getContainer());
                    this.addPage((Control)this.summaryPage.getPage());
                    this.setPageText(0, WorkbenchPlugin.labels.getString("WB433"));
                    this.setPageImage(0, FigureConstants.PSB_SUMMARY_IMAGE);
                    IFile psbContentFile = this.getCatalogPSBContentFile();
                    if (psbContentFile != null) {
                        this.addPage(1, (IEditorPart)new sourceReadOnlyEditor(), (IEditorInput)new FileEditorInput(psbContentFile));
                        this.setPageText(1, WorkbenchPlugin.labels.getString("WB433A"));
                    }
                    if (psbContentFile != null && (ddlContentFile = this.getPsbDDLContentFile(psbContentFile.getName() + ".ddl")) != null) {
                        this.addPage(2, (IEditorPart)new sourceReadOnlyEditor(), (IEditorInput)new FileEditorInput(ddlContentFile));
                        this.setPageText(2, WorkbenchPlugin.labels.getString("WB433C"));
                    }
                } else {
                    IFile ddlContentFile;
                    DbGEFModel dbNode = this.dbdOrPcbList.getList().get(0);
                    ResourceEditorPage page = new ResourceEditorPage(this, dbNode);
                    this.addPage((IEditorPart)page, this.getEditorInput());
                    this.setPageText(0, dbNode.getDbdName());
                    this.setTitleToolTip(dbNode.getDbdName());
                    this.setPageImage(0, FigureConstants.DBD_EDITOR_IMAGE);
                    this.getMultiPageCommandStackListener().addCommandStack(page.getCommandStack());
                    this.getDelegatingCommandStack().setCurrentCommandStack(page.getCommandStack());
                    dbNode.addListener(this);
                    this.getOutlinePage().initialize(this.getCurrentPage());
                    IFile dbdContentFile = this.getCatalogDBDContentFile(dbNode.getDbdName());
                    if (dbdContentFile != null) {
                        this.addPage(1, (IEditorPart)new sourceReadOnlyEditor(), (IEditorInput)new FileEditorInput(dbdContentFile));
                        this.setPageText(1, WorkbenchPlugin.labels.getString("WB433B"));
                    }
                    if ((ddlContentFile = this.getDbdDDLContentFile(dbNode.getDbdName() + ".ddl")) != null) {
                        this.addPage(2, (IEditorPart)new sourceReadOnlyEditor(), (IEditorInput)new FileEditorInput(ddlContentFile));
                        this.setPageText(2, WorkbenchPlugin.labels.getString("WB433C"));
                    }
                }
                this.setPageContentDescription();
            } else {
                ResourceEditorPage page = new ResourceEditorPage(this);
                this.addPage((IEditorPart)page, this.getEditorInput());
                this.closeEditor(false);
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "createPages()", e);
            logger.error(e);
        }
    }

    private IFile getCatalogDBDContentFile(String dbdName) throws CoreException {
        List dbdContentFiles = ProjectTreeFileHelper.getGenedSrcCatalogDbdList((String)this.projectName);
        for (IFile file : dbdContentFiles) {
            if (!file.getName().equals(dbdName)) continue;
            return file;
        }
        return null;
    }

    private IFile getCatalogPSBContentFile() throws CoreException {
        List psbContentFiles = ProjectTreeFileHelper.getGenedSrcCatalogPsbList((String)this.projectName);
        String psbName = ((PsbGEFModel)this.dbdOrPcbList).getPsb().getPsbName();
        for (IFile file : psbContentFiles) {
            if (!file.getName().equals(psbName)) continue;
            return file;
        }
        return null;
    }

    private IFile getPsbDDLContentFile(String ddlName) throws CoreException {
        List ddlContentFiles = ProjectTreeFileHelper.getGenedSrcCatalogPsbDdlList((String)this.projectName);
        for (IFile file : ddlContentFiles) {
            if (!file.getName().equals(ddlName)) continue;
            return file;
        }
        return null;
    }

    private IFile getDbdDDLContentFile(String ddlName) throws CoreException {
        List ddlContentFiles = ProjectTreeFileHelper.getGenedSrcCatalogDbdDdlList((String)this.projectName);
        for (IFile file : ddlContentFiles) {
            if (!file.getName().equals(ddlName)) continue;
            return file;
        }
        return null;
    }

    public void addPage(ResourceEditorPage page, boolean setActive) {
        try {
            int pageCount = super.addPage((IEditorPart)page, this.getEditorInput());
            this.setPageText(pageCount, page.getPageName());
            this.setPageImage(pageCount, FigureConstants.PCB_IMAGE);
            if (setActive) {
                super.setActivePage(pageCount);
            }
        }
        catch (PartInitException e) {
            logger.error((Throwable)e);
        }
    }

    public void dispose() {
        Shell[] shells = PlatformUI.getWorkbench().getDisplay().getShells();
        int i = 0;
        while (i < shells.length) {
            if (shells[i].getText().equals(WorkbenchPlugin.labels.getString("fdFind")) && shells[i].getImage().equals((Object)SearchDialog.FIND_IMAGE)) {
                shells[i].dispose();
                break;
            }
            ++i;
        }
        this.getMultiPageCommandStackListener().dispose();
        this.getDelegatingCommandStack().removeCommandStackListener(this.getDelegatingCommandStackListener());
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.getSelectionListener());
        this.getActionRegistry().dispose();
        IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
        file.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
        if (this.outlinePage != null) {
            this.outlinePage.dispose();
            this.outlinePage = null;
        }
        if (this.delegatingCommandStack != null) {
            this.delegatingCommandStack.dispose();
            this.delegatingCommandStack = null;
        }
        if (this.actionRegistry != null) {
            this.actionRegistry.dispose();
            this.actionRegistry = null;
        }
        if (this.multiPageCommandStackListener != null) {
            this.multiPageCommandStackListener.dispose();
            this.multiPageCommandStackListener = null;
        }
        if (this.undoablePropertySheetPage != null) {
            this.undoablePropertySheetPage.dispose();
            this.undoablePropertySheetPage = null;
        }
        if (this.synchronizer != null) {
            this.synchronizer.removeViewer((EditPartViewer)this.getCurrentViewer());
            this.synchronizer = null;
        }
        if (this.stackActionIDs != null) {
            this.stackActionIDs.clear();
        }
        this.stackActionIDs = null;
        if (this.editPartActionIDs != null) {
            this.editPartActionIDs.clear();
        }
        this.editPartActionIDs = null;
        if (this.editorActionIDs != null) {
            this.editorActionIDs.clear();
        }
        this.editorActionIDs = null;
        this.resourceTracker = null;
        this.sharedKeyHandler = null;
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            boolean genDBViews = store.getBoolean("explorer_enable_ims_jdbc");
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            this.reController.doSave(this.projectName, file, monitor, genDBViews);
            this.setDirty(false);
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "doSave(IProgressMonitor monitor)", e);
            logger.error(e);
        }
    }

    public void doSaveAs() {
        try {
            if (this.dbdOrPcbList != null) {
                this.saveEditorContentsAsImage();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.throwing(this.getClass().getName(), "doSaveAs()", e);
            logger.error(e);
        }
    }

    private void saveEditorContentsAsImage() throws Exception {
        String fileName = Utility.removeFileExt(this.getEditorInput().getName());
        FileDialog fileDialog = new FileDialog(this.getSite().getShell(), 8192);
        String[] filterExtensions = new String[]{"*.bmp", "*.jpg"};
        fileDialog.setFilterExtensions(filterExtensions);
        fileDialog.setFileName(fileName);
        String saveAsPath = fileDialog.open();
        if (saveAsPath != null) {
            int format = 0;
            String fileType = fileDialog.getFileName();
            if ((fileType = fileType.substring(fileType.lastIndexOf(46))).equalsIgnoreCase(".jpg")) {
                format = 4;
            }
            if (this.dbdOrPcbList instanceof PsbGEFModel) {
                String pageName = this.getCurrentPage().getPageName();
                this.saveCurrentGraphicalView(saveAsPath.replace(".", "_" + pageName + "."), format);
            } else {
                this.setActivePage(0);
                this.saveCurrentGraphicalView(saveAsPath, format);
            }
        }
    }

    private boolean setActivePageToSave(PcbDBModel currDbPcb) throws CoreException, ModelException, InvalidDBDSourceException {
        DbGEFModel dbGEFModel = this.summaryPage.getDbGEFModel(currDbPcb);
        currDbPcb.setDbdModel(dbGEFModel.getDbdModel());
        String pageName = PsbSummaryPage.createPageName(currDbPcb.getPcbNameOrLabel(), currDbPcb.getPcbNum());
        int i = 2;
        while (i < this.getPageCount()) {
            this.setActivePage(i);
            ResourceEditorPage page = this.getCurrentPage();
            if (page != null && page.getPageName().equals(pageName)) {
                return false;
            }
            ++i;
        }
        ResourceEditorPage page = new ResourceEditorPage(this, dbGEFModel);
        dbGEFModel.replacePhysicalNodesWithSecondaryDataStructure();
        dbGEFModel.assignSensegs(pageName);
        dbGEFModel.assignSenfields();
        page.setPageName(pageName);
        this.addPage(page, true);
        return true;
    }

    private void saveCurrentGraphicalView(String saveAsPath, int format) throws Exception {
        GraphicalViewer viewer = this.getCurrentViewer();
        ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)viewer.getEditPartRegistry().get(LayerManager.ID);
        viewer.reveal((EditPart)rootEditPart);
        IFigure rootFigure = rootEditPart.getLayer((Object)"Printable Layers");
        Rectangle rootFigureBounds = rootFigure.getBounds();
        Control figureCanvas = viewer.getControl();
        GC figureCanvasGC = new GC((Drawable)figureCanvas);
        Image img = new Image(null, rootFigureBounds.width, rootFigureBounds.height);
        GC imageGC = new GC((Drawable)img);
        imageGC.setBackground(figureCanvasGC.getBackground());
        imageGC.setForeground(figureCanvasGC.getForeground());
        imageGC.setFont(figureCanvasGC.getFont());
        imageGC.setLineStyle(figureCanvasGC.getLineStyle());
        imageGC.setLineWidth(figureCanvasGC.getLineWidth());
        SWTGraphics imgGraphics = new SWTGraphics(imageGC);
        imgGraphics.translate(0, -25);
        rootFigure.paint((Graphics)imgGraphics);
        ImageData[] imgData = new ImageData[]{img.getImageData()};
        ImageLoader imgLoader = new ImageLoader();
        imgLoader.data = imgData;
        imgLoader.save(saveAsPath, format);
        figureCanvasGC.dispose();
        imageGC.dispose();
        img.dispose();
        imgGraphics.dispose();
    }

    protected void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
        this.updateActions(this.editorActionIDs);
    }

    protected ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            return this.getPropertySheetPage();
        }
        if (type == CommandStack.class) {
            return this.getDelegatingCommandStack();
        }
        if (type == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (type == IContentOutlinePage.class) {
            return this.getOutlinePage();
        }
        if (type == ZoomManager.class) {
            return this.getDelegatingZoomManager();
        }
        return super.getAdapter(type);
    }

    public ResourceEditorPage getCurrentPage() {
        if (this.getActivePage() == -1 || !(this.getEditor(this.getActivePage()) instanceof ResourceEditorPage)) {
            return null;
        }
        return (ResourceEditorPage)this.getEditor(this.getActivePage());
    }

    public void toggleBasicView() {
        ResourceEditorPage page = this.getCurrentPage();
        page.toggleBasicView();
    }

    public void toggleRelDBDs() {
        ResourceEditorPage page = this.getCurrentPage();
        page.toggleRelDBDs();
    }

    public void expandAll() {
        ResourceEditorPage page = this.getCurrentPage();
        page.expandAll();
    }

    public void collapseAll() {
        ResourceEditorPage page = this.getCurrentPage();
        page.collapseAll();
    }

    public void resetLayout() {
        ResourceEditorPage page = this.getCurrentPage();
        page.resetLayout();
    }

    public void launchFindSegment() {
        ResourceEditorPage page = this.getCurrentPage();
        page.launchFindSegment();
    }

    public void toggleLogicalView(SegmentGEFModel gefSegment) throws InvalidRefException, ModelException, InvalidNameException {
        ResourceEditorPage page = this.getCurrentPage();
        page.toggleLogicalView(gefSegment);
    }

    public void launchManageSecondaryIx(SegmentGEFModel gefSegment, IWorkbenchWindow window) {
        ResourceEditorPage page = this.getCurrentPage();
        page.launchManageSecondaryIx(gefSegment, window);
    }

    public void launchManageLogicalRel(SegmentGEFModel gefSegment, IWorkbenchWindow window) {
        ResourceEditorPage page = this.getCurrentPage();
        page.launchManageLogicalRel(gefSegment, window);
    }

    public void launchManageField(SegmentGEFModel gefSegment, IWorkbenchWindow window) throws ModelException {
        ResourceEditorPage page = this.getCurrentPage();
        page.launchManageField(gefSegment, window);
    }

    public void launchManageSenflds(SegmentGEFModel gefSegment, IWorkbenchWindow window) throws ModelException {
        ResourceEditorPage page = this.getCurrentPage();
        page.launchManageSenflds(gefSegment, window);
    }

    public void launchManageMappings(SegmentGEFModel gefSegment, IWorkbenchWindow window) throws ModelException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "launchManageMappings(SegmentGEFModel gefSegment, IWorkbenchWindow window)", new Object[0]);
        }
        DbGEFModel dbGefModel = gefSegment.getDbGEFModel();
        ManageMappingController controller = new ManageMappingController(gefSegment.getSegmentModel(), this.isReadOnly);
        ManageMappingWizard wizard = new ManageMappingWizard(controller);
        Shell windowShell = window.getShell();
        WizardDialog dialog = new WizardDialog(windowShell, (IWizard)wizard);
        dialog.create();
        Shell dialogShell = dialog.getShell();
        Point windowSize = windowShell.getSize();
        int width = (int)((double)windowSize.x * 0.75);
        int height = (int)((double)windowSize.y * 0.75);
        dialogShell.setSize(width, height);
        int xPos = (int)((double)windowSize.x * 0.12);
        int yPos = (int)((double)windowSize.y * 0.12);
        dialogShell.setLocation(xPos, yPos);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            gefSegment.toggleExpand();
            gefSegment.setExpand(true);
            try {
                dbGefModel.fireEvent(new NodeEvents(2, dbGefModel));
            }
            catch (Throwable e) {
                logger.throwing(this.getClass().getName(), "editSenSegSenField(SegmentGEFModel parentGEFSegment, SegmentGEFModel childGEFSegment)", e);
                logger.error(e);
            }
            dbGefModel.recalculateLayout();
        }
        logger.exiting(this.getClass().getName(), "launchManageMappings(SegmentGEFModel gefSegment, IWorkbenchWindow window)", new Object[0]);
    }

    public void launchEditSenSegSenField(SegmentGEFModel gefSegment, IWorkbenchWindow window) {
        ResourceEditorPage page = this.getCurrentPage();
        page.launchEditSenSegSenField(gefSegment, window);
    }

    public void toggleConcatenate(SegmentGEFModel gefSegment) throws Exception {
        ResourceEditorPage page = this.getCurrentPage();
        page.toggleConcatenate(gefSegment);
    }

    public void launchImportDataStructure(SegmentGEFModel gefSegment, IWorkbenchWindow window) throws InvalidDBDSourceException, ModelException {
        ResourceEditorPage page = this.getCurrentPage();
        page.launchImportDataStructure(gefSegment, window);
    }

    public void editEncoding(SegmentGEFModel gefSegment, IWorkbenchWindow window) throws Exception {
        ResourceEditorPage page = this.getCurrentPage();
        page.launchEditEncoding(gefSegment, window);
    }

    public void editVersionDbver(IWorkbenchWindow window) throws ModelException {
        ResourceEditorPage page = this.getCurrentPage();
        page.launchEditVersionDbver(window);
    }

    public void launchEditDataset(IWorkbenchWindow window) throws ModelException {
        ResourceEditorPage page = this.getCurrentPage();
        page.launchEditDataset(window);
    }

    protected DelegatingZoomManager getDelegatingZoomManager() {
        if (this.delegatingZoomManager == null) {
            this.delegatingZoomManager = new DelegatingZoomManager();
            if (this.getCurrentPage() != null && this.getCurrentPage().getGraphicalViewer() != null) {
                this.delegatingZoomManager.setCurrentZoomManager(this.getZoomManager(this.getCurrentPage().getGraphicalViewer()));
            }
        }
        return this.delegatingZoomManager;
    }

    protected DelegatingCommandStack getDelegatingCommandStack() {
        if (this.delegatingCommandStack == null) {
            this.delegatingCommandStack = new DelegatingCommandStack();
            if (this.getCurrentPage() != null) {
                this.delegatingCommandStack.setCurrentCommandStack(this.getCurrentPage().getCommandStack());
            }
        }
        return this.delegatingCommandStack;
    }

    protected CommandStackListener getDelegatingCommandStackListener() {
        return this.delegatingCommandStackListener;
    }

    protected MultiPageCommandStackListener getMultiPageCommandStackListener() {
        if (this.multiPageCommandStackListener == null) {
            this.multiPageCommandStackListener = new MultiPageCommandStackListener();
        }
        return this.multiPageCommandStackListener;
    }

    protected ResourceEditorOutlinePage getOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new ResourceEditorOutlinePage(this);
        }
        this.outlinePage.initialize(this.getCurrentPage());
        return this.outlinePage;
    }

    protected PropertySheetPage getPropertySheetPage() {
        if (this.undoablePropertySheetPage == null) {
            this.undoablePropertySheetPage = new PropertySheetPage();
            UndoablePropertySheetEntry propertyEntry = new UndoablePropertySheetEntry((CommandStack)this.getDelegatingCommandStack());
            this.undoablePropertySheetPage.setRootEntry((IPropertySheetEntry)propertyEntry);
        }
        return this.undoablePropertySheetPage;
    }

    private ResourceTracker getResourceTracker() {
        if (this.resourceTracker == null) {
            this.resourceTracker = new ResourceTracker();
        }
        return this.resourceTracker;
    }

    protected ISelectionListener getSelectionListener() {
        return this.selectionListener;
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new SelectionSynchronizer();
        }
        return this.synchronizer;
    }

    protected KeyHandler getSharedKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.sharedKeyHandler;
    }

    private ZoomManager getZoomManager(GraphicalViewer viewer) {
        ZoomManager zoomManager = null;
        if (viewer != null) {
            RootEditPart rootEditPart = viewer.getRootEditPart();
            if (rootEditPart instanceof ScalableFreeformRootEditPart) {
                zoomManager = ((ScalableFreeformRootEditPart)rootEditPart).getZoomManager();
            } else if (rootEditPart instanceof ScalableRootEditPart) {
                zoomManager = ((ScalableRootEditPart)rootEditPart).getZoomManager();
            }
            if (zoomManager != null) {
                zoomManager.setZoomLevels(ZOOM_LEVELS);
            }
        }
        return zoomManager;
    }

    public void gotoMarker(IMarker marker) {
    }

    private void updateProjectClasspath() throws JavaModelException, IOException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(this.projectName);
        if (project != null && project.isAccessible()) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] cpEntries = javaProject.getRawClasspath();
            int i = 0;
            while (i < cpEntries.length) {
                IClasspathEntry currEntry = cpEntries[i];
                IPath currPath = currEntry.getPath();
                String lastSeg = currPath.lastSegment();
                if (lastSeg != null && !lastSeg.isEmpty() && lastSeg.equals("imsjava.jar")) {
                    String imsjavaPathStr = ExplorerCommonPlugin.getLibJarPath((String)"imsudb.jar", (IExplorerLogger)logger);
                    cpEntries[i] = JavaCore.newLibraryEntry((IPath)new Path(imsjavaPathStr), null, null);
                }
                ++i;
            }
            javaProject.setRawClasspath(cpEntries, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "init(IEditorSite site, IEditorInput input)", new Object[0]);
        }
        try {
            super.init(site, input);
            FileEditorInput fileInput = (FileEditorInput)this.getEditorInput();
            IFile file = fileInput.getFile();
            IPath path = file.getFullPath();
            this.projectName = path.segments()[0];
            if (this.projectName.equals("IMS_Explorer_Catalog_ReadOnly")) {
                this.isReadOnly = true;
                IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
                if (!store.getBoolean("EDITORS_READ_ONLY")) {
                    InfoDialogRunner idr = new InfoDialogRunner("EDITORS_READ_ONLY");
                    PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)idr);
                }
            }
            if (ProjectTreeFileHelper.isPathForProgram((IPath)path)) {
                this.reController = new ResourceEditorController(file.getContents(), true, this.projectName);
                this.buildPsbGEFModel(this.reController.getPsbModel(), this.projectName);
                this.setTitleImage(FigureConstants.PSB_IMAGE);
            } else if (ProjectTreeFileHelper.isPathForDatabase((IPath)path)) {
                this.reController = new ResourceEditorController(file.getContents(), false, this.projectName);
                DbdModel dbdModel = this.reController.getDbdModel();
                if (dbdModel.getXMLSchemaVersion() == null) {
                    MigrateProjectIfNeeded mp = new MigrateProjectIfNeeded();
                    new ProgressMonitorDialog(site.getShell()).run(true, true, (IRunnableWithProgress)mp);
                }
                this.buildDbdGEFModel(dbdModel, this.projectName);
                this.setTitleImage(FigureConstants.DBD_EDITOR_IMAGE);
            } else {
                logger.error("ERROR: File " + String.valueOf(path) + " was opened in ResourceMultiPageEditor that is not a database or program file", new Object[0]);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("extension: " + path.getFileExtension());
                String[] segments = path.segments();
                Object fullPath = "";
                int i = 0;
                while (i < segments.length) {
                    if (i > 0) {
                        fullPath = (String)fullPath + File.separator;
                    }
                    fullPath = (String)fullPath + segments[i];
                    ++i;
                }
                logger.fine("Initializing editor for file: " + (String)fullPath);
            }
            this.getDelegatingCommandStack().addCommandStackListener(this.getDelegatingCommandStackListener());
            this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.getSelectionListener());
        }
        catch (ModelException e) {
            logger.throwing(this.getClass().getName(), "init(IEditorSite site, IEditorInput input)", (Throwable)e);
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)WorkbenchPlugin.errors.getString("EISRC30"), (String)e.getMessage());
        }
        catch (InvalidDBDSourceException e) {
            logger.throwing(this.getClass().getName(), "init(IEditorSite site, IEditorInput input)", (Throwable)e);
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)WorkbenchPlugin.errors.getString("EISRC30"), (String)e.getMessage());
        }
        catch (MissingDBDException e) {
            logger.throwing(this.getClass().getName(), "init(IEditorSite site, IEditorInput input)", (Throwable)e);
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)WorkbenchPlugin.errors.getString("EISRC30"), (String)e.getMessage());
        }
        catch (CoreException e) {
            logger.throwing(this.getClass().getName(), "init(IEditorSite site, IEditorInput input)", (Throwable)e);
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)WorkbenchPlugin.errors.getString("EISRC30"), (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "init(IEditorSite site, IEditorInput input)", e);
            logger.error(e);
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)WorkbenchPlugin.errors.getString("EISRC30"), (String)e.getMessage());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "init(IEditorSite site, IEditorInput input)", new Object[0]);
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void handleEvent(NodeEvents e) {
        boolean bl = this.isUpdated = e.getEventType() == 2 || e.getEventType() == 4 || e.getEventType() == 5 || e.getEventType() == 7 || e.getEventType() == 8 || e.getEventType() == 12;
        if (e.getEventType() == 13 || e.getEventType() == 14 || e.getEventType() == 2) {
            this.setDirty(true);
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void pageChange(int newPageIndex) {
        if (this.dbdOrPcbList != null) {
            super.pageChange(newPageIndex);
            this.currentPageChanged();
        }
    }

    public void setActivePage(int pageIndex) {
        if (this.dbdOrPcbList != null) {
            super.setActivePage(pageIndex);
            this.currentPageChanged();
        }
    }

    protected void currentPageChanged() {
        ResourceEditorPage currentPage = this.getCurrentPage();
        if (currentPage != null) {
            this.getDelegatingCommandStack().setCurrentCommandStack(currentPage.getCommandStack());
            this.getDelegatingZoomManager().setCurrentZoomManager(this.getZoomManager(currentPage.getGraphicalViewer()));
            this.getOutlinePage().initialize(currentPage);
        } else {
            this.getOutlinePage().initialize(null);
        }
        this.setPageContentDescription();
    }

    public int getPageCount() {
        return super.getPageCount();
    }

    public void setDirty(boolean dirty) {
        if (this.isDirty != dirty) {
            this.isDirty = dirty;
            this.firePropertyChange(257);
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    protected void setInput(IEditorInput input) {
        IFile file;
        if (this.getEditorInput() != null) {
            file = ((FileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
        }
        super.setInput(input);
        if (this.getEditorInput() != null) {
            file = ((FileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
            this.setPartName(file.getName());
        }
    }

    private void updateActions(List actionIds) {
        Iterator ids = actionIds.iterator();
        while (ids.hasNext()) {
            IAction action = this.getActionRegistry().getAction(ids.next());
            if (action == null || !(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }

    public void expandAllNodes(boolean isExpand) {
        if (this.getCurrentPage() != null && this.getCurrentPage().getGraphicalViewer() != null) {
            RootEditPart rootEditPart = this.getCurrentPage().getGraphicalViewer().getRootEditPart();
            DbGEFModel dbGGEFModel = (DbGEFModel)rootEditPart.getContents().getModel();
            dbGGEFModel.setExpand(isExpand);
            dbGGEFModel.recalculateLayout();
        }
    }

    public void resetGraphicalViewerLayout() {
        RootEditPart rootEditPart = this.getCurrentPage().getGraphicalViewer().getRootEditPart();
        DbGEFModel dbGGEFModel = (DbGEFModel)rootEditPart.getContents().getModel();
        dbGGEFModel.recalculateLayout();
    }

    public GraphicalViewer getCurrentViewer() {
        if (this.getCurrentPage() != null) {
            return this.getCurrentPage().getGraphicalViewer();
        }
        return null;
    }

    private void buildPsbGEFModel(PsbModel psb, String projectName) throws PartInitException {
        try {
            this.dbdOrPcbList = new PsbGEFModel(psb);
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "buildPsbGEFModel(InputStream psbFileContents, String projectName)", e);
            logger.error(e);
        }
    }

    private void buildDbdGEFModel(DbdModel dbdModel, String projectName) throws ModelException, InvalidDBDSourceException, MissingDBDException {
        this.dbdOrPcbList = new DbdsGEFModel(dbdModel, projectName);
        this.dbdOrPcbList.getList().get(0).addListener(this);
    }

    public void setPageName(ResourceEditorPage page, String name) {
        int i = 0;
        while (i < this.getPageCount()) {
            if (this.getEditor(i) == page) {
                this.setPageText(i, name);
            }
            ++i;
        }
    }

    public void setPageContentDescription() {
        IProject project = this.getProject();
        String dbdName = this.getDbdName();
        if (this.dbdOrPcbList instanceof DbdsGEFModel) {
            String osAccessType;
            Object accessType = ((DbdsGEFModel)this.dbdOrPcbList).getList().elementAt(0).getDbdModel().getAccessType().value();
            if ((((String)accessType).equalsIgnoreCase("PHIDAM") || ((String)accessType).equalsIgnoreCase("SHISAM") || ((String)accessType).equalsIgnoreCase("HISAM") || ((String)accessType).equalsIgnoreCase("HIDAM") || ((String)accessType).equalsIgnoreCase("HDAM") || ((String)accessType).equalsIgnoreCase("GSAM") || ((String)accessType).equalsIgnoreCase("PHDAM")) && (osAccessType = ((DbdsGEFModel)this.dbdOrPcbList).getList().elementAt(0).getDbdModel().getOsAccess()) != null && osAccessType.length() > 0) {
                accessType = "(" + (String)accessType + "," + osAccessType + ")";
            }
            this.setContentDescription("||    " + WorkbenchPlugin.labels.getString("WB232") + " " + project.getName() + "     ||     " + WorkbenchPlugin.labels.getString("WB233") + " " + dbdName + "     ||     " + WorkbenchPlugin.labels.getString("WB271") + " " + (String)accessType + "     ||     ");
        } else {
            this.setContentDescription("||    " + WorkbenchPlugin.labels.getString("WB232") + " " + project.getName() + "     ||     " + WorkbenchPlugin.labels.getString("WB234") + " " + ((PsbGEFModel)this.dbdOrPcbList).getPsb().getPsbName() + "     ||");
        }
    }

    private IProject getProject() {
        return ((FileEditorInput)this.getEditorInput()).getFile().getProject();
    }

    private String getDbdName() {
        if (this.getCurrentPage() != null) {
            return this.getCurrentPage().getDbGEFModel().getDbdName();
        }
        return "";
    }

    public DbdOrPcbList getDbdOrPcbList() {
        return this.dbdOrPcbList;
    }

    public int getActivePage() {
        return super.getActivePage();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public ResourceEditorController getReController() {
        return this.reController;
    }

    public PsbSummaryPage getSummaryPage() {
        return this.summaryPage;
    }

    class MigrateProjectIfNeeded
    implements IRunnableWithProgress {
        MigrateProjectIfNeeded() {
        }

        public void run(IProgressMonitor monitor) throws InterruptedException {
            int totalMonitorUnits = 1000;
            try {
                FileEditorInput fileInput = (FileEditorInput)ResourceMultiPageEditor.this.getEditorInput();
                IFile file = fileInput.getFile();
                IPath path = file.getFullPath();
                ResourceMultiPageEditor.this.projectName = path.segments()[0];
                ResourceMultiPageEditor.this.updateProjectClasspath();
                Vector dbdMetadataFileList = ProjectTreeFileHelper.getDbdMetadataFileList((String)ResourceMultiPageEditor.this.projectName);
                int numOfFiles = dbdMetadataFileList.size();
                if (dbdMetadataFileList != null) {
                    monitor.beginTask("Migrating MetaData files...", totalMonitorUnits);
                    int i = 0;
                    while (i < numOfFiles) {
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        IFile dbdMetadataFile = (IFile)dbdMetadataFileList.elementAt(i);
                        DbdModel dbdModel = new DbdModel(dbdMetadataFile.getContents());
                        String defaultEncoding = WorkbenchPlugin.getDefault().getPreferenceStore().getString("explorer_dbd_encoding_selection");
                        dbdModel.setEncoding(defaultEncoding);
                        MigrateHelper.mig0to1(dbdMetadataFile.getContents(), dbdModel);
                        ByteArrayOutputStream dbdOutputStream = new ByteArrayOutputStream();
                        dbdModel.marshall(dbdOutputStream);
                        String currDBDName = dbdModel.getDbd().getDbdName();
                        IFile dbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)ResourceMultiPageEditor.this.projectName, (String)currDBDName);
                        dbdFile.setContents((InputStream)new ByteArrayInputStream(dbdOutputStream.toByteArray()), true, true, null);
                        ProjectTreeFileHelper.marshallGeneratedDbdFile((String)currDBDName, (DbdModel)dbdModel);
                        ProjectTreeFileHelper.marshallGeneratedDdlFile((String)ResourceMultiPageEditor.this.projectName, (DbdModel)dbdModel);
                        ProjectTreeFileHelper.marshallCatalogEnabledGeneratedDbdFile((String)currDBDName, (DbdModel)dbdModel);
                        monitor.worked(totalMonitorUnits / numOfFiles);
                        ++i;
                    }
                }
            }
            catch (Throwable e) {
                logger.throwing(this.getClass().getName(), "", e);
                logger.error(e);
            }
        }
    }

    private class MultiPageCommandStackListener
    implements CommandStackListener {
        private List commandStacks = new ArrayList();

        private MultiPageCommandStackListener() {
        }

        public void addCommandStack(CommandStack commandStack) {
            this.commandStacks.add(commandStack);
            commandStack.addCommandStackListener((CommandStackListener)this);
        }

        public void commandStackChanged(EventObject event) {
            if (((CommandStack)event.getSource()).isDirty()) {
                ResourceMultiPageEditor.this.setDirty(ResourceMultiPageEditor.this.isUpdated);
            } else {
                boolean isOneDirty = false;
                for (CommandStack stack : this.commandStacks) {
                    if (!stack.isDirty()) continue;
                    isOneDirty = true;
                    break;
                }
                ResourceMultiPageEditor.this.setDirty(isOneDirty);
            }
        }

        public void dispose() {
            Iterator stacks = this.commandStacks.iterator();
            while (stacks.hasNext()) {
                ((CommandStack)stacks.next()).removeCommandStackListener((CommandStackListener)this);
            }
            this.commandStacks.clear();
        }
    }

    private class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException exception) {
                exception.printStackTrace();
            }
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !delta.getResource().equals((Object)((IFileEditorInput)ResourceMultiPageEditor.this.getEditorInput()).getFile())) {
                return true;
            }
            if (delta.getKind() == 2) {
                if ((0x2000 & delta.getFlags()) == 0) {
                    if (!ResourceMultiPageEditor.this.isDirty()) {
                        ResourceMultiPageEditor.this.closeEditor(false);
                    }
                } else {
                    final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    Display display = ResourceMultiPageEditor.this.getSite().getShell().getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ResourceMultiPageEditor.this.setInput((IEditorInput)new FileEditorInput(newFile));
                        }
                    });
                }
            }
            return false;
        }
    }

    class sourceReadOnlyEditor
    extends TextEditor {
        sourceReadOnlyEditor() {
        }

        public boolean isEditable() {
            return false;
        }

        public boolean isEditorInputModifiable() {
            return false;
        }

        public boolean isEditorInputReadOnly() {
            return true;
        }

        public boolean isDirty() {
            return false;
        }
    }
}

