/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.editor.ResourceEditorController;
import com.ibm.im.ims.workbench.controller.field.ManageFieldsController;
import com.ibm.im.ims.workbench.controller.field.ManageSenfldsController;
import com.ibm.im.ims.workbench.editors.GraphicalPartFactory;
import com.ibm.im.ims.workbench.editors.InvalidDBDSourceException;
import com.ibm.im.ims.workbench.editors.MissingDBDException;
import com.ibm.im.ims.workbench.editors.ResourceMultiPageEditor;
import com.ibm.im.ims.workbench.editors.figures.FigureConstants;
import com.ibm.im.ims.workbench.editors.model.DbGEFModel;
import com.ibm.im.ims.workbench.editors.model.FieldGEFModel;
import com.ibm.im.ims.workbench.editors.model.NodeEventListener;
import com.ibm.im.ims.workbench.editors.model.NodeEvents;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.editors.parts.DbEditPart;
import com.ibm.im.ims.workbench.editors.parts.FieldEditPart;
import com.ibm.im.ims.workbench.editors.parts.SegmentEditPart;
import com.ibm.im.ims.workbench.editors.preferences.GetNodePreferences;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.utilities.Warnings;
import com.ibm.im.ims.workbench.wizard.managefield.ManageFieldWizard;
import com.ibm.im.ims.workbench.wizard.managesenfld.ManageSenfldsWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.TitleBarBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ResourceEditorPage
extends GraphicalEditor
implements NodeEventListener,
ISelectionChangedListener,
IPostSelectionProvider {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public static String CONTEXT_MENU_ID = "com.ibm.im.ims.workbench.ui.editors.graphicalview.contextmenu";
    private static int margin = 2;
    private final ResourceMultiPageEditor parent;
    private DbGEFModel dbGEFModel;
    private Button logicalViewButton;
    private Button relatedDbdsViewButton;
    private Button regularViewButton;
    private SegmentEditPart selectedSegmentEditPart = null;
    public boolean inDisplayRelatedDBDsMode = false;
    public boolean inLogicalViewMode = false;
    public boolean inApplicationView = false;
    private Button appViewButton;
    private Button editViewButton;
    private String pageName;

    public ResourceEditorPage(ResourceMultiPageEditor parent, DbGEFModel model) {
        this.parent = parent;
        this.dbGEFModel = model;
        model.addListener(this);
        model.setEditorPage(this);
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public ResourceEditorPage(ResourceMultiPageEditor parent) {
        this.parent = parent;
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new GraphicalPartFactory());
        viewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
        viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(viewer));
        this.createContextMenu();
        viewer.getControl().addMouseListener((MouseListener)new FieldNameEditMouseListener(this));
        viewer.getControl().addKeyListener((KeyListener)new FieldNameEditKeyListener(this));
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(viewer.getControl(), "com.ibm.im.ims.workbench.ies1_wb_psbsummary2");
        if (this.dbGEFModel != null && this.dbGEFModel.getMissingPhysicalDBDs().length() > 0 && this.dbGEFModel.getDbdModel().getAccessType().equals((Object)DBDConstants.GSAM)) {
            Display display = this.getSite().getShell().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Object[] messageArguments = new Object[]{ResourceEditorPage.this.dbGEFModel.getDbdName()};
                    MessageFormat formatter = new MessageFormat("");
                    formatter.setLocale(Locale.getDefault());
                    formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC32"));
                    IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
                    if (!store.getBoolean("explorer_wizard_skip_warning_flag")) {
                        Warnings warnings = new Warnings(null, WorkbenchPlugin.errors.getString("EISRC27"), null, formatter.format(messageArguments), 4, new String[]{IDialogConstants.OK_LABEL}, 0);
                        warnings.setWarnings(ResourceEditorPage.this.dbGEFModel.getMissingPhysicalDBDs().toString());
                        warnings.open();
                    }
                }
            });
        }
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new ContextMenuListener());
        Menu menu = menuMgr.createContextMenu(this.getGraphicalViewer().getControl());
        this.getGraphicalViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.getGraphicalViewer());
    }

    public static void fillContextMenu(IMenuManager menuMgr) {
        menuMgr.add((IContributionItem)new Separator("edit"));
        menuMgr.add((IContributionItem)new Separator("crap"));
        menuMgr.add((IContributionItem)new Separator("additions"));
    }

    public void toggleRelDBDs() {
        if (!this.isLogicallyRelatedDBD()) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Message", (String)WorkbenchPlugin.errors.getString("DHB1700"));
        } else {
            try {
                this.dbGEFModel.toggleRelDBDs();
            }
            catch (MissingDBDException e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)e.getMessage());
            }
            catch (ModelException e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)e.getMessage());
            }
            catch (InvalidDBDSourceException e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)e.getMessage());
            }
            catch (Throwable e) {
                logger.throwing(this.getClass().getName(), "toggleRelDBDs()", e);
                logger.error(e);
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)e.getMessage());
            }
        }
    }

    public void expandAll() {
        try {
            this.dbGEFModel.setExpand(true);
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "toggleRelDBDs()", e);
            logger.error(e);
        }
    }

    public void collapseAll() {
        try {
            this.dbGEFModel.setExpand(false);
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "toggleRelDBDs()", e);
            logger.error(e);
        }
    }

    public void resetLayout() {
        try {
            this.dbGEFModel.recalculateLayout();
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "toggleRelDBDs()", e);
            logger.error(e);
        }
    }

    public void toggleBasicView() {
        if (this.dbGEFModel.isInLogicalViewMode()) {
            this.toggleLogicalView(null);
        } else if (this.dbGEFModel.isInDisplayRelatedDBDsMode()) {
            this.toggleRelDBDs();
        }
    }

    public void toggleLogicalView(SegmentGEFModel gefSegment) {
        try {
            this.dbGEFModel.toggleLogicalView(gefSegment);
        }
        catch (MissingDBDException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)e.getMessage());
        }
        catch (ModelException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)e.getMessage());
        }
        catch (InvalidDBDSourceException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "toggleRelDBDs()", e);
            logger.error(e);
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)e.getMessage());
        }
    }

    public void launchManageSecondaryIx(SegmentGEFModel gefSegment, IWorkbenchWindow window) {
        this.dbGEFModel.launchManageSecondaryIx(gefSegment, window);
    }

    public void launchManageLogicalRel(SegmentGEFModel gefSegment, IWorkbenchWindow window) {
        this.dbGEFModel.launchManageLogicalRel(gefSegment, window);
    }

    public void launchManageField(SegmentGEFModel gefSegment, IWorkbenchWindow window) throws ModelException {
        String selectedSegmentName = gefSegment.getSegmentModel().getName();
        ResourceEditorController reController = this.parent.getReController();
        boolean isReadOnly = this.parent.isReadOnly();
        ManageFieldsController controller = new ManageFieldsController(reController.getSegmentModel(selectedSegmentName), reController, isReadOnly);
        ManageFieldWizard wizard = new ManageFieldWizard(gefSegment, controller);
        Shell windowShell = window.getShell();
        WizardDialog dialog = new WizardDialog(windowShell, (IWizard)wizard);
        dialog.create();
        Shell dialogShell = dialog.getShell();
        Point windowSize = windowShell.getSize();
        int width = (int)((double)windowSize.x * 0.75);
        int height = (int)((double)windowSize.y * 0.75);
        dialogShell.setSize(width, height);
        int xPos = (int)((double)windowSize.x * 0.12);
        int yPos = (int)((double)windowSize.y * 0.12);
        dialogShell.setLocation(xPos, yPos);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            gefSegment.toggleExpand();
            gefSegment.setExpand(true);
            try {
                this.dbGEFModel.fireEvent(new NodeEvents(2, this.dbGEFModel));
            }
            catch (Throwable e) {
                logger.throwing(this.getClass().getName(), "editSenSegSenField(SegmentGEFModel parentGEFSegment, SegmentGEFModel childGEFSegment)", e);
                logger.error(e);
            }
            this.dbGEFModel.recalculateLayout();
            this.parent.getReController().setSegmentMetadataChanged(true);
        }
    }

    public void launchManageSenflds(SegmentGEFModel gefSegment, IWorkbenchWindow window) throws ModelException {
        String selectedSegmentName = gefSegment.getSegmentModel().getImsName();
        ResourceEditorController reController = this.parent.getReController();
        PcbDBModel dbPcbModel = this.dbGEFModel.getPcbModel();
        ManageSenfldsController controller = new ManageSenfldsController(dbPcbModel.getSensegModel(selectedSegmentName), reController, this.parent.isReadOnly());
        ManageSenfldsWizard wizard = new ManageSenfldsWizard(controller);
        WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            gefSegment.toggleExpand();
            gefSegment.setExpand(true);
            try {
                this.dbGEFModel.fireEvent(new NodeEvents(2, this.dbGEFModel));
            }
            catch (Throwable e) {
                logger.throwing(this.getClass().getName(), "editSenSegSenField(SegmentGEFModel parentGEFSegment, SegmentGEFModel childGEFSegment)", e);
                logger.error(e);
            }
            this.dbGEFModel.recalculateLayout();
        }
    }

    public void launchEditSenSegSenField(SegmentGEFModel gefSegment, IWorkbenchWindow window) {
        this.dbGEFModel.launchEditSenSegSenField(gefSegment, window, this, this.parent.isReadOnly());
    }

    public void toggleConcatenate(SegmentGEFModel gefSegment) throws Exception {
        this.dbGEFModel.toggleConcatenate(gefSegment);
    }

    public void toggleApplicationView() {
        try {
            this.dbGEFModel.toggleApplicationView();
        }
        catch (MissingDBDException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)e.getMessage());
        }
        catch (ModelException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)e.getMessage());
        }
        catch (InvalidDBDSourceException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "toggleRelDBDs()", e);
            logger.error(e);
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)e.getMessage());
        }
    }

    public void launchImportDataStructure(SegmentGEFModel gefSegment, IWorkbenchWindow window) throws InvalidDBDSourceException, ModelException {
        this.dbGEFModel.launchImportDataStructure(gefSegment, window);
    }

    public void launchEditEncoding(SegmentGEFModel gefSegment, IWorkbenchWindow window) throws Exception {
        this.dbGEFModel.launchEditEncoding(gefSegment, window, this.parent.isReadOnly());
    }

    public void launchEditVersionDbver(IWorkbenchWindow window) throws ModelException {
        this.dbGEFModel.launchEditVersionDbver(window, this.parent.isReadOnly());
    }

    public void launchEditDataset(IWorkbenchWindow window) throws ModelException {
        this.dbGEFModel.launchEditDataset(window, this.parent.isReadOnly());
    }

    public void launchFindSegment() {
        this.dbGEFModel.launchSearch();
    }

    public boolean isLogicallyRelatedDBD() {
        return this.dbGEFModel.isLogicallyRelatedDBD();
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        if (this.dbGEFModel != null) {
            viewer.setContents((Object)this.dbGEFModel);
            this.dbGEFModel.recalculateLayout();
            this.revealEditPart();
        }
    }

    private void revealEditPart() {
        DbEditPart dbEditPart = (DbEditPart)this.getEditPart();
        List children = dbEditPart.getChildren();
        SegmentEditPart segEditPart = null;
        int i = 0;
        while (i < children.size()) {
            if (children.get(i) instanceof SegmentEditPart) {
                segEditPart = (SegmentEditPart)children.get(i);
                break;
            }
            ++i;
        }
        if (segEditPart != null) {
            IFigure target = segEditPart.getFigure();
            FigureCanvas figureCanvas = (FigureCanvas)this.getViewer().getControl();
            Rectangle rectangle = this.dbGEFModel.getDbdBorderModel().getConstraint();
            figureCanvas.setBounds(0, 0, rectangle.x, rectangle.y);
            figureCanvas.scrollTo(target.getBounds().x / 2 + target.getSize().width / 2, target.getBounds().y - 40);
        } else {
            Insets CANVAS_INSETS = new Insets(45, 5, 0, 0);
            Insets DB_BORDER_INSETS = new Insets(10, 10, 20, 20);
            int SEGMENT_VERTICAL_GAP = 80;
            FigureCanvas figureCanvas = (FigureCanvas)this.getViewer().getControl();
            RectangleFigure dbdBorderFigure = this.dbGEFModel.getDbdBorderModel().getFigure();
            TitleBarBorder titleBarBorder = (TitleBarBorder)dbdBorderFigure.getBorder();
            int width = titleBarBorder.getPreferredSize((IFigure)dbdBorderFigure).width;
            int leftBoundary = CANVAS_INSETS.left + DB_BORDER_INSETS.right;
            this.dbGEFModel.getDbdBorderModel().setConstraint(new Rectangle(leftBoundary - DB_BORDER_INSETS.left, CANVAS_INSETS.top, width, SEGMENT_VERTICAL_GAP));
            Rectangle rectangle = this.dbGEFModel.getDbdBorderModel().getConstraint();
            figureCanvas.setBounds(0, 0, rectangle.x, rectangle.y);
        }
    }

    public final void doSave(IProgressMonitor monitor) {
        this.getPsbMultiPageEditor().doSave(monitor);
    }

    public final void doSaveAs() {
        this.getPsbMultiPageEditor().doSaveAs();
    }

    public final boolean isDirty() {
        return this.getPsbMultiPageEditor().isDirty();
    }

    protected final CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    public final boolean isSaveAsAllowed() {
        return this.getPsbMultiPageEditor().isSaveAsAllowed();
    }

    public void setFocus() {
        this.getGraphicalViewer().getControl().setFocus();
    }

    public ResourceMultiPageEditor getPsbMultiPageEditor() {
        return this.parent;
    }

    public DbGEFModel getDbGEFModel() {
        return this.dbGEFModel;
    }

    protected GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    public GraphicalViewer getViewer() {
        return this.getGraphicalViewer();
    }

    public String getPageName() {
        return this.pageName;
    }

    public List getSelectedParts() {
        return this.getGraphicalViewer().getSelectedEditParts();
    }

    public EditPart getEditPart() {
        return this.getGraphicalViewer().getContents();
    }

    public void setSelectedPart(EditPart part) {
        this.getGraphicalViewer().deselect(part);
        this.getGraphicalViewer().select(part);
    }

    public String getTitle() {
        return this.dbGEFModel.getPcbAlias();
    }

    public void setPageName(String name) {
        this.parent.setPageName(this, name);
        this.pageName = name;
    }

    public void createPartControl(Composite parent) {
        try {
            if (this.dbGEFModel == null) {
                return;
            }
            FormLayout fl = new FormLayout();
            parent.setLayout((Layout)fl);
            Composite mainEditor = new Composite(parent, 0);
            mainEditor.setLayout((Layout)new FillLayout());
            FormData fd = new FormData();
            fd.top = new FormAttachment(0, 0);
            fd.left = new FormAttachment(0, 0);
            fd.bottom = new FormAttachment(100, 0);
            fd.right = new FormAttachment(100, 0);
            mainEditor.setLayoutData((Object)fd);
            super.createPartControl(mainEditor);
            this.getSite().setSelectionProvider((ISelectionProvider)this);
            if (this.dbGEFModel.isPsb()) {
                FormData fd2 = new FormData();
                fd2.top = new FormAttachment(0, 5);
                fd2.right = new FormAttachment(100, -24);
                Composite viewSwitchComp = new Composite(parent, 2048);
                FormLayout formLayout = new FormLayout();
                formLayout.spacing = 2;
                formLayout.marginHeight = 2;
                formLayout.marginWidth = 2;
                viewSwitchComp.setLayout((Layout)formLayout);
                viewSwitchComp.setLayoutData((Object)fd2);
                viewSwitchComp.moveAbove(null);
                viewSwitchComp.setBackground(parent.getDisplay().getSystemColor(35));
                Composite subComposite = new Composite(viewSwitchComp, 0);
                subComposite.setLayout((Layout)new FormLayout());
                subComposite.setBackground(parent.getDisplay().getSystemColor(35));
                Label viewLabel = new Label(subComposite, 0);
                viewLabel.setText(WorkbenchPlugin.labels.getString("WB462") + WorkbenchPlugin.colon.getString("COLON"));
                viewLabel.setBackground(parent.getDisplay().getSystemColor(35));
                viewLabel.setFont(GetNodePreferences.fetchPreferenceFont("explorer_field_font"));
                fd = new FormData();
                fd.top = new FormAttachment(0, margin);
                fd.left = new FormAttachment(0, margin);
                viewLabel.setLayoutData((Object)fd);
                this.editViewButton = new Button(subComposite, 8);
                fd = new FormData();
                fd.left = new FormAttachment((Control)viewLabel, margin);
                this.editViewButton.setLayoutData((Object)fd);
                this.editViewButton.setBackground(parent.getDisplay().getSystemColor(35));
                this.appViewButton = new Button(subComposite, 8);
                fd = new FormData();
                fd.left = new FormAttachment((Control)this.editViewButton, margin);
                this.appViewButton.setLayoutData((Object)fd);
                this.appViewButton.setBackground(parent.getDisplay().getSystemColor(35));
                Label viewLabel1 = new Label(subComposite, 0);
                viewLabel1.setText("|");
                viewLabel1.setFont(GetNodePreferences.fetchPreferenceFont("explorer_field_font"));
                viewLabel1.setBackground(parent.getDisplay().getSystemColor(35));
                fd = new FormData();
                fd.top = new FormAttachment(0, margin);
                fd.left = new FormAttachment((Control)this.appViewButton, margin - 1);
                viewLabel1.setLayoutData((Object)fd);
                Button closeViewButton = new Button(subComposite, 8);
                fd = new FormData();
                fd.left = new FormAttachment((Control)viewLabel1, margin);
                closeViewButton.setLayoutData((Object)fd);
                closeViewButton.setBackground(parent.getDisplay().getSystemColor(35));
                this.editViewButton.setImage(FigureConstants.EDIT_VIEW_IMAGE);
                this.editViewButton.moveAbove(null);
                this.editViewButton.setEnabled(this.dbGEFModel != null && this.dbGEFModel.isApplicationView());
                this.editViewButton.setToolTipText(WorkbenchPlugin.labels.getString("WB447"));
                this.editViewButton.addMouseListener(new MouseListener(){

                    public void mouseDoubleClick(MouseEvent arg0) {
                    }

                    public void mouseDown(MouseEvent arg0) {
                    }

                    public void mouseUp(MouseEvent arg0) {
                        try {
                            ResourceEditorPage.this.toggleApplicationView();
                        }
                        catch (Throwable e) {
                            logger.throwing(this.getClass().getName(), "mouseUp(MouseEvent arg0)", e);
                            logger.error(e);
                        }
                    }
                });
                this.appViewButton.setImage(FigureConstants.APPL_VIEW_IMAGE);
                this.appViewButton.moveAbove(null);
                this.appViewButton.setEnabled(this.dbGEFModel != null && !this.dbGEFModel.isApplicationView());
                this.appViewButton.setToolTipText(WorkbenchPlugin.labels.getString("WB446"));
                this.appViewButton.addMouseListener(new MouseListener(){

                    public void mouseDoubleClick(MouseEvent arg0) {
                    }

                    public void mouseDown(MouseEvent arg0) {
                    }

                    public void mouseUp(MouseEvent arg0) {
                        try {
                            ResourceEditorPage.this.toggleApplicationView();
                        }
                        catch (Throwable e) {
                            logger.throwing(this.getClass().getName(), "mouseUp(MouseEvent arg0)", e);
                            logger.error(e);
                        }
                    }
                });
                closeViewButton.setImage(FigureConstants.CLOSE_VIEW_IMAGE);
                closeViewButton.moveAbove(null);
                closeViewButton.setEnabled(true);
                closeViewButton.setToolTipText(WorkbenchPlugin.labels.getString("WB461"));
                closeViewButton.addMouseListener(new MouseListener(){

                    public void mouseDoubleClick(MouseEvent arg0) {
                    }

                    public void mouseDown(MouseEvent arg0) {
                    }

                    public void mouseUp(MouseEvent arg0) {
                        try {
                            ResourceEditorPage.this.getPsbMultiPageEditor().removePage(ResourceEditorPage.this.getPsbMultiPageEditor().getActivePage());
                            ResourceEditorPage.this.getPsbMultiPageEditor().setActivePage(0);
                        }
                        catch (Throwable e) {
                            logger.throwing(this.getClass().getName(), "mouseUp(MouseEvent arg0)", e);
                            logger.error(e);
                        }
                    }
                });
            } else {
                FormData fd2 = new FormData();
                fd2.top = new FormAttachment(0, 5);
                fd2.right = new FormAttachment(100, -24);
                Composite viewSwitchComp = new Composite(parent, 2048);
                FormLayout formLayout = new FormLayout();
                formLayout.spacing = 2;
                formLayout.marginHeight = 2;
                formLayout.marginWidth = 2;
                viewSwitchComp.setLayout((Layout)formLayout);
                viewSwitchComp.setLayoutData((Object)fd2);
                viewSwitchComp.moveAbove(null);
                viewSwitchComp.setBackground(parent.getDisplay().getSystemColor(35));
                Composite subComposite = new Composite(viewSwitchComp, 0);
                subComposite.setLayout((Layout)new FormLayout());
                subComposite.setBackground(parent.getDisplay().getSystemColor(35));
                Label viewLabel = new Label(subComposite, 0);
                viewLabel.setText(WorkbenchPlugin.labels.getString("WB462") + WorkbenchPlugin.colon.getString("COLON"));
                viewLabel.setBackground(parent.getDisplay().getSystemColor(35));
                viewLabel.setFont(GetNodePreferences.fetchPreferenceFont("explorer_field_font"));
                fd = new FormData();
                fd.top = new FormAttachment(0, margin);
                fd.left = new FormAttachment(0, margin);
                viewLabel.setLayoutData((Object)fd);
                this.logicalViewButton = new Button(subComposite, 8);
                fd = new FormData();
                fd.left = new FormAttachment((Control)viewLabel, margin);
                this.logicalViewButton.setLayoutData((Object)fd);
                this.logicalViewButton.setBackground(parent.getDisplay().getSystemColor(35));
                this.relatedDbdsViewButton = new Button(subComposite, 8);
                fd = new FormData();
                fd.left = new FormAttachment((Control)this.logicalViewButton, margin);
                this.relatedDbdsViewButton.setLayoutData((Object)fd);
                this.relatedDbdsViewButton.setBackground(parent.getDisplay().getSystemColor(35));
                this.regularViewButton = new Button(subComposite, 8);
                fd = new FormData();
                fd.left = new FormAttachment((Control)this.relatedDbdsViewButton, margin);
                this.regularViewButton.setLayoutData((Object)fd);
                this.regularViewButton.setBackground(parent.getDisplay().getSystemColor(35));
                this.logicalViewButton.setImage(FigureConstants.SECONDARY_VIEW_IMAGE);
                this.logicalViewButton.moveAbove(null);
                this.logicalViewButton.setEnabled(false);
                this.logicalViewButton.setToolTipText(WorkbenchPlugin.labels.getString("WB348"));
                this.logicalViewButton.addMouseListener(new MouseListener(){

                    public void mouseDoubleClick(MouseEvent arg0) {
                    }

                    public void mouseDown(MouseEvent arg0) {
                    }

                    public void mouseUp(MouseEvent arg0) {
                        if (ResourceEditorPage.this.selectedSegmentEditPart != null) {
                            ResourceEditorPage.this.toggleLogicalView((SegmentGEFModel)ResourceEditorPage.this.selectedSegmentEditPart.getModel());
                        }
                    }
                });
                this.relatedDbdsViewButton.setImage(FigureConstants.RELATED_DBD_VIEW_IMAGE);
                this.relatedDbdsViewButton.moveAbove(null);
                this.relatedDbdsViewButton.setEnabled(true);
                this.relatedDbdsViewButton.setToolTipText(WorkbenchPlugin.labels.getString("WB349"));
                this.relatedDbdsViewButton.addMouseListener(new MouseListener(){

                    public void mouseDoubleClick(MouseEvent arg0) {
                    }

                    public void mouseDown(MouseEvent arg0) {
                    }

                    public void mouseUp(MouseEvent arg0) {
                        try {
                            ResourceEditorPage.this.toggleRelDBDs();
                        }
                        catch (Throwable e) {
                            logger.throwing(this.getClass().getName(), "mouseUp(MouseEvent arg0)", e);
                            logger.error(e);
                        }
                    }
                });
                this.regularViewButton.setImage(FigureConstants.DBD_IMAGE);
                this.regularViewButton.moveAbove(null);
                this.regularViewButton.setEnabled(false);
                this.regularViewButton.setToolTipText(WorkbenchPlugin.labels.getString("WB347"));
                this.regularViewButton.addMouseListener(new MouseListener(){

                    public void mouseDoubleClick(MouseEvent arg0) {
                    }

                    public void mouseDown(MouseEvent arg0) {
                    }

                    public void mouseUp(MouseEvent arg0) {
                        if (ResourceEditorPage.this.dbGEFModel.isInLogicalViewMode()) {
                            ResourceEditorPage.this.toggleLogicalView(null);
                        } else if (ResourceEditorPage.this.dbGEFModel.isInDisplayRelatedDBDsMode()) {
                            ResourceEditorPage.this.toggleRelDBDs();
                        }
                    }
                });
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "", e);
            logger.error(e);
        }
    }

    private void updateViewButtons() {
        if (!this.dbGEFModel.isPsb()) {
            if (this.dbGEFModel.isInDisplayRelatedDBDsMode()) {
                this.logicalViewButton.setEnabled(false);
                this.relatedDbdsViewButton.setEnabled(false);
                this.regularViewButton.setEnabled(true);
            } else if (this.dbGEFModel.isInLogicalViewMode()) {
                this.logicalViewButton.setEnabled(false);
                this.relatedDbdsViewButton.setEnabled(false);
                this.regularViewButton.setEnabled(true);
            } else {
                this.regularViewButton.setEnabled(false);
                this.relatedDbdsViewButton.setEnabled(true);
                if (this.dbGEFModel.getDbdModel().getAccessType() != DBDConstants.LOGICAL) {
                    if (this.selectedSegmentEditPart != null && this.selectedSegmentEditPart.canBeLogicalRoot()) {
                        this.logicalViewButton.setEnabled(true);
                    } else {
                        this.logicalViewButton.setEnabled(false);
                    }
                }
            }
        } else if (this.inApplicationView) {
            if (this.editViewButton != null && !this.editViewButton.isDisposed()) {
                this.editViewButton.setEnabled(true);
            }
            if (this.appViewButton != null && !this.appViewButton.isDisposed()) {
                this.appViewButton.setEnabled(false);
            }
        } else {
            if (this.editViewButton != null && !this.editViewButton.isDisposed()) {
                this.editViewButton.setEnabled(false);
            }
            if (this.appViewButton != null && !this.appViewButton.isDisposed()) {
                this.appViewButton.setEnabled(true);
            }
        }
    }

    public PcbDBModel getDbPcbModel() {
        return this.dbGEFModel.getPcbModel();
    }

    @Override
    public void handleEvent(NodeEvents e) {
        if (e.getEventType() == 9 || e.getEventType() == 10 || e.getEventType() == 15) {
            this.updateViewButtons();
        }
    }

    public void selectionChanged(SelectionChangedEvent e) {
        StructuredSelection ss;
        Object[] selections;
        ISelection selection = e.getSelection();
        this.selectedSegmentEditPart = selection instanceof StructuredSelection ? ((selections = (ss = (StructuredSelection)selection).toArray()).length > 0 && selections[selections.length - 1] instanceof SegmentEditPart ? (SegmentEditPart)selections[selections.length - 1] : null) : null;
        this.updateViewButtons();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.getGraphicalViewer().addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.getGraphicalViewer().getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.getGraphicalViewer().removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.getGraphicalViewer().setSelection(selection);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.getGraphicalViewer().addSelectionChangedListener(listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.getGraphicalViewer().removeSelectionChangedListener(listener);
    }

    class ContextMenuListener
    implements IMenuListener {
        ContextMenuListener() {
        }

        public void menuAboutToShow(IMenuManager m) {
            ResourceEditorPage.fillContextMenu(m);
        }
    }

    class FieldNameEditKeyListener
    implements KeyListener {
        private ResourceEditorPage page;

        public FieldNameEditKeyListener(ResourceEditorPage page) {
            this.page = page;
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            try {
                List editParts = ResourceEditorPage.this.getSelectedParts();
                if (e.keyCode == 13 || e.keyCode == 127) {
                    SegmentGEFModel gefSegment;
                    if (editParts.size() == 1 && (editParts.get(0) instanceof FieldEditPart || editParts.get(0) instanceof SegmentEditPart) && !ResourceEditorPage.this.dbGEFModel.isPsb() && !ResourceEditorPage.this.dbGEFModel.isInDisplayRelatedDBDsMode() && ResourceEditorPage.this.dbGEFModel.isPhysicalDb() && !ResourceEditorPage.this.dbGEFModel.isInLogicalViewMode()) {
                        SegmentGEFModel gefSegment2 = editParts.get(0) instanceof SegmentEditPart ? (SegmentGEFModel)((SegmentEditPart)editParts.get(0)).getModel() : ((FieldGEFModel)((FieldEditPart)editParts.get(0)).getModel()).getSegmentGEFModel();
                        if (gefSegment2 != null) {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            ResourceEditorPage.this.launchManageField(gefSegment2, window);
                        }
                    } else if (editParts.size() == 1 && (editParts.get(0) instanceof FieldEditPart || editParts.get(0) instanceof SegmentEditPart) && ResourceEditorPage.this.dbGEFModel.isPsb() && !ResourceEditorPage.this.dbGEFModel.isApplicationView() && (gefSegment = editParts.get(0) instanceof SegmentEditPart ? (SegmentGEFModel)((SegmentEditPart)editParts.get(0)).getModel() : ((FieldGEFModel)((FieldEditPart)editParts.get(0)).getModel()).getSegmentGEFModel()) != null && gefSegment.isSenseg()) {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        ResourceEditorPage.this.dbGEFModel.launchEditSenSegSenField(gefSegment, window, this.page, ResourceEditorPage.this.parent.isReadOnly());
                    }
                } else if (e.keyCode == 32) {
                    SegmentGEFModel gefSegment;
                    if (editParts.size() == 1 && (editParts.get(0) instanceof FieldEditPart || editParts.get(0) instanceof SegmentEditPart) && ResourceEditorPage.this.dbGEFModel.isPsb() && ResourceEditorPage.this.dbGEFModel.isInPCBEditMode() && editParts.get(0) instanceof SegmentEditPart && (gefSegment = (SegmentGEFModel)((SegmentEditPart)editParts.get(0)).getModel()).getParent() != null) {
                        gefSegment.toggleSensitiveSegment(!gefSegment.isSenseg());
                    }
                } else if (e.keyCode == 102 && e.stateMask == 262144) {
                    ResourceEditorPage.this.dbGEFModel.launchSearch();
                }
            }
            catch (Throwable exc) {
                logger.throwing(this.getClass().getName(), "handleStateChanged(ChangeEvent event)", exc);
                logger.error(exc);
            }
        }
    }

    class FieldNameEditMouseListener
    implements MouseListener {
        private ResourceEditorPage page;

        public FieldNameEditMouseListener(ResourceEditorPage page) {
            this.page = page;
        }

        public void mouseDoubleClick(MouseEvent e) {
            try {
                SegmentGEFModel gefSegment;
                List editParts = ResourceEditorPage.this.getSelectedParts();
                if (editParts.size() == 1 && (editParts.get(0) instanceof FieldEditPart || editParts.get(0) instanceof SegmentEditPart) && !ResourceEditorPage.this.dbGEFModel.isPsb() && !ResourceEditorPage.this.dbGEFModel.isInDisplayRelatedDBDsMode() && ResourceEditorPage.this.dbGEFModel.isPhysicalDb() && !ResourceEditorPage.this.dbGEFModel.isInLogicalViewMode()) {
                    SegmentGEFModel gefSegment2 = editParts.get(0) instanceof SegmentEditPart ? (SegmentGEFModel)((SegmentEditPart)editParts.get(0)).getModel() : ((FieldGEFModel)((FieldEditPart)editParts.get(0)).getModel()).getSegmentGEFModel();
                    if (gefSegment2 != null) {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (gefSegment2.getSegmentModel().isVirtualLogicalChild()) {
                            MessageDialog.openError((Shell)window.getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)WorkbenchPlugin.errors.getString("NO_LAUNCH_MNG_FIELDS_VLC"));
                        } else {
                            ResourceEditorPage.this.launchManageField(gefSegment2, window);
                        }
                    }
                } else if (editParts.size() == 1 && (editParts.get(0) instanceof FieldEditPart || editParts.get(0) instanceof SegmentEditPart) && ResourceEditorPage.this.dbGEFModel.isPsb() && !ResourceEditorPage.this.dbGEFModel.isApplicationView() && (gefSegment = editParts.get(0) instanceof SegmentEditPart ? (SegmentGEFModel)((SegmentEditPart)editParts.get(0)).getModel() : ((FieldGEFModel)((FieldEditPart)editParts.get(0)).getModel()).getSegmentGEFModel()) != null && gefSegment.isSenseg()) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    ResourceEditorPage.this.dbGEFModel.launchEditSenSegSenField(gefSegment, window, this.page, ResourceEditorPage.this.parent.isReadOnly());
                }
            }
            catch (Throwable exc) {
                logger.throwing(this.getClass().getName(), "execute(ExecutionEvent event)", exc);
                logger.error(exc);
            }
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }
    }
}

