/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors;

import com.ibm.im.ims.workbench.editors.ResourceEditorPage;
import com.ibm.im.ims.workbench.editors.ResourceMultiPageEditor;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class ResourceEditorOutlinePage
extends Page
implements IContentOutlinePage {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Canvas overview;
    private RootEditPart rootEditPart;
    private ScrollableThumbnail thumbnail;
    private LightweightSystem lws;
    private ResourceMultiPageEditor editor;

    public ResourceEditorOutlinePage(ResourceMultiPageEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        this.overview = new Canvas(parent, 0);
        this.lws = new LightweightSystem(this.overview);
        this.initializeOutlineView(this.editor.getCurrentPage() != null);
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    private void initializeOutlineView(boolean isVisible) {
        if (this.lws == null) {
            return;
        }
        if (this.thumbnail != null) {
            this.thumbnail.deactivate();
        }
        if (this.getContent() != null) {
            Viewport viewport = null;
            IFigure source = null;
            if (this.getContent() instanceof ScalableFreeformRootEditPart) {
                viewport = (Viewport)((ScalableFreeformRootEditPart)this.getContent()).getFigure();
                source = ((ScalableFreeformRootEditPart)this.getContent()).getLayer((Object)"Printable Layers");
            }
            if (this.getContent() instanceof ScalableRootEditPart) {
                viewport = (Viewport)((ScalableRootEditPart)this.getContent()).getFigure();
                source = ((ScalableRootEditPart)this.getContent()).getLayer((Object)"Printable Layers");
            }
            if (viewport != null && source != null) {
                this.thumbnail = new ScrollableThumbnail();
                this.thumbnail.setBorder((Border)new MarginBorder(2));
                this.thumbnail.setVisible(isVisible);
                this.thumbnail.setViewport(viewport);
                this.thumbnail.setSource(source);
                this.lws.setContents((IFigure)this.thumbnail);
            }
        }
    }

    public void initialize(ResourceEditorPage newPage) {
        if (newPage != null && newPage.getGraphicalViewer() != null) {
            this.setContent(newPage.getGraphicalViewer().getRootEditPart());
        } else {
            this.setContent(null);
        }
    }

    public RootEditPart getContent() {
        return this.rootEditPart;
    }

    private void setContent(RootEditPart part) {
        if (part != null && this.rootEditPart != part) {
            this.rootEditPart = part;
        }
        this.initializeOutlineView(part != null);
    }

    public void dispose() {
        if (this.rootEditPart != null) {
            this.rootEditPart.deactivate();
        }
        super.dispose();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public Control getControl() {
        return this.overview;
    }

    public ISelection getSelection() {
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setFocus() {
        if (this.getControl() != null) {
            this.getControl().setFocus();
        }
    }

    public void setSelection(ISelection selection) {
    }
}

