/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;

public class DelegatingZoomManager
extends ZoomManager
implements ZoomListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ZoomManager m_currentZoomManager;
    private ListenerList m_zoomListeners = new ListenerList(1);

    public DelegatingZoomManager() {
        super(null, null);
    }

    public void zoomChanged(double zoom) {
        Object[] listeners = this.m_zoomListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ZoomListener)listeners[i]).zoomChanged(zoom);
            ++i;
        }
    }

    public void addZoomListener(ZoomListener listener) {
        this.m_zoomListeners.add((Object)listener);
    }

    public void removeZoomListener(ZoomListener listener) {
        this.m_zoomListeners.remove((Object)listener);
    }

    public void setCurrentZoomManager(ZoomManager zoomManager) {
        if (this.m_currentZoomManager != null) {
            this.m_currentZoomManager.removeZoomListener((ZoomListener)this);
        }
        this.m_currentZoomManager = zoomManager;
        if (this.m_currentZoomManager != null) {
            this.m_currentZoomManager.addZoomListener((ZoomListener)this);
            this.zoomChanged(this.m_currentZoomManager.getZoom());
        }
    }

    public boolean canZoomIn() {
        if (this.m_currentZoomManager == null) {
            return false;
        }
        return this.m_currentZoomManager.canZoomIn();
    }

    public boolean canZoomOut() {
        if (this.m_currentZoomManager == null) {
            return false;
        }
        return this.m_currentZoomManager.canZoomOut();
    }

    public double getMaxZoom() {
        if (this.m_currentZoomManager == null) {
            return 1.0;
        }
        return this.m_currentZoomManager.getMaxZoom();
    }

    public double getMinZoom() {
        if (this.m_currentZoomManager == null) {
            return 1.0;
        }
        return this.m_currentZoomManager.getMinZoom();
    }

    public double getNextZoomLevel() {
        if (this.m_currentZoomManager == null) {
            return 1.0;
        }
        return this.m_currentZoomManager.getNextZoomLevel();
    }

    public double getPreviousZoomLevel() {
        if (this.m_currentZoomManager == null) {
            return 1.0;
        }
        return this.m_currentZoomManager.getPreviousZoomLevel();
    }

    public ScalableFigure getScalableFigure() {
        if (this.m_currentZoomManager == null) {
            return null;
        }
        return this.m_currentZoomManager.getScalableFigure();
    }

    public double getUIMultiplier() {
        if (this.m_currentZoomManager == null) {
            return 1.0;
        }
        return this.m_currentZoomManager.getUIMultiplier();
    }

    public Viewport getViewport() {
        if (this.m_currentZoomManager == null) {
            return null;
        }
        return this.m_currentZoomManager.getViewport();
    }

    public double getZoom() {
        if (this.m_currentZoomManager == null) {
            return 1.0;
        }
        return this.m_currentZoomManager.getZoom();
    }

    public String getZoomAsText() {
        if (this.m_currentZoomManager == null) {
            return " 100%";
        }
        return this.m_currentZoomManager.getZoomAsText();
    }

    public double[] getZoomLevels() {
        if (this.m_currentZoomManager == null) {
            return new double[]{1.0};
        }
        return this.m_currentZoomManager.getZoomLevels();
    }

    public String[] getZoomLevelsAsText() {
        if (this.m_currentZoomManager == null) {
            return new String[]{" 100%"};
        }
        return this.m_currentZoomManager.getZoomLevelsAsText();
    }

    public void setUIMultiplier(double multiplier) {
        if (this.m_currentZoomManager != null) {
            this.m_currentZoomManager.setUIMultiplier(multiplier);
        }
    }

    public void setViewLocation(Point p) {
        if (this.m_currentZoomManager != null) {
            this.m_currentZoomManager.setViewLocation(p);
        }
    }

    public void setZoom(double zoom) {
        if (this.m_currentZoomManager != null) {
            this.m_currentZoomManager.setZoom(zoom);
        }
    }

    public void setZoomAnimationStyle(int style) {
        if (this.m_currentZoomManager != null) {
            this.m_currentZoomManager.setZoomAnimationStyle(style);
        }
    }

    public void setZoomAsText(String zoomString) {
        if (this.m_currentZoomManager != null) {
            this.m_currentZoomManager.setZoomAsText(zoomString);
        }
    }

    public void setZoomLevels(double[] zoomLevels) {
        if (this.m_currentZoomManager != null) {
            this.m_currentZoomManager.setZoomLevels(zoomLevels);
        }
    }

    public void zoomIn() {
        if (this.m_currentZoomManager != null) {
            this.m_currentZoomManager.zoomIn();
        }
    }

    public void zoomOut() {
        if (this.m_currentZoomManager != null) {
            this.m_currentZoomManager.zoomOut();
        }
    }

    public void zoomTo(Rectangle rect) {
        if (this.m_currentZoomManager != null) {
            this.m_currentZoomManager.zoomTo(rect);
        }
    }
}

