/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.editors;

import java.util.EventObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.commands.UnexecutableCommand;

public class DelegatingCommandStack
extends CommandStack
implements CommandStackListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private CommandStack currentCommandStack;

    public CommandStack getCurrentCommandStack() {
        return this.currentCommandStack;
    }

    public void setCurrentCommandStack(CommandStack stack) {
        if (this.currentCommandStack == stack) {
            return;
        }
        if (this.currentCommandStack != null) {
            this.currentCommandStack.removeCommandStackListener((CommandStackListener)this);
        }
        this.currentCommandStack = stack;
        this.currentCommandStack.addCommandStackListener((CommandStackListener)this);
    }

    public boolean canRedo() {
        if (this.currentCommandStack == null) {
            return false;
        }
        return this.currentCommandStack.canRedo();
    }

    public boolean canUndo() {
        if (this.currentCommandStack == null) {
            return false;
        }
        return this.currentCommandStack.canUndo();
    }

    public void dispose() {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.dispose();
        }
    }

    public void execute(Command command) {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.execute(command);
        }
    }

    public void flush() {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.flush();
        }
    }

    public Object[] getCommands() {
        if (this.currentCommandStack == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        return this.currentCommandStack.getCommands();
    }

    public Command getRedoCommand() {
        if (this.currentCommandStack == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return this.currentCommandStack.getRedoCommand();
    }

    public Command getUndoCommand() {
        if (this.currentCommandStack == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return this.currentCommandStack.getUndoCommand();
    }

    public int getUndoLimit() {
        if (this.currentCommandStack == null) {
            return -1;
        }
        return this.currentCommandStack.getUndoLimit();
    }

    public boolean isDirty() {
        if (this.currentCommandStack == null) {
            return false;
        }
        return this.currentCommandStack.isDirty();
    }

    public void markSaveLocation() {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.markSaveLocation();
        }
    }

    public void redo() {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.redo();
        }
    }

    public void setUndoLimit(int undoLimit) {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.setUndoLimit(undoLimit);
        }
    }

    public void undo() {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.undo();
        }
    }

    public String toString() {
        return "DelegatingCommandStack(" + String.valueOf(this.currentCommandStack) + ")";
    }

    public void commandStackChanged(EventObject event) {
        this.notifyListeners();
    }
}

