/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.dialogs;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.builder.WarningsWithoutCheckboxNoPrompt;
import com.ibm.im.ims.workbench.controller.compare.ModelCompareException;
import com.ibm.im.ims.workbench.controller.compare.SubmitChangesController;
import com.ibm.im.ims.workbench.dialogs.ImportInformationDialog;
import com.ibm.im.ims.workbench.imsdb.connections.exceptions.ImsDbConnectionException;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbUtils;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.ims.dli.DLIException;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SubmitChangesToIMSDialog
extends StatusDialog
implements ModifyListener {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private SubmitChangesController controller;
    private String connProfName;
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Composite compContents;
    private Text textGeneratedDDL;
    private Button okButton;
    private Combo profileCombo;
    private Throwable genStmtsException = null;

    public SubmitChangesToIMSDialog(Shell parentShell, SubmitChangesController controller) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
        this.controller = controller;
    }

    protected Control createDialogArea(Composite parent) {
        Control retVal = null;
        try {
            retVal = this.createDialogAreaBody(parent);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return retVal;
    }

    private Control createDialogAreaBody(Composite parent) throws Exception {
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        Composite compDialogArea = (Composite)super.createDialogArea(parent);
        compDialogArea.setBackground(this.formToolkit.getColors().getBackground());
        GridLayout gl_compDialogArea = new GridLayout(1, false);
        gl_compDialogArea.horizontalSpacing = 0;
        gl_compDialogArea.verticalSpacing = 0;
        gl_compDialogArea.marginHeight = 0;
        compDialogArea.setLayout((Layout)gl_compDialogArea);
        this.compContents = new Composite(compDialogArea, 0);
        GridLayout gl_compContents = new GridLayout(2, false);
        gl_compContents.marginTop = 5;
        gl_compContents.verticalSpacing = 10;
        this.compContents.setLayout((Layout)gl_compContents);
        this.compContents.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Text description = new Text(this.compContents, 72);
        description.setText(WorkbenchPlugin.descriptions.getString("SUB_CHGS_DLG_DESCR"));
        GridData gd_description = new GridData(4, 128, true, false, 2, 1);
        gd_description.widthHint = 600;
        description.setLayoutData((Object)gd_description);
        Label connProfLabel = new Label(this.compContents, 0);
        connProfLabel.setText(WorkbenchPlugin.labels.getString("PROFILE") + WorkbenchPlugin.colon.getString("COLON"));
        this.profileCombo = new Combo(this.compContents, 8);
        List connProfiles = this.controller.getIMSConnectionProfiles();
        if (connProfiles.size() >= 1) {
            int i = 0;
            while (i < connProfiles.size()) {
                this.profileCombo.add((String)connProfiles.get(i));
                ++i;
            }
        }
        this.profileCombo.addModifyListener((ModifyListener)this);
        this.profileCombo.setFocus();
        this.textGeneratedDDL = new Text(this.compContents, 2888);
        GridData gd_textArea = new GridData(1808);
        gd_textArea.grabExcessVerticalSpace = true;
        gd_textArea.grabExcessHorizontalSpace = true;
        gd_textArea.heightHint = 600;
        gd_textArea.horizontalSpan = 2;
        this.textGeneratedDDL.setLayoutData((Object)gd_textArea);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.im.ims.workbench.wb_submittoims");
        return compDialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(this.formToolkit.getColors().getBackground());
        this.createButton(parent, 0, IDialogConstants.PROCEED_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton = this.getButton(0);
        this.okButton.setEnabled(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(WorkbenchPlugin.labels.getString("SUB_CHGS_DLG_TITLE"));
    }

    protected void okPressed() {
        try {
            SubmitDDLStmtsRunnable runStmts = new SubmitDDLStmtsRunnable(this.controller);
            new ProgressMonitorDialog(this.getShell()).run(false, true, (IRunnableWithProgress)runStmts);
            super.okPressed();
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    public void modifyText(ModifyEvent event) {
        try {
            if (event.widget == this.profileCombo) {
                this.connProfName = this.profileCombo.getText();
                this.handleConnectionSelected(this.connProfName);
                if (this.genStmtsException != null) {
                    this.okButton.setEnabled(false);
                } else {
                    this.okButton.setEnabled(!this.textGeneratedDDL.getText().isEmpty());
                }
            }
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    private void handleConnectionSelected(String profName) throws InvocationTargetException, InterruptedException, DLIException, SQLException, ModelException, ModelCompareException {
        this.controller.setConnProfName(this.connProfName);
        this.okButton.setEnabled(false);
        GenerateAlterStmtsRunnable genStmts = new GenerateAlterStmtsRunnable(this.controller);
        new ProgressMonitorDialog(this.getShell()).run(false, false, (IRunnableWithProgress)genStmts);
        this.genStmtsException = genStmts.getGenStmtsException();
        if (this.genStmtsException != null) {
            this.textGeneratedDDL.setText(this.genStmtsException.getMessage());
        } else {
            this.textGeneratedDDL.setText(genStmts.getStmtsStr());
        }
    }

    public class GenerateAlterStmtsRunnable
    implements IRunnableWithProgress {
        SubmitChangesController controller;
        private String stmtsStr = "";
        private Throwable genStmtsException;

        public GenerateAlterStmtsRunnable(SubmitChangesController controller) {
            this.controller = controller;
            this.genStmtsException = null;
        }

        public String getStmtsStr() {
            return this.stmtsStr;
        }

        public Throwable getGenStmtsException() {
            return this.genStmtsException;
        }

        public void run(IProgressMonitor monitor) {
            try {
                monitor.beginTask(WorkbenchModelBundle.getLabel().getString("SUB_CHGS_DLG_GEN_STMTS"), -1);
                ArrayList ddlStmts = this.controller.runObjectCompare();
                int i = 0;
                while (i < ddlStmts.size()) {
                    this.stmtsStr = String.valueOf(this.stmtsStr) + (String)ddlStmts.get(i);
                    ++i;
                }
                monitor.done();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                this.genStmtsException = e.getCause();
            }
        }
    }

    public class SubmitDDLStmtsRunnable
    implements IRunnableWithProgress {
        SubmitChangesController controller;

        public SubmitDDLStmtsRunnable(SubmitChangesController controller) {
            this.controller = controller;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                monitor.beginTask(WorkbenchModelBundle.getLabel().getString("SUB_CHGS_DLG_RUNNING_DDL"), -1);
                this.controller.runDDLStatements(monitor);
                monitor.done();
                IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
                if (!store.getBoolean("DDL_SUCCESSFULLY_RAN")) {
                    IImsDbConnection imsConn = ImsDbUtils.getConnectionByName((String)SubmitChangesToIMSDialog.this.connProfName, (boolean)true);
                    String imsVersion = String.valueOf(imsConn.getDatabaseMajorVersion());
                    ImportInformationDialog infoDialog = new ImportInformationDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), imsVersion);
                    infoDialog.open();
                }
            }
            catch (ImsDbConnectionException e) {
                WarningsWithoutCheckboxNoPrompt warnings = new WarningsWithoutCheckboxNoPrompt(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), WorkbenchPlugin.labels.getString("WB496N"), IconAndMessageDialog.getImage((String)"dialog_error_image"), WorkbenchModelBundle.getLabel().getString("SUB_CHGS_DLG_ERROR_MSG"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                warnings.setWarnings(e.getMessage());
                warnings.open();
            }
            catch (Throwable t) {
                logger.error(t);
            }
        }
    }
}

