/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.dialogs;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ConfirmationDialog
extends Dialog {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String messageStr;
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private String title;

    public ConfirmationDialog(Shell parentShell, String messageStr, String title) {
        super(parentShell);
        this.messageStr = messageStr;
        this.title = title;
    }

    protected void configureShell(Shell shell) {
        try {
            super.configureShell(shell);
            shell.setText(WorkbenchPlugin.labels.getString(this.title));
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "configureShell(Shell shell)", e);
            logger.error(e);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        try {
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
            this.createButton(parent, 4, IDialogConstants.YES_TO_ALL_LABEL, false);
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, false);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createButtonsForButtonBar(Composite parent)", e);
            logger.error(e);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        try {
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            ConfirmationDialog.applyDialogFont((Control)composite);
            Image image = Display.getCurrent().getSystemImage(4);
            if (image != null) {
                Label imageLabel = new Label(composite, 0);
                image.setBackground(imageLabel.getBackground());
                imageLabel.setImage(image);
                GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)imageLabel);
            }
            Label messageLabel = new Label(composite, 64);
            messageLabel.setText(this.messageStr);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)messageLabel);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createDialogArea(Composite parent)", e);
            logger.error(e);
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        try {
            this.setReturnCode(buttonId);
            this.close();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "buttonPressed(int buttonId)", e);
            logger.error(e);
        }
    }
}

