/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.builder;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.builder.MessageDialogRunner;
import com.ibm.im.ims.workbench.builder.PopupMessageTester;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.ResourceTemplatesModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.TemplateModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.PlatformUI;

public class WorkbenchBuilder
extends IncrementalProjectBuilder {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private String projectName;
    private HashMap<String, DbdModel> dbdCache;
    private Vector<IFile> dbdFileList;
    private Vector<IFile> psbFileList;
    private HashSet<String> psbNamesToValidate;
    private Vector<String> missingConvInfoMsgs;
    private Vector<String> segsWithoutUserFieldsMsgs;
    private Vector<String> badPsbNameMsgs;
    private Vector<String> badPcbNameMsgs;
    private Vector<String> pcbWithoutNameMsgs;
    private Vector<String> psbMissingDbdMsgs;
    private Vector<String> fieldsDoNotFitMsgs;
    private Vector<String> noPcbsHaveNamesMsgs;
    private Vector<String> allDbdsAreMissingMsgs;
    private Vector<String> gsamNoSegm;
    public static final String PPEW = "PPEW_";
    public static final String EAWC = "EAWC_";
    public static final String MISSING_CONV_INFO = "MISSING_CONV_INFO";
    public static final String SEGS_WITHOUT_USER_FIELDS = "SEGS_WITHOUT_USER_FIELDS";
    public static final String BAD_PSB_NAME = "BAD_PSB_NAME";
    public static final String BAD_PCB_NAME = "BAD_PCB_NAME";
    public static final String PCB_WITHOUT_NAME = "PCB_WITHOUT_NAME";
    public static final String PSB_MISSING_DBD = "PSB_MISSING_DBD";
    public static final String FIELDS_DO_NOT_FIT = "FIELDS_DO_NOT_FIT";
    public static final String NO_PCBS_HAVE_NAMES = "NO_PCBS_HAVE_NAMES";
    public static final String ALL_DBDS_MISSING = "ALL_DBDS_MISSING";
    public static final String GSAM_NO_SEGM = "GSAM_NO_SEGM";
    private ResourceChangeListener resourceChangeListener = new ResourceChangeListener();

    public WorkbenchBuilder() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
    }

    private void init() {
        this.getDbdCache().clear();
        this.psbNamesToValidate = new HashSet();
        this.missingConvInfoMsgs = new Vector();
        this.segsWithoutUserFieldsMsgs = new Vector();
        this.badPsbNameMsgs = new Vector();
        this.badPcbNameMsgs = new Vector();
        this.pcbWithoutNameMsgs = new Vector();
        this.psbMissingDbdMsgs = new Vector();
        this.fieldsDoNotFitMsgs = new Vector();
        this.noPcbsHaveNamesMsgs = new Vector();
        this.allDbdsAreMissingMsgs = new Vector();
        this.gsamNoSegm = new Vector();
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        try {
            ProjectScope projectScope;
            IEclipsePreferences preferences;
            IResourceDelta delta;
            this.init();
            IProject project = this.getProject();
            this.projectName = project.getName();
            if (!this.projectName.equals("IMS_Explorer_Catalog_ReadOnly") && (delta = this.getDelta(project)) != null) {
                this.dbdFileList = new Vector();
                this.psbFileList = new Vector();
                this.populateDBDandPSBFileLists(delta.getAffectedChildren(5));
                if (this.dbdFileList.size() > 0) {
                    Vector<String> newChangedDbds = new Vector<String>();
                    int i = 0;
                    while (i < this.dbdFileList.size()) {
                        IFile currDbdFile = this.dbdFileList.get(i);
                        String currDbdFileName = currDbdFile.getName();
                        String currDbdName = currDbdFileName.substring(0, currDbdFileName.length() - 4);
                        newChangedDbds.add(currDbdName);
                        ++i;
                    }
                    List allAffectedPsbs = ProjectTreeFileHelper.findRelatedPSBNames((String)this.projectName, newChangedDbds, (IProgressMonitor)monitor, (List)ProjectTreeFileHelper.getPSBNamesInProject((String)this.projectName));
                    int i2 = 0;
                    while (i2 < allAffectedPsbs.size()) {
                        String currPsbName = (String)allAffectedPsbs.get(i2);
                        if (!this.psbNamesToValidate.contains(currPsbName)) {
                            this.psbNamesToValidate.add(currPsbName);
                        }
                        ++i2;
                    }
                }
                if (logger.isLoggable(Level.FINEST)) {
                    this.traceLeafResources();
                }
                if (this.dbdFileList.size() > 0 || this.psbFileList.size() > 0) {
                    this.build(monitor);
                }
            }
            if ((preferences = (projectScope = new ProjectScope(project)).getNode("com.ibm.im.ims.workbench")) != null) {
                preferences.sync();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "build(int kind, Map args, IProgressMonitor monitor)", e);
            logger.error(e);
        }
        return null;
    }

    private void build(IProgressMonitor monitor) throws CoreException, ModelException, JAXBException {
        int i = 0;
        while (i < this.dbdFileList.size()) {
            IFile currFile = this.dbdFileList.get(i);
            String fileName = currFile.getName();
            DbdModel dbdModel = this.getDbdModel(fileName.substring(0, fileName.length() - 4));
            this.validateDbd(currFile, dbdModel);
            ++i;
        }
        for (String currPsbName : this.psbNamesToValidate) {
            IFile currFile = this.getPsbFile(currPsbName);
            PsbModel psbModel = this.getPsbModel(currPsbName);
            this.validatePsb(currFile, psbModel);
        }
        this.popupMsgDialogs();
    }

    private void validatePsb(IFile currFile, PsbModel psbModel) throws CoreException, JAXBException, ModelException {
        currFile.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        ResourceTemplatesModel resourceTemplateModel = ProjectTreeFileHelper.unmarshallTemplate((String)this.projectName);
        ArrayList templates = resourceTemplateModel.getTemplateModels();
        String psbName = psbModel.getPsbName();
        if (!this.isValidIdentifier(psbName, templates)) {
            String dynamicPart = WorkbenchPlugin.colon.getString("COLON") + " " + psbName;
            String errMsg = this.createErrMsg(BAD_PSB_NAME, dynamicPart);
            Utility.reportProblem((IFile)currFile, (String)errMsg, (int)1);
            this.badPsbNameMsgs.add(psbName);
        }
        Vector<String> badPcbNames = new Vector<String>();
        List dbPcbList = psbModel.getDBPcbList();
        boolean allPcbNamesMissing = true;
        boolean atLeastOnePcbNameMissing = false;
        if (dbPcbList != null && !dbPcbList.isEmpty()) {
            String errMsg;
            String dynamicPart;
            int x = 0;
            while (x < dbPcbList.size()) {
                String pcbNameOrLabel = ((PcbDBModel)dbPcbList.get(x)).getPcbName();
                if (pcbNameOrLabel == null || pcbNameOrLabel.isEmpty()) {
                    pcbNameOrLabel = ((PcbDBModel)dbPcbList.get(x)).getLabel();
                }
                if (pcbNameOrLabel == null || pcbNameOrLabel.isEmpty()) {
                    atLeastOnePcbNameMissing = true;
                } else {
                    allPcbNamesMissing = false;
                    if (!this.isValidIdentifier(pcbNameOrLabel, templates)) {
                        badPcbNames.add(pcbNameOrLabel);
                    }
                }
                ++x;
            }
            Object pcbListStr = "PSB " + psbName + " - PCBs" + WorkbenchPlugin.colon.getString("COLON") + " ";
            if (badPcbNames.size() > 0) {
                int i = 0;
                while (i < badPcbNames.size()) {
                    String currPcbName = (String)badPcbNames.get(i);
                    pcbListStr = (String)pcbListStr + currPcbName + ", ";
                    ++i;
                }
                pcbListStr = ((String)pcbListStr).substring(0, ((String)pcbListStr).length() - 2);
                dynamicPart = WorkbenchPlugin.colon.getString("COLON") + " " + (String)pcbListStr;
                errMsg = this.createErrMsg(BAD_PCB_NAME, dynamicPart);
                Utility.reportProblem((IFile)currFile, (String)errMsg, (int)1);
                this.badPcbNameMsgs.add((String)pcbListStr);
            }
            if (allPcbNamesMissing) {
                dynamicPart = WorkbenchPlugin.colon.getString("COLON") + " " + psbName;
                errMsg = this.createErrMsg(NO_PCBS_HAVE_NAMES, dynamicPart);
                Utility.reportProblem((IFile)currFile, (String)errMsg, (int)2);
                this.noPcbsHaveNamesMsgs.add(psbName);
            } else if (atLeastOnePcbNameMissing) {
                dynamicPart = WorkbenchPlugin.colon.getString("COLON") + " " + psbName;
                errMsg = this.createErrMsg(PCB_WITHOUT_NAME, dynamicPart);
                Utility.reportProblem((IFile)currFile, (String)errMsg, (int)1);
                this.pcbWithoutNameMsgs.add(psbName);
            }
            pcbListStr = "PSB " + psbName + " - PCB -> DBD" + WorkbenchPlugin.colon.getString("COLON") + " ";
            boolean allDbdsMissing = true;
            boolean atLeastOneDbdMissing = false;
            int i = 0;
            while (i < dbPcbList.size()) {
                PcbDBModel currPcb = (PcbDBModel)dbPcbList.get(i);
                String currDbdName = currPcb.getDbdName();
                DbdModel currDbd = this.getDbdModel(currDbdName);
                if (currDbd == null) {
                    atLeastOneDbdMissing = true;
                    Object pcbNameOrLabel = ((PcbDBModel)dbPcbList.get(i)).getPcbName();
                    if (pcbNameOrLabel == null || ((String)pcbNameOrLabel).isEmpty()) {
                        pcbNameOrLabel = ((PcbDBModel)dbPcbList.get(i)).getLabel();
                    }
                    if (pcbNameOrLabel == null || ((String)pcbNameOrLabel).isEmpty()) {
                        pcbNameOrLabel = "dbpcb#" + (i + 1);
                    }
                    pcbListStr = (String)pcbListStr + (String)pcbNameOrLabel + " -> " + currDbdName + ", ";
                } else {
                    allDbdsMissing = false;
                }
                ++i;
            }
            if (allDbdsMissing) {
                String dynamicPart2 = WorkbenchPlugin.colon.getString("COLON") + " " + psbName;
                errMsg = this.createErrMsg(ALL_DBDS_MISSING, dynamicPart2);
                Utility.reportProblem((IFile)currFile, (String)errMsg, (int)2);
                this.allDbdsAreMissingMsgs.add(psbName);
            } else if (atLeastOneDbdMissing) {
                pcbListStr = ((String)pcbListStr).substring(0, ((String)pcbListStr).length() - 2);
                String dynamicPart3 = WorkbenchPlugin.colon.getString("COLON") + " " + (String)pcbListStr;
                errMsg = this.createErrMsg(PSB_MISSING_DBD, dynamicPart3);
                Utility.reportProblem((IFile)currFile, (String)errMsg, (int)1);
                this.psbMissingDbdMsgs.add((String)pcbListStr);
            }
        }
    }

    private boolean isValidIdentifier(String identifier, ArrayList<TemplateModel> templates) throws JAXBException {
        boolean retVal = true;
        String complianceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
        String sourceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
        if (!JavaConventions.validateIdentifier((String)identifier, (String)sourceLevel, (String)complianceLevel).isOK()) {
            retVal = false;
            boolean templateFixesId = false;
            if (templates.size() > 0) {
                int i = 0;
                while (i < templates.size()) {
                    String newPsbName;
                    TemplateModel currTemplate = templates.get(i);
                    String varStr = currTemplate.getVarString();
                    ArrayList repStrs = currTemplate.getRepStrings();
                    if (identifier.contains(varStr) && repStrs.size() > 0 && JavaConventions.validateIdentifier((String)(newPsbName = identifier.replaceFirst(varStr, (String)repStrs.get(0))), (String)sourceLevel, (String)complianceLevel).isOK()) {
                        templateFixesId = true;
                        break;
                    }
                    ++i;
                }
            }
            if (templateFixesId) {
                retVal = true;
            }
        }
        return retVal;
    }

    private IFile getPsbFile(String psbName) throws CoreException {
        IFile retVal = null;
        if (this.psbFileList.size() > 0) {
            int i = 0;
            while (i < this.psbFileList.size()) {
                IFile currFile = this.psbFileList.get(i);
                String currFileName = currFile.getName();
                if (psbName.equals(currFileName = currFileName.substring(0, currFileName.length() - 4))) {
                    retVal = currFile;
                    break;
                }
                ++i;
            }
        }
        if (retVal == null) {
            retVal = ProjectTreeFileHelper.getPsbMetadataFile((String)this.projectName, (String)psbName);
        }
        return retVal;
    }

    private void popupMsgDialogs() {
        MessageDialogRunner mdr;
        Object msgStr;
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        PopupMessageTester msgTester = PopupMessageTester.getSingletonInstance();
        if (this.fieldsDoNotFitMsgs.size() > 0 && !store.getBoolean(FIELDS_DO_NOT_FIT) && !msgTester.testAndSetMessageDisplayed(FIELDS_DO_NOT_FIT, true)) {
            msgStr = "";
            int i = 0;
            while (i < this.fieldsDoNotFitMsgs.size()) {
                msgStr = (String)msgStr + this.fieldsDoNotFitMsgs.get(i) + "\n";
                ++i;
            }
            mdr = new MessageDialogRunner(FIELDS_DO_NOT_FIT, (String)msgStr);
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)mdr);
        }
        if (this.noPcbsHaveNamesMsgs.size() > 0 && !store.getBoolean(NO_PCBS_HAVE_NAMES) && !msgTester.testAndSetMessageDisplayed(NO_PCBS_HAVE_NAMES, true)) {
            msgStr = "";
            int i = 0;
            while (i < this.noPcbsHaveNamesMsgs.size()) {
                msgStr = (String)msgStr + this.noPcbsHaveNamesMsgs.get(i) + "\n";
                ++i;
            }
            mdr = new MessageDialogRunner(NO_PCBS_HAVE_NAMES, (String)msgStr);
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)mdr);
        }
        if (this.allDbdsAreMissingMsgs.size() > 0 && !store.getBoolean(ALL_DBDS_MISSING) && store.getBoolean("explorer_enable_ims_jdbc") && !msgTester.testAndSetMessageDisplayed(ALL_DBDS_MISSING, true)) {
            msgStr = "";
            int i = 0;
            while (i < this.allDbdsAreMissingMsgs.size()) {
                msgStr = (String)msgStr + this.allDbdsAreMissingMsgs.get(i) + "\n";
                ++i;
            }
            mdr = new MessageDialogRunner(ALL_DBDS_MISSING, (String)msgStr);
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)mdr);
        }
        if (this.missingConvInfoMsgs.size() > 0 && !store.getBoolean(MISSING_CONV_INFO) && !msgTester.testAndSetMessageDisplayed(MISSING_CONV_INFO, true)) {
            msgStr = "";
            int i = 0;
            while (i < this.missingConvInfoMsgs.size()) {
                msgStr = (String)msgStr + this.missingConvInfoMsgs.get(i) + "\n";
                ++i;
            }
            mdr = new MessageDialogRunner(MISSING_CONV_INFO, (String)msgStr);
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)mdr);
        }
        if (this.segsWithoutUserFieldsMsgs.size() > 0 && !store.getBoolean(SEGS_WITHOUT_USER_FIELDS) && !msgTester.testAndSetMessageDisplayed(SEGS_WITHOUT_USER_FIELDS, true)) {
            msgStr = "";
            int i = 0;
            while (i < this.segsWithoutUserFieldsMsgs.size()) {
                msgStr = (String)msgStr + this.segsWithoutUserFieldsMsgs.get(i) + "\n";
                ++i;
            }
            mdr = new MessageDialogRunner(SEGS_WITHOUT_USER_FIELDS, (String)msgStr);
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)mdr);
        }
        if (this.badPsbNameMsgs.size() > 0 && !store.getBoolean(BAD_PSB_NAME) && store.getBoolean("explorer_enable_ims_jdbc") && !msgTester.testAndSetMessageDisplayed(BAD_PSB_NAME, true)) {
            msgStr = "";
            int i = 0;
            while (i < this.badPsbNameMsgs.size()) {
                msgStr = (String)msgStr + this.badPsbNameMsgs.get(i) + "\n";
                ++i;
            }
            mdr = new MessageDialogRunner(BAD_PSB_NAME, (String)msgStr);
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)mdr);
        }
        if (this.badPcbNameMsgs.size() > 0 && !store.getBoolean(BAD_PCB_NAME) && store.getBoolean("explorer_enable_ims_jdbc") && !msgTester.testAndSetMessageDisplayed(BAD_PCB_NAME, true)) {
            msgStr = "";
            int i = 0;
            while (i < this.badPcbNameMsgs.size()) {
                msgStr = (String)msgStr + this.badPcbNameMsgs.get(i) + "\n";
                ++i;
            }
            mdr = new MessageDialogRunner(BAD_PCB_NAME, (String)msgStr);
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)mdr);
        }
        if (this.pcbWithoutNameMsgs.size() > 0 && !store.getBoolean(PCB_WITHOUT_NAME) && !msgTester.testAndSetMessageDisplayed(PCB_WITHOUT_NAME, true)) {
            msgStr = "";
            int i = 0;
            while (i < this.pcbWithoutNameMsgs.size()) {
                msgStr = (String)msgStr + this.pcbWithoutNameMsgs.get(i) + "\n";
                ++i;
            }
            mdr = new MessageDialogRunner(PCB_WITHOUT_NAME, (String)msgStr);
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)mdr);
        }
        if (this.psbMissingDbdMsgs.size() > 0 && !store.getBoolean(PSB_MISSING_DBD) && store.getBoolean("explorer_enable_ims_jdbc") && !msgTester.testAndSetMessageDisplayed(PSB_MISSING_DBD, true)) {
            msgStr = "";
            int i = 0;
            while (i < this.psbMissingDbdMsgs.size()) {
                msgStr = (String)msgStr + this.psbMissingDbdMsgs.get(i) + "\n";
                ++i;
            }
            mdr = new MessageDialogRunner(PSB_MISSING_DBD, (String)msgStr);
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)mdr);
        }
        if (this.gsamNoSegm.size() > 0 && !store.getBoolean(GSAM_NO_SEGM) && !msgTester.testAndSetMessageDisplayed(GSAM_NO_SEGM, true)) {
            msgStr = "";
            int i = 0;
            while (i < this.gsamNoSegm.size()) {
                msgStr = (String)msgStr + this.gsamNoSegm.get(i) + "\n";
                ++i;
            }
            MessageDialogRunner mdr2 = new MessageDialogRunner(GSAM_NO_SEGM, (String)msgStr);
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)mdr2);
        }
    }

    private void validateDbd(IFile currFile, DbdModel dbdModel) throws CoreException, ModelException {
        currFile.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        SegmentModel rootSeg = dbdModel.getRootSegment();
        Vector<FieldModel> fieldsDoNotFit = new Vector<FieldModel>();
        Vector<FieldModel> fieldsMissingConvInfo = new Vector<FieldModel>();
        Vector<SegmentModel> segsWithoutUserFields = new Vector<SegmentModel>();
        if (rootSeg != null) {
            this.recursiveValidateSegment(currFile, rootSeg, fieldsMissingConvInfo, segsWithoutUserFields, fieldsDoNotFit);
        } else if (dbdModel.getAccessType() == DBDConstants.GSAM) {
            String dynamicPart = WorkbenchPlugin.colon.getString("COLON") + " " + dbdModel.getDBDName();
            String errMsg = this.createErrMsg(GSAM_NO_SEGM, dynamicPart);
            Utility.reportProblem((IFile)currFile, (String)errMsg, (int)0);
            this.gsamNoSegm.add(dbdModel.getDBDName());
        }
        this.reportFieldsDoNotFit(fieldsDoNotFit, currFile, dbdModel);
        this.reportMissingConvInfo(fieldsMissingConvInfo, currFile, dbdModel);
        this.reportSegsWithoutUserFields(segsWithoutUserFields, currFile, dbdModel);
    }

    private void reportSegsWithoutUserFields(Vector<SegmentModel> segsWithoutUserFields, IFile currFile, DbdModel dbdModel) throws CoreException {
        if (segsWithoutUserFields.size() > 0) {
            Object segListStr = "DBD " + dbdModel.getDBDName() + " - Segments" + WorkbenchPlugin.colon.getString("COLON") + " ";
            int i = 0;
            while (i < segsWithoutUserFields.size()) {
                String currSeg = segsWithoutUserFields.get(i).getName();
                segListStr = (String)segListStr + currSeg + ", ";
                ++i;
            }
            segListStr = ((String)segListStr).substring(0, ((String)segListStr).length() - 2);
            String dynamicPart = WorkbenchPlugin.colon.getString("COLON") + " " + (String)segListStr;
            String errMsg = this.createErrMsg(SEGS_WITHOUT_USER_FIELDS, dynamicPart);
            Utility.reportProblem((IFile)currFile, (String)errMsg, (int)1);
            this.segsWithoutUserFieldsMsgs.add((String)segListStr);
        }
    }

    private void reportMissingConvInfo(Vector<FieldModel> fieldsMissingConvInfo, IFile currFile, DbdModel dbdModel) throws CoreException {
        if (fieldsMissingConvInfo.size() > 0) {
            String dbdStr = "DBD " + dbdModel.getDBDName();
            SegmentModel currSegment = fieldsMissingConvInfo.get(0).getSegmentModel();
            Object fieldListStr = dbdStr + " - Segment " + currSegment.getName() + " - FIELDs" + WorkbenchPlugin.colon.getString("COLON") + " ";
            int indexOfLastReportedProblem = -1;
            int i = 0;
            while (i < fieldsMissingConvInfo.size()) {
                FieldModel currField = fieldsMissingConvInfo.get(i);
                SegmentModel nextSegment = currField.getSegmentModel();
                if (currSegment != nextSegment) {
                    fieldListStr = ((String)fieldListStr).substring(0, ((String)fieldListStr).length() - 2);
                    String dynamicPart = WorkbenchPlugin.colon.getString("COLON") + " " + (String)fieldListStr;
                    String errMsg = this.createErrMsg(MISSING_CONV_INFO, dynamicPart);
                    indexOfLastReportedProblem = i - 1;
                    Utility.reportProblem((IFile)currFile, (String)errMsg, (int)1);
                    this.missingConvInfoMsgs.add((String)fieldListStr);
                    currSegment = nextSegment;
                    fieldListStr = dbdStr + " - Segment " + currSegment.getName() + " - FIELDs" + WorkbenchPlugin.colon.getString("COLON") + " " + currField.getName() + ", ";
                } else {
                    fieldListStr = (String)fieldListStr + currField.getName() + ", ";
                }
                ++i;
            }
            if (indexOfLastReportedProblem < fieldsMissingConvInfo.size() - 1) {
                fieldListStr = ((String)fieldListStr).substring(0, ((String)fieldListStr).length() - 2);
                String dynamicPart = WorkbenchPlugin.colon.getString("COLON") + " " + (String)fieldListStr;
                String errMsg = this.createErrMsg(MISSING_CONV_INFO, dynamicPart);
                Utility.reportProblem((IFile)currFile, (String)errMsg, (int)1);
                this.missingConvInfoMsgs.add((String)fieldListStr);
            }
        }
    }

    private void reportFieldsDoNotFit(Vector<FieldModel> fieldsDoNotFit, IFile currFile, DbdModel dbdModel) throws CoreException {
        if (fieldsDoNotFit.size() > 0) {
            String dbdStr = "DBD " + dbdModel.getDBDName();
            SegmentModel currSegment = fieldsDoNotFit.get(0).getSegmentModel();
            Object fieldListStr = dbdStr + " - Segment " + currSegment.getName() + " - FIELDs" + WorkbenchPlugin.colon.getString("COLON") + " ";
            int indexOfLastReportedProblem = -1;
            int i = 0;
            while (i < fieldsDoNotFit.size()) {
                FieldModel currField = fieldsDoNotFit.get(i);
                SegmentModel nextSegment = currField.getSegmentModel();
                if (currSegment != nextSegment) {
                    fieldListStr = ((String)fieldListStr).substring(0, ((String)fieldListStr).length() - 2);
                    String dynamicPart = WorkbenchPlugin.colon.getString("COLON") + " " + (String)fieldListStr;
                    String errMsg = this.createErrMsg(FIELDS_DO_NOT_FIT, dynamicPart);
                    indexOfLastReportedProblem = i - 1;
                    Utility.reportProblem((IFile)currFile, (String)errMsg, (int)2);
                    this.fieldsDoNotFitMsgs.add((String)fieldListStr);
                    currSegment = nextSegment;
                    fieldListStr = dbdStr + " - Segment " + currSegment.getName() + " - FIELDs" + WorkbenchPlugin.colon.getString("COLON") + " " + currField.getName() + ", ";
                } else {
                    fieldListStr = (String)fieldListStr + currField.getName() + ", ";
                }
                ++i;
            }
            if (indexOfLastReportedProblem < fieldsDoNotFit.size() - 1) {
                fieldListStr = ((String)fieldListStr).substring(0, ((String)fieldListStr).length() - 2);
                String dynamicPart = WorkbenchPlugin.colon.getString("COLON") + " " + (String)fieldListStr;
                String errMsg = this.createErrMsg(FIELDS_DO_NOT_FIT, dynamicPart);
                Utility.reportProblem((IFile)currFile, (String)errMsg, (int)2);
                this.fieldsDoNotFitMsgs.add((String)fieldListStr);
            }
        }
    }

    private String createErrMsg(String type, String dynamicPart) {
        String retVal = null;
        retVal = WorkbenchModelBundle.getNoXlatLabel().getString(EAWC + type) + " - " + WorkbenchModelBundle.getError().getString(PPEW + type) + dynamicPart;
        return retVal;
    }

    private void recursiveValidateSegment(IFile currFile, SegmentModel segment, Vector<FieldModel> fieldsMissingConvInfo, Vector<SegmentModel> segsWithoutUserFields, Vector<FieldModel> fieldsDoNotFit) throws ModelException {
        Vector fieldList = segment.getFieldList(false, false);
        boolean userDefinedFieldExists = false;
        int i = 0;
        while (i < fieldList.size()) {
            DBDConstants appDataType;
            FieldModel currField = (FieldModel)fieldList.get(i);
            if (!currField.isIMSField()) {
                userDefinedFieldExists = true;
            }
            if (!segment.isVirtualLogicalChild() && !Utility.isFieldFit((SegmentModel)segment, (FieldModel)currField)) {
                fieldsDoNotFit.add(currField);
            }
            if ((appDataType = currField.getAppDatatype()) == DBDConstants.DATE || appDataType == DBDConstants.TIME || appDataType == DBDConstants.TIMESTAMP) {
                String datePattern = currField.getPattern();
                if ((datePattern == null || datePattern.isEmpty()) && ((userConverter = currField.getUserTypeConverter()) == null || userConverter.isEmpty())) {
                    fieldsMissingConvInfo.add(currField);
                }
            } else if (appDataType == DBDConstants.DECIMAL) {
                DBDConstants physDataType = currField.getPhysicalDataType();
                if (physDataType == null || physDataType == DBDConstants.PACKEDDECIMAL || physDataType == DBDConstants.ZONEDDECIMAL || physDataType == DBDConstants.BINARY) {
                    if (physDataType != null) {
                        String decimalPattern = currField.getDecimalPattern();
                        if (decimalPattern == null || decimalPattern.isEmpty()) {
                            fieldsMissingConvInfo.add(currField);
                        }
                    } else {
                        userConverter = currField.getUserTypeConverter();
                        if (userConverter == null || userConverter.isEmpty()) {
                            fieldsMissingConvInfo.add(currField);
                        }
                    }
                }
            } else if (appDataType == DBDConstants.BINARY && currField.getImsDatatype() == DBDConstants.P) {
                fieldsMissingConvInfo.add(currField);
            }
            ++i;
        }
        if (!userDefinedFieldExists) {
            segsWithoutUserFields.add(segment);
        }
        List childSegments = segment.getChildSegments();
        int i2 = 0;
        while (i2 < childSegments.size()) {
            SegmentModel currChildSegment = (SegmentModel)childSegments.get(i2);
            this.recursiveValidateSegment(currFile, currChildSegment, fieldsMissingConvInfo, segsWithoutUserFields, fieldsDoNotFit);
            ++i2;
        }
    }

    private DbdModel getDbdModel(String dbdName) throws CoreException, ModelException {
        IFile dbdFile;
        DbdModel retVal = null;
        retVal = this.getDbdCache().get(dbdName);
        if (retVal == null && (dbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)this.projectName, (String)dbdName)).exists()) {
            retVal = new DbdModel(dbdFile.getContents());
            this.getDbdCache().put(dbdName, retVal);
        }
        return retVal;
    }

    private PsbModel getPsbModel(String psbName) throws CoreException, ModelException {
        IFile psbFile = ProjectTreeFileHelper.getPsbMetadataFile((String)this.projectName, (String)psbName);
        return new PsbModel(psbFile.getContents());
    }

    private HashMap<String, DbdModel> getDbdCache() {
        if (this.dbdCache == null) {
            this.dbdCache = new HashMap();
        }
        return this.dbdCache;
    }

    private void populateDBDandPSBFileLists(IResourceDelta[] children) throws FileNotFoundException, CoreException, ModelException {
        int i = 0;
        while (i < children.length) {
            String ext;
            IResource currRsrc;
            IPath path = children[i].getProjectRelativePath();
            String lastSegment = path.lastSegment();
            if (lastSegment.equals("WFM")) {
                return;
            }
            IResourceDelta[] childrenOfThisChild = children[i].getAffectedChildren(5);
            if (childrenOfThisChild.length > 0) {
                this.populateDBDandPSBFileLists(childrenOfThisChild);
            } else if (childrenOfThisChild.length == 0 && (currRsrc = children[i].getResource()) instanceof IFile && !currRsrc.isDerived() && (ext = currRsrc.getFileExtension()) != null) {
                if (ext.equals("dbd")) {
                    this.dbdFileList.add((IFile)currRsrc);
                } else if (ext.equals("psb")) {
                    IFile currPsbFile = (IFile)currRsrc;
                    this.psbFileList.add(currPsbFile);
                    String currPsbFileName = currPsbFile.getName();
                    this.psbNamesToValidate.add(currPsbFileName.substring(0, currPsbFileName.length() - 4));
                }
            }
            ++i;
        }
    }

    private void traceLeafResources() {
        IResource currRsrc;
        logger.finest("IMS Explorer builder called with " + this.dbdFileList.size() + " DBDs and " + this.psbFileList.size() + " PSBs.");
        int i = 0;
        while (i < this.dbdFileList.size()) {
            currRsrc = (IResource)this.dbdFileList.get(i);
            logger.finest(currRsrc.toString());
            ++i;
        }
        i = 0;
        while (i < this.psbFileList.size()) {
            currRsrc = (IResource)this.psbFileList.get(i);
            logger.finest(currRsrc.toString());
            ++i;
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException e) {
                logger.error((Throwable)e);
            }
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !(delta.getResource() instanceof IProject)) {
                return true;
            }
            IProject project = (IProject)delta.getResource();
            if (!project.isOpen()) {
                return true;
            }
            if (!(delta.getKind() == 2 || delta.getKind() == 1 && delta.getMovedFromPath() != null || delta.getKind() == 4 && delta.getMovedToPath() == null)) {
                try {
                    ProjectTreeFileHelper.clearUUIDForProject((IProject)project, (String)"com.ibm.im.ims.workbench");
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
            return false;
        }
    }
}

