/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.builder;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.builder.PopupMessageTester;
import com.ibm.im.ims.workbench.builder.Warnings;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.ui.PlatformUI;

public class MessageDialogRunner
implements Runnable {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Warnings warnings;
    private String dynamicMessage;
    private String warningType;
    private static final String PPEW_PREFIX = "PPEW_";
    private static final String BFDM_PREFIX = "BFDM_";
    private static final String EAWC = "EAWC_";

    public MessageDialogRunner(String warningType, String dynamicMessage) {
        this.dynamicMessage = dynamicMessage;
        this.warningType = warningType;
    }

    @Override
    public void run() {
        int severity = 4;
        Object[] inserts = new Object[]{new String(Character.toChars(8482))};
        String fullDialogWarningMsg = WorkbenchPlugin.noxlatlabels.getString(EAWC + this.warningType) + " - " + WorkbenchPlugin.errors.getString(PPEW_PREFIX + this.warningType) + ".\n\n" + WorkbenchPlugin.errors.getString(BFDM_PREFIX + this.warningType, inserts);
        if (this.warningType.equals("FIELDS_DO_NOT_FIT")) {
            severity = 1;
        } else if (this.warningType.equals("NO_PCBS_HAVE_NAMES")) {
            severity = 1;
        } else if (this.warningType.equals("ALL_DBDS_MISSING")) {
            severity = 1;
        } else if (this.warningType.equals("GSAM_NO_SEGM")) {
            severity = 2;
        }
        this.warnings = new Warnings(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), WorkbenchPlugin.labels.getString("WDT_DIALOG_TITLE"), null, fullDialogWarningMsg, severity, new String[]{IDialogConstants.OK_LABEL}, 0);
        this.warnings.setWarnings(this.dynamicMessage);
        this.warnings.setWarningType(this.warningType);
        this.warnings.open();
        PopupMessageTester msgTester = PopupMessageTester.getSingletonInstance();
        msgTester.testAndSetMessageDisplayed(this.warningType, false);
    }
}

