/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench;

import com.ibm.etools.zusage.core.UsagePlugin;
import com.ibm.etools.zusage.core.model.IOfferingUsageRegistry;
import com.ibm.im.ims.workbench.editors.figures.FigureConstants;
import com.ibm.im.ims.workbench.editors.preferences.GetNodePreferences;
import com.ibm.im.ims.workbench.perspective.IMSPerspectiveAdapter;
import com.ibm.im.ims.workbench.resources.utilities.BundleHelper;
import com.ibm.im.ims.workbench.resources.utilities.MessageBundleWithInserts;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityEvent;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityListener;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class WorkbenchPlugin
extends AbstractUIPlugin {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static final String COM_IBM_CICS_EXPLORER_CAPABILITY_DEFAULTS_SET = "com.ibm.cics.explorer.capability.defaults.set";
    private static final String COM_IBM_CICS_EXPLORER_SYSTEMADMIN = "com.ibm.cics.explorer.systemadmin.activity";
    private static final String COM_IBM_CICS_EXPLORER_DEVELOPER = "com.ibm.cics.explorer.developer.activity";
    private static final String COM_IBM_CICS_EXPLORER_REQUIRED_ACTIVITIES = "com.ibm.cics.explorer.required.activities";
    private IWorkbenchActivitySupport workbenchActivitySupport;
    private IActivityManager activityManager;
    private String[] activities;
    private boolean[] forcedActivities;
    private static WorkbenchPlugin plugin;
    public static ResourceBundle icons;
    public static ResourceBundle noxlatlabels;
    public static MessageBundleWithInserts errors;
    public static MessageBundleWithInserts labels;
    public static MessageBundleWithInserts descriptions;
    public static MessageBundleWithInserts colon;
    public static final String PLUGIN_ID = "com.ibm.im.ims.workbench";
    public static final String NewProjectWizard = ".NewProjectWizard";
    public static final String NewPSBWizard = ".ies1_wb_createpsb";
    public static final String ImportResourceWizard = ".ImportResourceWizard";
    public static final String ImportDLIModelWizard = ".ies1_wb_dmumigration1";
    public static final String NewDatabaseConnection = ".ies1_wb_newconnection";
    public static final String ProjectExplorer = ".ies1_wb_projectexplorer";
    public static final String DBDEditor = ".DBDEditorView";
    public static final String CreateNewPHIDAMWizard = ".CreateNewPHIDAMWizard";
    public static final String DBD_EDITOR_ID = "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorDbd";
    public static final String WFM_EDITOR_ID = "com.ibm.im.ims.catalog.ui.workflow.WorkflowManager";
    public static final String SubmitChangesToIMS = ".wb_submittoims";
    private static String[] overLayFolderNames;
    public static final String OFFERING_ID = "5655TDA";
    public static final String OFFERING_NAME = "IBM IMS Enterprise Suite Explorer for Development";

    public WorkbenchPlugin() {
        try {
            plugin = this;
            errors = new MessageBundleWithInserts("com.ibm.im.ims.workbench.resources.properties.Errors");
            icons = BundleHelper.getResourceBundle((String)"com.ibm.im.ims.workbench.resources.properties.Icons");
            descriptions = new MessageBundleWithInserts("com.ibm.im.ims.workbench.resources.properties.Descriptions");
            noxlatlabels = BundleHelper.getResourceBundle((String)"com.ibm.im.ims.workbench.resources.properties.NoXlatLabels");
            labels = new MessageBundleWithInserts("com.ibm.im.ims.workbench.resources.properties.Labels");
            colon = new MessageBundleWithInserts("com.ibm.im.ims.workbench.resources.properties.Colon");
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    public static WorkbenchPlugin getDefault() {
        return plugin;
    }

    public static String[] getOverlayFolderNames() {
        return overLayFolderNames;
    }

    public static String[] addNewOverlayFolderName(String newFolderName) {
        if (overLayFolderNames == null) {
            overLayFolderNames = new String[1];
            WorkbenchPlugin.overLayFolderNames[0] = newFolderName;
        } else {
            int oldLength = overLayFolderNames.length;
            String[] newItems = new String[oldLength + 1];
            System.arraycopy(overLayFolderNames, 0, newItems, 0, oldLength);
            newItems[oldLength] = newFolderName;
            overLayFolderNames = newItems;
        }
        return overLayFolderNames;
    }

    public void start(BundleContext context) throws Exception {
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(((Object)((Object)this)).getClass().getName(), "start(BundleContext context)", new Object[0]);
            }
            super.start(context);
            IOfferingUsageRegistry usageRegistry = UsagePlugin.getOfferingRegistry();
            usageRegistry.findOrRegisterOffering(OFFERING_ID, OFFERING_NAME);
            while (!PlatformUI.isWorkbenchRunning()) {
                Thread.sleep(2000L);
            }
            this.workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
            this.activityManager = this.workbenchActivitySupport.getActivityManager();
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                window.addPerspectiveListener((IPerspectiveListener)new IMSPerspectiveAdapter());
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(((Object)((Object)this)).getClass().getName(), "start(BundleContext context)", new Object[0]);
            }
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    public DialogSettings getGlobalDialogSettings() {
        return (DialogSettings)this.getDialogSettings();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(((Object)((Object)this)).getClass().getName(), "stop(BundleContext context)", new Object[0]);
            }
            super.stop(context);
            plugin = null;
            labels = null;
            icons = null;
            errors = null;
            descriptions = null;
            noxlatlabels = null;
            colon = null;
            GetNodePreferences.dispose();
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(((Object)((Object)this)).getClass().getName(), "stop(BundleContext context)", new Object[0]);
            }
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    private void setCapabilityDefaults() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        String requiredActivities = preferenceStore.getString(COM_IBM_CICS_EXPLORER_REQUIRED_ACTIVITIES);
        if (requiredActivities != null && !requiredActivities.equals("")) {
            this.activities = requiredActivities.split(",\\s+");
            this.forcedActivities = new boolean[this.activities.length];
            int i = 0;
            while (i < this.activities.length) {
                if (this.activities[i].charAt(0) == '@') {
                    this.activities[i] = this.activities[i].substring(1);
                    this.forcedActivities[i] = true;
                    IActivity devActivity = this.activityManager.getActivity(this.activities[i]);
                    if (devActivity != null) {
                        devActivity.addActivityListener(new IActivityListener(){

                            public void activityChanged(ActivityEvent activityEvent) {
                                IActivity activity = activityEvent.getActivity();
                                if (!activity.isEnabled()) {
                                    int i = 0;
                                    while (i < WorkbenchPlugin.this.activities.length) {
                                        if (activity.getId().equals(WorkbenchPlugin.this.activities[i])) {
                                            if (!WorkbenchPlugin.this.forcedActivities[i]) break;
                                            HashSet<String> enabledActivityIds = new HashSet<String>(WorkbenchPlugin.this.activityManager.getEnabledActivityIds());
                                            enabledActivityIds.add(WorkbenchPlugin.this.activities[i]);
                                            WorkbenchPlugin.this.workbenchActivitySupport.setEnabledActivityIds(enabledActivityIds);
                                            break;
                                        }
                                        ++i;
                                    }
                                }
                            }
                        });
                    }
                } else {
                    this.forcedActivities[i] = false;
                }
                ++i;
            }
        }
        if (preferenceStore.getString(COM_IBM_CICS_EXPLORER_CAPABILITY_DEFAULTS_SET).equals("")) {
            HashSet<String> enabledActivityIds = new HashSet<String>(this.activityManager.getEnabledActivityIds());
            if (requiredActivities == null || requiredActivities.equals("")) {
                enabledActivityIds.add(COM_IBM_CICS_EXPLORER_DEVELOPER);
                enabledActivityIds.add(COM_IBM_CICS_EXPLORER_SYSTEMADMIN);
            } else {
                int i = 0;
                while (i < this.activities.length) {
                    enabledActivityIds.add(this.activities[i]);
                    ++i;
                }
            }
            this.workbenchActivitySupport.setEnabledActivityIds(enabledActivityIds);
            preferenceStore.setValue(COM_IBM_CICS_EXPLORER_CAPABILITY_DEFAULTS_SET, COM_IBM_CICS_EXPLORER_CAPABILITY_DEFAULTS_SET);
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store = WorkbenchPlugin.getDefault().getPreferenceStore();
        store.setDefault("explorer_dbd_label_color", StringConverter.asString((RGB)FigureConstants.DBD_LABEL_COLOR));
        store.setDefault("explorer_dbd_background_color", StringConverter.asString((RGB)FigureConstants.DBD_BACKGROUND_COLOR));
        store.setDefault("explorer_segment_color", StringConverter.asString((RGB)FigureConstants.SEGM_LABEL_COLOR));
        store.setDefault("explorer_field_color", StringConverter.asString((RGB)FigureConstants.FIELD_LABEL_COLOR));
        store.setDefault("explorer_field_selected_color", StringConverter.asString((RGB)FigureConstants.FIELD_SELECTED_COLOR));
        store.setDefault("explorer_connection_physical_color", StringConverter.asString((RGB)FigureConstants.CONNECTION_PHYSICAL_COLOR));
        store.setDefault("explorer_connection_logical_color", StringConverter.asString((RGB)FigureConstants.CONNECTION_LOGICAL_COLOR));
        store.setDefault("explorer_selected_connection_logical_color", StringConverter.asString((RGB)FigureConstants.CONNECTION_SELECTED_LOGICAL_COLOR));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"explorer_dbd_font", (FontData)new FontData("Tahoma", 12, 1));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"explorer_segment_font", (FontData)new FontData("Tahoma", 10, 1));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"explorer_field_font", (FontData)new FontData("Tahoma", 10, 0));
        store.setDefault("explorer_segment_expand_all_flag", false);
        store.setDefault("explorer_wizard_skip_warning_flag", false);
        store.setDefault("explorer_enable_ims_jdbc", false);
        store.setDefault("explorer_dbd_encoding_selection", "Cp1047");
        store.setDefault("EDITORS_READ_ONLY", false);
        store.setDefault("WFM_DS_IMPORT_WARNING", false);
        store.setDefault("EDITORS_SENSEG_WARNING", false);
        store.setDefault("MISSING_CONV_INFO", false);
        store.setDefault("SEGS_WITHOUT_USER_FIELDS", false);
        store.setDefault("BAD_PSB_NAME", false);
        store.setDefault("BAD_PCB_NAME", false);
        store.setDefault("PCB_WITHOUT_NAME", false);
        store.setDefault("PSB_MISSING_DBD", false);
        store.setDefault("FIELDS_DO_NOT_FIT", false);
        store.setDefault("NO_PCBS_HAVE_NAMES", false);
        store.setDefault("ALL_DBDS_MISSING", false);
        store.setDefault("DDL_SUCCESSFULLY_RAN", false);
        store.setDefault("GSAM_NO_SEGM", false);
    }
}

