/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.workflow.util;

import com.ibm.im.ims.catalog.ui.workflow.FieldImportWorkflowXViewer;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDBD;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDataStructureType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowMapCaseType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowSegmentType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowSelectedDataStructureType;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowController;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowModelUtil;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class FieldImportWorkflowCandidateSelectionListener
implements SelectionListener {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private MenuItem menuItem;
    private TreeItem treeItem;
    private FieldImportWorkflowXViewer workflowXViewer;
    private FieldImportWorkflowController workflowController;

    public FieldImportWorkflowCandidateSelectionListener(FieldImportWorkflowXViewer xViewer, MenuItem menuItem, TreeItem treeItem) {
        this.workflowXViewer = xViewer;
        this.menuItem = menuItem;
        this.treeItem = treeItem;
        this.workflowController = this.workflowXViewer.getWorkflowController();
    }

    public void widgetDefaultSelected(SelectionEvent se) {
        this.widgetSelected(se);
    }

    public void widgetSelected(SelectionEvent se) {
        block16: {
            WorkflowDBD workflowDBD = null;
            try {
                WorkflowMapCaseType workflowMapCase = (WorkflowMapCaseType)this.treeItem.getData();
                WorkflowSegmentType workflowSegment = workflowMapCase.getParent();
                workflowDBD = workflowSegment.getParent();
                String dsName = this.menuItem.getText();
                WorkflowSelectedDataStructureType selectedDs = workflowMapCase.getWorkflowSelectedDataStructure();
                String selectedDsName = null;
                boolean sameDs = false;
                if (selectedDs != null) {
                    selectedDsName = selectedDs.getName();
                }
                if (dsName != null && !dsName.isEmpty() && dsName.equals(selectedDsName)) {
                    sameDs = true;
                } else if (selectedDsName == null && dsName.isEmpty()) {
                    sameDs = true;
                }
                if (sameDs) break block16;
                if (!this.workflowXViewer.checkIfDbdIsLocked(workflowDBD, true)) {
                    workflowDBD = null;
                    return;
                }
                try {
                    this.workflowController.acquireDBDLock(workflowDBD.getName());
                    String dbdName = workflowDBD.getName();
                    String projectName = this.workflowController.getProjectName();
                    IFile origDbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)dbdName);
                    boolean isDirty = false;
                    boolean saveConfirm = false;
                    IEditorPart currEditor = com.ibm.im.ims.workbench.model.utilities.Utility.getDirtyEditor((IFile)origDbdFile, (String)projectName);
                    isDirty = com.ibm.im.ims.workbench.model.utilities.Utility.isEditorDirty((IFile)origDbdFile, (String)projectName);
                    if (isDirty && (saveConfirm = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"WARNING", (String)"This DBD is open and currently being used by IMS DBD Editor in another tab. \nDo you want to save your changes before continuing?"))) {
                        NullProgressMonitor nullMonitor = new NullProgressMonitor();
                        currEditor.doSave((IProgressMonitor)nullMonitor);
                    }
                    WorkflowDataStructureType workflowCandidateDS = null;
                    WorkflowSelectedDataStructureType workflowSelectedDS = null;
                    if (!isDirty || saveConfirm) {
                        if (this.menuItem.getData() != null) {
                            workflowCandidateDS = (WorkflowDataStructureType)this.menuItem.getData();
                            workflowSelectedDS = new WorkflowSelectedDataStructureType();
                            workflowSelectedDS.setName(workflowCandidateDS.getName());
                            workflowSelectedDS.setLocation(workflowCandidateDS.getLocation());
                        }
                        this.workflowController.importDataStructure(workflowMapCase, workflowCandidateDS, Utility.isJDBCEnable());
                        workflowMapCase.setWorkflowSelectedDataStructure(workflowSelectedDS);
                        this.workflowController.saveWorkflowDBD(workflowDBD);
                        this.workflowController.refreshDSEConnections();
                        IFile dbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)this.workflowController.getProjectName(), (String)workflowDBD.getName());
                        boolean editorWasOpen = com.ibm.im.ims.workbench.model.utilities.Utility.closeOpenedEditorForResourceFile((IFile)dbdFile, (String)this.workflowController.getProjectName());
                        if (editorWasOpen) {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            IWorkbenchPage page = window.getActivePage();
                            page.openEditor((IEditorInput)new FileEditorInput(dbdFile), "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorDbd");
                            IFile wfFile = FieldImportWorkflowModelUtil.getFieldImportWorkflowFile((String)this.workflowController.getProjectName());
                            page.openEditor((IEditorInput)new FileEditorInput(wfFile), "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorDbd");
                        }
                    }
                }
                catch (Throwable e) {
                    logger.error(e);
                }
            }
            finally {
                if (workflowDBD != null) {
                    this.workflowController.releaseDBDLock(workflowDBD.getName());
                }
            }
        }
    }
}

