/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.workflow.util;

import com.ibm.im.ims.catalog.ui.workflow.FieldImportWorkflowXViewer;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDBD;
import com.ibm.im.ims.metadata.workflow.field.WorkflowSegmentType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowStatusType;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowController;
import com.ibm.im.ims.workbench.controller.workflow.field.WFMStateChangeException;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class FieldImportStateSelectionListener
implements SelectionListener {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private MenuItem menuItem;
    private TreeItem treeItem;
    private FieldImportWorkflowXViewer workflowXViewer;
    private FieldImportWorkflowController workflowController;

    public FieldImportStateSelectionListener(FieldImportWorkflowXViewer xViewer, MenuItem menuItem, TreeItem treeItem) {
        this.workflowXViewer = xViewer;
        this.menuItem = menuItem;
        this.treeItem = treeItem;
        this.workflowController = this.workflowXViewer.getWorkflowController();
    }

    public void widgetDefaultSelected(SelectionEvent se) {
        this.widgetSelected(se);
    }

    public void widgetSelected(SelectionEvent se) {
        WorkflowDBD workflowDBD = null;
        try {
            WorkflowSegmentType workflowSegment = (WorkflowSegmentType)this.treeItem.getData();
            WorkflowStatusType workflowStatus = (WorkflowStatusType)this.menuItem.getData();
            workflowDBD = workflowSegment.getParent();
            if (!this.workflowXViewer.checkIfDbdIsLocked(workflowDBD, true)) {
                workflowDBD = null;
                return;
            }
            try {
                this.workflowController.acquireDBDLock(workflowDBD.getName());
                try {
                    this.workflowController.checkSegmentStatusChange(workflowSegment, workflowStatus);
                    this.workflowController.setSegmentStatus(workflowSegment, workflowStatus);
                }
                catch (WFMStateChangeException e) {
                    String msgDialogTitle;
                    int kind;
                    if (e.getExceptionType() == WFMStateChangeException.ExceptionType.ERROR) {
                        kind = 1;
                        msgDialogTitle = WorkbenchModelBundle.getLabel().getString("WB496N");
                    } else {
                        kind = 4;
                        this.workflowController.setSegmentStatus(workflowSegment, workflowStatus);
                        msgDialogTitle = WorkbenchModelBundle.getLabel().getString("WB496P");
                    }
                    MessageDialog.open((int)kind, (Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)msgDialogTitle, (String)e.getMessage(), (int)0);
                }
                this.workflowController.saveWorkflowDBD(workflowSegment.getParent());
            }
            catch (Throwable e) {
                logger.error(e);
            }
        }
        finally {
            if (workflowDBD != null) {
                this.workflowController.releaseDBDLock(workflowDBD.getName());
            }
        }
    }
}

