/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.workflow.actions;

import com.ibm.im.ims.catalog.ui.workflow.FieldImportWorkflowXViewer;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDBD;
import com.ibm.im.ims.metadata.workflow.field.WorkflowSegmentType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowStatusType;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowController;
import com.ibm.im.ims.workbench.controller.workflow.field.WFMStateChangeException;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.im.ims.workbench.ui.core.Utility;
import com.ibm.im.ims.workbench.wizard.importds.UpdateSegmentStatusDialog;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class UpdateSegmentStatusAction
extends Action {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private FieldImportWorkflowXViewer workflowXViewer;
    private FieldImportWorkflowController workflowController;

    public UpdateSegmentStatusAction(FieldImportWorkflowXViewer workflowXViewer) {
        super(WorkbenchPlugin.labels.getString("FIM_CHANGE_SEGM_STATUS"), Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("targetIndex")));
        this.workflowXViewer = workflowXViewer;
        this.workflowController = workflowXViewer.getWorkflowController();
    }

    public void run() {
        block15: {
            WorkflowDBD workflowDBD;
            block12: {
                WorkflowSegmentType workflowSegment;
                block13: {
                    block14: {
                        logger.entering(((Object)((Object)this)).getClass().getName(), "run()", new Object[0]);
                        workflowDBD = null;
                        TreeItem treeItem = this.workflowXViewer.getRightClickSelectedItem();
                        Object workflowObject = treeItem.getData();
                        if (!(workflowObject instanceof WorkflowSegmentType)) break block12;
                        workflowSegment = (WorkflowSegmentType)workflowObject;
                        workflowDBD = workflowSegment.getParent();
                        if (this.workflowXViewer.checkIfDbdIsLocked(workflowDBD, true)) break block13;
                        workflowDBD = null;
                        if (workflowDBD == null) break block14;
                        this.workflowController.releaseDBDLock(workflowDBD.getName());
                    }
                    return;
                }
                try {
                    try {
                        this.workflowController.acquireDBDLock(workflowDBD.getName());
                        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        UpdateSegmentStatusDialog dialog = new UpdateSegmentStatusDialog(shell, workflowSegment);
                        if (dialog.open() != 0) break block12;
                        WorkflowStatusType workflowStatus = dialog.getSegmentStatus();
                        try {
                            this.workflowController.checkSegmentStatusChange(workflowSegment, workflowStatus);
                            this.workflowController.setSegmentStatus(workflowSegment, workflowStatus);
                        }
                        catch (WFMStateChangeException e) {
                            String msgDialogTitle;
                            int kind;
                            if (e.getExceptionType() == WFMStateChangeException.ExceptionType.ERROR) {
                                kind = 1;
                                msgDialogTitle = WorkbenchModelBundle.getLabel().getString("WB496N");
                            } else {
                                kind = 4;
                                this.workflowController.setSegmentStatus(workflowSegment, workflowStatus);
                                msgDialogTitle = WorkbenchModelBundle.getLabel().getString("WB496P");
                            }
                            MessageDialog.open((int)kind, (Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)msgDialogTitle, (String)e.getMessage(), (int)0);
                        }
                        this.workflowController.notifySegmentChanged(workflowSegment);
                        this.workflowController.saveWorkflowDBD(workflowSegment.getParent());
                    }
                    catch (Throwable e) {
                        logger.throwing(((Object)((Object)this)).getClass().getName(), "run()", e);
                        logger.error(e);
                        if (workflowDBD != null) {
                            this.workflowController.releaseDBDLock(workflowDBD.getName());
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (workflowDBD != null) {
                        this.workflowController.releaseDBDLock(workflowDBD.getName());
                    }
                    throw throwable;
                }
            }
            if (workflowDBD != null) {
                this.workflowController.releaseDBDLock(workflowDBD.getName());
            }
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "run()", new Object[0]);
    }
}

