/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.workflow.actions;

import com.ibm.im.ims.catalog.ui.workflow.FieldImportWorkflowXViewer;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDBD;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.compare.SubmitChangesController;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowController;
import com.ibm.im.ims.workbench.dialogs.SubmitChangesToIMSDialog;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class SubmitChangestoIMSAction
extends Action {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private FieldImportWorkflowXViewer workflowXViewer;
    private FieldImportWorkflowController workflowController;

    public SubmitChangestoIMSAction(FieldImportWorkflowXViewer workflowXViewer) {
        super(WorkbenchPlugin.labels.getString("WFM_SUBMIT_CHANGES_TO_IMS"), com.ibm.im.ims.workbench.ui.core.Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("submitChangesToIMS")));
        this.workflowXViewer = workflowXViewer;
        this.workflowController = workflowXViewer.getWorkflowController();
    }

    public void run() {
        try {
            TreeItem treeItem = this.workflowXViewer.getRightClickSelectedItem();
            Object workflowObject = treeItem.getData();
            if (workflowObject instanceof WorkflowDBD) {
                WorkflowDBD workflowDBD = (WorkflowDBD)workflowObject;
                String dbdName = workflowDBD.getName();
                String projectName = this.workflowController.getProjectName();
                IFile dbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)dbdName);
                DbdModel dbd = new DbdModel(dbdFile.getContents());
                boolean isDirty = false;
                boolean saveConfirm = false;
                IEditorPart currEditor = Utility.getDirtyEditor((IFile)dbdFile, (String)projectName);
                isDirty = Utility.isEditorDirty((IFile)dbdFile, (String)projectName);
                if (isDirty && (saveConfirm = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"WARNING", (String)"This DBD is open and currently being used by IMS DBD Editor in another tab. \nDo you want to save your changes before continuing?"))) {
                    NullProgressMonitor nullMonitor = new NullProgressMonitor();
                    currEditor.doSave((IProgressMonitor)nullMonitor);
                }
                if (!isDirty || saveConfirm) {
                    SubmitChangesController controller = new SubmitChangesController(projectName, dbd);
                    SubmitChangesToIMSDialog dialog = new SubmitChangesToIMSDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), controller);
                    dialog.open();
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }
}

