/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.workflow.actions;

import com.ibm.im.ims.catalog.ui.workflow.FieldImportWorkflowXViewer;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDBD;
import com.ibm.im.ims.metadata.workflow.field.WorkflowMapCaseType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowSegmentType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowStatusType;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.importer.datastructure.PreviewAndSelectDSController;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowController;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowModelUtil;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.wizard.importds.PreviewAndSelectDataStructureDialog;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class PreviewAndSelectDSAction
extends Action {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private FieldImportWorkflowXViewer workflowXViewer;
    private FieldImportWorkflowController workflowController;

    public PreviewAndSelectDSAction(FieldImportWorkflowXViewer workflowXViewer) {
        super(WorkbenchPlugin.labels.getString("WFM_PRVIEW"), com.ibm.im.ims.workbench.ui.core.Utility.getImageDescriptor("Preview_DS_16.png"));
        this.workflowXViewer = workflowXViewer;
        this.workflowController = workflowXViewer.getWorkflowController();
    }

    public void run() {
        block14: {
            WorkflowDBD workflowDBD;
            block11: {
                WorkflowSegmentType workflowSegment;
                WorkflowMapCaseType workflowMapCase;
                block12: {
                    block13: {
                        logger.entering(((Object)((Object)this)).getClass().getName(), "run()", new Object[0]);
                        workflowDBD = null;
                        TreeItem treeItem = this.workflowXViewer.getRightClickSelectedItem();
                        Object workflowObject = treeItem.getData();
                        if (!(workflowObject instanceof WorkflowMapCaseType)) break block11;
                        workflowMapCase = (WorkflowMapCaseType)workflowObject;
                        workflowSegment = workflowMapCase.getParent();
                        workflowDBD = workflowSegment.getParent();
                        if (this.workflowXViewer.checkIfDbdIsLocked(workflowDBD, true)) break block12;
                        workflowDBD = null;
                        if (workflowDBD == null) break block13;
                        this.workflowController.releaseDBDLock(workflowDBD.getName());
                    }
                    return;
                }
                try {
                    try {
                        PreviewAndSelectDSController controller;
                        Shell shell;
                        PreviewAndSelectDataStructureDialog dialog;
                        this.workflowController.acquireDBDLock(workflowDBD.getName());
                        String projectName = this.workflowController.getProjectName();
                        IFile origDbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)workflowDBD.getName());
                        boolean isDirty = false;
                        boolean toSave = false;
                        IEditorPart currEditor = com.ibm.im.ims.workbench.model.utilities.Utility.getDirtyEditor((IFile)origDbdFile, (String)projectName);
                        isDirty = com.ibm.im.ims.workbench.model.utilities.Utility.isEditorDirty((IFile)origDbdFile, (String)projectName);
                        if (isDirty && (toSave = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"WARNING", (String)"This DBD is open and currently being used by IMS DBD Editor in another tab. \nDo you want to save your changes before continuing?"))) {
                            NullProgressMonitor nullMonitor = new NullProgressMonitor();
                            currEditor.doSave((IProgressMonitor)nullMonitor);
                        }
                        if ((toSave || !isDirty) && (dialog = new PreviewAndSelectDataStructureDialog(shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), controller = new PreviewAndSelectDSController(workflowMapCase, this.workflowController.getProjectName(), this.workflowXViewer.getWorkflowController()))).open() == 0) {
                            this.workflowController.setSegmentStatus(workflowSegment, WorkflowStatusType.DATA_STRUCTURE_SELECTED);
                            this.workflowController.notifySegmentChanged(workflowSegment);
                            controller.doFinish(Utility.isJDBCEnable());
                            IFile dbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)this.workflowController.getProjectName(), (String)workflowDBD.getName());
                            boolean editorWasOpen = com.ibm.im.ims.workbench.model.utilities.Utility.closeOpenedEditorForResourceFile((IFile)dbdFile, (String)this.workflowController.getProjectName());
                            if (editorWasOpen) {
                                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                IWorkbenchPage page = window.getActivePage();
                                page.openEditor((IEditorInput)new FileEditorInput(dbdFile), "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorDbd");
                                IFile wfFile = FieldImportWorkflowModelUtil.getFieldImportWorkflowFile((String)this.workflowController.getProjectName());
                                page.openEditor((IEditorInput)new FileEditorInput(wfFile), "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorDbd");
                            }
                            this.workflowController.refreshDSEConnections();
                        }
                    }
                    catch (Throwable e) {
                        logger.throwing(((Object)((Object)this)).getClass().getName(), "run()", e);
                        logger.error(e);
                        if (workflowDBD != null) {
                            this.workflowController.releaseDBDLock(workflowDBD.getName());
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    if (workflowDBD != null) {
                        this.workflowController.releaseDBDLock(workflowDBD.getName());
                    }
                    throw throwable;
                }
            }
            if (workflowDBD != null) {
                this.workflowController.releaseDBDLock(workflowDBD.getName());
            }
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "run()", new Object[0]);
    }
}

