/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.workflow.actions;

import com.ibm.im.ims.catalog.ui.workflow.FieldImportWorkflowXViewer;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDBD;
import com.ibm.im.ims.metadata.workflow.field.WorkflowMapCaseType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowSegmentType;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.mapping.ManageMappingController;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowController;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowModelUtil;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import com.ibm.im.ims.workbench.wizard.managemapping.ManageMappingWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class ManageMapCaseAction
extends Action {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private FieldImportWorkflowXViewer workflowXViewer;
    private FieldImportWorkflowController workflowController;
    private TreeItem selectedItem = null;

    public ManageMapCaseAction(FieldImportWorkflowXViewer workflowXViewer) {
        super(WorkbenchPlugin.labels.getString("WFM_ADDEDIT_MAP"), com.ibm.im.ims.workbench.ui.core.Utility.getImageDescriptor("ManageMap_16.gif"));
        this.workflowXViewer = workflowXViewer;
        this.workflowController = workflowXViewer.getWorkflowController();
    }

    public ManageMapCaseAction(FieldImportWorkflowXViewer workflowXViewer, TreeItem selectedItem) {
        super(WorkbenchPlugin.labels.getString("WFM_ADDEDIT_MAP"), com.ibm.im.ims.workbench.ui.core.Utility.getImageDescriptor("ManageMap_16.gif"));
        this.workflowXViewer = workflowXViewer;
        this.workflowController = workflowXViewer.getWorkflowController();
        this.selectedItem = selectedItem;
    }

    public void run() {
        WorkflowDBD workflowDBD = null;
        try {
            Object workflowObject;
            workflowDBD = null;
            WorkflowSegmentType workflowSegment = null;
            if (this.selectedItem == null) {
                this.selectedItem = this.workflowXViewer.getRightClickSelectedItem();
            }
            if ((workflowObject = this.selectedItem.getData()) instanceof WorkflowSegmentType) {
                workflowSegment = (WorkflowSegmentType)workflowObject;
                workflowDBD = workflowSegment.getParent();
            } else if (workflowObject instanceof WorkflowMapCaseType) {
                workflowSegment = ((WorkflowMapCaseType)workflowObject).getParent();
                workflowDBD = workflowSegment.getParent();
            }
            String projectName = this.workflowController.getProjectName();
            DbdModel dbdModel = ProjectTreeFileHelper.unmarshalDbd((String)workflowDBD.getName(), (String)projectName);
            SegmentModel segmentModel = dbdModel.getSegment(workflowSegment.getName());
            if (segmentModel.isVirtualLogicalChild()) {
                MessageDialog.openError(null, (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)WorkbenchPlugin.errors.getString("NO_LAUNCH_MNG_MAPS_VLC"));
                return;
            }
            if (!this.workflowXViewer.checkIfDbdIsLocked(workflowDBD, true)) {
                workflowDBD = null;
                return;
            }
            try {
                this.workflowController.acquireDBDLock(workflowDBD.getName());
                IFile origDbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)workflowDBD.getName());
                boolean isDirty = false;
                boolean saveConfirm = false;
                IEditorPart currEditor = Utility.getDirtyEditor((IFile)origDbdFile, (String)projectName);
                isDirty = Utility.isEditorDirty((IFile)origDbdFile, (String)projectName);
                if (isDirty && (saveConfirm = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"WARNING", (String)"This DBD is open and currently being used by IMS DBD Editor in another tab. \nDo you want to save your changes before continuing?"))) {
                    NullProgressMonitor nullMonitor = new NullProgressMonitor();
                    currEditor.doSave((IProgressMonitor)nullMonitor);
                    dbdModel = ProjectTreeFileHelper.unmarshalDbd((String)workflowDBD.getName(), (String)projectName);
                    segmentModel = dbdModel.getSegment(workflowSegment.getName());
                }
                if (!isDirty || saveConfirm) {
                    ManageMappingController controller = new ManageMappingController(segmentModel, false);
                    ManageMappingWizard wizard = new ManageMappingWizard(controller);
                    Shell windowShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    WizardDialog dialog = new WizardDialog(windowShell, (IWizard)wizard);
                    dialog.create();
                    Shell dialogShell = dialog.getShell();
                    Point windowSize = windowShell.getSize();
                    int width = (int)((double)windowSize.x * 0.75);
                    int height = (int)((double)windowSize.y * 0.75);
                    dialogShell.setSize(width, height);
                    int xPos = (int)((double)windowSize.x * 0.12);
                    int yPos = (int)((double)windowSize.y * 0.12);
                    dialogShell.setLocation(xPos, yPos);
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        ProjectTreeFileHelper.marshallDBD((DbdModel)dbdModel, (String)projectName);
                        this.workflowController.mapCasesEdited(workflowSegment, segmentModel);
                        this.workflowController.notifySegmentChanged(workflowSegment);
                        FieldImportWorkflowModelUtil.marshallWorkflowDBD((WorkflowDBD)workflowDBD, (String)projectName);
                        IFile dbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)workflowDBD.getName());
                        boolean editorWasOpen = Utility.closeOpenedEditorForResourceFile((IFile)dbdFile, (String)projectName);
                        if (editorWasOpen) {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            IWorkbenchPage page = window.getActivePage();
                            page.openEditor((IEditorInput)new FileEditorInput(dbdFile), "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorDbd");
                            IFile wfFile = FieldImportWorkflowModelUtil.getFieldImportWorkflowFile((String)projectName);
                            page.openEditor((IEditorInput)new FileEditorInput(wfFile), "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorDbd");
                        }
                        ProjectTreeFileHelper.marshallCatalogEnabledGeneratedDbdFile((String)projectName, (DbdModel)dbdModel);
                        this.workflowXViewer.segmentChanged(workflowSegment);
                        this.selectedItem.setExpanded(true);
                        this.workflowXViewer.refresh(this.selectedItem, true);
                        this.workflowController.refreshDSEConnections();
                    }
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        finally {
            if (workflowDBD != null) {
                this.workflowController.releaseDBDLock(workflowDBD.getName());
            }
        }
    }
}

