/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.workflow.actions;

import com.ibm.etools.tdlang.TDLangElement;
import com.ibm.im.ims.cam.walkers.util.DataStructureContainer;
import com.ibm.im.ims.catalog.ui.workflow.FieldImportWorkflowXViewer;
import com.ibm.im.ims.metadata.workflow.field.FieldImportWorkflow;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDBD;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDataStructureType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowMapCaseType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowSegmentType;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.importer.datastructure.DSSA;
import com.ibm.im.ims.workbench.controller.importer.datastructure.ImportDsToDbdController;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowController;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowModelUtil;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.wizard.importds.ImportDataStructureWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class FieldImportWorkflowImportDSAction
extends Action {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private FieldImportWorkflowXViewer workflowXViewer;
    private FieldImportWorkflowController workflowController;
    private TreeItem selectedItem = null;

    public FieldImportWorkflowImportDSAction(FieldImportWorkflowXViewer workflowXViewer) {
        super(WorkbenchPlugin.labels.getString("WFM_IMPORT_COBOL"), com.ibm.im.ims.workbench.ui.core.Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("sImportDSWizard")));
        this.workflowXViewer = workflowXViewer;
        this.workflowController = workflowXViewer.getWorkflowController();
    }

    public FieldImportWorkflowImportDSAction(FieldImportWorkflowXViewer workflowXViewer, TreeItem selectedItem) {
        super(WorkbenchPlugin.labels.getString("WFM_IMPORT_COBOL"), com.ibm.im.ims.workbench.ui.core.Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("sImportDSWizard")));
        this.workflowXViewer = workflowXViewer;
        this.workflowController = workflowXViewer.getWorkflowController();
        this.selectedItem = selectedItem;
    }

    public void run() {
        WorkflowDBD workflowDBD = null;
        try {
            Object workflowObject;
            workflowDBD = null;
            WorkflowSegmentType workflowSegment = null;
            if (this.selectedItem == null) {
                this.selectedItem = this.workflowXViewer.getRightClickSelectedItem();
            }
            if ((workflowObject = this.selectedItem.getData()) instanceof WorkflowDBD) {
                workflowDBD = (WorkflowDBD)workflowObject;
                if (workflowDBD.getWorkflowSegment().size() != 0) {
                    workflowSegment = (WorkflowSegmentType)workflowDBD.getWorkflowSegment().get(0);
                }
            } else if (workflowObject instanceof WorkflowSegmentType) {
                workflowSegment = (WorkflowSegmentType)workflowObject;
                workflowDBD = workflowSegment.getParent();
            } else if (workflowObject instanceof WorkflowMapCaseType) {
                workflowSegment = ((WorkflowMapCaseType)workflowObject).getParent();
                workflowDBD = workflowSegment.getParent();
            }
            if (!this.workflowXViewer.checkIfDbdIsLocked(workflowDBD, true)) {
                workflowDBD = null;
                return;
            }
            try {
                this.workflowController.acquireDBDLock(workflowDBD.getName());
                DbdModel dbdModel = null;
                dbdModel = ProjectTreeFileHelper.unmarshalDbd((String)workflowDBD.getName(), (String)this.workflowController.getProjectName());
                SegmentModel segmentModel = null;
                if (workflowSegment != null) {
                    segmentModel = dbdModel.getSegment(workflowSegment.getName());
                } else {
                    workflowDBD.getWorkflowSegment().add(new WorkflowSegmentType());
                    workflowSegment = (WorkflowSegmentType)workflowDBD.getWorkflowSegment().get(0);
                    workflowSegment.setName("TEMP");
                    segmentModel = new SegmentModel(dbdModel);
                    segmentModel.setName("TEMP");
                    dbdModel.setRootSegment(segmentModel);
                }
                ImportDsToDbdController dsImportController = new ImportDsToDbdController(segmentModel, dbdModel, this.workflowController.getProjectName());
                ImportDataStructureWizard wizard = new ImportDataStructureWizard(dsImportController, null);
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                if (workflowSegment != null && segmentModel.isVirtualLogicalChild()) {
                    MessageDialog.openError(null, (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)WorkbenchPlugin.errors.getString("NO_LAUNCH_MNG_FIELDS_VLC"));
                } else {
                    String projectName = this.workflowController.getProjectName();
                    IFile origDbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)workflowDBD.getName());
                    boolean isDirty = false;
                    boolean toSave = false;
                    IEditorPart currEditor = com.ibm.im.ims.workbench.model.utilities.Utility.getDirtyEditor((IFile)origDbdFile, (String)projectName);
                    isDirty = com.ibm.im.ims.workbench.model.utilities.Utility.isEditorDirty((IFile)origDbdFile, (String)projectName);
                    if (isDirty && (toSave = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"WARNING", (String)"This DBD is open and currently being used by IMS DBD Editor in another tab. \nDo you want to save your changes before continuing?"))) {
                        NullProgressMonitor nullMonitor = new NullProgressMonitor();
                        currEditor.doSave((IProgressMonitor)nullMonitor);
                    }
                    if (toSave || !isDirty) {
                        dialog.open();
                        if (dialog.getReturnCode() == 0) {
                            Vector dssaList = dsImportController.getDsSegmentAssociations();
                            for (DSSA dssa : dssaList) {
                                if (!dssa.segmentName.equals(workflowSegment.getName())) {
                                    workflowSegment = FieldImportWorkflowModelUtil.getWorkflowSegmentByName((WorkflowDBD)workflowDBD, (String)dssa.segmentName);
                                }
                                TDLangElement langElement = dsImportController.getLangElement(dssa);
                                DataStructureContainer dsContainer = DataStructureContainer.generate((TDLangElement)langElement, (boolean)true);
                                this.workflowController.saveDatastructureFile(dbdModel.getDBDName(), dsContainer);
                                if (workflowSegment == null) continue;
                                FieldImportWorkflowModelUtil.addCandidateDS((WorkflowSegmentType)workflowSegment, (DataStructureContainer)dsContainer, (boolean)true);
                                this.workflowController.notifySegmentChanged(workflowSegment);
                                WorkflowMapCaseType wfMapCaseType = this.getWorkflowMapCaseType(workflowSegment, dssa);
                                WorkflowDataStructureType wfDSType = this.getWorkflowDataStructureType(workflowSegment, dsContainer.getName());
                                if (wfMapCaseType == null || wfDSType == null) continue;
                                boolean isJDBCEnable = Utility.isJDBCEnable();
                                this.workflowController.importDataStructure(wfMapCaseType, wfDSType, isJDBCEnable);
                                FieldImportWorkflowModelUtil.marshallWorkflow((FieldImportWorkflow)this.workflowController.getWorkflow(), (String)projectName, (boolean)true);
                                IFile dbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)workflowDBD.getName());
                                boolean editorWasOpen = com.ibm.im.ims.workbench.model.utilities.Utility.closeOpenedEditorForResourceFile((IFile)dbdFile, (String)projectName);
                                if (!editorWasOpen) continue;
                                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                IWorkbenchPage page = window.getActivePage();
                                page.openEditor((IEditorInput)new FileEditorInput(dbdFile), "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorDbd");
                                IFile wfFile = FieldImportWorkflowModelUtil.getFieldImportWorkflowFile((String)this.workflowController.getProjectName());
                                page.openEditor((IEditorInput)new FileEditorInput(wfFile), "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorDbd");
                            }
                            FieldImportWorkflowModelUtil.marshallWorkflowDBD((WorkflowDBD)workflowDBD, (String)this.workflowController.getProjectName());
                            if (workflowSegment != null) {
                                this.workflowXViewer.segmentChanged(workflowSegment);
                            }
                            this.selectedItem.setExpanded(true);
                            this.workflowXViewer.refresh(this.selectedItem, true);
                            this.workflowController.refreshDSEConnections();
                        }
                    }
                }
            }
            catch (Throwable e) {
                logger.error(e);
            }
        }
        finally {
            if (workflowDBD != null) {
                this.workflowController.releaseDBDLock(workflowDBD.getName());
            }
        }
    }

    private WorkflowMapCaseType getWorkflowMapCaseType(WorkflowSegmentType workflowSegment, DSSA dssa) {
        WorkflowMapCaseType retVal = null;
        List wfMapCaseTypes = workflowSegment.getWorkflowMapCase();
        Object mapCaseName = "Unmapped";
        if (dssa.mapName != null && dssa.caseName != null && !dssa.caseName.isEmpty()) {
            mapCaseName = dssa.mapName + "/" + dssa.caseName;
        }
        int i = 0;
        while (i < wfMapCaseTypes.size()) {
            WorkflowMapCaseType wfMapCaseType = (WorkflowMapCaseType)wfMapCaseTypes.get(i);
            if (wfMapCaseType.getName().equals(mapCaseName)) {
                retVal = wfMapCaseType;
                break;
            }
            ++i;
        }
        return retVal;
    }

    private WorkflowDataStructureType getWorkflowDataStructureType(WorkflowSegmentType workflowSegment, String dsName) {
        WorkflowDataStructureType retVal = null;
        List wfDSTypes = workflowSegment.getWorkflowCandidateDataStructure();
        int i = 0;
        while (i < wfDSTypes.size()) {
            WorkflowDataStructureType wfDSType = (WorkflowDataStructureType)wfDSTypes.get(i);
            if (wfDSType.getName().equals(dsName)) {
                retVal = wfDSType;
                break;
            }
            ++i;
        }
        return retVal;
    }
}

