/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.workflow.actions;

import com.ibm.im.ims.catalog.ui.workflow.FieldImportWorkflowXViewer;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDBD;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowController;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowModelUtil;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import com.ibm.im.ims.workbench.utilities.EditDbdInfoDialog;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EditDBDAction
extends Action {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private FieldImportWorkflowXViewer workflowXViewer;
    private FieldImportWorkflowController workflowController;

    public EditDBDAction(FieldImportWorkflowXViewer workflowXViewer) {
        super(WorkbenchPlugin.labels.getString("WFM_EDIT_DBD_ATTRIBUTES"), com.ibm.im.ims.workbench.ui.core.Utility.getImageDescriptor("databaseEditor_16.gif"));
        this.workflowXViewer = workflowXViewer;
        this.workflowController = workflowXViewer.getWorkflowController();
    }

    public void run() {
        WorkflowDBD workflowDBD = null;
        try {
            TreeItem treeItem = this.workflowXViewer.getRightClickSelectedItem();
            Object workflowObject = treeItem.getData();
            if (!(workflowObject instanceof WorkflowDBD)) {
                return;
            }
            workflowDBD = (WorkflowDBD)workflowObject;
            String projectName = this.workflowController.getProjectName();
            String dbdName = workflowDBD.getName();
            if (!this.workflowXViewer.checkIfDbdIsLocked(workflowDBD, true)) {
                workflowDBD = null;
                return;
            }
            try {
                this.workflowController.acquireDBDLock(dbdName);
                DbdModel dbdModel = ProjectTreeFileHelper.unmarshalDbd((String)dbdName, (String)projectName);
                ProjectTreeFileHelper.marshallDBD((DbdModel)dbdModel, (String)projectName);
                FieldImportWorkflowModelUtil.marshallWorkflowDBD((WorkflowDBD)workflowDBD, (String)projectName);
                IFile dbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)dbdName);
                boolean editorWasOpen = Utility.closeOpenedEditorForResourceFile((IFile)dbdFile, (String)projectName);
                if (editorWasOpen) {
                    dbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)dbdName);
                }
                dbdModel = new DbdModel(dbdFile.getContents());
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                EditDbdInfoDialog dialog = new EditDbdInfoDialog(window.getShell(), dbdModel, false);
                if (dialog.open() == 0) {
                    ProjectTreeFileHelper.marshallCatalogEnabledGeneratedDbdFile((String)projectName, (DbdModel)dbdModel);
                    ProjectTreeFileHelper.marshallDBD((DbdModel)dbdModel, (String)projectName);
                    ProjectTreeFileHelper.marshallGeneratedDbdFile((String)projectName, (DbdModel)dbdModel);
                    ProjectTreeFileHelper.marshallGeneratedDdlFile((String)projectName, (DbdModel)dbdModel);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        finally {
            if (workflowDBD != null) {
                this.workflowController.releaseDBDLock(workflowDBD.getName());
            }
        }
    }
}

