/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.workflow.actions;

import com.ibm.im.ims.catalog.ui.workflow.FieldImportWorkflowXViewer;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDBD;
import com.ibm.im.ims.metadata.workflow.field.WorkflowSegmentType;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowController;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowModelUtil;
import com.ibm.im.ims.workbench.editors.ResourceEditorPage;
import com.ibm.im.ims.workbench.editors.ResourceMultiPageEditor;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.editors.parts.DbEditPart;
import com.ibm.im.ims.workbench.editors.parts.SegmentEditPart;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class AddOrEditFieldAction
extends Action {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private FieldImportWorkflowXViewer workflowXViewer;
    private FieldImportWorkflowController workflowController;
    private TreeItem selectedSegment = null;

    public AddOrEditFieldAction(FieldImportWorkflowXViewer workflowXViewer) {
        super(WorkbenchPlugin.labels.getString("WFM_ADD_EDIT_FIELD"), com.ibm.im.ims.workbench.ui.core.Utility.getImageDescriptor("dbd_dat_typ_edit_wizard_16_.gif"));
        this.workflowXViewer = workflowXViewer;
        this.workflowController = workflowXViewer.getWorkflowController();
    }

    public AddOrEditFieldAction(FieldImportWorkflowXViewer workflowXViewer, TreeItem selectedSegment) {
        super(WorkbenchPlugin.labels.getString("WFM_ADD_EDIT_FIELD"), com.ibm.im.ims.workbench.ui.core.Utility.getImageDescriptor("dbd_dat_typ_edit_wizard_16_.gif"));
        this.workflowXViewer = workflowXViewer;
        this.workflowController = workflowXViewer.getWorkflowController();
        this.selectedSegment = selectedSegment;
    }

    public void run() {
        WorkflowDBD workflowDBD = null;
        WorkflowSegmentType workflowSegment = null;
        try {
            Object workflowObject;
            if (this.selectedSegment == null) {
                this.selectedSegment = this.workflowXViewer.getRightClickSelectedItem();
            }
            if (!((workflowObject = this.selectedSegment.getData()) instanceof WorkflowSegmentType)) {
                return;
            }
            workflowSegment = (WorkflowSegmentType)workflowObject;
            workflowDBD = workflowSegment.getParent();
            String projectName = this.workflowController.getProjectName();
            String dbdName = workflowDBD.getName();
            String segmentName = workflowSegment.getName();
            DbdModel dbdModel = ProjectTreeFileHelper.unmarshalDbd((String)dbdName, (String)projectName);
            SegmentModel segmentModel = dbdModel.getSegment(segmentName);
            if (segmentModel.isVirtualLogicalChild()) {
                MessageDialog.openError(null, (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)WorkbenchPlugin.errors.getString("NO_LAUNCH_MNG_FIELDS_VLC"));
                return;
            }
            if (!this.workflowXViewer.checkIfDbdIsLocked(workflowDBD, true)) {
                workflowDBD = null;
                return;
            }
            try {
                this.workflowController.acquireDBDLock(dbdName);
                ProjectTreeFileHelper.marshallDBD((DbdModel)dbdModel, (String)projectName);
                FieldImportWorkflowModelUtil.marshallWorkflowDBD((WorkflowDBD)workflowDBD, (String)projectName);
                IFile dbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)dbdName);
                boolean isDirty = false;
                boolean saveConfirm = false;
                IEditorPart currEditor = Utility.getDirtyEditor((IFile)dbdFile, (String)projectName);
                isDirty = Utility.isEditorDirty((IFile)dbdFile, (String)projectName);
                if (isDirty && (saveConfirm = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"WARNING", (String)"This DBD is open and currently being used by IMS DBD Editor in another tab. \nDo you want to save your changes before continuing?"))) {
                    NullProgressMonitor nullMonitor = new NullProgressMonitor();
                    currEditor.doSave((IProgressMonitor)nullMonitor);
                }
                if (!isDirty || saveConfirm) {
                    IWorkbenchWindow window;
                    ResourceMultiPageEditor dbdEditor;
                    ResourceEditorPage page;
                    boolean editorWasOpen = Utility.closeOpenedEditorForResourceFile((IFile)dbdFile, (String)projectName);
                    if (editorWasOpen) {
                        dbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)dbdName);
                    }
                    if ((page = (dbdEditor = (ResourceMultiPageEditor)(window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getActivePage().openEditor((IEditorInput)new FileEditorInput(dbdFile), "com.ibm.im.ims.workbench.ui.editors.graphicalviews.ResourceMultiPageEditorDbd")).getCurrentPage()) != null) {
                        SegmentGEFModel gefSegment = page.getDbGEFModel().getSegmentGEFModel(segmentName);
                        this.segmentSearch(page, gefSegment);
                        page.launchManageField(gefSegment, window);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        finally {
            if (workflowDBD != null) {
                this.workflowController.releaseDBDLock(workflowDBD.getName());
            }
        }
    }

    private void segmentSearch(ResourceEditorPage editorPage, SegmentGEFModel segmentGEFModel) {
        DbEditPart dbEditPart = (DbEditPart)editorPage.getEditPart();
        List children = dbEditPart.getChildren();
        int i = 0;
        while (i < children.size()) {
            SegmentEditPart segEditPart;
            SegmentGEFModel currSegModel;
            if (children.get(i) instanceof SegmentEditPart && (currSegModel = (SegmentGEFModel)(segEditPart = (SegmentEditPart)children.get(i)).getModel()).equals(segmentGEFModel)) {
                this.revealEditPart((GraphicalEditPart)segEditPart, editorPage);
                break;
            }
            ++i;
        }
    }

    private void revealEditPart(GraphicalEditPart editPart, ResourceEditorPage editorPage) {
        IFigure target = editPart.getFigure();
        FigureCanvas figureCanvas = (FigureCanvas)editorPage.getViewer().getControl();
        Rectangle rectangle = editorPage.getDbGEFModel().getDbdBorderModel().getConstraint();
        figureCanvas.setBounds(0, 0, rectangle.x, rectangle.y);
        figureCanvas.scrollTo(target.getBounds().x - 100, target.getBounds().y - 100);
        editorPage.setSelectedPart((EditPart)editPart);
    }
}

