/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.workflow;

import com.ibm.im.ims.catalog.ui.workflow.FieldImportWorkflowXViewer;
import com.ibm.im.ims.catalog.ui.workflow.FieldImportWorkflowXViewerContentProvider;
import com.ibm.im.ims.catalog.ui.workflow.FieldImportWorkflowXViewerConverter;
import com.ibm.im.ims.catalog.ui.workflow.FieldImportWorkflowXViewerLabelProvider;
import com.ibm.im.ims.catalog.ui.workflow.FieldImportWorkflowXViewerMouseListener;
import com.ibm.im.ims.catalog.ui.workflow.MultiPageEditor;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowController;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.nebula.widgets.xviewer.edit.DefaultXViewerControlFactory;
import org.eclipse.nebula.widgets.xviewer.edit.XViewerControlFactory;
import org.eclipse.nebula.widgets.xviewer.edit.XViewerConverter;
import org.eclipse.nebula.widgets.xviewer.edit.XViewerEditAdapter;
import org.eclipse.nebula.widgets.xviewer.edit.XViewerMultiEditAdapter;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.FileEditorInput;

public class WorkflowManager
extends FormPage
implements SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private FormToolkit toolkit;
    private Form form;
    private String projectName;
    private FieldImportWorkflowXViewer xViewer;
    private FieldImportWorkflowController workflowController;
    private Combo serverCombo;
    private Combo siteCombo;
    private Button discoveryButton;
    private boolean saveWorkflow = true;

    public WorkflowManager(MultiPageEditor parent, Composite compositeContainer, String title, FileEditorInput fileInput) throws Exception {
        super(null, WorkbenchPlugin.labels.getString("WFM_TITLE"), title);
        IFile file = fileInput.getFile();
        IPath path = file.getFullPath();
        this.projectName = path.segments()[0];
        String projectUUID = ProjectTreeFileHelper.getUUIDForProject((String)this.projectName, (String)"com.ibm.im.ims.workbench");
        this.workflowController = new FieldImportWorkflowController(this.projectName, file, projectUUID);
        this.createContent(compositeContainer);
        this.xViewer.setInput(this.workflowController.getWorkflowDBDs());
        this.workflowController.startPopulateWorkflowMetadataJob();
    }

    private void createContent(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createForm(parent);
        this.createEditor(this.toolkit);
    }

    private void createEditor(FormToolkit toolkit) {
        Composite composite = this.form.getBody();
        composite.setLayout((Layout)new GridLayout());
        Section section = toolkit.createSection(composite, 128);
        section.setText(WorkbenchPlugin.labels.getString("WFM_TITLE"));
        section.setDescription(WorkbenchPlugin.descriptions.getString("WFM_DESC"));
        section.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.createCompositeSeparator((Composite)section);
        Composite client = toolkit.createComposite((Composite)section, 64);
        client.setLayout((Layout)new GridLayout(1, false));
        section.setClient((Control)client);
        this.xViewer = new FieldImportWorkflowXViewer(client, 67586, this.workflowController);
        this.xViewer.setContentProvider((IContentProvider)new FieldImportWorkflowXViewerContentProvider());
        this.xViewer.setLabelProvider((IBaseLabelProvider)new FieldImportWorkflowXViewerLabelProvider(this.xViewer));
        this.xViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.xViewer.getTree().addMouseMoveListener((MouseMoveListener)new FieldImportWorkflowXViewerMouseListener(this.xViewer));
        DefaultXViewerControlFactory cFactory = new DefaultXViewerControlFactory();
        FieldImportWorkflowXViewerConverter converter = new FieldImportWorkflowXViewerConverter();
        this.xViewer.setXViewerEditAdapter((XViewerEditAdapter)new XViewerMultiEditAdapter((XViewerControlFactory)cFactory, (XViewerConverter)converter));
        toolkit.paintBordersFor(client);
    }

    public void widgetSelected(SelectionEvent event) {
    }

    public String getServerName() {
        String retVal = "";
        if (this.serverCombo != null && !this.serverCombo.isDisposed()) {
            retVal = this.serverCombo.getText();
        }
        return retVal;
    }

    public void setServerName(String text) {
        if (this.serverCombo != null && !this.serverCombo.isDisposed()) {
            if (text == null) {
                text = "";
            }
            this.serverCombo.setText(text);
        }
    }

    public String getSiteName() {
        String retVal = "";
        if (this.siteCombo != null && !this.siteCombo.isDisposed()) {
            retVal = this.siteCombo.getText();
        }
        return retVal;
    }

    public void setSiteName(String text) {
        if (this.siteCombo != null && !this.siteCombo.isDisposed()) {
            if (text == null) {
                text = "";
            }
            this.siteCombo.setText(text);
        }
    }

    public String getDiscoveryButtonText() {
        String retVal = "";
        if (this.discoveryButton != null && !this.discoveryButton.isDisposed()) {
            retVal = this.discoveryButton.getText();
        }
        return retVal;
    }

    public void setDiscoveryButtonText(Image image, String text) {
        if (this.discoveryButton != null && !this.discoveryButton.isDisposed()) {
            this.discoveryButton.setImage(image);
            this.discoveryButton.setText(text);
            int x = Utility.getTextWidth(this.discoveryButton.getParent(), 0, text);
            this.discoveryButton.setSize(x, this.discoveryButton.getSize().y);
            this.discoveryButton.getParent().pack();
        }
    }

    public void setEnabled(Control control, boolean enabled) {
        if (control != null && !control.isDisposed()) {
            control.setEnabled(enabled);
        }
    }

    public boolean isDiscoveryStarted() {
        boolean retVal = false;
        if (this.getDiscoveryButtonText().equals(WorkbenchPlugin.labels.getString("WFM_PAUSE_DISCOVERY"))) {
            retVal = true;
        }
        return retVal;
    }

    public Composite getPage() {
        return this.form;
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void dispose() {
        try {
            if (this.saveWorkflow) {
                this.workflowController.saveWorkflow();
            }
        }
        catch (Exception e) {
            UIHelper.displayErrorDialog(WorkbenchPlugin.labels.getString("WFM_TITLE"), e.getMessage(), e);
            logger.error((Throwable)e);
        }
        this.toolkit.dispose();
        this.workflowController.editorIsClosing();
        super.dispose();
    }

    public void setSaveWorkflow(boolean saveWorkflow) {
        this.saveWorkflow = saveWorkflow;
    }

    public FieldImportWorkflowController getWorkflowController() {
        return this.workflowController;
    }

    public FieldImportWorkflowXViewer getXviewer() {
        return this.xViewer;
    }
}

