/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.workflow;

import com.ibm.im.ims.catalog.ui.workflow.WorkflowManager;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class MultiPageEditor
extends MultiPageEditorPart {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private boolean isDirty = false;
    private String projectName;
    private String serverName;
    private WorkflowManager wfManager;
    private ResourceTracker resourceTracker;

    void addPages() throws Exception {
        FileEditorInput fileInput = (FileEditorInput)this.getEditorInput();
        String fileName = fileInput.getName();
        if (fileName.indexOf(".wfm") > 0) {
            this.wfManager = new WorkflowManager(this, this.getContainer(), "wfm title", fileInput);
            this.addPage((Control)this.wfManager.getPage());
            this.setPartName(fileName);
        }
        if (this.getPageCount() == 1 && this.getContainer() instanceof CTabFolder) {
            ((CTabFolder)this.getContainer()).setTabHeight(0);
        }
    }

    public void refreshEditor() throws JAXBException {
    }

    protected void createPages() {
        try {
            this.addPages();
            this.wfManager.getWorkflowController().editorOpenedSuccessfully();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", e);
            logger.error(e);
        }
    }

    public void setDirty(boolean dirty) {
        if (this.isDirty != dirty) {
            this.isDirty = dirty;
            this.firePropertyChange(257);
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        super.dispose();
        IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
        file.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
        this.resourceTracker = null;
        this.wfManager.setSaveWorkflow(false);
        this.wfManager.dispose();
    }

    private void closeEditor(final boolean save) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MultiPageEditor.this.getSite().getPage().closeEditor((IEditorPart)MultiPageEditor.this, save);
            }
        });
    }

    private ResourceTracker getResourceTracker() {
        if (this.resourceTracker == null) {
            this.resourceTracker = new ResourceTracker();
        }
        return this.resourceTracker;
    }

    protected void setInput(IEditorInput input) {
        IFile file;
        if (this.getEditorInput() != null) {
            file = ((FileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
        }
        super.setInput(input);
        if (this.getEditorInput() != null) {
            file = ((FileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
            this.setPartName(file.getName());
            this.firePropertyChange(258);
            this.firePropertyChange(1);
        }
    }

    public WorkflowManager getWorkflowManager() {
        return this.wfManager;
    }

    private class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException e) {
                logger.error((Throwable)e);
            }
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !delta.getResource().equals((Object)((IFileEditorInput)MultiPageEditor.this.getEditorInput()).getFile())) {
                return true;
            }
            if (delta.getKind() == 2) {
                if ((0x2000 & delta.getFlags()) == 0) {
                    if (!MultiPageEditor.this.isDirty()) {
                        MultiPageEditor.this.closeEditor(false);
                    }
                } else {
                    final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    Display display = MultiPageEditor.this.getSite().getShell().getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MultiPageEditor.this.setInput((IEditorInput)new FileEditorInput(newFile));
                        }
                    });
                }
            }
            return false;
        }
    }
}

