/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.workflow;

import com.ibm.im.ims.metadata.workflow.field.WorkflowDBD;
import com.ibm.im.ims.metadata.workflow.field.WorkflowMapCaseType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowSegmentType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowStatusType;
import com.ibm.im.ims.workbench.model.utilities.FieldImportWorkflowUtil;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerTextFilter;

public class FieldImportWorkflowXViewerTextFilter
extends XViewerTextFilter {
    public FieldImportWorkflowXViewerTextFilter(XViewer xViewer) {
        super(xViewer);
    }

    public void update() {
        String filterText = this.xViewer.getCustomizeMgr().getFilterText();
        if (filterText == null || filterText.isEmpty()) {
            this.textPattern = null;
        } else {
            int flags = 2;
            if (!this.xViewer.getCustomizeMgr().isFilterTextRegularExpression()) {
                flags = 0x10 | flags;
            }
            this.textPattern = Pattern.compile(filterText, flags);
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean selected = false;
        if (element instanceof WorkflowDBD) {
            selected = this.dbdMatches((WorkflowDBD)element);
        } else if (element instanceof WorkflowSegmentType) {
            selected = this.segmentMatches((WorkflowSegmentType)element);
        } else if (element instanceof WorkflowMapCaseType) {
            selected = this.mapCaseMatches((WorkflowMapCaseType)element);
        }
        return selected;
    }

    protected boolean dbdMatches(WorkflowDBD dbd) {
        if (this.textPattern == null || dbd == null) {
            return true;
        }
        boolean match = false;
        String patternText = this.textPattern.toString().toUpperCase();
        String dbdName = dbd.getName().toUpperCase();
        if (dbdName != null && !dbdName.isEmpty()) {
            if (this.xViewer.getCustomizeMgr().isFilterTextRegularExpression() && this.textPattern.matcher(dbdName).matches()) {
                return true;
            }
            if (dbdName.contains(patternText)) {
                return true;
            }
        }
        String statusValue = null;
        if (dbd.getStatus() != null && dbd.getStatus().value() != null) {
            statusValue = FieldImportWorkflowUtil.getTranslatedStatusTextUC((WorkflowStatusType)dbd.getStatus());
        }
        if (statusValue != null && !statusValue.isEmpty()) {
            if (this.xViewer.getCustomizeMgr().isFilterTextRegularExpression() && this.textPattern.matcher(statusValue).matches()) {
                return true;
            }
            if (statusValue.contains(patternText)) {
                return true;
            }
        }
        if (dbd.getWorkflowSegment() != null && !dbd.getWorkflowSegment().isEmpty()) {
            for (WorkflowSegmentType segment : dbd.getWorkflowSegment()) {
                match = this.segmentMatches(segment);
                if (match) break;
                if (segment.getWorkflowMapCase() == null || segment.getWorkflowMapCase().isEmpty()) continue;
                for (WorkflowMapCaseType mapCase : segment.getWorkflowMapCase()) {
                    match = this.mapCaseMatches(mapCase);
                    if (match) break;
                }
                if (match) break;
            }
        }
        return match;
    }

    protected boolean segmentMatches(WorkflowSegmentType segment) {
        if (this.textPattern == null || segment == null) {
            return true;
        }
        if (this.textPattern != null) {
            String patternText = this.textPattern.toString().toUpperCase();
            String segmentName = segment.getName().toUpperCase();
            if (segmentName != null && !segmentName.isEmpty()) {
                if (this.xViewer.getCustomizeMgr().isFilterTextRegularExpression() && this.textPattern.matcher(segmentName).matches()) {
                    return true;
                }
                if (segmentName.contains(patternText)) {
                    return true;
                }
            }
            String statusValue = null;
            if (segment.getStatus() != null && segment.getStatus().value() != null) {
                statusValue = FieldImportWorkflowUtil.getTranslatedStatusTextUC((WorkflowStatusType)segment.getStatus());
            }
            if (statusValue != null && !statusValue.isEmpty()) {
                if (this.xViewer.getCustomizeMgr().isFilterTextRegularExpression() && this.textPattern.matcher(statusValue).matches()) {
                    return true;
                }
                if (statusValue.contains(patternText)) {
                    return true;
                }
            }
            for (WorkflowMapCaseType mapCase : segment.getWorkflowMapCase()) {
                if (!this.mapCaseMatches(mapCase)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean mapCaseMatches(WorkflowMapCaseType mapCase) {
        if (this.textPattern == null || mapCase == null) {
            return true;
        }
        if (this.textPattern != null) {
            String patternText = this.textPattern.toString().toUpperCase();
            String mapCaseName = mapCase.getName().toUpperCase();
            if (mapCaseName != null && !mapCaseName.isEmpty()) {
                if (this.xViewer.getCustomizeMgr().isFilterTextRegularExpression() && this.textPattern.matcher(mapCaseName).matches()) {
                    return true;
                }
                if (mapCaseName.contains(patternText)) {
                    return true;
                }
            }
            String dataStructureName = null;
            if (mapCase.getWorkflowSelectedDataStructure() != null && mapCase.getWorkflowSelectedDataStructure().getName() != null) {
                dataStructureName = mapCase.getWorkflowSelectedDataStructure().getName().toUpperCase();
            }
            if (dataStructureName != null && !dataStructureName.isEmpty()) {
                if (this.xViewer.getCustomizeMgr().isFilterTextRegularExpression() && this.textPattern.matcher(dataStructureName).matches()) {
                    return true;
                }
                if (dataStructureName.contains(patternText)) {
                    return true;
                }
            }
        }
        return false;
    }
}

