/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.workflow;

import com.ibm.im.ims.catalog.ui.workflow.FieldImportWorkflowXViewer;
import com.ibm.im.ims.catalog.ui.workflow.FieldImportWorkflowXViewerFactory;
import com.ibm.im.ims.catalog.ui.workflow.util.FieldImportWorkflowImageCache;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDBD;
import com.ibm.im.ims.metadata.workflow.field.WorkflowMapCaseType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowSegmentType;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowController;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.TreeColumn;

public class FieldImportWorkflowXViewerMouseListener
implements MouseMoveListener {
    private FieldImportWorkflowXViewer xViewer;
    private FieldImportWorkflowController workflowController;
    private ViewerRow lastDataStructureRow = null;
    private ViewerRow lastStateRow = null;

    public FieldImportWorkflowXViewerMouseListener(FieldImportWorkflowXViewer xViewer) {
        this.xViewer = xViewer;
        this.workflowController = xViewer.getWorkflowController();
    }

    private void resetImagesAboveBelow(colType type) {
        Image image;
        ViewerRow row;
        int colNum;
        if (type == colType.datastructure) {
            colNum = colType.datastructure.ordinal();
            row = this.lastDataStructureRow;
            image = FieldImportWorkflowImageCache.getImage("dataStructure_select_16.gif");
        } else {
            colNum = colType.state.ordinal();
            row = this.lastStateRow;
            image = FieldImportWorkflowImageCache.getImage("dbd_just_imported.gif");
        }
        ViewerRow above = row.getNeighbor(1, false);
        while (above != null) {
            ViewerCell aboveCell = above.getCell(colNum);
            if (aboveCell.getImage() != null) {
                if (type == colType.state && aboveCell.getElement() instanceof WorkflowSegmentType) {
                    workflowSegment = (WorkflowSegmentType)aboveCell.getElement();
                    aboveCell.setImage(FieldImportWorkflowImageCache.getImageForWorkflowStatus(workflowSegment.getStatus()));
                } else if (type == colType.state && aboveCell.getElement() instanceof WorkflowDBD) {
                    WorkflowDBD workflowDBD = (WorkflowDBD)aboveCell.getElement();
                    aboveCell.setImage(FieldImportWorkflowImageCache.getImageForWorkflowStatus(workflowDBD.getStatus()));
                } else if (type == colType.datastructure && aboveCell.getElement() instanceof WorkflowSegmentType) {
                    workflowSegment = (WorkflowSegmentType)aboveCell.getElement();
                    if (workflowSegment.getWorkflowCandidateDataStructure().isEmpty()) {
                        aboveCell.setImage(FieldImportWorkflowImageCache.getImage("dataStructure_disable_16.gif"));
                    } else {
                        aboveCell.setImage(image);
                    }
                } else if (type == colType.datastructure && aboveCell.getElement() instanceof WorkflowMapCaseType) {
                    WorkflowMapCaseType workflowMapCase = (WorkflowMapCaseType)aboveCell.getElement();
                    if (workflowMapCase.getParent().getWorkflowCandidateDataStructure().isEmpty()) {
                        aboveCell.setImage(FieldImportWorkflowImageCache.getImage("dataStructure_disable_16.gif"));
                    } else {
                        aboveCell.setImage(image);
                    }
                } else {
                    aboveCell.setImage(image);
                }
            }
            above = above.getNeighbor(1, false);
        }
        ViewerRow below = row.getNeighbor(2, false);
        while (below != null) {
            ViewerCell belowCell = below.getCell(colNum);
            if (belowCell.getImage() != null) {
                if (type == colType.state && belowCell.getElement() instanceof WorkflowSegmentType) {
                    workflowSegment = (WorkflowSegmentType)belowCell.getElement();
                    belowCell.setImage(FieldImportWorkflowImageCache.getImageForWorkflowStatus(workflowSegment.getStatus()));
                } else if (type == colType.state && belowCell.getElement() instanceof WorkflowDBD) {
                    WorkflowDBD workflowDBD = (WorkflowDBD)belowCell.getElement();
                    belowCell.setImage(FieldImportWorkflowImageCache.getImageForWorkflowStatus(workflowDBD.getStatus()));
                } else if (type == colType.datastructure && belowCell.getElement() instanceof WorkflowSegmentType) {
                    workflowSegment = (WorkflowSegmentType)belowCell.getElement();
                    if (workflowSegment.getWorkflowCandidateDataStructure().isEmpty()) {
                        belowCell.setImage(FieldImportWorkflowImageCache.getImage("dataStructure_disable_16.gif"));
                    } else {
                        belowCell.setImage(image);
                    }
                } else if (type == colType.datastructure && belowCell.getElement() instanceof WorkflowMapCaseType) {
                    WorkflowMapCaseType workflowMapCase = (WorkflowMapCaseType)belowCell.getElement();
                    if (workflowMapCase.getParent().getWorkflowCandidateDataStructure().isEmpty()) {
                        belowCell.setImage(FieldImportWorkflowImageCache.getImage("dataStructure_disable_16.gif"));
                    } else {
                        belowCell.setImage(image);
                    }
                } else {
                    belowCell.setImage(image);
                }
            }
            below = below.getNeighbor(2, false);
        }
    }

    public void mouseMove(MouseEvent me) {
        TreeColumn column = this.xViewer.getColumnUnderMouseClick(new Point(me.x, me.y));
        if (column != null && FieldImportWorkflowXViewerFactory.DataStructure_Col.is(column)) {
            ViewerCell middleCell;
            if (this.lastStateRow != null) {
                if (!this.lastStateRow.getItem().isDisposed()) {
                    ViewerCell dsCell = this.lastStateRow.getCell(colType.state.ordinal());
                    if (dsCell.getElement() instanceof WorkflowSegmentType) {
                        WorkflowSegmentType workflowSegment = (WorkflowSegmentType)dsCell.getElement();
                        dsCell.setImage(FieldImportWorkflowImageCache.getImageForWorkflowStatus(workflowSegment.getStatus()));
                    } else if (dsCell.getElement() instanceof WorkflowDBD) {
                        WorkflowDBD workflowDBD = (WorkflowDBD)dsCell.getElement();
                        dsCell.setImage(FieldImportWorkflowImageCache.getImageForWorkflowStatus(workflowDBD.getStatus()));
                    }
                    this.resetImagesAboveBelow(colType.state);
                }
                this.lastStateRow = null;
            }
            if ((middleCell = this.xViewer.getCell(new Point(me.x, me.y))) != null) {
                WorkflowMapCaseType mapCase;
                this.lastDataStructureRow = middleCell.getViewerRow();
                if (middleCell.getImage() != null && middleCell.getElement() instanceof WorkflowMapCaseType && (mapCase = (WorkflowMapCaseType)middleCell.getElement()).getParent().getWorkflowCandidateDataStructure().size() > 0 && !this.workflowController.isDBDLocked(mapCase)) {
                    middleCell.setImage(FieldImportWorkflowImageCache.getImage("dataStructure_select_DownArrow_16.gif"));
                }
                this.resetImagesAboveBelow(colType.datastructure);
            }
        } else if (column != null && FieldImportWorkflowXViewerFactory.State_Col.is(column)) {
            ViewerCell cell;
            WorkflowSegmentType workflowSegment;
            if (this.lastDataStructureRow != null) {
                if (!this.lastDataStructureRow.getItem().isDisposed()) {
                    ViewerCell dsCell = this.lastDataStructureRow.getCell(colType.datastructure.ordinal());
                    if (dsCell.getImage() != null) {
                        if (dsCell.getElement() instanceof WorkflowSegmentType) {
                            workflowSegment = (WorkflowSegmentType)dsCell.getElement();
                            if (workflowSegment.getWorkflowCandidateDataStructure().isEmpty()) {
                                dsCell.setImage(FieldImportWorkflowImageCache.getImage("dataStructure_disable_16.gif"));
                            } else {
                                dsCell.setImage(FieldImportWorkflowImageCache.getImage("dataStructure_select_16.gif"));
                            }
                        } else if (dsCell.getElement() instanceof WorkflowMapCaseType) {
                            WorkflowMapCaseType workflowMapCase = (WorkflowMapCaseType)dsCell.getElement();
                            if (workflowMapCase.getParent().getWorkflowCandidateDataStructure().isEmpty()) {
                                dsCell.setImage(FieldImportWorkflowImageCache.getImage("dataStructure_disable_16.gif"));
                            } else {
                                dsCell.setImage(FieldImportWorkflowImageCache.getImage("dataStructure_select_16.gif"));
                            }
                        } else {
                            dsCell.setImage(FieldImportWorkflowImageCache.getImage("dataStructure_select_16.gif"));
                        }
                    }
                    this.resetImagesAboveBelow(colType.datastructure);
                }
                this.lastDataStructureRow = null;
            }
            if ((cell = this.xViewer.getCell(new Point(me.x, me.y))) != null) {
                this.lastStateRow = cell.getViewerRow();
                if (cell.getElement() instanceof WorkflowSegmentType) {
                    workflowSegment = (WorkflowSegmentType)cell.getElement();
                    ViewerCell middleCell = cell;
                    if (middleCell.getImage() != null && !this.workflowController.isDBDLocked(workflowSegment)) {
                        middleCell.setImage(FieldImportWorkflowImageCache.getHoverImageForWorkflowStatus(workflowSegment.getStatus()));
                    }
                }
                this.resetImagesAboveBelow(colType.state);
            }
        } else if (this.lastDataStructureRow != null) {
            ViewerCell dsCell;
            if (!this.lastDataStructureRow.getItem().isDisposed() && (dsCell = this.lastDataStructureRow.getCell(colType.datastructure.ordinal())).getImage() != null) {
                if (dsCell.getElement() instanceof WorkflowSegmentType) {
                    WorkflowSegmentType workflowSegment = (WorkflowSegmentType)dsCell.getElement();
                    if (workflowSegment.getWorkflowCandidateDataStructure().isEmpty()) {
                        dsCell.setImage(FieldImportWorkflowImageCache.getImage("dataStructure_disable_16.gif"));
                    } else {
                        dsCell.setImage(FieldImportWorkflowImageCache.getImage("dataStructure_select_16.gif"));
                    }
                } else if (dsCell.getElement() instanceof WorkflowMapCaseType) {
                    WorkflowMapCaseType workflowMapCase = (WorkflowMapCaseType)dsCell.getElement();
                    if (workflowMapCase.getParent().getWorkflowCandidateDataStructure().isEmpty()) {
                        dsCell.setImage(FieldImportWorkflowImageCache.getImage("dataStructure_disable_16.gif"));
                    } else {
                        dsCell.setImage(FieldImportWorkflowImageCache.getImage("dataStructure_select_16.gif"));
                    }
                } else {
                    dsCell.setImage(FieldImportWorkflowImageCache.getImage("dataStructure_select_16.gif"));
                }
                this.resetImagesAboveBelow(colType.datastructure);
            }
            this.lastDataStructureRow = null;
        } else if (this.lastStateRow != null) {
            if (!this.lastStateRow.getItem().isDisposed()) {
                ViewerCell dsCell = this.lastStateRow.getCell(colType.state.ordinal());
                if (dsCell.getImage() != null) {
                    if (dsCell.getElement() instanceof WorkflowSegmentType) {
                        WorkflowSegmentType workflowSegment = (WorkflowSegmentType)dsCell.getElement();
                        dsCell.setImage(FieldImportWorkflowImageCache.getImageForWorkflowStatus(workflowSegment.getStatus()));
                    } else if (dsCell.getElement() instanceof WorkflowDBD) {
                        WorkflowDBD workflowDBD = (WorkflowDBD)dsCell.getElement();
                        dsCell.setImage(FieldImportWorkflowImageCache.getImageForWorkflowStatus(workflowDBD.getStatus()));
                    }
                }
                this.resetImagesAboveBelow(colType.state);
            }
            this.lastStateRow = null;
        }
    }

    private static enum colType {
        dbdsegment,
        state,
        mapcase,
        datastructure;

    }
}

