/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.workflow;

import com.ibm.im.ims.catalog.ui.workflow.FieldImportWorkflowXViewerFactory;
import com.ibm.im.ims.catalog.ui.workflow.FieldImportWorkflowXViewerTextFilter;
import com.ibm.im.ims.catalog.ui.workflow.actions.AddOrEditFieldAction;
import com.ibm.im.ims.catalog.ui.workflow.actions.DeleteDBDAction;
import com.ibm.im.ims.catalog.ui.workflow.actions.EditDBDAction;
import com.ibm.im.ims.catalog.ui.workflow.actions.EditDatasetAction;
import com.ibm.im.ims.catalog.ui.workflow.actions.EditSEGMAction;
import com.ibm.im.ims.catalog.ui.workflow.actions.FieldImportWorkflowImportDSAction;
import com.ibm.im.ims.catalog.ui.workflow.actions.ManageMapCaseAction;
import com.ibm.im.ims.catalog.ui.workflow.actions.OpenDbdGraphicalEditorAction;
import com.ibm.im.ims.catalog.ui.workflow.actions.PreviewAndSelectDSAction;
import com.ibm.im.ims.catalog.ui.workflow.actions.SubmitChangestoIMSAction;
import com.ibm.im.ims.catalog.ui.workflow.actions.UpdateSegmentStatusAction;
import com.ibm.im.ims.catalog.ui.workflow.util.FieldImportWorkflowMenuBuilder;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDBD;
import com.ibm.im.ims.metadata.workflow.field.WorkflowMapCaseType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowSegmentType;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowController;
import com.ibm.im.ims.workbench.controller.workflow.field.IFieldImportWorkflowEventListener;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerTextFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class FieldImportWorkflowXViewer
extends XViewer
implements IFieldImportWorkflowEventListener {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private FieldImportWorkflowController workflowController;
    private Menu leftClickMenu = null;

    public FieldImportWorkflowXViewer(Shell shell_1, int i) {
        super((Composite)shell_1, i, (IXViewerFactory)new FieldImportWorkflowXViewerFactory());
    }

    public FieldImportWorkflowXViewer(Composite parent, int style, FieldImportWorkflowController workflowController) {
        super(parent, style, (IXViewerFactory)new FieldImportWorkflowXViewerFactory());
        this.workflowController = workflowController;
        this.workflowController.getWorkflowEventListeners().add(this);
    }

    public FieldImportWorkflowXViewer(Composite parent, int style, IXViewerFactory xViewerFactory) {
        super(parent, style, xViewerFactory);
    }

    public FieldImportWorkflowXViewer(Tree tree, IXViewerFactory xViewerFactory) {
        super(tree, xViewerFactory);
    }

    public FieldImportWorkflowXViewer(Composite parent, int style, IXViewerFactory xViewerFactory, boolean filterRealTime, boolean searchRealTime) {
        super(parent, style, xViewerFactory, filterRealTime, searchRealTime);
    }

    public FieldImportWorkflowXViewer(Tree tree, IXViewerFactory xViewerFactory, boolean filterRealTime, boolean searchRealTime) {
        super(tree, xViewerFactory, filterRealTime, searchRealTime);
    }

    public XViewerTextFilter getXViewerTextFilter() {
        return new FieldImportWorkflowXViewerTextFilter(this);
    }

    public boolean handleLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        if (treeColumn == null || treeItem == null) {
            return false;
        }
        if (!this.checkIfDbdIsLocked(treeItem, false)) {
            return false;
        }
        if (this.leftClickMenu != null && !this.leftClickMenu.isDisposed()) {
            this.leftClickMenu.dispose();
            this.leftClickMenu = null;
        }
        if (FieldImportWorkflowXViewerFactory.DataStructure_Col.is(treeColumn)) {
            this.leftClickMenu = FieldImportWorkflowMenuBuilder.buildCandidateStructureMenu(this, treeColumn, treeItem);
        } else if (FieldImportWorkflowXViewerFactory.State_Col.is(treeColumn)) {
            this.leftClickMenu = FieldImportWorkflowMenuBuilder.buildStateMenu(this, treeColumn, treeItem);
        }
        if (this.leftClickMenu != null && !this.leftClickMenu.isDisposed()) {
            this.leftClickMenu.setVisible(true);
        }
        return true;
    }

    public boolean handleLeftClickInIconArea(TreeColumn treeColumn, TreeItem treeItem) {
        return this.handleLeftClick(treeColumn, treeItem);
    }

    public void setStatusLabelText(String text) {
        if (!this.getStatusLabel().isDisposed()) {
            this.getStatusLabel().setText(text);
        }
    }

    public void mapCaseChanged(final WorkflowMapCaseType workflowMapCase) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!FieldImportWorkflowXViewer.this.getControl().isDisposed()) {
                    FieldImportWorkflowXViewer.this.refresh(workflowMapCase, true);
                }
            }
        });
    }

    public void mapCaseAdded(final WorkflowMapCaseType workflowMapCase) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!FieldImportWorkflowXViewer.this.getControl().isDisposed()) {
                    FieldImportWorkflowXViewer.this.refresh(workflowMapCase.getParent(), true);
                }
            }
        });
    }

    public void segmentChanged(final WorkflowSegmentType workflowSegment) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!FieldImportWorkflowXViewer.this.getControl().isDisposed()) {
                    FieldImportWorkflowXViewer.this.refresh(workflowSegment, true);
                }
            }
        });
    }

    public void dbdChanged(final WorkflowDBD workflowDBD) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!FieldImportWorkflowXViewer.this.getControl().isDisposed()) {
                    FieldImportWorkflowXViewer.this.refresh(workflowDBD, true);
                }
            }
        });
    }

    public void dbdsAdded() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!FieldImportWorkflowXViewer.this.getControl().isDisposed()) {
                    FieldImportWorkflowXViewer.this.refresh();
                }
            }
        });
    }

    public FieldImportWorkflowController getWorkflowController() {
        return this.workflowController;
    }

    public void updateMenuActionsForTable() {
        this.getMenuManager().removeAll();
        TreeItem treeItem = this.getRightClickSelectedItem();
        if (treeItem == null || !this.checkIfDbdIsLocked(treeItem, true)) {
            return;
        }
        Object workflowObject = treeItem.getData();
        if (this.isPhysicalDbd(treeItem)) {
            this.getMenuManager().add((IAction)new FieldImportWorkflowImportDSAction(this));
            if (workflowObject instanceof WorkflowMapCaseType) {
                this.getMenuManager().add((IAction)new PreviewAndSelectDSAction(this));
            } else if (workflowObject instanceof WorkflowSegmentType) {
                this.getMenuManager().add((IAction)new AddOrEditFieldAction(this));
                this.getMenuManager().add((IAction)new ManageMapCaseAction(this));
                this.getMenuManager().add((IAction)new EditSEGMAction(this));
                this.getMenuManager().add((IAction)new UpdateSegmentStatusAction(this));
            } else if (workflowObject instanceof WorkflowDBD) {
                this.getMenuManager().add((IAction)new OpenDbdGraphicalEditorAction(this));
                this.getMenuManager().add((IAction)new EditDBDAction(this));
                this.getMenuManager().add((IAction)new EditDatasetAction(this));
                if (this.isNotMSDB((WorkflowDBD)workflowObject)) {
                    this.getMenuManager().add((IAction)new SubmitChangestoIMSAction(this));
                }
                this.getMenuManager().add((IAction)new DeleteDBDAction(this));
            }
        } else if (workflowObject instanceof WorkflowSegmentType) {
            this.getMenuManager().add((IAction)new EditSEGMAction(this));
            this.getMenuManager().add((IAction)new UpdateSegmentStatusAction(this));
        } else if (workflowObject instanceof WorkflowDBD) {
            this.getMenuManager().add((IAction)new OpenDbdGraphicalEditorAction(this));
            this.getMenuManager().add((IAction)new EditDBDAction(this));
            this.getMenuManager().add((IAction)new SubmitChangestoIMSAction(this));
            this.getMenuManager().add((IAction)new DeleteDBDAction(this));
        }
    }

    private boolean isNotMSDB(WorkflowDBD workflowDbd) {
        boolean retVal = true;
        String dbdName = workflowDbd.getName();
        String projectName = this.workflowController.getProjectName();
        try {
            IFile dbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)dbdName);
            DbdModel dbd = new DbdModel(dbdFile.getContents());
            if (dbd.getAccessType() == DBDConstants.MSDB) {
                retVal = false;
            }
        }
        catch (Throwable e) {
            logger.error(e);
        }
        return retVal;
    }

    private boolean isNotGSAM(WorkflowSegmentType workflowSegment) {
        boolean retVal = true;
        String dbdName = workflowSegment.getParent().getName();
        String projectName = this.workflowController.getProjectName();
        try {
            IFile dbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)dbdName);
            DbdModel dbd = new DbdModel(dbdFile.getContents());
            if (dbd.getAccessType() == DBDConstants.GSAM) {
                retVal = false;
            }
        }
        catch (Throwable e) {
            logger.error(e);
        }
        return retVal;
    }

    private boolean isPhysicalDbd(TreeItem treeItem) {
        boolean retVal = true;
        WorkflowDBD workflowDBD = null;
        if (treeItem.getData() instanceof WorkflowDBD) {
            workflowDBD = (WorkflowDBD)treeItem.getData();
        } else if (treeItem.getData() instanceof WorkflowSegmentType) {
            workflowDBD = ((WorkflowSegmentType)treeItem.getData()).getParent();
        } else if (treeItem.getData() instanceof WorkflowMapCaseType) {
            workflowDBD = ((WorkflowMapCaseType)treeItem.getData()).getParent().getParent();
        }
        if (workflowDBD != null) {
            String dbdName = workflowDBD.getName();
            String projectName = this.workflowController.getProjectName();
            try {
                IFile dbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)dbdName);
                DbdModel dbd = new DbdModel(dbdFile.getContents());
                if (dbd.getAccessType() == DBDConstants.LOGICAL) {
                    retVal = false;
                }
            }
            catch (Throwable e) {
                logger.error(e);
            }
        }
        return retVal;
    }

    public boolean checkIfDbdIsLocked(TreeItem treeItem, boolean popup) {
        WorkflowDBD workflowDBD = null;
        if (treeItem.getData() instanceof WorkflowDBD) {
            workflowDBD = (WorkflowDBD)treeItem.getData();
        } else if (treeItem.getData() instanceof WorkflowSegmentType) {
            workflowDBD = ((WorkflowSegmentType)treeItem.getData()).getParent();
        } else if (treeItem.getData() instanceof WorkflowMapCaseType) {
            workflowDBD = ((WorkflowMapCaseType)treeItem.getData()).getParent().getParent();
        }
        return this.checkIfDbdIsLocked(workflowDBD, popup);
    }

    public boolean checkIfDbdIsLocked(WorkflowDBD workflowDBD, boolean popup) {
        String workflowDBDName = workflowDBD.getName();
        if (this.workflowController.isDBDLocked(workflowDBDName)) {
            if (popup) {
                Utility.openMessageDialog(1, WorkbenchPlugin.labels.getString("WFM_TITLE"), WorkbenchPlugin.errors.getString("WFM_DBD_BEING_UPDATED", (Object[])new String[]{workflowDBDName}));
            }
            return false;
        }
        return true;
    }

    public WorkflowDBD getWorkflowDBD(TreeItem item) {
        WorkflowDBD retVal = null;
        if (item.getData() instanceof WorkflowDBD) {
            retVal = (WorkflowDBD)item.getData();
        } else if (item.getData() instanceof WorkflowSegmentType) {
            retVal = ((WorkflowSegmentType)item.getData()).getParent();
        } else if (item.getData() instanceof WorkflowMapCaseType) {
            retVal = ((WorkflowMapCaseType)item.getData()).getParent().getParent();
        }
        return retVal;
    }
}

