/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sql.util;

import com.ibm.ims.datatools.connectivity.sqm.core.rte.ICatalogObject;
import com.ibm.ims.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import com.ibm.ims.datatools.modelbase.sql.routines.Routine;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import com.ibm.ims.datatools.modelbase.sql.schema.Event;
import com.ibm.ims.datatools.modelbase.sql.schema.SQLObject;
import com.ibm.ims.datatools.modelbase.sql.tables.Table;
import com.ibm.ims.datatools.modelbase.sql.tables.Trigger;
import com.ibm.ims.datatools.sqltools.core.DatabaseVendorDefinitionId;
import com.ibm.ims.datatools.sqltools.core.EditorCorePlugin;
import com.ibm.ims.datatools.sqltools.core.ProcIdentifier;
import com.ibm.ims.datatools.sqltools.core.services.ActionService;
import com.ibm.ims.datatools.sqltools.editor.ui.core.SQLDevToolsUIConfiguration;
import com.ibm.ims.datatools.sqltools.editor.ui.core.SQLToolsUIFacade;
import com.ibm.ims.datatools.sqltools.internal.SQLDevToolsUtil;
import com.ibm.ims.datatools.sqltools.sql.util.Messages;

public class DSEUtil {
    public static String getProfileName(IVirtualNode _node) {
        ConnectionInfo conInfo = _node.getParentConnection();
        Object parent = _node.getParent();
        if (!(conInfo instanceof ConnectionInfoImpl) && parent instanceof ICatalogObject) {
            Database db = ((ICatalogObject)parent).getCatalogDatabase();
            conInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(db);
            if (conInfo == null) {
                EditorCorePlugin.getDefault().log(Messages.error_cannot_get_connection_profile);
                return null;
            }
        }
        String profileName = ((ConnectionInfoImpl)conInfo).getConnectionProfile().getName();
        return profileName;
    }

    public static void refreshParent(SQLObject element) {
        Table parent = null;
        if (element instanceof Trigger) {
            parent = ((Trigger)element).getSubjectTable();
        } else if (element instanceof Routine) {
            parent = ((Routine)element).getSchema();
        } else if (element instanceof Event) {
            parent = ((Event)element).getDatabase();
        }
        if (parent instanceof ICatalogObject) {
            ((ICatalogObject)parent).refresh();
        }
    }

    public static ActionService getActionService(SQLObject object) {
        ProcIdentifier procIdentifier = SQLDevToolsUtil.getProcIdentifier((SQLObject)object);
        return DSEUtil.getActionService(procIdentifier.getProfileName());
    }

    public static ActionService getActionService(IVirtualNode node) {
        String profileName = ((ConnectionInfoImpl)node.getParentConnection()).getConnectionProfile().getName();
        return DSEUtil.getActionService(profileName);
    }

    public static ActionService getActionService(String profileName) {
        SQLDevToolsUIConfiguration conf = SQLToolsUIFacade.getConfigurationByProfileName(profileName);
        return conf.getActionService();
    }

    public static ActionService getActionService(DatabaseVendorDefinitionId vendorId) {
        SQLDevToolsUIConfiguration conf = SQLToolsUIFacade.getConfigurationByVendorIdentifier(vendorId);
        return conf.getActionService();
    }
}

