/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.internal.services;

import com.ibm.ims.datatools.connectivity.internal.ConnectivityPlugin;
import com.ibm.ims.datatools.connectivity.internal.services.BundleResourceLocator;
import com.ibm.ims.datatools.connectivity.internal.services.ClassLoaderResourceLocator;
import com.ibm.ims.datatools.connectivity.internal.services.ResourceLocatorDelegate;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class PluginResourceLocatorImpl {
    static final String PLUGIN_ROOT_PATH = "/";
    private static final String WORKSPACE_PATH_SUFFIX = "_workspacepath";
    private static final String DATATOOLS_NAMESPACE = "org.eclipse.datatools";
    private static ResourceLocatorDelegate sm_delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ResourceLocatorDelegate getDelegate() {
        if (sm_delegate != null) return sm_delegate;
        ResourceLocatorDelegate delegate = ConnectivityPlugin.isRunningOSGiPlatform() ? new BundleResourceLocator() : new ClassLoaderResourceLocator();
        Class<PluginResourceLocatorImpl> clazz = PluginResourceLocatorImpl.class;
        synchronized (PluginResourceLocatorImpl.class) {
            if (sm_delegate != null) return sm_delegate;
            sm_delegate = delegate;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sm_delegate;
        }
    }

    public static IPath getPluginRootPath(IConfigurationElement configElement) {
        return PluginResourceLocatorImpl.adaptToPath(PluginResourceLocatorImpl.getPluginEntry(configElement, PLUGIN_ROOT_PATH));
    }

    public static IPath getPluginRootPath(String pluginId) {
        return PluginResourceLocatorImpl.adaptToPath(PluginResourceLocatorImpl.getPluginEntry(pluginId, PLUGIN_ROOT_PATH, null));
    }

    public static IPath getPluginEntryPath(String pluginId, String path) {
        return PluginResourceLocatorImpl.adaptToPath(PluginResourceLocatorImpl.getPluginEntry(pluginId, path, null));
    }

    public static URL getPluginEntry(IConfigurationElement configElement, String path) {
        String bundleName = configElement.getContributor().getName();
        return PluginResourceLocatorImpl.getPluginEntry(bundleName, path, configElement.getClass().getClassLoader());
    }

    public static URL getPluginEntry(String pluginId, String path, ClassLoader cl) {
        return PluginResourceLocatorImpl.getDelegate().findPluginEntry(pluginId, path, cl);
    }

    public static URL getPluginResource(String pluginId, String name, ClassLoader cl) {
        return PluginResourceLocatorImpl.getDelegate().findPluginResource(pluginId, name, cl);
    }

    static IPath adaptToPath(URL pluginRoot) {
        if (pluginRoot == null) {
            return null;
        }
        try {
            pluginRoot = PluginResourceLocatorImpl.resolve(pluginRoot);
            String path = pluginRoot.getPath();
            if (path.endsWith("!/")) {
                path = path.substring(0, path.length() - 2);
                pluginRoot = new URL(path);
            }
            pluginRoot = PluginResourceLocatorImpl.toFileURL(pluginRoot);
        }
        catch (IOException ex) {
            ConnectivityPlugin.getDefault().logWarning(ConnectivityPlugin.getDefault().getResourceString("PluginResourceLocator.invalidURL", new Object[]{pluginRoot, ex.getMessage()}));
        }
        return new Path(pluginRoot.getFile()).removeTrailingSeparator();
    }

    public static IPath getPluginStateLocation(String pluginId) {
        return PluginResourceLocatorImpl.getDelegate().findPluginStateLocation(pluginId);
    }

    static IPath getConfigurableWorkspacePath(String pluginId) {
        URL wsURL = PluginResourceLocatorImpl.getConfigurableWorkspaceLocation(pluginId);
        return wsURL != null ? new Path(wsURL.getPath()).removeTrailingSeparator() : null;
    }

    public static URL getConfigurableWorkspaceLocation(String pluginId) {
        IPath pluginLoc;
        String wsLocKey = pluginId + WORKSPACE_PATH_SUFFIX;
        String value = null;
        try {
            value = System.getProperty(wsLocKey);
        }
        catch (SecurityException ex) {
            ConnectivityPlugin.getDefault().logInfo(ex.getMessage());
        }
        if (value == null && (value = System.getenv(wsLocKey)) == null) {
            if (pluginId.equals(DATATOOLS_NAMESPACE)) {
                return null;
            }
            URL parentWsLoc = PluginResourceLocatorImpl.getConfigurableWorkspaceLocation(DATATOOLS_NAMESPACE);
            if (parentWsLoc == null) {
                return null;
            }
            if (!PluginResourceLocatorImpl.isExistingFolder(parentWsLoc)) {
                ConnectivityPlugin.getDefault().logWarning("PluginResourceLocatorImpl#getConfigurableWorkspaceLocation(String): Invalid parent workspace path (" + parentWsLoc.getPath() + "); must specify an existing directory for the org.eclipse.datatools workspace path.");
                return null;
            }
            Path parentWsPath = new Path(parentWsLoc.getPath());
            value = parentWsPath.append(pluginId).toString();
        }
        if (!new File(value).isAbsolute() && (pluginLoc = PluginResourceLocatorImpl.getPluginRootPath(pluginId)) != null) {
            value = pluginLoc.append(value).toString();
        }
        return PluginResourceLocatorImpl.convertToURL(value);
    }

    private static URL convertToURL(String absoluteDirPath) {
        File workspaceFolder = new File(absoluteDirPath);
        if (!workspaceFolder.isAbsolute()) {
            ConnectivityPlugin.getDefault().logWarning("PluginResourceLocatorImpl#convertToURL(String): Unable to use the workspace location (" + absoluteDirPath + "); must specify an absolute path for the workspace.");
            return null;
        }
        try {
            return workspaceFolder.toURI().toURL();
        }
        catch (Exception ex) {
            ConnectivityPlugin.getDefault().logWarning("PluginResourceLocatorImpl#convertToURL(String): Unable to encode and convert workspace location (" + absoluteDirPath + ") to an URL;\n Exception message: " + ex.getMessage());
            return null;
        }
    }

    private static boolean isExistingFolder(URL workspaceLoc) {
        try {
            File wsFolder = new File(workspaceLoc.toURI());
            return wsFolder.isDirectory();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getResourceString(String pluginId, String value) {
        String resourceString = PluginResourceLocatorImpl.getDelegate().findResourceString(pluginId, value);
        return resourceString != null ? resourceString : Platform.getResourceString(null, (String)value);
    }

    public static URL resolve(URL url) throws IOException {
        return PluginResourceLocatorImpl.getDelegate().resolveURL(url);
    }

    public static URL toFileURL(URL url) throws IOException {
        return PluginResourceLocatorImpl.getDelegate().toFileURL(url);
    }
}

